/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db.entitymanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.executor.BatchExecutorException;
import org.apache.ibatis.executor.BatchResult;
import org.camunda.bpm.engine.impl.DeploymentQueryImpl;
import org.camunda.bpm.engine.impl.ExecutionQueryImpl;
import org.camunda.bpm.engine.impl.GroupQueryImpl;
import org.camunda.bpm.engine.impl.HistoricActivityInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricDetailQueryImpl;
import org.camunda.bpm.engine.impl.HistoricJobLogQueryImpl;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricTaskInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricVariableInstanceQueryImpl;
import org.camunda.bpm.engine.impl.JobQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.TaskQueryImpl;
import org.camunda.bpm.engine.impl.UserQueryImpl;
import org.camunda.bpm.engine.impl.cfg.IdGenerator;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.DbEntityLifecycleAware;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.db.EntityLoadListener;
import org.camunda.bpm.engine.impl.db.HasDbReferences;
import org.camunda.bpm.engine.impl.db.HasDbRevision;
import org.camunda.bpm.engine.impl.db.HistoricEntity;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.db.PersistenceSession;
import org.camunda.bpm.engine.impl.db.entitymanager.OptimisticLockingListener;
import org.camunda.bpm.engine.impl.db.entitymanager.cache.CachedDbEntity;
import org.camunda.bpm.engine.impl.db.entitymanager.cache.DbEntityCache;
import org.camunda.bpm.engine.impl.db.entitymanager.cache.DbEntityState;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbBulkOperation;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbEntityOperation;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperationManager;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperationType;
import org.camunda.bpm.engine.impl.identity.db.DbGroupQueryImpl;
import org.camunda.bpm.engine.impl.identity.db.DbUserQueryImpl;
import org.camunda.bpm.engine.impl.interceptor.Session;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutorContext;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.util.ExceptionUtil;
import org.camunda.bpm.engine.repository.ResourceTypes;

public class DbEntityManager
implements Session,
EntityLoadListener {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    protected static final String TOGGLE_FOREIGN_KEY_STMT = "toggleForeignKey";
    public static final int BATCH_SIZE = 50;
    protected List<OptimisticLockingListener> optimisticLockingListeners;
    protected IdGenerator idGenerator;
    protected DbEntityCache dbEntityCache;
    protected DbOperationManager dbOperationManager;
    protected PersistenceSession persistenceSession;
    protected boolean isIgnoreForeignKeysForNextFlush;

    public DbEntityManager(IdGenerator idGenerator, PersistenceSession persistenceSession) {
        this.idGenerator = idGenerator;
        this.persistenceSession = persistenceSession;
        if (persistenceSession != null) {
            this.persistenceSession.addEntityLoadListener(this);
        }
        this.initializeEntityCache();
        this.initializeOperationManager();
    }

    protected void initializeOperationManager() {
        this.dbOperationManager = new DbOperationManager();
    }

    protected void initializeEntityCache() {
        JobExecutorContext jobExecutorContext = Context.getJobExecutorContext();
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration != null && processEngineConfiguration.isDbEntityCacheReuseEnabled() && jobExecutorContext != null) {
            this.dbEntityCache = jobExecutorContext.getEntityCache();
            if (this.dbEntityCache == null) {
                this.dbEntityCache = new DbEntityCache(processEngineConfiguration.getDbEntityCacheKeyMapping());
                jobExecutorContext.setEntityCache(this.dbEntityCache);
            }
        } else {
            this.dbEntityCache = processEngineConfiguration != null ? new DbEntityCache(processEngineConfiguration.getDbEntityCacheKeyMapping()) : new DbEntityCache();
        }
    }

    public List selectList(String statement) {
        return this.selectList(statement, null, 0, Integer.MAX_VALUE);
    }

    public List selectList(String statement, Object parameter) {
        return this.selectList(statement, parameter, 0, Integer.MAX_VALUE);
    }

    public List selectList(String statement, Object parameter, Page page) {
        if (page != null) {
            return this.selectList(statement, parameter, page.getFirstResult(), page.getMaxResults());
        }
        return this.selectList(statement, parameter, 0, Integer.MAX_VALUE);
    }

    public List selectList(String statement, ListQueryParameterObject parameter, Page page) {
        return this.selectList(statement, parameter);
    }

    public List selectList(String statement, Object parameter, int firstResult, int maxResults) {
        return this.selectList(statement, new ListQueryParameterObject(parameter, firstResult, maxResults));
    }

    public List selectList(String statement, ListQueryParameterObject parameter) {
        return this.selectListWithRawParameter(statement, parameter, parameter.getFirstResult(), parameter.getMaxResults());
    }

    public List selectListWithRawParameter(String statement, Object parameter, int firstResult, int maxResults) {
        if (firstResult == -1 || maxResults == -1) {
            return Collections.EMPTY_LIST;
        }
        List<Object> loadedObjects = this.persistenceSession.selectList(statement, parameter);
        return this.filterLoadedObjects(loadedObjects);
    }

    public Object selectOne(String statement, Object parameter) {
        Object result = this.persistenceSession.selectOne(statement, parameter);
        if (result instanceof DbEntity) {
            DbEntity loadedObject = (DbEntity)result;
            result = this.cacheFilter(loadedObject);
        }
        return result;
    }

    public boolean selectBoolean(String statement, Object parameter) {
        List<?> result = this.persistenceSession.selectList(statement, parameter);
        if (result != null) {
            return result.contains(1);
        }
        return false;
    }

    public <T extends DbEntity> T selectById(Class<T> entityClass, String id) {
        T persistentObject = this.dbEntityCache.get(entityClass, id);
        if (persistentObject != null) {
            return persistentObject;
        }
        persistentObject = this.persistenceSession.selectById(entityClass, id);
        if (persistentObject == null) {
            return null;
        }
        return persistentObject;
    }

    public <T extends DbEntity> T getCachedEntity(Class<T> type, String id) {
        return this.dbEntityCache.get(type, id);
    }

    public <T extends DbEntity> List<T> getCachedEntitiesByType(Class<T> type) {
        return this.dbEntityCache.getEntitiesByType(type);
    }

    protected List filterLoadedObjects(List<Object> loadedObjects) {
        if (loadedObjects.isEmpty() || loadedObjects.get(0) == null) {
            return loadedObjects;
        }
        if (!DbEntity.class.isAssignableFrom(loadedObjects.get(0).getClass())) {
            return loadedObjects;
        }
        ArrayList<DbEntity> filteredObjects = new ArrayList<DbEntity>(loadedObjects.size());
        for (Object loadedObject : loadedObjects) {
            DbEntity cachedPersistentObject = this.cacheFilter((DbEntity)loadedObject);
            filteredObjects.add(cachedPersistentObject);
        }
        return filteredObjects;
    }

    protected DbEntity cacheFilter(DbEntity persistentObject) {
        Object cachedPersistentObject = this.dbEntityCache.get(persistentObject.getClass(), persistentObject.getId());
        if (cachedPersistentObject != null) {
            return cachedPersistentObject;
        }
        return persistentObject;
    }

    @Override
    public void onEntityLoaded(DbEntity entity) {
        Object cachedPersistentObject = this.dbEntityCache.get(entity.getClass(), entity.getId());
        if (cachedPersistentObject == null) {
            this.dbEntityCache.putPersistent(entity);
            if (entity instanceof DbEntityLifecycleAware) {
                DbEntityLifecycleAware lifecycleAware = (DbEntityLifecycleAware)((Object)entity);
                lifecycleAware.postLoad();
            }
        }
    }

    public void lock(String statement) {
        this.lock(statement, null);
    }

    public void lock(String statement, Object parameter) {
        this.persistenceSession.lock(statement, parameter);
    }

    public boolean isDirty(DbEntity dbEntity) {
        CachedDbEntity cachedEntity = this.dbEntityCache.getCachedEntity(dbEntity);
        if (cachedEntity == null) {
            return false;
        }
        return cachedEntity.isDirty() || cachedEntity.getEntityState() == DbEntityState.MERGED;
    }

    @Override
    public void flush() {
        this.flushEntityCache();
        this.flushDbOperationManager();
    }

    public void setIgnoreForeignKeysForNextFlush(boolean ignoreForeignKeysForNextFlush) {
        this.isIgnoreForeignKeysForNextFlush = ignoreForeignKeysForNextFlush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushDbOperationManager() {
        List<DbOperation> operationsToFlush = this.dbOperationManager.calculateFlush();
        if (operationsToFlush == null || operationsToFlush.size() == 0) {
            return;
        }
        LOG.databaseFlushSummary(operationsToFlush);
        if (this.isIgnoreForeignKeysForNextFlush) {
            this.persistenceSession.executeNonEmptyUpdateStmt(TOGGLE_FOREIGN_KEY_STMT, false);
            this.persistenceSession.flushOperations();
        }
        try {
            List<List<DbOperation>> batches = CollectionUtil.partition(operationsToFlush, 50);
            for (List<DbOperation> batch : batches) {
                this.flushDbOperations(batch);
            }
        }
        finally {
            if (this.isIgnoreForeignKeysForNextFlush) {
                this.persistenceSession.executeNonEmptyUpdateStmt(TOGGLE_FOREIGN_KEY_STMT, true);
                this.persistenceSession.flushOperations();
                this.isIgnoreForeignKeysForNextFlush = false;
            }
        }
    }

    protected void flushDbOperations(List<DbOperation> operationsToFlush) {
        for (DbOperation dbOperation : operationsToFlush) {
            boolean doOptimisticLockingException;
            block7: {
                doOptimisticLockingException = false;
                try {
                    this.persistenceSession.executeDbOperation(dbOperation);
                }
                catch (Exception e) {
                    doOptimisticLockingException = this.isOptimisticLockingException(dbOperation, e);
                    if (doOptimisticLockingException) break block7;
                    throw LOG.flushDbOperationException(operationsToFlush, dbOperation, e);
                }
            }
            if (!dbOperation.isFailed() && !doOptimisticLockingException) continue;
            this.handleOptimisticLockingException(dbOperation);
        }
        if (Context.getProcessEngineConfiguration().isJdbcBatchProcessing()) {
            ArrayList<BatchResult> flushResult = new ArrayList();
            try {
                flushResult = this.persistenceSession.flushOperations();
            }
            catch (Exception e) {
                DbOperation failedOperation = this.hasOptimisticLockingException(operationsToFlush, e);
                if (failedOperation == null) {
                    throw LOG.flushDbOperationsException(operationsToFlush, e);
                }
                this.handleOptimisticLockingException(failedOperation);
            }
            this.checkFlushResults(operationsToFlush, flushResult);
        }
    }

    private DbOperation hasOptimisticLockingException(List<DbOperation> operationsToFlush, Throwable cause) {
        DbOperation failedOperation;
        int failedOperationIndex;
        BatchExecutorException batchExecutorException = ExceptionUtil.findBatchExecutorException(cause);
        if (batchExecutorException != null && (failedOperationIndex = batchExecutorException.getSuccessfulBatchResults().size()) < operationsToFlush.size() && this.isOptimisticLockingException(failedOperation = operationsToFlush.get(failedOperationIndex), cause)) {
            return failedOperation;
        }
        return null;
    }

    private boolean isOptimisticLockingException(DbOperation failedOperation, Throwable cause) {
        boolean isConstraintViolation = ExceptionUtil.checkForeignKeyConstraintViolation(cause);
        boolean isVariableIntegrityViolation = ExceptionUtil.checkVariableIntegrityViolation(cause);
        if (isVariableIntegrityViolation) {
            return true;
        }
        if (isConstraintViolation && failedOperation instanceof DbEntityOperation && ((DbEntityOperation)failedOperation).getEntity() instanceof HasDbReferences && (failedOperation.getOperationType().equals((Object)DbOperationType.INSERT) || failedOperation.getOperationType().equals((Object)DbOperationType.UPDATE))) {
            DbEntity entity = ((DbEntityOperation)failedOperation).getEntity();
            for (Map.Entry<String, Class> reference : ((HasDbReferences)((Object)entity)).getReferencedEntitiesIdAndClass().entrySet()) {
                Object referencedEntity = this.persistenceSession.selectById(reference.getValue(), reference.getKey());
                if (referencedEntity != null) continue;
                return true;
            }
        }
        return false;
    }

    protected void checkFlushResults(List<DbOperation> operationsToFlush, List<BatchResult> flushResult) {
        int flushResultSize = 0;
        if (flushResult != null && flushResult.size() > 0) {
            LOG.printBatchResults(flushResult);
            Iterator<DbOperation> operationIt = operationsToFlush.iterator();
            for (BatchResult batchResult : flushResult) {
                for (int statementResult : batchResult.getUpdateCounts()) {
                    ++flushResultSize;
                    DbOperation thisOperation = operationIt.next();
                    thisOperation.setRowsAffected(statementResult);
                    if (!(thisOperation instanceof DbEntityOperation) || !(((DbEntityOperation)thisOperation).getEntity() instanceof HasDbRevision) || thisOperation.getOperationType().equals((Object)DbOperationType.INSERT)) continue;
                    DbEntity dbEntity = ((DbEntityOperation)thisOperation).getEntity();
                    if (statementResult != 1) {
                        ((DbEntityOperation)thisOperation).setFailed(true);
                        this.handleOptimisticLockingException(thisOperation);
                        continue;
                    }
                    if (!thisOperation.getOperationType().equals((Object)DbOperationType.UPDATE)) continue;
                    HasDbRevision versionedObject = (HasDbRevision)((Object)dbEntity);
                    versionedObject.setRevision(versionedObject.getRevisionNext());
                }
            }
            if (operationsToFlush.size() != flushResultSize) {
                LOG.wrongBatchResultsSizeException(operationsToFlush);
            }
        }
    }

    public void flushEntity(DbEntity entity) {
        CachedDbEntity cachedEntity = this.dbEntityCache.getCachedEntity(entity);
        if (cachedEntity != null) {
            this.flushCachedEntity(cachedEntity);
        }
        this.flushDbOperationManager();
    }

    protected void handleOptimisticLockingException(DbOperation dbOperation) {
        DbEntity dbEntity;
        boolean isHandled = false;
        if (this.optimisticLockingListeners != null) {
            for (OptimisticLockingListener optimisticLockingListener : this.optimisticLockingListeners) {
                if (optimisticLockingListener.getEntityType() != null && !optimisticLockingListener.getEntityType().isAssignableFrom(dbOperation.getEntityType())) continue;
                optimisticLockingListener.failedOperation(dbOperation);
                isHandled = true;
            }
        }
        if (!isHandled && Context.getProcessEngineConfiguration().isSkipHistoryOptimisticLockingExceptions() && ((dbEntity = ((DbEntityOperation)dbOperation).getEntity()) instanceof HistoricEntity || this.isHistoricByteArray(dbEntity))) {
            isHandled = true;
        }
        if (!isHandled) {
            throw LOG.concurrentUpdateDbEntityException(dbOperation);
        }
    }

    protected boolean isHistoricByteArray(DbEntity dbEntity) {
        if (dbEntity instanceof ByteArrayEntity) {
            ByteArrayEntity byteArrayEntity = (ByteArrayEntity)dbEntity;
            return byteArrayEntity.getType().equals(ResourceTypes.HISTORY.getValue());
        }
        return false;
    }

    protected void flushEntityCache() {
        List<CachedDbEntity> cachedEntities = this.dbEntityCache.getCachedEntities();
        for (CachedDbEntity cachedDbEntity : cachedEntities) {
            this.flushCachedEntity(cachedDbEntity);
        }
        LOG.flushedCacheState(this.dbEntityCache.getCachedEntities());
    }

    protected void flushCachedEntity(CachedDbEntity cachedDbEntity) {
        if (cachedDbEntity.getEntityState() == DbEntityState.TRANSIENT) {
            cachedDbEntity.determineEntityReferences();
            this.performEntityOperation(cachedDbEntity, DbOperationType.INSERT);
            cachedDbEntity.setEntityState(DbEntityState.PERSISTENT);
        } else if (cachedDbEntity.getEntityState() == DbEntityState.PERSISTENT && cachedDbEntity.isDirty()) {
            this.performEntityOperation(cachedDbEntity, DbOperationType.UPDATE);
        } else if (cachedDbEntity.getEntityState() == DbEntityState.MERGED) {
            this.performEntityOperation(cachedDbEntity, DbOperationType.UPDATE);
            cachedDbEntity.setEntityState(DbEntityState.PERSISTENT);
        } else if (cachedDbEntity.getEntityState() == DbEntityState.DELETED_TRANSIENT) {
            this.dbEntityCache.remove(cachedDbEntity);
        } else if (cachedDbEntity.getEntityState() == DbEntityState.DELETED_PERSISTENT || cachedDbEntity.getEntityState() == DbEntityState.DELETED_MERGED) {
            this.performEntityOperation(cachedDbEntity, DbOperationType.DELETE);
            this.dbEntityCache.remove(cachedDbEntity);
        }
        if (cachedDbEntity.getEntityState() == DbEntityState.PERSISTENT) {
            cachedDbEntity.makeCopy();
            cachedDbEntity.determineEntityReferences();
        }
    }

    public void insert(DbEntity dbEntity) {
        this.ensureHasId(dbEntity);
        this.validateId(dbEntity);
        this.dbEntityCache.putTransient(dbEntity);
    }

    public void merge(DbEntity dbEntity) {
        if (dbEntity.getId() == null) {
            throw LOG.mergeDbEntityException(dbEntity);
        }
        this.dbEntityCache.putMerged(dbEntity);
    }

    public void forceUpdate(DbEntity entity) {
        CachedDbEntity cachedEntity = this.dbEntityCache.getCachedEntity(entity);
        if (cachedEntity != null && cachedEntity.getEntityState() == DbEntityState.PERSISTENT) {
            cachedEntity.forceSetDirty();
        }
    }

    public void delete(DbEntity dbEntity) {
        this.dbEntityCache.setDeleted(dbEntity);
    }

    public void undoDelete(DbEntity entity) {
        this.dbEntityCache.undoDelete(entity);
    }

    public void update(Class<? extends DbEntity> entityType, String statement, Object parameter) {
        this.performBulkOperation(entityType, statement, parameter, DbOperationType.UPDATE_BULK);
    }

    public void updatePreserveOrder(Class<? extends DbEntity> entityType, String statement, Object parameter) {
        this.performBulkOperationPreserveOrder(entityType, statement, parameter, DbOperationType.UPDATE_BULK);
    }

    public void delete(Class<? extends DbEntity> entityType, String statement, Object parameter) {
        this.performBulkOperation(entityType, statement, parameter, DbOperationType.DELETE_BULK);
    }

    public DbBulkOperation deletePreserveOrder(Class<? extends DbEntity> entityType, String statement, Object parameter) {
        return this.performBulkOperationPreserveOrder(entityType, statement, parameter, DbOperationType.DELETE_BULK);
    }

    protected DbBulkOperation performBulkOperation(Class<? extends DbEntity> entityType, String statement, Object parameter, DbOperationType operationType) {
        DbBulkOperation bulkOperation = this.createDbBulkOperation(entityType, statement, parameter, operationType);
        this.dbOperationManager.addOperation(bulkOperation);
        return bulkOperation;
    }

    protected DbBulkOperation performBulkOperationPreserveOrder(Class<? extends DbEntity> entityType, String statement, Object parameter, DbOperationType operationType) {
        DbBulkOperation bulkOperation = this.createDbBulkOperation(entityType, statement, parameter, operationType);
        this.dbOperationManager.addOperationPreserveOrder(bulkOperation);
        return bulkOperation;
    }

    private DbBulkOperation createDbBulkOperation(Class<? extends DbEntity> entityType, String statement, Object parameter, DbOperationType operationType) {
        DbBulkOperation bulkOperation = new DbBulkOperation();
        bulkOperation.setOperationType(operationType);
        bulkOperation.setEntityType(entityType);
        bulkOperation.setStatement(statement);
        bulkOperation.setParameter(parameter);
        return bulkOperation;
    }

    protected void performEntityOperation(CachedDbEntity cachedDbEntity, DbOperationType type) {
        DbEntityOperation dbOperation = new DbEntityOperation();
        dbOperation.setEntity(cachedDbEntity.getEntity());
        dbOperation.setFlushRelevantEntityReferences(cachedDbEntity.getFlushRelevantEntityReferences());
        dbOperation.setOperationType(type);
        this.dbOperationManager.addOperation(dbOperation);
    }

    @Override
    public void close() {
    }

    public boolean isDeleted(DbEntity object) {
        return this.dbEntityCache.isDeleted(object);
    }

    protected void ensureHasId(DbEntity dbEntity) {
        if (dbEntity.getId() == null) {
            String nextId = this.idGenerator.getNextId();
            dbEntity.setId(nextId);
        }
    }

    protected void validateId(DbEntity dbEntity) {
        EnsureUtil.ensureValidIndividualResourceId("Entity " + dbEntity + " has an invalid id", dbEntity.getId());
    }

    public <T extends DbEntity> List<T> pruneDeletedEntities(List<T> listToPrune) {
        ArrayList<DbEntity> prunedList = new ArrayList<DbEntity>();
        for (DbEntity potentiallyDeleted : listToPrune) {
            if (this.isDeleted(potentiallyDeleted)) continue;
            prunedList.add(potentiallyDeleted);
        }
        return prunedList;
    }

    public boolean contains(DbEntity dbEntity) {
        return this.dbEntityCache.contains(dbEntity);
    }

    public DbOperationManager getDbOperationManager() {
        return this.dbOperationManager;
    }

    public void setDbOperationManager(DbOperationManager operationManager) {
        this.dbOperationManager = operationManager;
    }

    public DbEntityCache getDbEntityCache() {
        return this.dbEntityCache;
    }

    public void setDbEntityCache(DbEntityCache dbEntityCache) {
        this.dbEntityCache = dbEntityCache;
    }

    public DeploymentQueryImpl createDeploymentQuery() {
        return new DeploymentQueryImpl();
    }

    public ProcessDefinitionQueryImpl createProcessDefinitionQuery() {
        return new ProcessDefinitionQueryImpl();
    }

    public CaseDefinitionQueryImpl createCaseDefinitionQuery() {
        return new CaseDefinitionQueryImpl();
    }

    public ProcessInstanceQueryImpl createProcessInstanceQuery() {
        return new ProcessInstanceQueryImpl();
    }

    public ExecutionQueryImpl createExecutionQuery() {
        return new ExecutionQueryImpl();
    }

    public TaskQueryImpl createTaskQuery() {
        return new TaskQueryImpl();
    }

    public JobQueryImpl createJobQuery() {
        return new JobQueryImpl();
    }

    public HistoricProcessInstanceQueryImpl createHistoricProcessInstanceQuery() {
        return new HistoricProcessInstanceQueryImpl();
    }

    public HistoricActivityInstanceQueryImpl createHistoricActivityInstanceQuery() {
        return new HistoricActivityInstanceQueryImpl();
    }

    public HistoricTaskInstanceQueryImpl createHistoricTaskInstanceQuery() {
        return new HistoricTaskInstanceQueryImpl();
    }

    public HistoricDetailQueryImpl createHistoricDetailQuery() {
        return new HistoricDetailQueryImpl();
    }

    public HistoricVariableInstanceQueryImpl createHistoricVariableInstanceQuery() {
        return new HistoricVariableInstanceQueryImpl();
    }

    public HistoricJobLogQueryImpl createHistoricJobLogQuery() {
        return new HistoricJobLogQueryImpl();
    }

    public UserQueryImpl createUserQuery() {
        return new DbUserQueryImpl();
    }

    public GroupQueryImpl createGroupQuery() {
        return new DbGroupQueryImpl();
    }

    public void registerOptimisticLockingListener(OptimisticLockingListener optimisticLockingListener) {
        if (this.optimisticLockingListeners == null) {
            this.optimisticLockingListeners = new ArrayList<OptimisticLockingListener>();
        }
        this.optimisticLockingListeners.add(optimisticLockingListener);
    }

    public List<String> getTableNamesPresentInDatabase() {
        return this.persistenceSession.getTableNamesPresent();
    }
}

