/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.history;

import java.util.Calendar;
import java.util.Date;
import org.camunda.bpm.engine.impl.history.HistoryRemovalTimeProvider;
import org.camunda.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class DefaultHistoryRemovalTimeProvider
implements HistoryRemovalTimeProvider {
    @Override
    public Date calculateRemovalTime(HistoricProcessInstanceEventEntity historicRootProcessInstance, ProcessDefinition processDefinition) {
        Integer historyTimeToLive = processDefinition.getHistoryTimeToLive();
        if (historyTimeToLive != null) {
            if (this.isProcessInstanceRunning(historicRootProcessInstance)) {
                Date startTime = historicRootProcessInstance.getStartTime();
                return this.determineRemovalTime(startTime, historyTimeToLive);
            }
            if (this.isProcessInstanceEnded(historicRootProcessInstance)) {
                Date endTime = historicRootProcessInstance.getEndTime();
                return this.determineRemovalTime(endTime, historyTimeToLive);
            }
        }
        return null;
    }

    protected boolean isProcessInstanceRunning(HistoricProcessInstanceEventEntity historicProcessInstance) {
        return historicProcessInstance.getEndTime() == null;
    }

    protected boolean isProcessInstanceEnded(HistoricProcessInstanceEventEntity historicProcessInstance) {
        return historicProcessInstance.getEndTime() != null;
    }

    protected Date determineRemovalTime(Date initTime, Integer timeToLive) {
        Calendar removalTime = Calendar.getInstance();
        removalTime.setTime(initTime);
        removalTime.add(5, timeToLive);
        return removalTime.getTime();
    }
}

