/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.history.producer;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.dmn.engine.delegate.DmnDecisionEvaluationEvent;
import org.camunda.bpm.dmn.engine.delegate.DmnDecisionLiteralExpressionEvaluationEvent;
import org.camunda.bpm.dmn.engine.delegate.DmnDecisionLogicEvaluationEvent;
import org.camunda.bpm.dmn.engine.delegate.DmnDecisionTableEvaluationEvent;
import org.camunda.bpm.dmn.engine.delegate.DmnEvaluatedDecisionRule;
import org.camunda.bpm.dmn.engine.delegate.DmnEvaluatedInput;
import org.camunda.bpm.dmn.engine.delegate.DmnEvaluatedOutput;
import org.camunda.bpm.engine.delegate.DelegateCaseExecution;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.history.HistoricDecisionInputInstance;
import org.camunda.bpm.engine.history.HistoricDecisionOutputInstance;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProvider;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProviderHistoricDecisionInstanceContext;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionEvaluationEvent;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInputInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionOutputInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.producer.DmnHistoryEventProducer;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.DoubleValue;
import org.camunda.bpm.engine.variable.value.IntegerValue;
import org.camunda.bpm.engine.variable.value.LongValue;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class DefaultDmnHistoryEventProducer
implements DmnHistoryEventProducer {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;

    @Override
    public HistoryEvent createDecisionEvaluatedEvt(final DelegateExecution execution, DmnDecisionEvaluationEvent evaluationEvent) {
        return this.createHistoryEvent(evaluationEvent, new HistoricDecisionInstanceSupplier(){

            @Override
            public HistoricDecisionInstanceEntity createHistoricDecisionInstance(DmnDecisionLogicEvaluationEvent evaluationEvent) {
                return DefaultDmnHistoryEventProducer.this.createDecisionEvaluatedEvt(evaluationEvent, (ExecutionEntity)execution);
            }
        });
    }

    @Override
    public HistoryEvent createDecisionEvaluatedEvt(final DelegateCaseExecution execution, DmnDecisionEvaluationEvent evaluationEvent) {
        return this.createHistoryEvent(evaluationEvent, new HistoricDecisionInstanceSupplier(){

            @Override
            public HistoricDecisionInstanceEntity createHistoricDecisionInstance(DmnDecisionLogicEvaluationEvent evaluationEvent) {
                return DefaultDmnHistoryEventProducer.this.createDecisionEvaluatedEvt(evaluationEvent, (CaseExecutionEntity)execution);
            }
        });
    }

    @Override
    public HistoryEvent createDecisionEvaluatedEvt(DmnDecisionEvaluationEvent evaluationEvent) {
        return this.createHistoryEvent(evaluationEvent, new HistoricDecisionInstanceSupplier(){

            @Override
            public HistoricDecisionInstanceEntity createHistoricDecisionInstance(DmnDecisionLogicEvaluationEvent evaluationEvent) {
                return DefaultDmnHistoryEventProducer.this.createDecisionEvaluatedEvt(evaluationEvent);
            }
        });
    }

    protected HistoryEvent createHistoryEvent(DmnDecisionEvaluationEvent evaluationEvent, HistoricDecisionInstanceSupplier supplier) {
        HistoricDecisionEvaluationEvent event = this.newDecisionEvaluationEvent(evaluationEvent);
        HistoricDecisionInstanceEntity rootDecisionEvent = supplier.createHistoricDecisionInstance(evaluationEvent.getDecisionResult());
        Date removalTime = null;
        if (rootDecisionEvent.getRootProcessInstanceId() == null) {
            removalTime = this.getRemovalTime(rootDecisionEvent.getEvaluationTime(), evaluationEvent.getDecisionResult());
            rootDecisionEvent.setRemovalTime(removalTime);
        }
        event.setRootHistoricDecisionInstance(rootDecisionEvent);
        ArrayList<HistoricDecisionInstanceEntity> requiredDecisionEvents = new ArrayList<HistoricDecisionInstanceEntity>();
        for (DmnDecisionLogicEvaluationEvent requiredDecisionResult : evaluationEvent.getRequiredDecisionResults()) {
            HistoricDecisionInstanceEntity requiredDecisionEvent = supplier.createHistoricDecisionInstance(requiredDecisionResult);
            if (requiredDecisionEvent.getRemovalTime() == null) {
                requiredDecisionEvent.setRemovalTime(removalTime);
            }
            requiredDecisionEvents.add(requiredDecisionEvent);
        }
        event.setRequiredHistoricDecisionInstances(requiredDecisionEvents);
        return event;
    }

    protected HistoricDecisionInstanceEntity createDecisionEvaluatedEvt(DmnDecisionLogicEvaluationEvent evaluationEvent, ExecutionEntity execution) {
        HistoricDecisionInstanceEntity event = this.newDecisionInstanceEventEntity(execution, evaluationEvent);
        this.setReferenceToProcessInstance(event, execution);
        if (this.isHistoryRemovalTimeStrategyProcessStart()) {
            this.provideRemovalTime(event);
        }
        this.initDecisionInstanceEvent(event, evaluationEvent, HistoryEventTypes.DMN_DECISION_EVALUATE);
        event.setEvaluationTime(ClockUtil.getCurrentTime());
        DecisionDefinition decisionDefinition = (DecisionDefinition)evaluationEvent.getDecision();
        String tenantId = execution.getTenantId();
        if (tenantId == null) {
            tenantId = this.provideTenantId(decisionDefinition, event);
        }
        event.setTenantId(tenantId);
        return event;
    }

    protected HistoricDecisionInstanceEntity createDecisionEvaluatedEvt(DmnDecisionLogicEvaluationEvent evaluationEvent, CaseExecutionEntity execution) {
        HistoricDecisionInstanceEntity event = this.newDecisionInstanceEventEntity(execution, evaluationEvent);
        this.initDecisionInstanceEvent(event, evaluationEvent, HistoryEventTypes.DMN_DECISION_EVALUATE);
        this.setReferenceToCaseInstance(event, execution);
        event.setEvaluationTime(ClockUtil.getCurrentTime());
        DecisionDefinition decisionDefinition = (DecisionDefinition)evaluationEvent.getDecision();
        String tenantId = execution.getTenantId();
        if (tenantId == null) {
            tenantId = this.provideTenantId(decisionDefinition, event);
        }
        event.setTenantId(tenantId);
        return event;
    }

    protected HistoricDecisionInstanceEntity createDecisionEvaluatedEvt(DmnDecisionLogicEvaluationEvent evaluationEvent) {
        HistoricDecisionInstanceEntity event = this.newDecisionInstanceEventEntity(evaluationEvent);
        this.initDecisionInstanceEvent(event, evaluationEvent, HistoryEventTypes.DMN_DECISION_EVALUATE);
        event.setEvaluationTime(ClockUtil.getCurrentTime());
        this.setUserId(event);
        DecisionDefinition decisionDefinition = (DecisionDefinition)evaluationEvent.getDecision();
        String tenantId = decisionDefinition.getTenantId();
        if (tenantId == null) {
            tenantId = this.provideTenantId(decisionDefinition, event);
        }
        event.setTenantId(tenantId);
        return event;
    }

    protected HistoricDecisionEvaluationEvent newDecisionEvaluationEvent(DmnDecisionEvaluationEvent evaluationEvent) {
        return new HistoricDecisionEvaluationEvent();
    }

    protected HistoricDecisionInstanceEntity newDecisionInstanceEventEntity(ExecutionEntity executionEntity, DmnDecisionLogicEvaluationEvent evaluationEvent) {
        return new HistoricDecisionInstanceEntity();
    }

    protected HistoricDecisionInstanceEntity newDecisionInstanceEventEntity(CaseExecutionEntity executionEntity, DmnDecisionLogicEvaluationEvent evaluationEvent) {
        return new HistoricDecisionInstanceEntity();
    }

    protected HistoricDecisionInstanceEntity newDecisionInstanceEventEntity(DmnDecisionLogicEvaluationEvent evaluationEvent) {
        return new HistoricDecisionInstanceEntity();
    }

    protected void initDecisionInstanceEvent(HistoricDecisionInstanceEntity event, DmnDecisionLogicEvaluationEvent evaluationEvent, HistoryEventTypes eventType) {
        event.setEventType(eventType.getEventName());
        DecisionDefinition decision = (DecisionDefinition)evaluationEvent.getDecision();
        event.setDecisionDefinitionId(decision.getId());
        event.setDecisionDefinitionKey(decision.getKey());
        event.setDecisionDefinitionName(decision.getName());
        if (decision.getDecisionRequirementsDefinitionId() != null) {
            event.setDecisionRequirementsDefinitionId(decision.getDecisionRequirementsDefinitionId());
            event.setDecisionRequirementsDefinitionKey(decision.getDecisionRequirementsDefinitionKey());
        }
        if (evaluationEvent instanceof DmnDecisionTableEvaluationEvent) {
            this.initDecisionInstanceEventForDecisionTable(event, (DmnDecisionTableEvaluationEvent)evaluationEvent);
        } else if (evaluationEvent instanceof DmnDecisionLiteralExpressionEvaluationEvent) {
            this.initDecisionInstanceEventForDecisionLiteralExpression(event, (DmnDecisionLiteralExpressionEvaluationEvent)evaluationEvent);
        } else {
            event.setInputs(Collections.emptyList());
            event.setOutputs(Collections.emptyList());
        }
    }

    protected void initDecisionInstanceEventForDecisionTable(HistoricDecisionInstanceEntity event, DmnDecisionTableEvaluationEvent evaluationEvent) {
        if (evaluationEvent.getCollectResultValue() != null) {
            Double collectResultValue = this.getCollectResultValue(evaluationEvent.getCollectResultValue());
            event.setCollectResultValue(collectResultValue);
        }
        List<HistoricDecisionInputInstance> historicDecisionInputInstances = this.createHistoricDecisionInputInstances(evaluationEvent, event.getRootProcessInstanceId(), event.getRemovalTime());
        event.setInputs(historicDecisionInputInstances);
        List<HistoricDecisionOutputInstance> historicDecisionOutputInstances = this.createHistoricDecisionOutputInstances(evaluationEvent, event.getRootProcessInstanceId(), event.getRemovalTime());
        event.setOutputs(historicDecisionOutputInstances);
    }

    protected Double getCollectResultValue(TypedValue collectResultValue) {
        if (collectResultValue instanceof IntegerValue) {
            return ((Integer)((IntegerValue)collectResultValue).getValue()).doubleValue();
        }
        if (collectResultValue instanceof LongValue) {
            return ((Long)((LongValue)collectResultValue).getValue()).doubleValue();
        }
        if (collectResultValue instanceof DoubleValue) {
            return (Double)((DoubleValue)collectResultValue).getValue();
        }
        throw LOG.collectResultValueOfUnsupportedTypeException(collectResultValue);
    }

    protected List<HistoricDecisionInputInstance> createHistoricDecisionInputInstances(DmnDecisionTableEvaluationEvent evaluationEvent, String rootProcessInstanceId, Date removalTime) {
        ArrayList<HistoricDecisionInputInstance> inputInstances = new ArrayList<HistoricDecisionInputInstance>();
        for (DmnEvaluatedInput inputClause : evaluationEvent.getInputs()) {
            HistoricDecisionInputInstanceEntity inputInstance = new HistoricDecisionInputInstanceEntity(rootProcessInstanceId, removalTime);
            inputInstance.setClauseId(inputClause.getId());
            inputInstance.setClauseName(inputClause.getName());
            inputInstance.setCreateTime(ClockUtil.getCurrentTime());
            TypedValue typedValue = Variables.untypedValue((Object)inputClause.getValue());
            inputInstance.setValue(typedValue);
            inputInstances.add(inputInstance);
        }
        return inputInstances;
    }

    protected List<HistoricDecisionOutputInstance> createHistoricDecisionOutputInstances(DmnDecisionTableEvaluationEvent evaluationEvent, String rootProcessInstanceId, Date removalTime) {
        ArrayList<HistoricDecisionOutputInstance> outputInstances = new ArrayList<HistoricDecisionOutputInstance>();
        List matchingRules = evaluationEvent.getMatchingRules();
        for (int index = 0; index < matchingRules.size(); ++index) {
            DmnEvaluatedDecisionRule rule = (DmnEvaluatedDecisionRule)matchingRules.get(index);
            String ruleId = rule.getId();
            Integer ruleOrder = index + 1;
            for (DmnEvaluatedOutput outputClause : rule.getOutputEntries().values()) {
                HistoricDecisionOutputInstanceEntity outputInstance = new HistoricDecisionOutputInstanceEntity(rootProcessInstanceId, removalTime);
                outputInstance.setClauseId(outputClause.getId());
                outputInstance.setClauseName(outputClause.getName());
                outputInstance.setCreateTime(ClockUtil.getCurrentTime());
                outputInstance.setRuleId(ruleId);
                outputInstance.setRuleOrder(ruleOrder);
                outputInstance.setVariableName(outputClause.getOutputName());
                outputInstance.setValue(outputClause.getValue());
                outputInstances.add(outputInstance);
            }
        }
        return outputInstances;
    }

    protected void initDecisionInstanceEventForDecisionLiteralExpression(HistoricDecisionInstanceEntity event, DmnDecisionLiteralExpressionEvaluationEvent evaluationEvent) {
        event.setInputs(Collections.emptyList());
        HistoricDecisionOutputInstanceEntity outputInstance = new HistoricDecisionOutputInstanceEntity(event.getRootProcessInstanceId(), event.getRemovalTime());
        outputInstance.setVariableName(evaluationEvent.getOutputName());
        outputInstance.setValue(evaluationEvent.getOutputValue());
        event.setOutputs(Collections.singletonList(outputInstance));
    }

    protected void setReferenceToProcessInstance(HistoricDecisionInstanceEntity event, ExecutionEntity execution) {
        event.setProcessDefinitionKey(this.getProcessDefinitionKey(execution));
        event.setProcessDefinitionId(execution.getProcessDefinitionId());
        event.setRootProcessInstanceId(execution.getRootProcessInstanceId());
        event.setProcessInstanceId(execution.getProcessInstanceId());
        event.setExecutionId(execution.getId());
        event.setActivityId(execution.getActivityId());
        event.setActivityInstanceId(execution.getActivityInstanceId());
    }

    protected String getProcessDefinitionKey(ExecutionEntity execution) {
        ProcessDefinitionEntity definition = execution.getProcessDefinition();
        if (definition != null) {
            return definition.getKey();
        }
        return null;
    }

    protected void setReferenceToCaseInstance(HistoricDecisionInstanceEntity event, CaseExecutionEntity execution) {
        event.setCaseDefinitionKey(this.getCaseDefinitionKey(execution));
        event.setCaseDefinitionId(execution.getCaseDefinitionId());
        event.setCaseInstanceId(execution.getCaseInstanceId());
        event.setExecutionId(execution.getId());
        event.setActivityId(execution.getActivityId());
        event.setActivityInstanceId(execution.getId());
    }

    protected String getCaseDefinitionKey(CaseExecutionEntity execution) {
        CaseDefinitionEntity definition = (CaseDefinitionEntity)execution.getCaseDefinition();
        if (definition != null) {
            return definition.getKey();
        }
        return null;
    }

    protected void setUserId(HistoricDecisionInstanceEntity event) {
        event.setUserId(Context.getCommandContext().getAuthenticatedUserId());
    }

    protected String provideTenantId(DecisionDefinition decisionDefinition, HistoricDecisionInstanceEntity event) {
        TenantIdProvider tenantIdProvider = Context.getProcessEngineConfiguration().getTenantIdProvider();
        String tenantId = null;
        if (tenantIdProvider != null) {
            TenantIdProviderHistoricDecisionInstanceContext ctx = null;
            ctx = event.getExecutionId() != null ? new TenantIdProviderHistoricDecisionInstanceContext(decisionDefinition, this.getExecution(event)) : (event.getCaseExecutionId() != null ? new TenantIdProviderHistoricDecisionInstanceContext(decisionDefinition, this.getCaseExecution(event)) : new TenantIdProviderHistoricDecisionInstanceContext(decisionDefinition));
            tenantId = tenantIdProvider.provideTenantIdForHistoricDecisionInstance(ctx);
        }
        return tenantId;
    }

    protected DelegateExecution getExecution(HistoricDecisionInstanceEntity event) {
        return Context.getCommandContext().getExecutionManager().findExecutionById(event.getExecutionId());
    }

    protected DelegateCaseExecution getCaseExecution(HistoricDecisionInstanceEntity event) {
        return Context.getCommandContext().getCaseExecutionManager().findCaseExecutionById(event.getCaseExecutionId());
    }

    protected Date getRemovalTime(Date evaluationTime, DmnDecisionLogicEvaluationEvent evaluationEvent) {
        DecisionDefinition decision = (DecisionDefinition)evaluationEvent.getDecision();
        Integer ttl = decision.getHistoryTimeToLive();
        if (ttl == null) {
            return null;
        }
        Calendar removeTime = Calendar.getInstance();
        removeTime.setTime(evaluationTime);
        removeTime.add(5, ttl);
        return removeTime.getTime();
    }

    protected void provideRemovalTime(HistoryEvent historyEvent) {
        HistoricProcessInstanceEventEntity historicRootProcessInstance;
        String rootProcessInstanceId = historyEvent.getRootProcessInstanceId();
        if (rootProcessInstanceId != null && (historicRootProcessInstance = this.getHistoricRootProcessInstance(rootProcessInstanceId)) != null) {
            Date removalTime = historicRootProcessInstance.getRemovalTime();
            historyEvent.setRemovalTime(removalTime);
        }
    }

    protected boolean isHistoryRemovalTimeStrategyProcessStart() {
        return "process-start".equals(this.getHistoryRemovalTimeStrategy());
    }

    protected String getHistoryRemovalTimeStrategy() {
        return Context.getProcessEngineConfiguration().getHistoryRemovalTimeStrategy();
    }

    protected HistoricProcessInstanceEventEntity getHistoricRootProcessInstance(String rootProcessInstanceId) {
        return Context.getCommandContext().getDbEntityManager().selectById(HistoricProcessInstanceEventEntity.class, rootProcessInstanceId);
    }

    protected static interface HistoricDecisionInstanceSupplier {
        public HistoricDecisionInstanceEntity createHistoricDecisionInstance(DmnDecisionLogicEvaluationEvent var1);
    }
}

