/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor.historycleanup;

import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHandler;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHelper;

public class HistoryCleanupBatch
extends HistoryCleanupHandler {
    private List<String> historicProcessInstanceIds = Collections.emptyList();
    private List<String> historicDecisionInstanceIds = Collections.emptyList();
    private List<String> historicCaseInstanceIds = Collections.emptyList();
    private List<String> historicBatchIds = Collections.emptyList();

    public List<String> getHistoricProcessInstanceIds() {
        return this.historicProcessInstanceIds;
    }

    public void setHistoricProcessInstanceIds(List<String> historicProcessInstanceIds) {
        this.historicProcessInstanceIds = historicProcessInstanceIds;
    }

    public List<String> getHistoricDecisionInstanceIds() {
        return this.historicDecisionInstanceIds;
    }

    public void setHistoricDecisionInstanceIds(List<String> historicDecisionInstanceIds) {
        this.historicDecisionInstanceIds = historicDecisionInstanceIds;
    }

    public List<String> getHistoricCaseInstanceIds() {
        return this.historicCaseInstanceIds;
    }

    public void setHistoricCaseInstanceIds(List<String> historicCaseInstanceIds) {
        this.historicCaseInstanceIds = historicCaseInstanceIds;
    }

    public List<String> getHistoricBatchIds() {
        return this.historicBatchIds;
    }

    public void setHistoricBatchIds(List<String> historicBatchIds) {
        this.historicBatchIds = historicBatchIds;
    }

    public int size() {
        return this.historicProcessInstanceIds.size() + this.historicDecisionInstanceIds.size() + this.historicCaseInstanceIds.size() + this.historicBatchIds.size();
    }

    @Override
    public void performCleanup() {
        CommandContext commandContext = Context.getCommandContext();
        HistoryCleanupHelper.prepareNextBatch(this, commandContext);
        if (this.size() > 0) {
            if (this.historicProcessInstanceIds.size() > 0) {
                commandContext.getHistoricProcessInstanceManager().deleteHistoricProcessInstanceByIds(this.historicProcessInstanceIds);
                this.reportValue("history-cleanup-removed-process-instances", this.historicProcessInstanceIds.size());
            }
            if (this.historicDecisionInstanceIds.size() > 0) {
                commandContext.getHistoricDecisionInstanceManager().deleteHistoricDecisionInstanceByIds(this.historicDecisionInstanceIds);
                this.reportValue("history-cleanup-removed-decision-instances", this.historicDecisionInstanceIds.size());
            }
            if (this.historicCaseInstanceIds.size() > 0) {
                commandContext.getHistoricCaseInstanceManager().deleteHistoricCaseInstancesByIds(this.historicCaseInstanceIds);
                this.reportValue("history-cleanup-removed-case-instances", this.historicCaseInstanceIds.size());
            }
            if (this.historicBatchIds.size() > 0) {
                commandContext.getHistoricBatchManager().deleteHistoricBatchesByIds(this.historicBatchIds);
                this.reportValue("history-cleanup-removed-batch-operations", this.historicBatchIds.size());
            }
        }
        this.setRescheduleNow(this.isBatchThresholdReached());
    }

    protected boolean isBatchThresholdReached() {
        return this.size() >= this.getBatchSizeThreshold();
    }

    public Integer getBatchSizeThreshold() {
        return Context.getCommandContext().getProcessEngineConfiguration().getHistoryCleanupBatchThreshold();
    }
}

