/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor.historycleanup;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.impl.cfg.TransactionListener;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupJobHandlerConfiguration;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupSchedulerCmd;

public abstract class HistoryCleanupHandler
implements TransactionListener {
    public static final int MAX_BATCH_SIZE = 500;
    protected HistoryCleanupJobHandlerConfiguration configuration;
    protected String jobId;
    protected CommandExecutor commandExecutor;
    protected boolean isRescheduleNow = false;
    protected Map<String, Long> report = new HashMap<String, Long>();

    @Override
    public void execute(CommandContext commandContext) {
        this.commandExecutor.execute(new HistoryCleanupSchedulerCmd(this.isRescheduleNow, this.report, this.configuration, this.jobId));
    }

    abstract void performCleanup();

    protected void reportValue(String name, long value) {
        this.report.put(name, value);
    }

    public HistoryCleanupJobHandlerConfiguration getConfiguration() {
        return this.configuration;
    }

    public HistoryCleanupHandler setConfiguration(HistoryCleanupJobHandlerConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public HistoryCleanupHandler setJobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    public HistoryCleanupHandler setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        return this;
    }

    public void setRescheduleNow(boolean rescheduleNow) {
        this.isRescheduleNow = rescheduleNow;
    }
}

