/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor.historycleanup;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInstanceEntity;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHandler;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;

public class HistoryCleanupRemovalTime
extends HistoryCleanupHandler {
    protected Map<Class<? extends DbEntity>, DbOperation> deleteOperations = new HashMap<Class<? extends DbEntity>, DbOperation>();

    @Override
    public void performCleanup() {
        this.deleteOperations.putAll(this.performProcessCleanup());
        if (this.isDmnEnabled()) {
            this.deleteOperations.putAll(this.performDmnCleanup());
        }
    }

    @Override
    public void execute(CommandContext commandContext) {
        this.reportMetrics();
        this.setRescheduleNow(this.isMaxBatchExceeded());
        super.execute(commandContext);
    }

    protected Map<Class<? extends DbEntity>, DbOperation> performDmnCleanup() {
        return Context.getCommandContext().getHistoricDecisionInstanceManager().deleteHistoricDecisionsByRemovalTime(ClockUtil.getCurrentTime(), this.configuration.getMinuteFrom(), this.configuration.getMinuteTo(), this.getBatchSizePerDeleteOperation());
    }

    protected Map<Class<? extends DbEntity>, DbOperation> performProcessCleanup() {
        return Context.getCommandContext().getHistoricProcessInstanceManager().deleteHistoricProcessInstancesByRemovalTime(ClockUtil.getCurrentTime(), this.configuration.getMinuteFrom(), this.configuration.getMinuteTo(), this.getBatchSizePerDeleteOperation());
    }

    protected boolean isDmnEnabled() {
        return Context.getCommandContext().getProcessEngineConfiguration().isDmnEnabled();
    }

    protected void reportMetrics() {
        DbOperation deleteOperationDecisionInstance;
        DbOperation deleteOperationProcessInstance = this.deleteOperations.get(HistoricProcessInstanceEntity.class);
        if (deleteOperationProcessInstance != null) {
            this.reportValue("history-cleanup-removed-process-instances", deleteOperationProcessInstance.getRowsAffected());
        }
        if (this.isDmnEnabled() && (deleteOperationDecisionInstance = this.deleteOperations.get(HistoricDecisionInstanceEntity.class)) != null) {
            this.reportValue("history-cleanup-removed-decision-instances", deleteOperationDecisionInstance.getRowsAffected());
        }
    }

    protected boolean isMaxBatchExceeded() {
        for (DbOperation deleteOperation : this.deleteOperations.values()) {
            if (deleteOperation.getRowsAffected() != this.getBatchSizePerDeleteOperation()) continue;
            return true;
        }
        return false;
    }

    public int getBatchSizePerDeleteOperation() {
        return Context.getCommandContext().getProcessEngineConfiguration().getHistoryCleanupBatchSize();
    }
}

