/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.filter;

import java.util.HashMap;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.impl.TaskQueryImpl;
import org.camunda.bpm.engine.impl.persistence.entity.FilterEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.task.TaskQuery;

public class FilterServiceTest
extends PluggableProcessEngineTestCase {
    protected Filter filter;

    public void setUp() {
        this.filter = this.filterService.newTaskFilter().setName("name").setOwner("owner").setQuery((Query)this.taskService.createTaskQuery()).setProperties(new HashMap());
        FilterServiceTest.assertNull((Object)this.filter.getId());
        this.filterService.saveFilter(this.filter);
        FilterServiceTest.assertNotNull((Object)this.filter.getId());
    }

    public void tearDown() {
        for (Filter filter : this.filterService.createTaskFilterQuery().list()) {
            this.filterService.deleteFilter(filter.getId());
        }
    }

    public void testCreateFilter() {
        FilterServiceTest.assertNotNull((Object)this.filter);
        Filter filter2 = this.filterService.getFilter(this.filter.getId());
        FilterServiceTest.assertNotNull((Object)filter2);
        FilterServiceTest.compareFilter(this.filter, filter2);
    }

    public void testCreateInvalidFilter() {
        try {
            this.filter.setName(null);
            FilterServiceTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.filter.setName("");
            FilterServiceTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.filter.setQuery((Query)null);
            FilterServiceTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testUpdateFilter() {
        this.filter.setName("newName");
        this.filter.setOwner("newOwner");
        this.filter.setQuery((Query)this.taskService.createTaskQuery());
        this.filter.setProperties(new HashMap());
        this.filterService.saveFilter(this.filter);
        Filter filter2 = this.filterService.getFilter(this.filter.getId());
        FilterServiceTest.compareFilter(this.filter, filter2);
    }

    public void testExtendFilter() {
        TaskQuery extendingQuery = this.taskService.createTaskQuery().taskName("newName").taskOwner("newOwner");
        Filter newFilter = this.filter.extend((Query)extendingQuery);
        FilterServiceTest.assertNull((Object)newFilter.getId());
        TaskQueryImpl filterQuery = (TaskQueryImpl)newFilter.getQuery();
        FilterServiceTest.assertEquals((String)"newName", (String)filterQuery.getName());
        FilterServiceTest.assertEquals((String)"newOwner", (String)filterQuery.getOwner());
    }

    public void testQueryFilter() {
        Filter filter2 = (Filter)this.filterService.createTaskFilterQuery().filterId(this.filter.getId()).filterName("name").filterOwner("owner").singleResult();
        FilterServiceTest.compareFilter(this.filter, filter2);
        filter2 = (Filter)this.filterService.createTaskFilterQuery().filterNameLike("%m%").singleResult();
        FilterServiceTest.compareFilter(this.filter, filter2);
    }

    public void testQueryUnknownFilter() {
        Filter unknownFilter = (Filter)this.filterService.createTaskFilterQuery().filterId("unknown").singleResult();
        FilterServiceTest.assertNull((Object)unknownFilter);
        unknownFilter = (Filter)this.filterService.createTaskFilterQuery().filterId(this.filter.getId()).filterName("invalid").singleResult();
        FilterServiceTest.assertNull((Object)unknownFilter);
    }

    public void testDeleteFilter() {
        this.filterService.deleteFilter(this.filter.getId());
        this.filter = this.filterService.getFilter(this.filter.getId());
        FilterServiceTest.assertNull((Object)this.filter);
    }

    public void testDeleteUnknownFilter() {
        this.filterService.deleteFilter(this.filter.getId());
        long count = this.filterService.createFilterQuery().count();
        FilterServiceTest.assertEquals((long)0L, (long)count);
        try {
            this.filterService.deleteFilter(this.filter.getId());
            FilterServiceTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public static void compareFilter(Filter filter1, Filter filter2) {
        FilterServiceTest.assertNotNull((Object)filter1);
        FilterServiceTest.assertNotNull((Object)filter2);
        FilterServiceTest.assertEquals((String)filter1.getId(), (String)filter2.getId());
        FilterServiceTest.assertEquals((String)filter1.getResourceType(), (String)filter2.getResourceType());
        FilterServiceTest.assertEquals((String)filter1.getName(), (String)filter2.getName());
        FilterServiceTest.assertEquals((String)filter1.getOwner(), (String)filter2.getOwner());
        FilterServiceTest.assertEquals((String)((FilterEntity)filter1).getQueryInternal(), (String)((FilterEntity)filter2).getQueryInternal());
        FilterServiceTest.assertEquals((Object)filter1.getProperties(), (Object)filter2.getProperties());
    }
}

