/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.api.delegate.AssertingJavaDelegate;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyDelegateExecutionTest
extends PluggableProcessEngineTestCase {
    protected static final String PROCESS_DEFINITION_KEY = "testProcess";

    public void testSingleExecution() {
        this.deploymentForTenant("tenant1", new BpmnModelInstance[]{((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().serviceTask().camundaClass(AssertingJavaDelegate.class.getName())).endEvent().done()});
        AssertingJavaDelegate.addAsserts(MultiTenancyDelegateExecutionTest.hasTenantId("tenant1"));
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
    }

    public void testConcurrentExecution() {
        this.deploymentForTenant("tenant1", new BpmnModelInstance[]{((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().parallelGateway("fork").serviceTask().camundaClass(AssertingJavaDelegate.class.getName())).parallelGateway("join").endEvent().moveToNode("fork").serviceTask().camundaClass(AssertingJavaDelegate.class.getName())).connectTo("join").done()});
        AssertingJavaDelegate.addAsserts(MultiTenancyDelegateExecutionTest.hasTenantId("tenant1"));
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
    }

    public void testEmbeddedSubprocess() {
        this.deploymentForTenant("tenant1", new BpmnModelInstance[]{((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().subProcess().embeddedSubProcess().startEvent().serviceTask().camundaClass(AssertingJavaDelegate.class.getName())).endEvent().subProcessDone().endEvent().done()});
        AssertingJavaDelegate.addAsserts(MultiTenancyDelegateExecutionTest.hasTenantId("tenant1"));
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
    }

    protected void startProcessInstance(String processDefinitionKey) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).latestVersion().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
    }

    protected void tearDown() throws Exception {
        AssertingJavaDelegate.clear();
        super.tearDown();
    }

    protected static AssertingJavaDelegate.DelegateExecutionAsserter hasTenantId(final String expectedTenantId) {
        return new AssertingJavaDelegate.DelegateExecutionAsserter(){

            @Override
            public void doAssert(DelegateExecution execution) {
                Assert.assertThat((Object)execution.getTenantId(), (Matcher)CoreMatchers.is((Object)expectedTenantId));
            }
        };
    }
}

