/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import org.camunda.bpm.engine.migration.MigrationInstructionsBuilder;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.CallActivityModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.CompensationModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.EventBasedGatewayModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.EventSubProcessModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ExternalTaskModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.GatewayModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.MessageReceiveModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.MultiInstanceProcessModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ServiceTaskModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.TransactionModels;
import org.camunda.bpm.engine.test.util.MigrationPlanAssert;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.camunda.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.camunda.bpm.model.bpmn.builder.SendTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.camunda.bpm.model.bpmn.instance.UserTask;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationPlanGenerationTest {
    public static final String MESSAGE_NAME = "Message";
    public static final String SIGNAL_NAME = "Signal";
    public static final String TIMER_DATE = "2016-02-11T12:13:14Z";
    public static final String ERROR_CODE = "Error";
    public static final String ESCALATION_CODE = "Escalation";
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testMapEqualActivitiesInProcessDefinitionScope() {
        BpmnModelInstance sourceProcess = ProcessModels.ONE_TASK_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.ONE_TASK_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapEqualActivitiesInSameSubProcessScope() {
        BpmnModelInstance sourceProcess = ProcessModels.SUBPROCESS_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.SUBPROCESS_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"), MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapEqualActivitiesToSubProcessScope() {
        BpmnModelInstance sourceProcess = ProcessModels.ONE_TASK_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.SUBPROCESS_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testMapEqualActivitiesToNestedSubProcessScope() {
        BpmnModelInstance sourceProcess = ProcessModels.SUBPROCESS_PROCESS;
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(ProcessModels.DOUBLE_SUBPROCESS_PROCESS).changeElementId("outerSubProcess", "subProcess");
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"));
    }

    @Test
    public void testMapEqualActivitiesToSurroundingSubProcessScope() {
        BpmnModelInstance sourceProcess = ProcessModels.SUBPROCESS_PROCESS;
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(ProcessModels.DOUBLE_SUBPROCESS_PROCESS).changeElementId("innerSubProcess", "subProcess");
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testMapEqualActivitiesToDeeplyNestedSubProcessScope() {
        BpmnModelInstance sourceProcess = ProcessModels.ONE_TASK_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.DOUBLE_SUBPROCESS_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testMapEqualActivitiesToSiblingScope() {
        BpmnModelInstance sourceProcess = ProcessModels.PARALLEL_SUBPROCESS_PROCESS;
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).swapElementIds("userTask1", "userTask2");
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("subProcess1").to("subProcess1"), MigrationPlanAssert.migrate("subProcess2").to("subProcess2"), MigrationPlanAssert.migrate("fork").to("fork"));
    }

    @Test
    public void testMapEqualActivitiesToNestedSiblingScope() {
        BpmnModelInstance sourceProcess = ProcessModels.PARALLEL_DOUBLE_SUBPROCESS_PROCESS;
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_DOUBLE_SUBPROCESS_PROCESS).swapElementIds("userTask1", "userTask2");
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("subProcess1").to("subProcess1"), MigrationPlanAssert.migrate("nestedSubProcess1").to("nestedSubProcess1"), MigrationPlanAssert.migrate("subProcess2").to("subProcess2"), MigrationPlanAssert.migrate("nestedSubProcess2").to("nestedSubProcess2"), MigrationPlanAssert.migrate("fork").to("fork"));
    }

    @Test
    public void testMapEqualActivitiesWhichBecomeScope() {
        BpmnModelInstance sourceProcess = ProcessModels.ONE_TASK_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.SCOPE_TASK_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapEqualActivitiesWithParallelMultiInstance() {
        BpmnModelInstance testProcess = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((UserTask)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).getModelElementById("userTask")).builder().multiInstance().parallel()).cardinality("3")).multiInstanceDone().done();
        this.assertGeneratedMigrationPlan(testProcess, testProcess).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"), MigrationPlanAssert.migrate("userTask#multiInstanceBody").to("userTask#multiInstanceBody"));
    }

    @Test
    public void testMapEqualActivitiesIgnoreUnsupportedActivities() {
        BpmnModelInstance sourceProcess = ProcessModels.UNSUPPORTED_ACTIVITIES;
        BpmnModelInstance targetProcess = ProcessModels.UNSUPPORTED_ACTIVITIES;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testMapEqualUnsupportedAsyncBeforeActivities() {
        BpmnModelInstance testModel = ModifiableBpmnModelInstance.modify(ProcessModels.UNSUPPORTED_ACTIVITIES).flowNodeBuilder("startEvent").camundaAsyncBefore().moveToNode("decisionTask").camundaAsyncBefore().moveToNode("throwEvent").camundaAsyncAfter().moveToNode("serviceTask").camundaAsyncBefore().moveToNode("sendTask").camundaAsyncBefore().moveToNode("scriptTask").camundaAsyncBefore().moveToNode("endEvent").camundaAsyncBefore().done();
        this.assertGeneratedMigrationPlan(testModel, testModel).hasInstructions(MigrationPlanAssert.migrate("startEvent").to("startEvent"), MigrationPlanAssert.migrate("decisionTask").to("decisionTask"), MigrationPlanAssert.migrate("throwEvent").to("throwEvent"), MigrationPlanAssert.migrate("serviceTask").to("serviceTask"), MigrationPlanAssert.migrate("sendTask").to("sendTask"), MigrationPlanAssert.migrate("scriptTask").to("scriptTask"), MigrationPlanAssert.migrate("endEvent").to("endEvent"));
    }

    @Test
    public void testMapEqualUnsupportedAsyncAfterActivities() {
        BpmnModelInstance testModel = ModifiableBpmnModelInstance.modify(ProcessModels.UNSUPPORTED_ACTIVITIES).flowNodeBuilder("startEvent").camundaAsyncAfter().moveToNode("decisionTask").camundaAsyncAfter().moveToNode("throwEvent").camundaAsyncAfter().moveToNode("serviceTask").camundaAsyncAfter().moveToNode("sendTask").camundaAsyncAfter().moveToNode("scriptTask").camundaAsyncAfter().moveToNode("endEvent").camundaAsyncAfter().done();
        this.assertGeneratedMigrationPlan(testModel, testModel).hasInstructions(MigrationPlanAssert.migrate("startEvent").to("startEvent"), MigrationPlanAssert.migrate("decisionTask").to("decisionTask"), MigrationPlanAssert.migrate("throwEvent").to("throwEvent"), MigrationPlanAssert.migrate("serviceTask").to("serviceTask"), MigrationPlanAssert.migrate("sendTask").to("sendTask"), MigrationPlanAssert.migrate("scriptTask").to("scriptTask"), MigrationPlanAssert.migrate("endEvent").to("endEvent"));
    }

    @Test
    public void testMapEqualActivitiesToParentScope() {
        ModifiableBpmnModelInstance sourceProcess = ModifiableBpmnModelInstance.modify(ProcessModels.DOUBLE_SUBPROCESS_PROCESS).changeElementId("outerSubProcess", "subProcess");
        BpmnModelInstance targetProcess = ProcessModels.SUBPROCESS_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"));
    }

    @Test
    public void testMapEqualActivitiesFromScopeToProcessDefinition() {
        BpmnModelInstance sourceProcess = ProcessModels.SUBPROCESS_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.ONE_TASK_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testMapEqualActivitiesFromDoubleScopeToProcessDefinition() {
        BpmnModelInstance sourceProcess = ProcessModels.DOUBLE_SUBPROCESS_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.ONE_TASK_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testMapEqualActivitiesFromTripleScopeToProcessDefinition() {
        BpmnModelInstance sourceProcess = ProcessModels.TRIPLE_SUBPROCESS_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.ONE_TASK_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testMapEqualActivitiesFromTripleScopeToSingleNewScope() {
        BpmnModelInstance sourceProcess = ProcessModels.TRIPLE_SUBPROCESS_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.SUBPROCESS_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testMapEqualActivitiesFromTripleScopeToTwoNewScopes() {
        BpmnModelInstance sourceProcess = ProcessModels.TRIPLE_SUBPROCESS_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.DOUBLE_SUBPROCESS_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testMapEqualActivitiesToNewScopes() {
        BpmnModelInstance sourceProcess = ProcessModels.DOUBLE_SUBPROCESS_PROCESS;
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(ProcessModels.DOUBLE_SUBPROCESS_PROCESS).changeElementId("outerSubProcess", "newOuterSubProcess").changeElementId("innerSubProcess", "newInnerSubProcess");
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testMapEqualActivitiesOutsideOfScope() {
        BpmnModelInstance sourceProcess = ProcessModels.PARALLEL_GATEWAY_SUBPROCESS_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.PARALLEL_TASK_AND_SUBPROCESS_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"), MigrationPlanAssert.migrate("userTask1").to("userTask1"));
    }

    @Test
    public void testMapEqualActivitiesToHorizontalScope() {
        BpmnModelInstance sourceProcess = ProcessModels.PARALLEL_TASK_AND_SUBPROCESS_PROCESS;
        BpmnModelInstance targetProcess = ProcessModels.PARALLEL_GATEWAY_SUBPROCESS_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"), MigrationPlanAssert.migrate("userTask1").to("userTask1"));
    }

    @Test
    public void testMapEqualActivitiesFromTaskWithBoundaryEvent() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent(null).message(MESSAGE_NAME)).done();
        BpmnModelInstance targetProcess = ProcessModels.ONE_TASK_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapEqualActivitiesToTaskWithBoundaryEvent() {
        BpmnModelInstance sourceProcess = ProcessModels.ONE_TASK_PROCESS;
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent(null).message(MESSAGE_NAME)).done();
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapEqualActivitiesWithBoundaryEvent() {
        BpmnModelInstance testProcess = ((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("messageBoundary").message(MESSAGE_NAME)).moveToActivity("userTask").boundaryEvent("signalBoundary").signal(SIGNAL_NAME)).moveToActivity("userTask").boundaryEvent("timerBoundary").timerWithDate(TIMER_DATE)).done();
        this.assertGeneratedMigrationPlan(testProcess, testProcess).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"), MigrationPlanAssert.migrate("messageBoundary").to("messageBoundary"), MigrationPlanAssert.migrate("userTask").to("userTask"), MigrationPlanAssert.migrate("signalBoundary").to("signalBoundary"), MigrationPlanAssert.migrate("timerBoundary").to("timerBoundary"));
    }

    @Test
    public void testNotMapBoundaryEventsWithDifferentIds() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("message").message(MESSAGE_NAME)).done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("message", "newMessage");
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testIgnoreNotSupportedBoundaryEvents() {
        BpmnModelInstance testProcess = ((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("messageBoundary").message(MESSAGE_NAME)).moveToActivity("subProcess").boundaryEvent("errorBoundary").error(ERROR_CODE)).moveToActivity("subProcess").boundaryEvent("escalationBoundary").escalation(ESCALATION_CODE)).moveToActivity("userTask").boundaryEvent("signalBoundary").signal(SIGNAL_NAME)).done();
        this.assertGeneratedMigrationPlan(testProcess, testProcess).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"), MigrationPlanAssert.migrate("messageBoundary").to("messageBoundary"), MigrationPlanAssert.migrate("userTask").to("userTask"), MigrationPlanAssert.migrate("signalBoundary").to("signalBoundary"));
    }

    @Test
    public void testNotMigrateBoundaryToParallelActivity() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask1").boundaryEvent("message").message(MESSAGE_NAME)).done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask2").boundaryEvent("message").message(MESSAGE_NAME)).done();
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("userTask1").to("userTask1"), MigrationPlanAssert.migrate("userTask2").to("userTask2"), MigrationPlanAssert.migrate("fork").to("fork"));
    }

    @Test
    public void testNotMigrateBoundaryToChildActivity() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("message").message(MESSAGE_NAME)).done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("userTask").boundaryEvent("message").message(MESSAGE_NAME)).done();
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"), MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMigrateProcessInstanceWithEventSubProcess() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addSubProcessTo("Process").id("eventSubProcess")).triggerByEvent()).embeddedSubProcess().startEvent("eventSubProcessStart").message(MESSAGE_NAME)).endEvent().subProcessDone().done();
        this.assertGeneratedMigrationPlan(testProcess, testProcess).hasInstructions(MigrationPlanAssert.migrate("eventSubProcess").to("eventSubProcess"), MigrationPlanAssert.migrate("eventSubProcessStart").to("eventSubProcessStart"), MigrationPlanAssert.migrate("userTask").to("userTask"));
        this.assertGeneratedMigrationPlan(testProcess, ProcessModels.ONE_TASK_PROCESS).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"));
        this.assertGeneratedMigrationPlan(ProcessModels.ONE_TASK_PROCESS, testProcess).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMigrateSubProcessWithEventSubProcess() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").id("eventSubProcess")).triggerByEvent()).embeddedSubProcess().startEvent("eventSubProcessStart").message(MESSAGE_NAME)).endEvent().subProcessDone().done();
        this.assertGeneratedMigrationPlan(testProcess, testProcess).hasInstructions(MigrationPlanAssert.migrate("eventSubProcess").to("eventSubProcess"), MigrationPlanAssert.migrate("eventSubProcessStart").to("eventSubProcessStart"), MigrationPlanAssert.migrate("subProcess").to("subProcess"), MigrationPlanAssert.migrate("userTask").to("userTask"));
        this.assertGeneratedMigrationPlan(testProcess, ProcessModels.SUBPROCESS_PROCESS).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"), MigrationPlanAssert.migrate("userTask").to("userTask"));
        this.assertGeneratedMigrationPlan(ProcessModels.SUBPROCESS_PROCESS, testProcess).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"), MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMigrateUserTaskInEventSubProcess() {
        BpmnModelInstance testProcess = ((StartEventBuilder)((SubProcessBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").id("eventSubProcess")).triggerByEvent()).embeddedSubProcess().startEvent("eventSubProcessStart").message(MESSAGE_NAME)).userTask("innerTask").endEvent().subProcessDone().done();
        this.assertGeneratedMigrationPlan(testProcess, testProcess).hasInstructions(MigrationPlanAssert.migrate("eventSubProcess").to("eventSubProcess"), MigrationPlanAssert.migrate("eventSubProcessStart").to("eventSubProcessStart"), MigrationPlanAssert.migrate("innerTask").to("innerTask"), MigrationPlanAssert.migrate("subProcess").to("subProcess"), MigrationPlanAssert.migrate("userTask").to("userTask"));
        this.assertGeneratedMigrationPlan(testProcess, ProcessModels.SUBPROCESS_PROCESS).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"), MigrationPlanAssert.migrate("userTask").to("userTask"));
        this.assertGeneratedMigrationPlan(ProcessModels.SUBPROCESS_PROCESS, testProcess).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"), MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testNotMigrateActivitiesOfDifferentType() {
        BpmnModelInstance sourceProcess = ProcessModels.ONE_TASK_PROCESS;
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).swapElementIds("userTask", "subProcess");
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testNotMigrateBoundaryEventsOfDifferentType() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").signal(SIGNAL_NAME)).done();
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testNotMigrateMultiInstanceOfDifferentType() {
        BpmnModelInstance sourceProcess = MultiInstanceProcessModels.SEQ_MI_ONE_TASK_PROCESS;
        BpmnModelInstance targetProcess = MultiInstanceProcessModels.PAR_MI_ONE_TASK_PROCESS;
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testNotMigrateBoundaryEventsWithInvalidEventScopeInstruction() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message("foo")).done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_RECEIVE_TASK_PROCESS).changeElementId("receiveTask", "userTask").activityBuilder("userTask").boundaryEvent("boundary").message("foo")).done();
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasEmptyInstructions();
    }

    @Test
    public void testMapReceiveTasks() {
        this.assertGeneratedMigrationPlan(MessageReceiveModels.ONE_RECEIVE_TASK_PROCESS, MessageReceiveModels.ONE_RECEIVE_TASK_PROCESS).hasInstructions(MigrationPlanAssert.migrate("receiveTask").to("receiveTask"), MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapMessageCatchEvents() {
        this.assertGeneratedMigrationPlan(MessageReceiveModels.ONE_MESSAGE_CATCH_PROCESS, MessageReceiveModels.ONE_MESSAGE_CATCH_PROCESS).hasInstructions(MigrationPlanAssert.migrate("messageCatch").to("messageCatch"), MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapCallActivitiesToBpmnTest() {
        this.assertGeneratedMigrationPlan(CallActivityModels.oneBpmnCallActivityProcess("foo"), CallActivityModels.oneBpmnCallActivityProcess("foo")).hasInstructions(MigrationPlanAssert.migrate("callActivity").to("callActivity"), MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapCallActivitiesToCmmnTest() {
        this.assertGeneratedMigrationPlan(CallActivityModels.oneCmmnCallActivityProcess("foo"), CallActivityModels.oneCmmnCallActivityProcess("foo")).hasInstructions(MigrationPlanAssert.migrate("callActivity").to("callActivity"), MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapCallActivitiesFromBpmnToCmmnTest() {
        this.assertGeneratedMigrationPlan(CallActivityModels.oneBpmnCallActivityProcess("foo"), CallActivityModels.oneCmmnCallActivityProcess("foo")).hasInstructions(MigrationPlanAssert.migrate("callActivity").to("callActivity"), MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapCallActivitiesFromCmmnToBpmnTest() {
        this.assertGeneratedMigrationPlan(CallActivityModels.oneCmmnCallActivityProcess("foo"), CallActivityModels.oneBpmnCallActivityProcess("foo")).hasInstructions(MigrationPlanAssert.migrate("callActivity").to("callActivity"), MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapEventBasedGateway() {
        this.assertGeneratedMigrationPlan(EventBasedGatewayModels.TIMER_EVENT_BASED_GW_PROCESS, EventBasedGatewayModels.SIGNAL_EVENT_BASED_GW_PROCESS).hasInstructions(MigrationPlanAssert.migrate("eventBasedGateway").to("eventBasedGateway"));
    }

    @Test
    public void testMapEventBasedGatewayWithIdenticalFollowingEvents() {
        this.assertGeneratedMigrationPlan(EventBasedGatewayModels.TIMER_EVENT_BASED_GW_PROCESS, EventBasedGatewayModels.TIMER_EVENT_BASED_GW_PROCESS).hasInstructions(MigrationPlanAssert.migrate("eventBasedGateway").to("eventBasedGateway"), MigrationPlanAssert.migrate("timerCatch").to("timerCatch"), MigrationPlanAssert.migrate("afterTimerCatch").to("afterTimerCatch"));
    }

    @Test
    public void testMapTimerEventSubProcessAndStartEvent() {
        this.assertGeneratedMigrationPlan(EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS, EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"), MigrationPlanAssert.migrate("eventSubProcess").to("eventSubProcess"), MigrationPlanAssert.migrate("eventSubProcessStart").to("eventSubProcessStart"), MigrationPlanAssert.migrate("eventSubProcessTask").to("eventSubProcessTask"));
    }

    @Test
    public void testMapMessageEventSubProcessAndStartEvent() {
        this.assertGeneratedMigrationPlan(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS, EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"), MigrationPlanAssert.migrate("eventSubProcess").to("eventSubProcess"), MigrationPlanAssert.migrate("eventSubProcessStart").to("eventSubProcessStart"), MigrationPlanAssert.migrate("eventSubProcessTask").to("eventSubProcessTask"));
    }

    @Test
    public void testMapSignalEventSubProcessAndStartEvent() {
        this.assertGeneratedMigrationPlan(EventSubProcessModels.SIGNAL_EVENT_SUBPROCESS_PROCESS, EventSubProcessModels.SIGNAL_EVENT_SUBPROCESS_PROCESS).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"), MigrationPlanAssert.migrate("eventSubProcess").to("eventSubProcess"), MigrationPlanAssert.migrate("eventSubProcessStart").to("eventSubProcessStart"), MigrationPlanAssert.migrate("eventSubProcessTask").to("eventSubProcessTask"));
    }

    @Test
    public void testMapEscalationEventSubProcessAndStartEvent() {
        this.assertGeneratedMigrationPlan(EventSubProcessModels.ESCALATION_EVENT_SUBPROCESS_PROCESS, EventSubProcessModels.ESCALATION_EVENT_SUBPROCESS_PROCESS).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"), MigrationPlanAssert.migrate("eventSubProcess").to("eventSubProcess"), MigrationPlanAssert.migrate("eventSubProcessTask").to("eventSubProcessTask"));
    }

    @Test
    public void testMapErrorEventSubProcessAndStartEvent() {
        this.assertGeneratedMigrationPlan(EventSubProcessModels.ERROR_EVENT_SUBPROCESS_PROCESS, EventSubProcessModels.ERROR_EVENT_SUBPROCESS_PROCESS).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"), MigrationPlanAssert.migrate("eventSubProcess").to("eventSubProcess"), MigrationPlanAssert.migrate("eventSubProcessTask").to("eventSubProcessTask"));
    }

    @Test
    public void testMapCompensationEventSubProcessAndStartEvent() {
        this.assertGeneratedMigrationPlan(EventSubProcessModels.COMPENSATE_EVENT_SUBPROCESS_PROCESS, EventSubProcessModels.COMPENSATE_EVENT_SUBPROCESS_PROCESS).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"), MigrationPlanAssert.migrate("userTask").to("userTask"), MigrationPlanAssert.migrate("eventSubProcessStart").to("eventSubProcessStart"));
    }

    @Test
    public void testNotMapEventSubProcessStartEventOfDifferentType() {
        this.assertGeneratedMigrationPlan(EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS, EventSubProcessModels.SIGNAL_EVENT_SUBPROCESS_PROCESS).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"), MigrationPlanAssert.migrate("eventSubProcess").to("eventSubProcess"), MigrationPlanAssert.migrate("eventSubProcessTask").to("eventSubProcessTask"));
    }

    @Test
    public void testMapEventSubProcessStartEventWhenSubProcessesAreNotEqual() {
        BpmnModelInstance sourceModel = EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS;
        ModifiableBpmnModelInstance targetModel = ModifiableBpmnModelInstance.modify(EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS).changeElementId("eventSubProcess", "newEventSubProcess");
        this.assertGeneratedMigrationPlan(sourceModel, targetModel).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask"), MigrationPlanAssert.migrate("eventSubProcessStart").to("eventSubProcessStart"));
    }

    @Test
    public void testMapEventSubProcessToEmbeddedSubProcess() {
        ModifiableBpmnModelInstance sourceModel = ModifiableBpmnModelInstance.modify(EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS).changeElementId("eventSubProcess", "subProcess");
        BpmnModelInstance targetModel = ProcessModels.SUBPROCESS_PROCESS;
        this.assertGeneratedMigrationPlan(sourceModel, targetModel).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"));
    }

    @Test
    public void testMapEmbeddedSubProcessToEventSubProcess() {
        BpmnModelInstance sourceModel = ProcessModels.SUBPROCESS_PROCESS;
        ModifiableBpmnModelInstance targetModel = ModifiableBpmnModelInstance.modify(EventSubProcessModels.TIMER_EVENT_SUBPROCESS_PROCESS).changeElementId("eventSubProcess", "subProcess");
        this.assertGeneratedMigrationPlan(sourceModel, targetModel).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"));
    }

    @Test
    public void testMapExternalServiceTask() {
        BpmnModelInstance sourceModel = ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS;
        BpmnModelInstance targetModel = ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS;
        this.assertGeneratedMigrationPlan(sourceModel, targetModel).hasInstructions(MigrationPlanAssert.migrate("externalTask").to("externalTask"));
    }

    @Test
    public void testMapExternalServiceToDifferentType() {
        BpmnModelInstance sourceModel = ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS;
        BpmnModelInstance targetModel = ((SendTaskBuilder)((SendTaskBuilder)ProcessModels.newModel().startEvent().sendTask("externalTask").camundaType("external")).camundaTopic("foo")).endEvent().done();
        this.assertGeneratedMigrationPlan(sourceModel, targetModel).hasInstructions(MigrationPlanAssert.migrate("externalTask").to("externalTask"));
    }

    @Test
    public void testNotMapExternalToClassDelegateServiceTask() {
        BpmnModelInstance sourceModel = ExternalTaskModels.ONE_EXTERNAL_TASK_PROCESS;
        ModifiableBpmnModelInstance targetModel = ModifiableBpmnModelInstance.modify(ServiceTaskModels.oneClassDelegateServiceTask("foo.Bar")).changeElementId("serviceTask", "externalTask");
        this.assertGeneratedMigrationPlan(sourceModel, targetModel).hasEmptyInstructions();
    }

    @Test
    public void testMapParallelGateways() {
        BpmnModelInstance model = GatewayModels.PARALLEL_GW;
        this.assertGeneratedMigrationPlan(model, model).hasInstructions(MigrationPlanAssert.migrate("fork").to("fork"), MigrationPlanAssert.migrate("join").to("join"), MigrationPlanAssert.migrate("parallel1").to("parallel1"), MigrationPlanAssert.migrate("parallel2").to("parallel2"), MigrationPlanAssert.migrate("afterJoin").to("afterJoin"));
    }

    @Test
    public void testMapInclusiveGateways() {
        BpmnModelInstance model = GatewayModels.INCLUSIVE_GW;
        this.assertGeneratedMigrationPlan(model, model).hasInstructions(MigrationPlanAssert.migrate("fork").to("fork"), MigrationPlanAssert.migrate("join").to("join"), MigrationPlanAssert.migrate("parallel1").to("parallel1"), MigrationPlanAssert.migrate("parallel2").to("parallel2"), MigrationPlanAssert.migrate("afterJoin").to("afterJoin"));
    }

    @Test
    public void testNotMapParallelToInclusiveGateway() {
        this.assertGeneratedMigrationPlan(GatewayModels.PARALLEL_GW, GatewayModels.INCLUSIVE_GW).hasInstructions(MigrationPlanAssert.migrate("parallel1").to("parallel1"), MigrationPlanAssert.migrate("parallel2").to("parallel2"), MigrationPlanAssert.migrate("afterJoin").to("afterJoin"));
    }

    @Test
    public void testMapTransaction() {
        this.assertGeneratedMigrationPlan(TransactionModels.ONE_TASK_TRANSACTION, TransactionModels.ONE_TASK_TRANSACTION).hasInstructions(MigrationPlanAssert.migrate("transaction").to("transaction"), MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapEmbeddedSubProcessToTransaction() {
        BpmnModelInstance sourceProcess = ProcessModels.SUBPROCESS_PROCESS;
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(TransactionModels.ONE_TASK_TRANSACTION).changeElementId("transaction", "subProcess");
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess"), MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapTransactionToEventSubProcess() {
        BpmnModelInstance sourceProcess = TransactionModels.ONE_TASK_TRANSACTION;
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(EventSubProcessModels.MESSAGE_EVENT_SUBPROCESS_PROCESS).changeElementId("eventSubProcess", "transaction").changeElementId("userTask", "foo").changeElementId("eventSubProcessTask", "userTask");
        this.assertGeneratedMigrationPlan(sourceProcess, targetProcess).hasInstructions(MigrationPlanAssert.migrate("transaction").to("transaction"), MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapNoUpdateEventTriggers() {
        BpmnModelInstance model = MessageReceiveModels.ONE_MESSAGE_CATCH_PROCESS;
        this.assertGeneratedMigrationPlan(model, model, false).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask").updateEventTrigger(false), MigrationPlanAssert.migrate("messageCatch").to("messageCatch").updateEventTrigger(false));
    }

    @Test
    public void testMapUpdateEventTriggers() {
        BpmnModelInstance model = MessageReceiveModels.ONE_MESSAGE_CATCH_PROCESS;
        this.assertGeneratedMigrationPlan(model, model, true).hasInstructions(MigrationPlanAssert.migrate("userTask").to("userTask").updateEventTrigger(false), MigrationPlanAssert.migrate("messageCatch").to("messageCatch").updateEventTrigger(true));
    }

    @Test
    public void testMigrationPlanCreationWithEmptyDeploymentCache() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        this.rule.getProcessEngineConfiguration().getDeploymentCache().discardProcessDefinitionCache();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        Assert.assertNotNull((Object)migrationPlan);
    }

    @Test
    public void testMapCompensationBoundaryEvents() {
        this.assertGeneratedMigrationPlan(CompensationModels.ONE_COMPENSATION_TASK_MODEL, CompensationModels.ONE_COMPENSATION_TASK_MODEL, true).hasInstructions(MigrationPlanAssert.migrate("userTask1").to("userTask1").updateEventTrigger(false), MigrationPlanAssert.migrate("userTask2").to("userTask2").updateEventTrigger(false), MigrationPlanAssert.migrate("compensationBoundary").to("compensationBoundary").updateEventTrigger(false));
    }

    @Test
    public void testMapCompensationStartEvents() {
        this.assertGeneratedMigrationPlan(CompensationModels.COMPENSATION_EVENT_SUBPROCESS_MODEL, CompensationModels.COMPENSATION_EVENT_SUBPROCESS_MODEL, true).hasInstructions(MigrationPlanAssert.migrate("subProcess").to("subProcess").updateEventTrigger(false), MigrationPlanAssert.migrate("userTask1").to("userTask1").updateEventTrigger(false), MigrationPlanAssert.migrate("eventSubProcessStart").to("eventSubProcessStart").updateEventTrigger(false), MigrationPlanAssert.migrate("userTask2").to("userTask2").updateEventTrigger(false), MigrationPlanAssert.migrate("compensationBoundary").to("compensationBoundary").updateEventTrigger(false));
    }

    @Test
    public void testMapIntermediateConditionalEvent() {
        BpmnModelInstance sourceProcess = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"processKey").startEvent().intermediateCatchEvent("conditionCatch").condition("${any=='any'}")).userTask("userTask").endEvent().done();
        this.assertGeneratedMigrationPlan(sourceProcess, sourceProcess, false).hasInstructions(MigrationPlanAssert.migrate("conditionCatch").to("conditionCatch").updateEventTrigger(true), MigrationPlanAssert.migrate("userTask").to("userTask").updateEventTrigger(false));
    }

    @Test
    public void testMapConditionalEventSubProcess() {
        this.assertGeneratedMigrationPlan(EventSubProcessModels.FALSE_CONDITIONAL_EVENT_SUBPROCESS_PROCESS, EventSubProcessModels.CONDITIONAL_EVENT_SUBPROCESS_PROCESS, false).hasInstructions(MigrationPlanAssert.migrate("eventSubProcessStart").to("eventSubProcessStart").updateEventTrigger(true), MigrationPlanAssert.migrate("eventSubProcess").to("eventSubProcess").updateEventTrigger(false), MigrationPlanAssert.migrate("eventSubProcessTask").to("eventSubProcessTask"), MigrationPlanAssert.migrate("userTask").to("userTask"));
    }

    @Test
    public void testMapConditionalBoundaryEvents() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundaryId").condition("${any=='any'}")).done();
        this.assertGeneratedMigrationPlan(sourceProcess, sourceProcess, false).hasInstructions(MigrationPlanAssert.migrate("boundaryId").to("boundaryId").updateEventTrigger(true), MigrationPlanAssert.migrate("userTask").to("userTask").updateEventTrigger(false));
    }

    protected MigrationPlanAssert assertGeneratedMigrationPlan(BpmnModelInstance sourceProcess, BpmnModelInstance targetProcess) {
        return this.assertGeneratedMigrationPlan(sourceProcess, targetProcess, false);
    }

    protected MigrationPlanAssert assertGeneratedMigrationPlan(BpmnModelInstance sourceProcess, BpmnModelInstance targetProcess, boolean updateEventTriggers) {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationInstructionsBuilder migrationInstructionsBuilder = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities();
        if (updateEventTriggers) {
            migrationInstructionsBuilder.updateEventTriggers();
        }
        MigrationPlan migrationPlan = migrationInstructionsBuilder.build();
        MigrationPlanAssert.assertThat(migrationPlan).hasSourceProcessDefinition(sourceProcessDefinition).hasTargetProcessDefinition(targetProcessDefinition);
        return MigrationPlanAssert.assertThat(migrationPlan);
    }
}

