/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.message;

import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.ExecutionTree;

public class MessageNonInterruptingBoundaryEventTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testSingleNonInterruptingBoundaryMessageEvent() {
        this.runtimeService.startProcessInstanceByKey("process");
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        Task userTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)userTask);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)execution);
        this.runtimeService.messageEventReceived("messageName", execution.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)execution);
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        userTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterMessage").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)userTask);
        MessageNonInterruptingBoundaryEventTest.assertEquals((String)"taskAfterMessage", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.messageEventReceived("messageName", execution.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)execution);
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        userTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterMessage").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)userTask);
        MessageNonInterruptingBoundaryEventTest.assertEquals((String)"taskAfterMessage", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        userTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)userTask);
        this.taskService.complete(userTask.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNull((Object)execution);
        userTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterTask").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)userTask);
        this.taskService.complete(userTask.getId());
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("process");
        userTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)userTask);
        this.taskService.complete(userTask.getId());
        execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("messageName").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNull((Object)execution);
        userTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterTask").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)userTask);
        MessageNonInterruptingBoundaryEventTest.assertEquals((String)"taskAfterTask", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment
    public void testNonInterruptingEventInCombinationWithReceiveTask() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("firstMessage");
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task1);
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertEquals((String)processInstanceId, (String)((ExecutionEntity)task1Execution).getParentId());
        this.runtimeService.correlateMessage("secondMessage");
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task1);
        task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertEquals((String)processInstanceId, (String)((ExecutionEntity)task1Execution).getParentId());
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task2);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertEquals((String)processInstanceId, (String)((ExecutionEntity)task2Execution).getParentId());
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testNonInterruptingEventInCombinationWithReceiveTaskInConcurrentSubprocess() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("firstMessage");
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task1);
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertEquals((String)processInstanceId, (String)((ExecutionEntity)task1Execution).getParentId());
        this.runtimeService.correlateMessage("secondMessage");
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)3L, (long)this.taskService.createTaskQuery().count());
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        Task afterFork = (Task)this.taskService.createTaskQuery().taskDefinitionKey("afterFork").singleResult();
        this.taskService.complete(afterFork.getId());
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task2);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertEquals((String)processInstanceId, (String)((ExecutionEntity)task2Execution).getParentId());
        this.taskService.complete(task2.getId());
        this.taskService.complete(task1.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testNonInterruptingEventInCombinationWithReceiveTaskInsideSubProcess() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = instance.getId();
        this.runtimeService.correlateMessage("firstMessage");
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(instance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).beginScope("subProcess").activity("task1").beginScope("innerSubProcess").activity("receiveTask").done());
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task1);
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)task1Execution).getParentId()));
        this.runtimeService.correlateMessage("secondMessage");
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task1);
        task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)task1Execution).getParentId()));
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task2);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)task2Execution).getParentId()));
        MessageNonInterruptingBoundaryEventTest.assertTrue((boolean)((ExecutionEntity)task1Execution).getParentId().equals(((ExecutionEntity)task2Execution).getParentId()));
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testNonInterruptingEventInCombinationWithUserTaskInsideSubProcess() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("firstMessage");
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task1);
        Task innerTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)innerTask);
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("task1").noScope().concurrent().up().child(null).noScope().concurrent().child("innerTask").scope().done());
        this.taskService.complete(innerTask.getId());
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task1);
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task2);
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("task1").noScope().concurrent().up().child("task2").noScope().concurrent().done());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testNonInterruptingEventInCombinationWithUserTask() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("firstMessage");
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task1);
        Task innerTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)innerTask);
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").noScope().concurrent().up().child(null).noScope().concurrent().child("innerTask").scope().done());
        this.taskService.complete(innerTask.getId());
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task1);
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task2);
        executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").noScope().concurrent().up().child("task2").noScope().concurrent().done());
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testNonInterruptingWithUserTaskAndBoundaryEvent() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("firstMessage");
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task1);
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertEquals((String)processInstanceId, (String)((ExecutionEntity)task1Execution).getParentId());
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task2);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("innerTask").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)task2Execution).getParentId()));
        this.taskService.complete(task2.getId());
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task1);
        task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertEquals((String)processInstanceId, (String)((ExecutionEntity)task1Execution).getParentId());
        task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task2);
        task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("tasks").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertEquals((String)processInstanceId, (String)((ExecutionEntity)task1Execution).getParentId());
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testNestedEvents() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("firstMessage");
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task innerTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)innerTask);
        Execution innerTaskExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("innerTask").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)innerTaskExecution).getParentId()));
        this.runtimeService.correlateMessage("secondMessage");
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        innerTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)innerTask);
        innerTaskExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("innerTask").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)innerTaskExecution).getParentId()));
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task1);
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task1Execution);
        MessageNonInterruptingBoundaryEventTest.assertEquals((String)processInstanceId, (String)((ExecutionEntity)task1Execution).getParentId());
        this.runtimeService.correlateMessage("thirdMessage");
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task1);
        task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task1Execution);
        MessageNonInterruptingBoundaryEventTest.assertEquals((String)processInstanceId, (String)((ExecutionEntity)task1Execution).getParentId());
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task2);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task2Execution);
        MessageNonInterruptingBoundaryEventTest.assertEquals((String)processInstanceId, (String)((ExecutionEntity)task2Execution).getParentId());
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/message/MessageNonInterruptingBoundaryEventTest.testNestedEvents.bpmn20.xml"})
    public void testNestedEventsAnotherExecutionOrder() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("secondMessage");
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task1);
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task1Execution);
        MessageNonInterruptingBoundaryEventTest.assertEquals((String)processInstanceId, (String)((ExecutionEntity)task1Execution).getParentId());
        this.runtimeService.correlateMessage("firstMessage");
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Task innerTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)innerTask);
        Execution innerTaskExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("innerTask").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)innerTaskExecution).getParentId()));
        task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task1);
        task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task1Execution);
        MessageNonInterruptingBoundaryEventTest.assertEquals((String)processInstanceId, (String)((ExecutionEntity)task1Execution).getParentId());
        this.runtimeService.correlateMessage("thirdMessage");
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task1);
        task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task1Execution);
        MessageNonInterruptingBoundaryEventTest.assertEquals((String)processInstanceId, (String)((ExecutionEntity)task1Execution).getParentId());
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task2);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        MessageNonInterruptingBoundaryEventTest.assertNotNull((Object)task2Execution);
        MessageNonInterruptingBoundaryEventTest.assertEquals((String)processInstanceId, (String)((ExecutionEntity)task2Execution).getParentId());
        MessageNonInterruptingBoundaryEventTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        this.assertProcessEnded(processInstanceId);
    }
}

