/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.timer;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.cmd.DeleteJobsCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.event.timer.DummyServiceTask;
import org.camunda.bpm.engine.test.mock.Mocks;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;

public class StartTimerEventTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testDurationStartTimerEvent() throws Exception {
        Date startTime = new Date();
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + 3005000L));
        this.executeAllJobs();
        this.executeAllJobs();
        List pi = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("startTimerEventExample").list();
        StartTimerEventTest.assertEquals((int)1, (int)pi.size());
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment
    public void testFixedDateStartTimerEvent() throws Exception {
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        ClockUtil.setCurrentTime((Date)new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("15/11/2036 11:12:30"));
        this.executeAllJobs();
        List pi = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("startTimerEventExample").list();
        StartTimerEventTest.assertEquals((int)1, (int)pi.size());
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment
    public void FAILING_testCycleDateStartTimerEvent() throws Exception {
        ClockUtil.setCurrentTime((Date)new Date());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        ProcessInstanceQuery piq = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("startTimerEventExample");
        StartTimerEventTest.assertEquals((long)0L, (long)piq.count());
        this.moveByMinutes(5);
        this.executeAllJobs();
        StartTimerEventTest.assertEquals((long)1L, (long)piq.count());
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        this.moveByMinutes(5);
        this.executeAllJobs();
        StartTimerEventTest.assertEquals((long)1L, (long)piq.count());
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
    }

    private void moveByMinutes(int minutes) throws Exception {
        ClockUtil.setCurrentTime((Date)new Date(ClockUtil.getCurrentTime().getTime() + (long)(minutes * 60 * 1000 + 5000)));
    }

    @Deployment
    public void testCycleWithLimitStartTimerEvent() throws Exception {
        ClockUtil.setCurrentTime((Date)new Date());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        Job job = (Job)jobQuery.singleResult();
        StartTimerEventTest.assertNotNull((Object)job.getDeploymentId());
        ProcessInstanceQuery piq = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("startTimerEventExampleCycle");
        StartTimerEventTest.assertEquals((long)0L, (long)piq.count());
        this.moveByMinutes(5);
        this.executeAllJobs();
        StartTimerEventTest.assertEquals((long)1L, (long)piq.count());
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        job = (Job)jobQuery.singleResult();
        StartTimerEventTest.assertNotNull((Object)job.getDeploymentId());
        this.moveByMinutes(5);
        this.executeAllJobs();
        StartTimerEventTest.assertEquals((long)2L, (long)piq.count());
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment
    public void testPriorityInTimerCycleEvent() throws Exception {
        ClockUtil.setCurrentTime((Date)new Date());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        Job job = (Job)jobQuery.singleResult();
        StartTimerEventTest.assertNotNull((Object)job.getDeploymentId());
        StartTimerEventTest.assertEquals((long)9999L, (long)job.getPriority());
        ProcessInstanceQuery piq = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("startTimerEventExampleCycle");
        StartTimerEventTest.assertEquals((long)0L, (long)piq.count());
        this.moveByMinutes(5);
        this.executeAllJobs();
        StartTimerEventTest.assertEquals((long)1L, (long)piq.count());
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        job = (Job)jobQuery.singleResult();
        StartTimerEventTest.assertNotNull((Object)job.getDeploymentId());
        StartTimerEventTest.assertEquals((long)9999L, (long)job.getPriority());
    }

    @Deployment
    public void testExpressionStartTimerEvent() throws Exception {
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        ClockUtil.setCurrentTime((Date)new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("15/11/2036 11:12:30"));
        this.executeAllJobs();
        List pi = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("startTimerEventExample").list();
        StartTimerEventTest.assertEquals((int)1, (int)pi.size());
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
    }

    @Deployment
    public void testVersionUpgradeShouldCancelJobs() throws Exception {
        ClockUtil.setCurrentTime((Date)new Date());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("StartTimerEventTest.testVersionUpgradeShouldCancelJobs.bpmn20.xml");
        String process = new String(IoUtil.readInputStream((InputStream)in, (String)"")).replaceAll("beforeChange", "changed");
        IoUtil.closeSilently((Closeable)in);
        in = new ByteArrayInputStream(process.getBytes());
        String id = this.repositoryService.createDeployment().addInputStream("StartTimerEventTest.testVersionUpgradeShouldCancelJobs.bpmn20.xml", in).deploy().getId();
        IoUtil.closeSilently((Closeable)in);
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        this.moveByMinutes(5);
        this.executeAllJobs();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("startTimerEventExample").singleResult();
        String pi = processInstance.getProcessInstanceId();
        StartTimerEventTest.assertEquals((String)"changed", (String)((String)this.runtimeService.getActiveActivityIds(pi).get(0)));
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        this.repositoryService.deleteDeployment(id, true);
    }

    @Deployment
    public void testTimerShouldNotBeRecreatedOnDeploymentCacheReboot() {
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        this.processEngineConfiguration.getDeploymentCache().discardProcessDefinitionCache();
        this.runtimeService.startProcessInstanceByKey("startTimer");
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
    }

    public void testTimerShouldNotBeRemovedWhenUndeployingOldVersion() throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("StartTimerEventTest.testTimerShouldNotBeRemovedWhenUndeployingOldVersion.bpmn20.xml");
        String process = new String(IoUtil.readInputStream((InputStream)in, (String)""));
        IoUtil.closeSilently((Closeable)in);
        in = new ByteArrayInputStream(process.getBytes());
        String firstDeploymentId = this.repositoryService.createDeployment().addInputStream("StartTimerEventTest.testVersionUpgradeShouldCancelJobs.bpmn20.xml", in).deploy().getId();
        IoUtil.closeSilently((Closeable)in);
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        String processChanged = process.replaceAll("beforeChange", "changed");
        in = new ByteArrayInputStream(processChanged.getBytes());
        String secondDeploymentId = this.repositoryService.createDeployment().addInputStream("StartTimerEventTest.testVersionUpgradeShouldCancelJobs.bpmn20.xml", in).deploy().getId();
        IoUtil.closeSilently((Closeable)in);
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        this.repositoryService.deleteDeployment(firstDeploymentId, true);
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        this.cleanDB();
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
    }

    @Deployment
    public void testStartTimerEventInEventSubProcess() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startTimerEventInEventSubProcess");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)1L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().list().get(0)).getId());
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((boolean)true, (boolean)DummyServiceTask.wasExecuted);
        StartTimerEventTest.assertEquals((long)0L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)0L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)0L, (long)processInstanceQuery.count());
    }

    @Deployment
    public void testNonInterruptingStartTimerEventInEventSubProcess() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nonInterruptingStartTimerEventInEventSubProcess");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)1L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().list().get(0)).getId());
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((boolean)true, (boolean)DummyServiceTask.wasExecuted);
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)1L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)1L, (long)processInstanceQuery.count());
    }

    @Deployment
    public void testStartTimerEventSubProcessInSubProcess() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startTimerEventSubProcessInSubProcess");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)2L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)this.managementService.createJobQuery().list().get(0)).getId());
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((boolean)true, (boolean)DummyServiceTask.wasExecuted);
        StartTimerEventTest.assertEquals((long)0L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)0L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)0L, (long)processInstanceQuery.count());
    }

    @Deployment
    public void testNonInterruptingStartTimerEventSubProcessInSubProcess() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nonInterruptingStartTimerEventSubProcessInSubProcess");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)2L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)jobQuery.list().get(0)).getId());
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((boolean)true, (boolean)DummyServiceTask.wasExecuted);
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)2L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)1L, (long)processInstanceQuery.count());
    }

    @Deployment
    public void testStartTimerEventWithTwoEventSubProcesses() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startTimerEventWithTwoEventSubProcesses");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)1L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)2L, (long)jobQuery.count());
        List orderedJobList = ((JobQuery)jobQuery.orderByJobDuedate().asc()).list();
        this.managementService.executeJob(((Job)orderedJobList.get(0)).getId());
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((long)0L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)0L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)0L, (long)processInstanceQuery.count());
    }

    @Deployment
    public void testNonInterruptingStartTimerEventWithTwoEventSubProcesses() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nonInterruptingStartTimerEventWithTwoEventSubProcesses");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)1L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)2L, (long)jobQuery.count());
        List orderedJobList = ((JobQuery)jobQuery.orderByJobDuedate().asc()).list();
        this.managementService.executeJob(((Job)orderedJobList.get(0)).getId());
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((boolean)true, (boolean)DummyServiceTask.wasExecuted);
        DummyServiceTask.wasExecuted = false;
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)1L, (long)executionQuery.count());
        this.managementService.executeJob(((Job)orderedJobList.get(1)).getId());
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((boolean)true, (boolean)DummyServiceTask.wasExecuted);
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)1L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)1L, (long)processInstanceQuery.count());
    }

    @Deployment
    public void testStartTimerEventSubProcessWithUserTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startTimerEventSubProcessWithUserTask");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)2L, (long)jobQuery.count());
        List orderedJobList = ((JobQuery)jobQuery.orderByJobDuedate().asc()).list();
        this.managementService.executeJob(((Job)orderedJobList.get(0)).getId());
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((String)"subprocessUserTask", (String)((Task)taskQuery.list().get(0)).getTaskDefinitionKey());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)1L, (long)processInstanceQuery.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/simpleProcessWithCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/timer/StartTimerEventTest.testStartTimerEventWithTwoEventSubProcesses.bpmn20.xml"})
    public void testStartTimerEventSubProcessCalledFromCallActivity() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("calledProcess", "startTimerEventWithTwoEventSubProcesses");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("simpleCallActivityProcess", variables);
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)2L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)2L, (long)jobQuery.count());
        List orderedJobList = ((JobQuery)jobQuery.orderByJobDuedate().asc()).list();
        this.managementService.executeJob(((Job)orderedJobList.get(0)).getId());
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((long)0L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)0L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)0L, (long)processInstanceQuery.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/simpleProcessWithCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/timer/StartTimerEventTest.testNonInterruptingStartTimerEventWithTwoEventSubProcesses.bpmn20.xml"})
    public void testNonInterruptingStartTimerEventSubProcessesCalledFromCallActivity() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nonInterruptingStartTimerEventWithTwoEventSubProcesses");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)1L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)2L, (long)jobQuery.count());
        List orderedJobList = ((JobQuery)jobQuery.orderByJobDuedate().asc()).list();
        this.managementService.executeJob(((Job)orderedJobList.get(0)).getId());
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((boolean)true, (boolean)DummyServiceTask.wasExecuted);
        DummyServiceTask.wasExecuted = false;
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)1L, (long)executionQuery.count());
        this.managementService.executeJob(((Job)orderedJobList.get(1)).getId());
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((boolean)true, (boolean)DummyServiceTask.wasExecuted);
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)1L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)1L, (long)processInstanceQuery.count());
    }

    @Deployment
    public void testStartTimerEventSubProcessInMultiInstanceSubProcess() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startTimerEventSubProcessInMultiInstanceSubProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        String jobIdFirstLoop = ((Job)jobQuery.list().get(0)).getId();
        this.managementService.executeJob(jobIdFirstLoop);
        StartTimerEventTest.assertEquals((boolean)true, (boolean)DummyServiceTask.wasExecuted);
        DummyServiceTask.wasExecuted = false;
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        String jobIdSecondLoop = ((Job)jobQuery.list().get(0)).getId();
        StartTimerEventTest.assertNotSame((Object)jobIdFirstLoop, (Object)jobIdSecondLoop);
        this.managementService.executeJob(jobIdSecondLoop);
        StartTimerEventTest.assertEquals((boolean)true, (boolean)DummyServiceTask.wasExecuted);
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((long)0L, (long)taskQuery.count());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testNonInterruptingStartTimerEventInMultiInstanceEventSubProcess() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nonInterruptingStartTimerEventInMultiInstanceEventSubProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        String jobIdFirstLoop = ((Job)jobQuery.list().get(0)).getId();
        this.managementService.executeJob(jobIdFirstLoop);
        StartTimerEventTest.assertEquals((boolean)true, (boolean)DummyServiceTask.wasExecuted);
        DummyServiceTask.wasExecuted = false;
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        this.taskService.complete(((Task)taskQuery.list().get(0)).getId());
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        String jobIdSecondLoop = ((Job)jobQuery.list().get(0)).getId();
        StartTimerEventTest.assertNotSame((Object)jobIdFirstLoop, (Object)jobIdSecondLoop);
        this.managementService.executeJob(jobIdSecondLoop);
        StartTimerEventTest.assertEquals((boolean)true, (boolean)DummyServiceTask.wasExecuted);
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)1L, (long)processInstanceQuery.count());
    }

    @Deployment
    public void testStartTimerEventSubProcessInParallelMultiInstanceSubProcess() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startTimerEventSubProcessInParallelMultiInstanceSubProcess");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)6L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        StartTimerEventTest.assertEquals((long)2L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)2L, (long)jobQuery.count());
        for (Job job : jobQuery.list()) {
            this.managementService.executeJob(job.getId());
            StartTimerEventTest.assertEquals((boolean)true, (boolean)DummyServiceTask.wasExecuted);
            DummyServiceTask.wasExecuted = false;
        }
        StartTimerEventTest.assertEquals((long)0L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)0L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)0L, (long)processInstanceQuery.count());
    }

    @Deployment
    public void testNonInterruptingStartTimerEventSubProcessWithParallelMultiInstance() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nonInterruptingParallelMultiInstance");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)6L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        StartTimerEventTest.assertEquals((long)2L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)2L, (long)jobQuery.count());
        for (Job job : jobQuery.list()) {
            this.managementService.executeJob(job.getId());
            StartTimerEventTest.assertEquals((boolean)true, (boolean)DummyServiceTask.wasExecuted);
            DummyServiceTask.wasExecuted = false;
        }
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((long)2L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)6L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)1L, (long)processInstanceQuery.count());
    }

    @Deployment
    public void testStartTimerEventSubProcessInMultiInstanceSubProcessWithNonInterruptingBoundaryTimerEvent() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)2L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(1)).getId());
        StartTimerEventTest.assertEquals((boolean)true, (boolean)DummyServiceTask.wasExecuted);
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)2L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(0)).getId());
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)1L, (long)processInstanceQuery.count());
    }

    @Deployment
    public void testStartTimerEventSubProcessInMultiInstanceSubProcessWithInterruptingBoundaryTimerEvent() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)2L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(1)).getId());
        StartTimerEventTest.assertEquals((boolean)true, (boolean)DummyServiceTask.wasExecuted);
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)2L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(0)).getId());
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((long)0L, (long)taskQuery.count());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testNonInterruptingStartTimerEventSubProcessInMultiInstanceSubProcessWithInterruptingBoundaryTimerEvent() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)3L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)2L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(1)).getId());
        StartTimerEventTest.assertEquals((boolean)true, (boolean)DummyServiceTask.wasExecuted);
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        this.taskService.complete(((Task)taskQuery.list().get(0)).getId());
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)2L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(0)).getId());
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((long)0L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)0L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)0L, (long)processInstanceQuery.count());
    }

    @Deployment
    public void testStartTimerEventSubProcessInParallelMultiInstanceSubProcessWithNonInterruptingBoundaryTimerEvent() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)6L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        StartTimerEventTest.assertEquals((long)2L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)3L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(1)).getId());
        StartTimerEventTest.assertEquals((boolean)true, (boolean)DummyServiceTask.wasExecuted);
        StartTimerEventTest.assertEquals((long)2L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)5L, (long)executionQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(0)).getId());
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)5L, (long)executionQuery.count());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)1L, (long)processInstanceQuery.count());
    }

    @Deployment
    public void testStartTimerEventSubProcessInParallelMultiInstanceSubProcessWithInterruptingBoundaryTimerEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)6L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        StartTimerEventTest.assertEquals((long)2L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)3L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(1)).getId());
        StartTimerEventTest.assertEquals((long)2L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((long)1L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)5L, (long)executionQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(0)).getId());
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((long)0L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)0L, (long)executionQuery.count());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testNonInterruptingStartTimerEventSubProcessInParallelMiSubProcessWithInterruptingBoundaryTimerEvent() {
        DummyServiceTask.wasExecuted = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        StartTimerEventTest.assertEquals((long)6L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        StartTimerEventTest.assertEquals((long)2L, (long)taskQuery.count());
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)3L, (long)jobQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(1)).getId());
        StartTimerEventTest.assertEquals((boolean)true, (boolean)DummyServiceTask.wasExecuted);
        StartTimerEventTest.assertEquals((long)2L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((long)2L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)6L, (long)executionQuery.count());
        this.managementService.executeJob(((Job)((JobQuery)jobQuery.orderByJobDuedate().asc()).list().get(0)).getId());
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((long)0L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)0L, (long)executionQuery.count());
        this.assertProcessEnded(processInstance.getId());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)3L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((long)2L, (long)taskQuery.count());
        for (Task task : taskQuery.list()) {
            this.taskService.complete(task.getId());
        }
        StartTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((long)0L, (long)taskQuery.count());
        StartTimerEventTest.assertEquals((long)0L, (long)executionQuery.count());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testTimeCycle() {
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        String jobId = ((Job)jobQuery.singleResult()).getId();
        this.managementService.executeJob(jobId);
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        String anotherJobId = ((Job)jobQuery.singleResult()).getId();
        StartTimerEventTest.assertFalse((boolean)jobId.equals(anotherJobId));
    }

    @Deployment
    public void testFailingTimeCycle() throws Exception {
        JobQuery query = this.managementService.createJobQuery();
        JobQuery failedJobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)query.count());
        String jobId = ((Job)query.singleResult()).getId();
        failedJobQuery.jobId(jobId);
        this.moveByMinutes(5);
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Job failedJob = (Job)failedJobQuery.singleResult();
        StartTimerEventTest.assertEquals((int)2, (int)failedJob.getRetries());
        StartTimerEventTest.assertEquals((long)2L, (long)query.count());
        StartTimerEventTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        StartTimerEventTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        StartTimerEventTest.assertEquals((long)2L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        failedJob = (Job)failedJobQuery.singleResult();
        StartTimerEventTest.assertEquals((int)1, (int)failedJob.getRetries());
        StartTimerEventTest.assertEquals((long)2L, (long)query.count());
        StartTimerEventTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        StartTimerEventTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        StartTimerEventTest.assertEquals((long)2L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
    }

    @Deployment
    public void testNonInterruptingTimeCycleInEventSubProcess() {
        this.runtimeService.startProcessInstanceByKey("process");
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        String jobId = ((Job)jobQuery.singleResult()).getId();
        this.managementService.executeJob(jobId);
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        String anotherJobId = ((Job)jobQuery.singleResult()).getId();
        StartTimerEventTest.assertFalse((boolean)jobId.equals(anotherJobId));
    }

    public void testInterruptingWithDurationExpression() {
        Mocks.register((String)"duration", (Object)"PT60S");
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)"process");
        BpmnModelInstance modelInstance = ((StartEventBuilder)processBuilder.startEvent().timerWithDuration("${duration}")).userTask("aTaskName").endEvent().done();
        this.deploymentId = this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance).deploy().getId();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        StartTimerEventTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().taskName("aTaskName").list().size());
        Mocks.reset();
    }

    public void testInterruptingWithDurationExpressionInEventSubprocess() {
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)"process");
        BpmnModelInstance modelInstance = processBuilder.startEvent().userTask().endEvent().done();
        ((StartEventBuilder)processBuilder.eventSubProcess().startEvent().timerWithDuration("${duration}")).userTask("taskInSubprocess").endEvent();
        this.deploymentId = this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance).deploy().getId();
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("duration", (Object)"PT60S"));
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        StartTimerEventTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().taskName("taskInSubprocess").list().size());
    }

    public void testNonInterruptingWithDurationExpressionInEventSubprocess() {
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)"process");
        BpmnModelInstance modelInstance = processBuilder.startEvent().userTask().endEvent().done();
        ((StartEventBuilder)((StartEventBuilder)processBuilder.eventSubProcess().startEvent().interrupting(false)).timerWithDuration("${duration}")).userTask("taskInSubprocess").endEvent();
        this.deploymentId = this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance).deploy().getId();
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("duration", (Object)"PT60S"));
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        StartTimerEventTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().taskName("taskInSubprocess").list().size());
    }

    @Deployment
    public void testNonInterruptingFailingTimeCycleInEventSubProcess() {
        this.runtimeService.startProcessInstanceByKey("process");
        JobQuery failedJobQuery = this.managementService.createJobQuery();
        JobQuery jobQuery = this.managementService.createJobQuery();
        StartTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        String jobId = ((Job)jobQuery.singleResult()).getId();
        failedJobQuery.jobId(jobId);
        try {
            this.managementService.executeJob(jobId);
            StartTimerEventTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Job failedJob = (Job)failedJobQuery.singleResult();
        StartTimerEventTest.assertEquals((int)2, (int)failedJob.getRetries());
        StartTimerEventTest.assertEquals((long)2L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        StartTimerEventTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        StartTimerEventTest.assertEquals((long)2L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        failedJob = (Job)failedJobQuery.singleResult();
        StartTimerEventTest.assertEquals((int)1, (int)failedJob.getRetries());
        StartTimerEventTest.assertEquals((long)2L, (long)jobQuery.count());
        StartTimerEventTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        StartTimerEventTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        StartTimerEventTest.assertEquals((long)2L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
    }

    protected void executeAllJobs() {
        String nextJobId = this.getNextExecutableJobId();
        while (nextJobId != null) {
            try {
                this.managementService.executeJob(nextJobId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            nextJobId = this.getNextExecutableJobId();
        }
    }

    protected String getNextExecutableJobId() {
        List jobs = this.managementService.createJobQuery().executable().listPage(0, 1);
        if (jobs.size() == 1) {
            return ((Job)jobs.get(0)).getId();
        }
        return null;
    }

    private void cleanDB() {
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new DeleteJobsCmd(jobId, true));
    }
}

