/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.executionlistener;

import java.util.HashMap;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.bpmn.event.conditional.SetVariableDelegate;
import org.camunda.bpm.engine.test.bpmn.executionlistener.CurrentActivityExecutionListener;
import org.camunda.bpm.engine.test.bpmn.executionlistener.ExampleExecutionListenerPojo;
import org.camunda.bpm.engine.test.bpmn.executionlistener.RecorderExecutionListener;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ConditionalEventDefinitionBuilder;
import org.camunda.bpm.model.bpmn.builder.EndEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class ExecutionListenerTest {
    public ProcessEngineRule processEngineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.processEngineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.processEngineRule).around((TestRule)this.testHelper);
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected ManagementService managementService;
    private static final String MESSAGE = "cancelMessage";
    public static final BpmnModelInstance PROCESS_SERVICE_TASK_WITH_EXECUTION_START_LISTENER = ((BoundaryEventBuilder)((EndEventBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().parallelGateway("fork").userTask("userTask1").serviceTask("sendTask").camundaExecutionListenerClass("start", SendMessageDelegate.class.getName())).camundaExpression("${true}")).endEvent("endEvent").camundaExecutionListenerClass("start", RecorderExecutionListener.class.getName())).moveToLastGateway().userTask("userTask2").boundaryEvent("boundaryEvent").message("cancelMessage")).endEvent("endBoundaryEvent").moveToNode("userTask2").endEvent().done();
    public static final BpmnModelInstance PROCESS_SERVICE_TASK_WITH_TWO_EXECUTION_START_LISTENER = ModifiableBpmnModelInstance.modify(PROCESS_SERVICE_TASK_WITH_EXECUTION_START_LISTENER).activityBuilder("sendTask").camundaExecutionListenerClass("start", RecorderExecutionListener.class.getName()).done();
    public static final BpmnModelInstance PROCESS_SERVICE_TASK_WITH_EXECUTION_START_LISTENER_AND_SUB_PROCESS = ((UserTaskBuilder)((StartEventBuilder)((StartEventBuilder)((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(((EndEventBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().userTask("userTask").serviceTask("sendTask").camundaExecutionListenerClass("start", SendMessageDelegate.class.getName())).camundaExecutionListenerClass("start", RecorderExecutionListener.class.getName())).camundaExpression("${true}")).endEvent("endEvent").camundaExecutionListenerClass("start", RecorderExecutionListener.class.getName())).done()).addSubProcessTo("Process").triggerByEvent()).embeddedSubProcess().startEvent("startSubProcess").interrupting(false)).camundaExecutionListenerClass("start", RecorderExecutionListener.class.getName())).message("cancelMessage")).userTask("subProcessTask").camundaExecutionListenerClass("start", RecorderExecutionListener.class.getName())).endEvent("endSubProcess").done();

    @Before
    public void clearRecorderListener() {
        RecorderExecutionListener.clear();
    }

    @Before
    public void initServices() {
        this.runtimeService = this.processEngineRule.getRuntimeService();
        this.taskService = this.processEngineRule.getTaskService();
        this.historyService = this.processEngineRule.getHistoryService();
        this.managementService = this.processEngineRule.getManagementService();
    }

    public void assertProcessEnded(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance != null) {
            throw new AssertionFailedError("Expected finished process instance '" + processInstanceId + "' but it was still in the db");
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/executionlistener/ExecutionListenersProcess.bpmn20.xml"})
    public void testExecutionListenersOnAllPossibleElements() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("executionListenersProcess", "businessKey123");
        String varSetInExecutionListener = (String)this.runtimeService.getVariable(processInstance.getId(), "variableSetInExecutionListener");
        Assert.assertNotNull((Object)varSetInExecutionListener);
        Assert.assertEquals((Object)"firstValue", (Object)varSetInExecutionListener);
        String businessKey = (String)this.runtimeService.getVariable(processInstance.getId(), "businessKeyInExecution");
        Assert.assertNotNull((Object)businessKey);
        Assert.assertEquals((Object)"businessKey123", (Object)businessKey);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        varSetInExecutionListener = (String)this.runtimeService.getVariable(processInstance.getId(), "variableSetInExecutionListener");
        Assert.assertNotNull((Object)varSetInExecutionListener);
        Assert.assertEquals((Object)"secondValue", (Object)varSetInExecutionListener);
        ExampleExecutionListenerPojo myPojo = new ExampleExecutionListenerPojo();
        this.runtimeService.setVariable(processInstance.getId(), "myPojo", (Object)myPojo);
        task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        ExampleExecutionListenerPojo pojoVariable = (ExampleExecutionListenerPojo)this.runtimeService.getVariable(processInstance.getId(), "myPojo");
        Assert.assertNotNull((Object)pojoVariable.getReceivedEventName());
        Assert.assertEquals((Object)"end", (Object)pojoVariable.getReceivedEventName());
        task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/executionlistener/ExecutionListenersStartEndEvent.bpmn20.xml"})
    public void testExecutionListenersOnStartEndEvents() {
        RecorderExecutionListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("executionListenersProcess");
        this.assertProcessEnded(processInstance.getId());
        List<RecorderExecutionListener.RecordedEvent> recordedEvents = RecorderExecutionListener.getRecordedEvents();
        Assert.assertEquals((long)4L, (long)recordedEvents.size());
        Assert.assertEquals((Object)"theStart", (Object)recordedEvents.get(0).getActivityId());
        Assert.assertEquals((Object)"Start Event", (Object)recordedEvents.get(0).getActivityName());
        Assert.assertEquals((Object)"Start Event Listener", (Object)recordedEvents.get(0).getParameter());
        Assert.assertEquals((Object)"end", (Object)recordedEvents.get(0).getEventName());
        Assert.assertThat((Object)recordedEvents.get(0).isCanceled(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertEquals((Object)"noneEvent", (Object)recordedEvents.get(1).getActivityId());
        Assert.assertEquals((Object)"None Event", (Object)recordedEvents.get(1).getActivityName());
        Assert.assertEquals((Object)"Intermediate Catch Event Listener", (Object)recordedEvents.get(1).getParameter());
        Assert.assertEquals((Object)"end", (Object)recordedEvents.get(1).getEventName());
        Assert.assertThat((Object)recordedEvents.get(1).isCanceled(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertEquals((Object)"signalEvent", (Object)recordedEvents.get(2).getActivityId());
        Assert.assertEquals((Object)"Signal Event", (Object)recordedEvents.get(2).getActivityName());
        Assert.assertEquals((Object)"Intermediate Throw Event Listener", (Object)recordedEvents.get(2).getParameter());
        Assert.assertEquals((Object)"start", (Object)recordedEvents.get(2).getEventName());
        Assert.assertThat((Object)recordedEvents.get(2).isCanceled(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertEquals((Object)"theEnd", (Object)recordedEvents.get(3).getActivityId());
        Assert.assertEquals((Object)"End Event", (Object)recordedEvents.get(3).getActivityName());
        Assert.assertEquals((Object)"End Event Listener", (Object)recordedEvents.get(3).getParameter());
        Assert.assertEquals((Object)"start", (Object)recordedEvents.get(3).getEventName());
        Assert.assertThat((Object)recordedEvents.get(3).isCanceled(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/executionlistener/ExecutionListenersFieldInjectionProcess.bpmn20.xml"})
    public void testExecutionListenerFieldInjection() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("myVar", "listening!");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("executionListenersProcess", variables);
        Object varSetByListener = this.runtimeService.getVariable(processInstance.getId(), "var");
        Assert.assertNotNull((Object)varSetByListener);
        Assert.assertTrue((boolean)(varSetByListener instanceof String));
        Assert.assertEquals((Object)"Yes, I am listening!", (Object)varSetByListener);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/executionlistener/ExecutionListenersCurrentActivity.bpmn20.xml"})
    public void testExecutionListenerCurrentActivity() {
        CurrentActivityExecutionListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("executionListenersProcess");
        this.assertProcessEnded(processInstance.getId());
        List<CurrentActivityExecutionListener.CurrentActivity> currentActivities = CurrentActivityExecutionListener.getCurrentActivities();
        Assert.assertEquals((long)3L, (long)currentActivities.size());
        Assert.assertEquals((Object)"theStart", (Object)currentActivities.get(0).getActivityId());
        Assert.assertEquals((Object)"Start Event", (Object)currentActivities.get(0).getActivityName());
        Assert.assertEquals((Object)"noneEvent", (Object)currentActivities.get(1).getActivityId());
        Assert.assertEquals((Object)"None Event", (Object)currentActivities.get(1).getActivityName());
        Assert.assertEquals((Object)"theEnd", (Object)currentActivities.get(2).getActivityId());
        Assert.assertEquals((Object)"End Event", (Object)currentActivities.get(2).getActivityName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/executionlistener/ExecutionListenerTest.testOnBoundaryEvents.bpmn20.xml"})
    public void testOnBoundaryEvents() {
        RecorderExecutionListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Job firstTimer = (Job)this.managementService.createJobQuery().timers().singleResult();
        this.managementService.executeJob(firstTimer.getId());
        Job secondTimer = (Job)this.managementService.createJobQuery().timers().singleResult();
        this.managementService.executeJob(secondTimer.getId());
        this.assertProcessEnded(processInstance.getId());
        List<RecorderExecutionListener.RecordedEvent> recordedEvents = RecorderExecutionListener.getRecordedEvents();
        Assert.assertEquals((long)2L, (long)recordedEvents.size());
        Assert.assertEquals((Object)"timer1", (Object)recordedEvents.get(0).getActivityId());
        Assert.assertEquals((Object)"start boundary listener", (Object)recordedEvents.get(0).getParameter());
        Assert.assertEquals((Object)"start", (Object)recordedEvents.get(0).getEventName());
        Assert.assertThat((Object)recordedEvents.get(0).isCanceled(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertEquals((Object)"timer2", (Object)recordedEvents.get(1).getActivityId());
        Assert.assertEquals((Object)"end boundary listener", (Object)recordedEvents.get(1).getParameter());
        Assert.assertEquals((Object)"end", (Object)recordedEvents.get(1).getEventName());
        Assert.assertThat((Object)recordedEvents.get(1).isCanceled(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @Deployment
    public void testScriptListener() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertTrue((boolean)processInstance.isEnded());
        if (this.processEngineRule.getProcessEngineConfiguration().getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            String[] variableNames;
            HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
            long count = query.count();
            Assert.assertEquals((long)5L, (long)count);
            HistoricVariableInstance variableInstance = null;
            for (String variableName : variableNames = new String[]{"start-start", "start-end", "start-take", "end-start", "end-end"}) {
                variableInstance = (HistoricVariableInstance)query.variableName(variableName).singleResult();
                Assert.assertNotNull((String)("Unable ot find variable with name '" + variableName + "'"), (Object)variableInstance);
                Assert.assertTrue((String)("Variable '" + variableName + "' should be set to true"), (boolean)((Boolean)variableInstance.getValue()));
            }
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/executionlistener/ExecutionListenerTest.testScriptResourceListener.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/executionlistener/executionListener.groovy"})
    public void testScriptResourceListener() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertTrue((boolean)processInstance.isEnded());
        if (this.processEngineRule.getProcessEngineConfiguration().getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            String[] variableNames;
            HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
            long count = query.count();
            Assert.assertEquals((long)5L, (long)count);
            HistoricVariableInstance variableInstance = null;
            for (String variableName : variableNames = new String[]{"start-start", "start-end", "start-take", "end-start", "end-end"}) {
                variableInstance = (HistoricVariableInstance)query.variableName(variableName).singleResult();
                Assert.assertNotNull((String)("Unable ot find variable with name '" + variableName + "'"), (Object)variableInstance);
                Assert.assertTrue((String)("Variable '" + variableName + "' should be set to true"), (boolean)((Boolean)variableInstance.getValue()));
            }
        }
    }

    @Test
    @Deployment
    public void testExecutionListenerOnTerminateEndEvent() {
        RecorderExecutionListener.clear();
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        List<RecorderExecutionListener.RecordedEvent> recordedEvents = RecorderExecutionListener.getRecordedEvents();
        Assert.assertEquals((long)2L, (long)recordedEvents.size());
        Assert.assertEquals((Object)"start", (Object)recordedEvents.get(0).getEventName());
        Assert.assertEquals((Object)"end", (Object)recordedEvents.get(1).getEventName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/executionlistener/ExecutionListenerTest.testOnCancellingBoundaryEvent.bpmn"})
    public void testOnCancellingBoundaryEvents() {
        RecorderExecutionListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Job timer = (Job)this.managementService.createJobQuery().timers().singleResult();
        this.managementService.executeJob(timer.getId());
        this.assertProcessEnded(processInstance.getId());
        List<RecorderExecutionListener.RecordedEvent> recordedEvents = RecorderExecutionListener.getRecordedEvents();
        Assert.assertThat(recordedEvents, (Matcher)IsCollectionWithSize.hasSize((int)1));
        Assert.assertEquals((Object)"UserTask_1", (Object)recordedEvents.get(0).getActivityId());
        Assert.assertEquals((Object)"end", (Object)recordedEvents.get(0).getEventName());
        Assert.assertThat((Object)recordedEvents.get(0).isCanceled(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testServiceTaskExecutionListenerCall() {
        this.testHelper.deploy(PROCESS_SERVICE_TASK_WITH_EXECUTION_START_LISTENER);
        this.runtimeService.startProcessInstanceByKey("Process");
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().list().size());
        List<RecorderExecutionListener.RecordedEvent> recordedEvents = RecorderExecutionListener.getRecordedEvents();
        Assert.assertEquals((long)1L, (long)recordedEvents.size());
        Assert.assertEquals((Object)"endEvent", (Object)recordedEvents.get(0).getActivityId());
    }

    @Test
    public void testServiceTaskTwoExecutionListenerCall() {
        this.testHelper.deploy(PROCESS_SERVICE_TASK_WITH_TWO_EXECUTION_START_LISTENER);
        this.runtimeService.startProcessInstanceByKey("Process");
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().list().size());
        List<RecorderExecutionListener.RecordedEvent> recordedEvents = RecorderExecutionListener.getRecordedEvents();
        Assert.assertEquals((long)2L, (long)recordedEvents.size());
        Assert.assertEquals((Object)"sendTask", (Object)recordedEvents.get(0).getActivityId());
        Assert.assertEquals((Object)"endEvent", (Object)recordedEvents.get(1).getActivityId());
    }

    @Test
    public void testServiceTaskExecutionListenerCallAndSubProcess() {
        this.testHelper.deploy(PROCESS_SERVICE_TASK_WITH_EXECUTION_START_LISTENER_AND_SUB_PROCESS);
        this.runtimeService.startProcessInstanceByKey("Process");
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask").singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().list().size());
        List<RecorderExecutionListener.RecordedEvent> recordedEvents = RecorderExecutionListener.getRecordedEvents();
        Assert.assertEquals((long)4L, (long)recordedEvents.size());
        Assert.assertEquals((Object)"startSubProcess", (Object)recordedEvents.get(0).getActivityId());
        Assert.assertEquals((Object)"subProcessTask", (Object)recordedEvents.get(1).getActivityId());
        Assert.assertEquals((Object)"sendTask", (Object)recordedEvents.get(2).getActivityId());
        Assert.assertEquals((Object)"endEvent", (Object)recordedEvents.get(3).getActivityId());
    }

    @Test
    public void testEndExecutionListenerIsCalledOnlyOnce() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalProcessKey").startEvent().userTask().camundaExecutionListenerClass("end", SetVariableDelegate.class.getName())).camundaExecutionListenerClass("end", RecorderExecutionListener.class.getName())).endEvent().done();
        modelInstance = ((ConditionalEventDefinitionBuilder)((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(modelInstance).addSubProcessTo("conditionalProcessKey").triggerByEvent()).embeddedSubProcess().startEvent().interrupting(true)).conditionalEventDefinition().condition("${variable == 1}")).conditionalEventDefinitionDone().endEvent().done();
        this.testHelper.deploy(modelInstance);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalProcessKey");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.taskService.complete(((Task)taskQuery.singleResult()).getId());
        Assert.assertEquals((long)1L, (long)RecorderExecutionListener.getRecordedEvents().size());
    }

    public static class SendMessageDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            RuntimeService runtimeService = execution.getProcessEngineServices().getRuntimeService();
            runtimeService.correlateMessage(ExecutionListenerTest.MESSAGE);
        }
    }
}

