/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.concurrent.Callable;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.impl.MessageCorrelationBuilderImpl;
import org.camunda.bpm.engine.impl.cmd.AbstractCorrelateMessageCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.runtime.CorrelationHandler;
import org.camunda.bpm.engine.impl.runtime.CorrelationHandlerResult;
import org.camunda.bpm.engine.impl.runtime.CorrelationSet;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.MessageCorrelationResult;

public class CorrelateMessageCmd
extends AbstractCorrelateMessageCmd
implements Command<MessageCorrelationResult> {
    public CorrelateMessageCmd(MessageCorrelationBuilderImpl messageCorrelationBuilderImpl) {
        super(messageCorrelationBuilderImpl);
    }

    @Override
    public MessageCorrelationResult execute(final CommandContext commandContext) {
        EnsureUtil.ensureAtLeastOneNotNull("At least one of the following correlation criteria has to be present: messageName, businessKey, correlationKeys, processInstanceId", this.messageName, this.builder.getBusinessKey(), this.builder.getCorrelationProcessInstanceVariables(), this.builder.getProcessInstanceId());
        final CorrelationHandler correlationHandler = Context.getProcessEngineConfiguration().getCorrelationHandler();
        final CorrelationSet correlationSet = new CorrelationSet(this.builder);
        CorrelationHandlerResult correlationResult = commandContext.runWithoutAuthorization(new Callable<CorrelationHandlerResult>(){

            @Override
            public CorrelationHandlerResult call() throws Exception {
                return correlationHandler.correlateMessage(commandContext, CorrelateMessageCmd.this.messageName, correlationSet);
            }
        });
        if (correlationResult == null) {
            throw new MismatchingMessageCorrelationException(this.messageName, "No process definition or execution matches the parameters");
        }
        this.checkAuthorization(correlationResult);
        return this.createMessageCorrelationResult(commandContext, correlationResult);
    }
}

