/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query.history;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricDetailQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

@RequiredHistoryLevel(value="full")
public class MultiTenancyHistoricDetailVariableUpdateQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String VARIABLE_NAME = "myVar";
    protected static final String TENANT_ONE_VAR = "tenant1Var";
    protected static final String TENANT_TWO_VAR = "tenant2Var";

    protected void setUp() {
        BpmnModelInstance oneTaskProcess = Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{oneTaskProcess});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{oneTaskProcess});
        ProcessInstance processInstanceOne = this.startProcessInstanceForTenant(TENANT_ONE, TENANT_ONE_VAR);
        ProcessInstance processInstanceTwo = this.startProcessInstanceForTenant(TENANT_TWO, TENANT_TWO_VAR);
        this.completeUserTask(processInstanceOne, "tenant1Var_updated");
        this.completeUserTask(processInstanceTwo, "tenant2Var_updated");
    }

    public void testQueryWithoutTenantId() {
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)4L));
    }

    public void testQueryByTenantId() {
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        query = this.historyService.createHistoricDetailQuery().variableUpdates().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByTenantIds() {
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)4L));
    }

    public void testQueryByNonExistingTenantId() {
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testFailQueryByTenantIdNull() {
        try {
            this.historyService.createHistoricDetailQuery().variableUpdates().tenantIdIn(new String[]{null});
            MultiTenancyHistoricDetailVariableUpdateQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testQuerySortingAsc() {
        List historicDetails = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByTenantId().asc()).list();
        Assert.assertThat((Object)historicDetails.size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)((HistoricDetail)historicDetails.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((HistoricDetail)historicDetails.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((HistoricDetail)historicDetails.get(2)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((HistoricDetail)historicDetails.get(3)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    public void testQuerySortingDesc() {
        List historicDetails = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByTenantId().desc()).list();
        Assert.assertThat((Object)historicDetails.size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)((HistoricDetail)historicDetails.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((HistoricDetail)historicDetails.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((HistoricDetail)historicDetails.get(2)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((HistoricDetail)historicDetails.get(3)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)4L));
    }

    protected ProcessInstance startProcessInstanceForTenant(String tenant, String var) {
        return ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("testProcess").setVariable(VARIABLE_NAME, (Object)var)).processDefinitionTenantId(tenant).execute();
    }

    protected void completeUserTask(ProcessInstance processInstance, String varValue) {
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertThat((Object)task, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        HashMap<String, String> updatedVariables = new HashMap<String, String>();
        updatedVariables.put(VARIABLE_NAME, varValue);
        this.taskService.complete(task.getId(), updatedVariables);
    }
}

