/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineBootstrapCommand;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngines;
import org.camunda.bpm.engine.impl.BootstrapEngineCommand;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;

public class ConcurrentProcessEngineJobExecutorHistoryCleanupJobTest
extends ConcurrencyTestCase {
    private static final String PROCESS_ENGINE_NAME = "historyCleanupJobEngine";

    @Override
    public void setUp() throws Exception {
        Calendar timeOfDay = Calendar.getInstance();
        timeOfDay.set(11, 17);
        ClockUtil.setCurrentTime((Date)timeOfDay.getTime());
        this.processEngineConfiguration.setHistoryCleanupStrategy("endTimeBased");
        super.setUp();
    }

    protected void closeDownProcessEngine() {
        super.closeDownProcessEngine();
        final ProcessEngine otherProcessEngine = ProcessEngines.getProcessEngine((String)PROCESS_ENGINE_NAME);
        if (otherProcessEngine != null) {
            ((ProcessEngineConfigurationImpl)otherProcessEngine.getProcessEngineConfiguration()).getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

                public Void execute(CommandContext commandContext) {
                    List jobs = otherProcessEngine.getManagementService().createJobQuery().list();
                    if (jobs.size() > 0) {
                        TestCase.assertEquals((int)1, (int)jobs.size());
                        String jobId = ((Job)jobs.get(0)).getId();
                        commandContext.getJobManager().deleteJob((JobEntity)jobs.get(0));
                        commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
                    }
                    return null;
                }
            });
            otherProcessEngine.close();
            ProcessEngines.unregister((ProcessEngine)otherProcessEngine);
        }
    }

    @Override
    public void tearDown() throws Exception {
        ((ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration()).getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List jobs = ConcurrentProcessEngineJobExecutorHistoryCleanupJobTest.this.processEngine.getManagementService().createJobQuery().list();
                if (jobs.size() > 0) {
                    TestCase.assertEquals((int)1, (int)jobs.size());
                    String jobId = ((Job)jobs.get(0)).getId();
                    commandContext.getJobManager().deleteJob((JobEntity)jobs.get(0));
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
                }
                return null;
            }
        });
        ClockUtil.setCurrentTime((Date)new Date());
        super.tearDown();
    }

    public void testConcurrentHistoryCleanupJobReconfigurationExecution() throws InterruptedException {
        ConcurrentProcessEngineJobExecutorHistoryCleanupJobTest.getProcessEngine().getHistoryService().cleanUpHistoryAsync(true);
        ConcurrencyTestCase.ThreadControl thread1 = this.executeControllableCommand(new ControllableJobExecutionCommand());
        thread1.reportInterrupts();
        thread1.waitForSync();
        ConcurrencyTestCase.ThreadControl thread2 = this.executeControllableCommand(new ControllableProcessEngineBootstrapCommand());
        thread2.reportInterrupts();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        Thread.sleep(2000L);
        thread1.waitUntilDone();
        thread2.waitForSync();
        thread2.waitUntilDone(true);
        ConcurrentProcessEngineJobExecutorHistoryCleanupJobTest.assertNull((Object)thread1.getException());
        ConcurrentProcessEngineJobExecutorHistoryCleanupJobTest.assertNull((Object)thread2.getException());
        ConcurrentProcessEngineJobExecutorHistoryCleanupJobTest.assertNotNull(ProcessEngines.getProcessEngines().get(PROCESS_ENGINE_NAME));
    }

    protected static class ControllableBootstrapEngineCommand
    extends BootstrapEngineCommand
    implements Command<Void> {
        protected final ConcurrencyTestCase.ThreadControl monitor;

        public ControllableBootstrapEngineCommand(ConcurrencyTestCase.ThreadControl threadControl) {
            this.monitor = threadControl;
        }

        protected void createHistoryCleanupJob() {
            this.monitor.sync();
            super.createHistoryCleanupJob();
            this.monitor.sync();
        }
    }

    protected static class ControllableJobExecutionCommand
    extends ConcurrencyTestCase.ControllableCommand<Void> {
        protected ControllableJobExecutionCommand() {
        }

        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            List historyCleanupJobs = commandContext.getProcessEngineConfiguration().getHistoryService().findHistoryCleanupJobs();
            for (Job job : historyCleanupJobs) {
                commandContext.getProcessEngineConfiguration().getManagementService().executeJob(job.getId());
            }
            this.monitor.sync();
            return null;
        }
    }

    protected static class ControllableProcessEngineBootstrapCommand
    extends ConcurrencyTestCase.ControllableCommand<Void> {
        protected ControllableProcessEngineBootstrapCommand() {
        }

        public Void execute(CommandContext commandContext) {
            ControllableBootstrapEngineCommand bootstrapCommand = new ControllableBootstrapEngineCommand(this.monitor);
            ProcessEngineConfiguration processEngineConfiguration = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"org/camunda/bpm/engine/test/concurrency/historycleanup.camunda.cfg.xml");
            processEngineConfiguration.setProcessEngineBootstrapCommand((ProcessEngineBootstrapCommand)bootstrapCommand);
            processEngineConfiguration.setProcessEngineName(ConcurrentProcessEngineJobExecutorHistoryCleanupJobTest.PROCESS_ENGINE_NAME);
            processEngineConfiguration.buildProcessEngine();
            return null;
        }
    }
}

