/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.pvm;

import junit.framework.TestCase;
import org.camunda.bpm.engine.impl.pvm.ProcessDefinitionBuilder;
import org.camunda.bpm.engine.impl.pvm.PvmExecution;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.PvmProcessInstance;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.test.standalone.pvm.activities.Automatic;
import org.camunda.bpm.engine.test.standalone.pvm.activities.Decision;
import org.camunda.bpm.engine.test.standalone.pvm.activities.WaitState;

public class PvmTest
extends TestCase {
    public void testPvmWaitState() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("a").initial().behavior((ActivityBehavior)new WaitState()).transition("b").endActivity().createActivity("b").behavior((ActivityBehavior)new WaitState()).transition("c").endActivity().createActivity("c").behavior((ActivityBehavior)new WaitState()).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        PvmExecution activityInstance = processInstance.findExecution("a");
        PvmTest.assertNotNull((Object)activityInstance);
        activityInstance.signal(null, null);
        activityInstance = processInstance.findExecution("b");
        PvmTest.assertNotNull((Object)activityInstance);
        activityInstance.signal(null, null);
        activityInstance = processInstance.findExecution("c");
        PvmTest.assertNotNull((Object)activityInstance);
    }

    public void testPvmAutomatic() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("a").initial().behavior((ActivityBehavior)new Automatic()).transition("b").endActivity().createActivity("b").behavior((ActivityBehavior)new Automatic()).transition("c").endActivity().createActivity("c").behavior((ActivityBehavior)new WaitState()).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        PvmTest.assertNotNull((Object)processInstance.findExecution("c"));
    }

    public void testPvmDecision() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).transition("checkCredit").endActivity().createActivity("checkCredit").behavior((ActivityBehavior)new Decision()).transition("askDaughterOut", "wow").transition("takeToGolf", "nice").transition("ignore", "default").endActivity().createActivity("takeToGolf").behavior((ActivityBehavior)new WaitState()).endActivity().createActivity("askDaughterOut").behavior((ActivityBehavior)new WaitState()).endActivity().createActivity("ignore").behavior((ActivityBehavior)new WaitState()).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.setVariable("creditRating", (Object)"Aaa-");
        processInstance.start();
        PvmTest.assertNotNull((Object)processInstance.findExecution("takeToGolf"));
        processInstance = processDefinition.createProcessInstance();
        processInstance.setVariable("creditRating", (Object)"AAA+");
        processInstance.start();
        PvmTest.assertNotNull((Object)processInstance.findExecution("askDaughterOut"));
        processInstance = processDefinition.createProcessInstance();
        processInstance.setVariable("creditRating", (Object)"bb-");
        processInstance.start();
        PvmTest.assertNotNull((Object)processInstance.findExecution("ignore"));
    }
}

