/*
 * Copyright © 2013-2018 camunda services GmbH and various authors (info@camunda.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.camunda.bpm.application.impl;

/**
 * @author Thorben Lindhauer
 *
 */
public class ProcessApplicationContextImpl {

  protected static ThreadLocal<ProcessApplicationIdentifier> currentProcessApplication =
      new ThreadLocal<ProcessApplicationIdentifier>();

  public static ProcessApplicationIdentifier get() {
    return currentProcessApplication.get();
  }

  public static void set(ProcessApplicationIdentifier identifier) {
    currentProcessApplication.set(identifier);
  }

  public static void clear() {
    currentProcessApplication.remove();
  }
}
