/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.io.InputStream;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.authorization.TaskPermissions;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.form.StartFormData;
import org.camunda.bpm.engine.form.TaskFormData;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.camunda.bpm.engine.variable.VariableMap;

public class FormAuthorizationTest
extends AuthorizationTest {
    protected static final String FORM_PROCESS_KEY = "FormsProcess";
    protected static final String RENDERED_FORM_PROCESS_KEY = "renderedFormProcess";
    protected static final String CASE_KEY = "oneTaskCase";
    protected String deploymentId;
    protected boolean ensureSpecificVariablePermission;

    @Override
    public void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/api/form/DeployedFormsProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/start.form", "org/camunda/bpm/engine/test/api/form/task.form", "org/camunda/bpm/engine/test/api/authorization/renderedFormProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn").getId();
        this.ensureSpecificVariablePermission = this.processEngineConfiguration.isEnforceSpecificVariablePermission();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.deleteDeployment(this.deploymentId);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(this.ensureSpecificVariablePermission);
    }

    public void testGetStartFormDataWithoutAuthorizations() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        try {
            this.formService.getStartFormData(processDefinitionId);
            FormAuthorizationTest.fail((String)"Exception expected: It should not be possible to get start form data");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(FORM_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetStartFormData() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        StartFormData startFormData = this.formService.getStartFormData(processDefinitionId);
        FormAuthorizationTest.assertNotNull((Object)startFormData);
        FormAuthorizationTest.assertEquals((String)"deployment:org/camunda/bpm/engine/test/api/form/start.form", (String)startFormData.getFormKey());
    }

    public void testGetRenderedStartFormWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(RENDERED_FORM_PROCESS_KEY).getId();
        try {
            this.formService.getRenderedStartForm(processDefinitionId);
            FormAuthorizationTest.fail((String)"Exception expected: It should not be possible to get start form data");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(RENDERED_FORM_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetRenderedStartForm() {
        String processDefinitionId = this.selectProcessDefinitionByKey(RENDERED_FORM_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, RENDERED_FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        Object renderedStartForm = this.formService.getRenderedStartForm(processDefinitionId);
        FormAuthorizationTest.assertNotNull((Object)renderedStartForm);
    }

    public void testGetStartFormVariablesWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(RENDERED_FORM_PROCESS_KEY).getId();
        try {
            this.formService.getStartFormVariables(processDefinitionId);
            FormAuthorizationTest.fail((String)"Exception expected: It should not be possible to get start form data");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(RENDERED_FORM_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetStartFormVariables() {
        String processDefinitionId = this.selectProcessDefinitionByKey(RENDERED_FORM_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, RENDERED_FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.formService.getStartFormVariables(processDefinitionId);
        FormAuthorizationTest.assertNotNull((Object)variables);
        FormAuthorizationTest.assertEquals((int)1, (int)variables.size());
    }

    public void testSubmitStartFormWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        try {
            this.formService.submitStartForm(processDefinitionId, null);
            FormAuthorizationTest.fail((String)"Exception expected: It should not possible to submit a start form");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.CREATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
        }
    }

    public void testSubmitStartFormWithCreatePermissionOnProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.formService.submitStartForm(processDefinitionId, null);
            FormAuthorizationTest.fail((String)"Exception expected: It should not possible to submit a start form");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.CREATE_INSTANCE.getName(), message);
            this.assertTextPresent(FORM_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSubmitStartFormWithCreateInstancePermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            this.formService.submitStartForm(processDefinitionId, null);
            FormAuthorizationTest.fail((String)"Exception expected: It should not possible to submit a start form");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.CREATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
        }
    }

    public void testSubmitStartForm() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        ProcessInstance instance = this.formService.submitStartForm(processDefinitionId, null);
        FormAuthorizationTest.assertNotNull((Object)instance);
    }

    public void testStandaloneTaskGetTaskFormDataWithoutAuthorization() {
        String message;
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.formService.getTaskFormData(taskId);
            FormAuthorizationTest.fail((String)"Exception expected: It should not possible to get task form data");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.formService.getTaskFormData(taskId);
            FormAuthorizationTest.fail((String)"Exception expected: It should not possible to get task form data");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(TaskPermissions.READ_VARIABLE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetTaskFormData() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        FormAuthorizationTest.assertNull((Object)taskFormData);
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetTaskFormDataWithReadVariablePermission() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.READ_VARIABLE});
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        FormAuthorizationTest.assertNull((Object)taskFormData);
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskGetTaskFormDataWithoutAuthorization() {
        String message;
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.formService.getTaskFormData(taskId);
            FormAuthorizationTest.fail((String)"Exception expected: It should not possible to get task form data");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.READ_TASK.getName(), message);
            this.assertTextPresent(FORM_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.formService.getTaskFormData(taskId);
            FormAuthorizationTest.fail((String)"Exception expected: It should not possible to get task form data");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(TaskPermissions.READ_VARIABLE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(ProcessDefinitionPermissions.READ_TASK_VARIABLE.getName(), message);
            this.assertTextPresent(FORM_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskGetTaskFormDataWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        FormAuthorizationTest.assertNotNull((Object)taskFormData);
    }

    public void testProcessTaskGetTaskFormDataWithReadTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        FormAuthorizationTest.assertNotNull((Object)taskFormData);
    }

    public void testProcessTaskGetTaskFormDataWithReadVariablePermissionOnTask() {
        this.setReadVariableAsDefaultReadVariablePermission();
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.READ_VARIABLE});
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        FormAuthorizationTest.assertNotNull((Object)taskFormData);
    }

    public void testProcessTaskGetTaskFormDataWithReadTaskVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_TASK_VARIABLE});
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        FormAuthorizationTest.assertNotNull((Object)taskFormData);
    }

    public void testProcessTaskGetTaskFormData() {
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        FormAuthorizationTest.assertNotNull((Object)taskFormData);
    }

    public void testCaseTaskGetTaskFormData() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        FormAuthorizationTest.assertNotNull((Object)taskFormData);
    }

    public void testStandaloneTaskGetTaskRenderedFormWithoutAuthorization() {
        String message;
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.formService.getRenderedTaskForm(taskId);
            FormAuthorizationTest.fail((String)"Exception expected: It should not possible to get rendered task form");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.formService.getRenderedTaskForm(taskId);
            FormAuthorizationTest.fail((String)"Exception expected: It should not possible to get rendered task form");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(TaskPermissions.READ_VARIABLE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetTaskRenderedForm() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        try {
            this.formService.getRenderedTaskForm(taskId);
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetTaskRenderedFormWithReadVariablePermission() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.READ_VARIABLE});
        try {
            this.formService.getRenderedTaskForm(taskId);
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskGetRenderedTaskFormWithoutAuthorization() {
        String message;
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.formService.getRenderedTaskForm(taskId);
            FormAuthorizationTest.fail((String)"Exception expected: It should not possible to get rendered task form");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.READ_TASK.getName(), message);
            this.assertTextPresent(RENDERED_FORM_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.formService.getRenderedTaskForm(taskId);
            FormAuthorizationTest.fail((String)"Exception expected: It should not possible to get rendered task form");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(TaskPermissions.READ_VARIABLE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(ProcessDefinitionPermissions.READ_TASK_VARIABLE.getName(), message);
            this.assertTextPresent(RENDERED_FORM_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskGetRenderedTaskFormWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        Object taskForm = this.formService.getRenderedTaskForm(taskId);
        FormAuthorizationTest.assertNotNull((Object)taskForm);
    }

    public void testProcessTaskGetRenderedTaskFormWithReadTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, RENDERED_FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        Object taskForm = this.formService.getRenderedTaskForm(taskId);
        FormAuthorizationTest.assertNotNull((Object)taskForm);
    }

    public void testProcessTaskGetRenderedTaskFormWithReadTaskVariablesPermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, RENDERED_FORM_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_TASK_VARIABLE});
        Object taskForm = this.formService.getRenderedTaskForm(taskId);
        FormAuthorizationTest.assertNotNull((Object)taskForm);
    }

    public void testProcessTaskGetRenderedTaskFormWithReadVariablePermissionOnTask() {
        this.setReadVariableAsDefaultReadVariablePermission();
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.READ_VARIABLE});
        Object taskForm = this.formService.getRenderedTaskForm(taskId);
        FormAuthorizationTest.assertNotNull((Object)taskForm);
    }

    public void testProcessTaskGetRenderedTaskForm() {
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, RENDERED_FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        Object taskForm = this.formService.getRenderedTaskForm(taskId);
        FormAuthorizationTest.assertNotNull((Object)taskForm);
    }

    public void testCaseTaskGetRenderedTaskForm() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        Object taskForm = this.formService.getRenderedTaskForm(taskId);
        FormAuthorizationTest.assertNull((Object)taskForm);
    }

    public void testStandaloneTaskGetTaskFormVariablesWithoutAuthorization() {
        String message;
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.formService.getTaskFormVariables(taskId);
            FormAuthorizationTest.fail((String)"Exception expected: It should not possible to get task form variables");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.formService.getTaskFormVariables(taskId);
            FormAuthorizationTest.fail((String)"Exception expected: It should not possible to get task form variables");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(TaskPermissions.READ_VARIABLE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetTaskFormVariables() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.formService.getTaskFormVariables(taskId);
        FormAuthorizationTest.assertNotNull((Object)variables);
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetTaskFormVariablesWithReadVariablePermission() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.READ_VARIABLE});
        VariableMap variables = this.formService.getTaskFormVariables(taskId);
        FormAuthorizationTest.assertNotNull((Object)variables);
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskGetTaskFormVariablesWithoutAuthorization() {
        String message;
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.formService.getTaskFormVariables(taskId);
            FormAuthorizationTest.fail((String)"Exception expected: It should not possible to get task form variables");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.READ_TASK.getName(), message);
            this.assertTextPresent(RENDERED_FORM_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
        try {
            this.formService.getTaskFormVariables(taskId);
            FormAuthorizationTest.fail((String)"Exception expected: It should not possible to get task form variables");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(TaskPermissions.READ_VARIABLE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(ProcessDefinitionPermissions.READ_TASK_VARIABLE.getName(), message);
            this.assertTextPresent(RENDERED_FORM_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskGetTaskFormVariablesWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.formService.getTaskFormVariables(taskId);
        FormAuthorizationTest.assertNotNull((Object)variables);
        FormAuthorizationTest.assertEquals((int)1, (int)variables.size());
    }

    public void testProcessTaskGetTaskFormVariablesWithReadTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, RENDERED_FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        VariableMap variables = this.formService.getTaskFormVariables(taskId);
        FormAuthorizationTest.assertNotNull((Object)variables);
        FormAuthorizationTest.assertEquals((int)1, (int)variables.size());
    }

    public void testProcessTaskGetTaskFormVariables() {
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, RENDERED_FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        VariableMap variables = this.formService.getTaskFormVariables(taskId);
        FormAuthorizationTest.assertNotNull((Object)variables);
        FormAuthorizationTest.assertEquals((int)1, (int)variables.size());
    }

    public void testProcessTaskGetTaskFormVariablesWithReadVariablePermissionOnTask() {
        this.setReadVariableAsDefaultReadVariablePermission();
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.READ_VARIABLE});
        VariableMap variables = this.formService.getTaskFormVariables(taskId);
        FormAuthorizationTest.assertNotNull((Object)variables);
        FormAuthorizationTest.assertEquals((int)1, (int)variables.size());
    }

    public void testProcessTaskGetTaskFormVariablesWithReadTaskVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        this.startProcessInstanceByKey(RENDERED_FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, RENDERED_FORM_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_TASK_VARIABLE});
        VariableMap variables = this.formService.getTaskFormVariables(taskId);
        FormAuthorizationTest.assertNotNull((Object)variables);
        FormAuthorizationTest.assertEquals((int)1, (int)variables.size());
    }

    public void testCaseTaskGetTaskFormVariables() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        VariableMap variables = this.formService.getTaskFormVariables(taskId);
        FormAuthorizationTest.assertNotNull((Object)variables);
        FormAuthorizationTest.assertEquals((int)0, (int)variables.size());
    }

    public void testStandaloneTaskSubmitTaskFormWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.formService.submitTaskForm(taskId, null);
            FormAuthorizationTest.fail((String)"Exception expected: It should not possible to submit a task form");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSubmitTaskForm() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.formService.submitTaskForm(taskId, null);
        Task task = this.selectSingleTask();
        FormAuthorizationTest.assertNull((Object)task);
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskSubmitTaskFormWithoutAuthorization() {
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.formService.submitTaskForm(taskId, null);
            FormAuthorizationTest.fail((String)"Exception expected: It should not possible to submit a task form");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(FORM_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskSubmitTaskFormWithUpdatePermissionOnTask() {
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.formService.submitTaskForm(taskId, null);
        Task task = this.selectSingleTask();
        FormAuthorizationTest.assertNull((Object)task);
    }

    public void testProcessTaskSubmitTaskFormWithUpdateTaskPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.formService.submitTaskForm(taskId, null);
        Task task = this.selectSingleTask();
        FormAuthorizationTest.assertNull((Object)task);
    }

    public void testProcessTaskSubmitTaskForm() {
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.formService.submitTaskForm(taskId, null);
        Task task = this.selectSingleTask();
        FormAuthorizationTest.assertNull((Object)task);
    }

    public void testCaseTaskSubmitTaskForm() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.formService.submitTaskForm(taskId, null);
        Task task = this.selectSingleTask();
        FormAuthorizationTest.assertNull((Object)task);
    }

    public void testGetStartFormKeyWithoutAuthorizations() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        try {
            this.formService.getStartFormKey(processDefinitionId);
            FormAuthorizationTest.fail((String)"Exception expected: It should not possible to get a start form key");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(FORM_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetStartFormKey() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        String formKey = this.formService.getStartFormKey(processDefinitionId);
        FormAuthorizationTest.assertEquals((String)"deployment:org/camunda/bpm/engine/test/api/form/start.form", (String)formKey);
    }

    public void testGetTaskFormKeyWithoutAuthorizations() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        try {
            this.formService.getTaskFormKey(processDefinitionId, "task");
            FormAuthorizationTest.fail((String)"Exception expected: It should not possible to get a task form key");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(FORM_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetTaskFormKey() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        String formKey = this.formService.getTaskFormKey(processDefinitionId, "task");
        FormAuthorizationTest.assertEquals((String)"deployment:org/camunda/bpm/engine/test/api/form/task.form", (String)formKey);
    }

    public void testGetDeployedStartForm() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, FORM_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        InputStream inputStream = this.formService.getDeployedStartForm(processDefinitionId);
        FormAuthorizationTest.assertNotNull((Object)inputStream);
    }

    public void testGetDeployedStartFormWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(FORM_PROCESS_KEY).getId();
        try {
            this.formService.getDeployedStartForm(processDefinitionId);
            FormAuthorizationTest.fail((String)"Exception expected: It should not possible to get a deployed start form");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(FORM_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetDeployedTaskForm() {
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        InputStream inputStream = this.formService.getDeployedTaskForm(taskId);
        FormAuthorizationTest.assertNotNull((Object)inputStream);
    }

    public void testGetDeployedTaskFormWithoutAuthorization() {
        this.startProcessInstanceByKey(FORM_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.formService.getDeployedTaskForm(taskId);
            FormAuthorizationTest.fail((String)"Exception expected: It should not possible to get a deployed task form");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(FORM_PROCESS_KEY, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
        }
    }

    protected void setReadVariableAsDefaultReadVariablePermission() {
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
    }
}

