/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.optimize;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.OptimizeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

@RequiredHistoryLevel(value="full")
public class OptimizeProcessDefinitionServiceAuthorizationTest
extends AuthorizationTest {
    protected String deploymentId;
    private OptimizeService optimizeService;

    @Override
    public void setUp() throws Exception {
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)OptimizeProcessDefinitionServiceAuthorizationTest.getProcessEngine().getProcessEngineConfiguration();
        this.optimizeService = config.getOptimizeService();
        DeploymentBuilder deploymentbuilder = this.repositoryService.createDeployment();
        BpmnModelInstance defaultModel = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.deploymentId = this.deployment(deploymentbuilder, new BpmnModelInstance[]{defaultModel});
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.deleteDeployment(this.deploymentId);
    }

    public void testGetCompletedActivitiesWithoutAuthorization() {
        this.startProcessInstanceByKey("process");
        try {
            this.optimizeService.getCompletedHistoricActivityInstances(new Date(0L), null, 10);
            OptimizeProcessDefinitionServiceAuthorizationTest.fail((String)"Exception expected: It should not be possible to retrieve the activities");
        }
        catch (AuthorizationException e) {
            String exceptionMessage = e.getMessage();
            this.assertTextPresent(this.userId, exceptionMessage);
            this.assertTextPresent(Permissions.READ_HISTORY.getName(), exceptionMessage);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), exceptionMessage);
        }
    }

    public void testGetCompletedActivitiesWithAuthorization() {
        this.startProcessInstanceByKey("process");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        List completedHistoricActivityInstances = this.optimizeService.getCompletedHistoricActivityInstances(new Date(0L), null, 10);
        MatcherAssert.assertThat((Object)completedHistoricActivityInstances.size(), (Matcher)CoreMatchers.is((Object)2));
    }

    public void testGetRunningActivitiesWithoutAuthorization() {
        this.startProcessInstanceByKey("process");
        try {
            this.optimizeService.getRunningHistoricActivityInstances(new Date(0L), null, 10);
            OptimizeProcessDefinitionServiceAuthorizationTest.fail((String)"Exception expected: It should not be possible to retrieve the activities");
        }
        catch (AuthorizationException e) {
            String exceptionMessage = e.getMessage();
            this.assertTextPresent(this.userId, exceptionMessage);
            this.assertTextPresent(Permissions.READ_HISTORY.getName(), exceptionMessage);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), exceptionMessage);
        }
    }

    public void testGetRunningActivitiesWithAuthorization() {
        this.startProcessInstanceByKey("process");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        List runningHistoricActivityInstances = this.optimizeService.getRunningHistoricActivityInstances(new Date(0L), null, 10);
        MatcherAssert.assertThat((Object)runningHistoricActivityInstances.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    public void testGetCompletedTasksWithoutAuthorization() {
        this.startProcessInstanceByKey("process");
        try {
            this.optimizeService.getCompletedHistoricTaskInstances(new Date(0L), null, 10);
            OptimizeProcessDefinitionServiceAuthorizationTest.fail((String)"Exception expected: It should not be possible to retrieve the tasks");
        }
        catch (AuthorizationException e) {
            String exceptionMessage = e.getMessage();
            this.assertTextPresent(this.userId, exceptionMessage);
            this.assertTextPresent(Permissions.READ_HISTORY.getName(), exceptionMessage);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), exceptionMessage);
        }
    }

    public void testGetCompletedTasksWithAuthorization() {
        this.startProcessInstanceByKey("process");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        List completedHistoricTaskInstances = this.optimizeService.getCompletedHistoricTaskInstances(new Date(0L), null, 10);
        MatcherAssert.assertThat((Object)completedHistoricTaskInstances.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    public void testGetRunningTasksWithoutAuthorization() {
        this.startProcessInstanceByKey("process");
        try {
            this.optimizeService.getRunningHistoricTaskInstances(new Date(0L), null, 10);
            OptimizeProcessDefinitionServiceAuthorizationTest.fail((String)"Exception expected: It should not be possible to retrieve the tasks");
        }
        catch (AuthorizationException e) {
            String exceptionMessage = e.getMessage();
            this.assertTextPresent(this.userId, exceptionMessage);
            this.assertTextPresent(Permissions.READ_HISTORY.getName(), exceptionMessage);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), exceptionMessage);
        }
    }

    public void testGetRunningTasksWithAuthorization() {
        this.startProcessInstanceByKey("process");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        List runningHistoricTaskInstances = this.optimizeService.getRunningHistoricTaskInstances(new Date(0L), null, 10);
        MatcherAssert.assertThat((Object)runningHistoricTaskInstances.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    public void testGetOperationsLogWithoutAuthorization() {
        this.startProcessInstanceByKey("process");
        try {
            this.optimizeService.getHistoricUserOperationLogs(new Date(0L), null, 10);
            OptimizeProcessDefinitionServiceAuthorizationTest.fail((String)"Exception expected: It should not be possible to retrieve the logs");
        }
        catch (AuthorizationException e) {
            String exceptionMessage = e.getMessage();
            this.assertTextPresent(this.userId, exceptionMessage);
            this.assertTextPresent(Permissions.READ_HISTORY.getName(), exceptionMessage);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), exceptionMessage);
        }
    }

    public void testGetOperationsLogWithAuthorization() {
        this.startProcessInstanceByKey("process");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        List operationLogEntries = this.optimizeService.getHistoricUserOperationLogs(new Date(0L), null, 10);
        MatcherAssert.assertThat((Object)operationLogEntries.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    public void testGetCompletedProcessInstancesWithoutAuthorization() {
        this.startProcessInstanceByKey("process");
        try {
            this.optimizeService.getCompletedHistoricProcessInstances(new Date(0L), null, 10);
            OptimizeProcessDefinitionServiceAuthorizationTest.fail((String)"Exception expected: It should not be possible to retrieve the activities");
        }
        catch (AuthorizationException e) {
            String exceptionMessage = e.getMessage();
            this.assertTextPresent(this.userId, exceptionMessage);
            this.assertTextPresent(Permissions.READ_HISTORY.getName(), exceptionMessage);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), exceptionMessage);
        }
    }

    public void testGetCompletedProcessInstancesWithAuthorization() {
        this.startProcessInstanceByKey("process");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        List completedHistoricProcessInstances = this.optimizeService.getCompletedHistoricProcessInstances(new Date(0L), null, 10);
        MatcherAssert.assertThat((Object)completedHistoricProcessInstances.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    public void testGetRunningProcessInstancesWithoutAuthorization() {
        this.startProcessInstanceByKey("process");
        try {
            this.optimizeService.getRunningHistoricProcessInstances(new Date(0L), null, 10);
            OptimizeProcessDefinitionServiceAuthorizationTest.fail((String)"Exception expected: It should not be possible to retrieve the activities");
        }
        catch (AuthorizationException e) {
            String exceptionMessage = e.getMessage();
            this.assertTextPresent(this.userId, exceptionMessage);
            this.assertTextPresent(Permissions.READ_HISTORY.getName(), exceptionMessage);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), exceptionMessage);
        }
    }

    public void testGetRunningProcessInstancesWithAuthorization() {
        this.startProcessInstanceByKey("process");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        List runningHistoricProcessInstances = this.optimizeService.getRunningHistoricProcessInstances(new Date(0L), null, 10);
        MatcherAssert.assertThat((Object)runningHistoricProcessInstances.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    public void testGetVariableUpdatesWithoutAuthorization() {
        this.startProcessInstanceByKey("process");
        try {
            this.optimizeService.getHistoricVariableUpdates(new Date(0L), null, 10);
            OptimizeProcessDefinitionServiceAuthorizationTest.fail((String)"Exception expected: It should not be possible to retrieve the activities");
        }
        catch (AuthorizationException e) {
            String exceptionMessage = e.getMessage();
            this.assertTextPresent(this.userId, exceptionMessage);
            this.assertTextPresent(Permissions.READ_HISTORY.getName(), exceptionMessage);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), exceptionMessage);
        }
    }

    public void testGetVariableUpdatesWithAuthorization() {
        this.startProcessInstanceByKey("process");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        List historicVariableUpdates = this.optimizeService.getHistoricVariableUpdates(new Date(0L), null, 10);
        MatcherAssert.assertThat((Object)historicVariableUpdates.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    public void testAuthorizationsOnSingleProcessDefinitionIsNotEnough() {
        this.startProcessInstanceByKey("process");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "process", this.userId, new Permission[]{Permissions.READ_HISTORY});
        try {
            this.optimizeService.getCompletedHistoricActivityInstances(new Date(0L), null, 10);
            OptimizeProcessDefinitionServiceAuthorizationTest.fail((String)"Exception expected: It should not be possible to retrieve the activities");
        }
        catch (AuthorizationException e) {
            String exceptionMessage = e.getMessage();
            this.assertTextPresent(this.userId, exceptionMessage);
            this.assertTextPresent(Permissions.READ_HISTORY.getName(), exceptionMessage);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), exceptionMessage);
        }
    }

    public void testGrantAuthorizationWithAllPermissions() {
        this.startProcessInstanceByKey("process");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.ALL});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.ALL});
        List completedHistoricActivityInstances = this.optimizeService.getCompletedHistoricActivityInstances(new Date(0L), null, 10);
        MatcherAssert.assertThat((Object)completedHistoricActivityInstances.size(), (Matcher)CoreMatchers.is((Object)2));
    }
}

