/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.externaltask;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.ibatis.jdbc.RuntimeSqlException;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.externaltask.ExternalTaskQueryBuilder;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.externaltask.ExternalTaskCustomValue;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.AssertUtil;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.joda.time.DateTime;
import org.junit.Assert;

public class ExternalTaskServiceTest
extends PluggableProcessEngineTestCase {
    protected static final String WORKER_ID = "aWorkerId";
    protected static final long LOCK_TIME = 10000L;
    protected static final String TOPIC_NAME = "externalTaskTopic";

    protected void setUp() throws Exception {
        ClockUtil.setCurrentTime((Date)new Date());
    }

    protected void tearDown() throws Exception {
        ClockUtil.reset();
    }

    public void testFailOnMalformedpriorityInput() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/externaltask/externalTaskInvalidPriority.bpmn20.xml").deploy();
            ExternalTaskServiceTest.fail((String)"deploying a process with malformed priority should not succeed");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresentIgnoreCase("value 'NOTaNumber' for attribute 'taskPriority' is not a valid number", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetch() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)externalTasks.size());
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        ExternalTaskServiceTest.assertNotNull((Object)task.getId());
        ExternalTaskServiceTest.assertEquals((String)processInstance.getId(), (String)task.getProcessInstanceId());
        ExternalTaskServiceTest.assertEquals((String)processInstance.getProcessDefinitionId(), (String)task.getProcessDefinitionId());
        ExternalTaskServiceTest.assertEquals((String)"externalTask", (String)task.getActivityId());
        ExternalTaskServiceTest.assertEquals((String)"oneExternalTaskProcess", (String)task.getProcessDefinitionKey());
        ExternalTaskServiceTest.assertEquals((String)TOPIC_NAME, (String)task.getTopicName());
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId()).getActivityInstances("externalTask")[0];
        ExternalTaskServiceTest.assertEquals((String)activityInstance.getId(), (String)task.getActivityInstanceId());
        ExternalTaskServiceTest.assertEquals((String)activityInstance.getExecutionIds()[0], (String)task.getExecutionId());
        AssertUtil.assertEqualsSecondPrecision(this.nowPlus(10000L), task.getLockExpirationTime());
        ExternalTaskServiceTest.assertEquals((String)WORKER_ID, (String)task.getWorkerId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskWithPriorityProcess.bpmn20.xml"})
    public void testFetchWithPriority() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID, true).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)externalTasks.size());
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        ExternalTaskServiceTest.assertNotNull((Object)task.getId());
        ExternalTaskServiceTest.assertEquals((String)processInstance.getId(), (String)task.getProcessInstanceId());
        ExternalTaskServiceTest.assertEquals((String)processInstance.getProcessDefinitionId(), (String)task.getProcessDefinitionId());
        ExternalTaskServiceTest.assertEquals((String)"externalTaskWithPrio", (String)task.getActivityId());
        ExternalTaskServiceTest.assertEquals((String)"twoExternalTaskWithPriorityProcess", (String)task.getProcessDefinitionKey());
        ExternalTaskServiceTest.assertEquals((String)TOPIC_NAME, (String)task.getTopicName());
        ExternalTaskServiceTest.assertEquals((long)7L, (long)task.getPriority());
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId()).getActivityInstances("externalTaskWithPrio")[0];
        ExternalTaskServiceTest.assertEquals((String)activityInstance.getId(), (String)task.getActivityInstanceId());
        ExternalTaskServiceTest.assertEquals((String)activityInstance.getExecutionIds()[0], (String)task.getExecutionId());
        AssertUtil.assertEqualsSecondPrecision(this.nowPlus(10000L), task.getLockExpirationTime());
        ExternalTaskServiceTest.assertEquals((String)WORKER_ID, (String)task.getWorkerId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityProcess.bpmn20.xml"})
    public void testFetchProcessWithPriority() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(2, WORKER_ID, true).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)2, (int)externalTasks.size());
        ExternalTaskServiceTest.assertEquals((long)9L, (long)((LockedExternalTask)externalTasks.get(0)).getPriority());
        ExternalTaskServiceTest.assertEquals((long)7L, (long)((LockedExternalTask)externalTasks.get(1)).getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityExpressionProcess.bpmn20.xml"})
    public void testFetchProcessWithPriorityExpression() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess", (Map)Variables.createVariables().putValue("priority", (Object)18));
        List externalTasks = this.externalTaskService.fetchAndLock(2, WORKER_ID, true).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)2, (int)externalTasks.size());
        ExternalTaskServiceTest.assertEquals((long)18L, (long)((LockedExternalTask)externalTasks.get(0)).getPriority());
        ExternalTaskServiceTest.assertEquals((long)7L, (long)((LockedExternalTask)externalTasks.get(1)).getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityExpression.bpmn20.xml"})
    public void testFetchWithPriorityExpression() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess", (Map)Variables.createVariables().putValue("priority", (Object)18));
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID, true).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)externalTasks.size());
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        ExternalTaskServiceTest.assertNotNull((Object)task.getId());
        ExternalTaskServiceTest.assertEquals((String)processInstance.getId(), (String)task.getProcessInstanceId());
        ExternalTaskServiceTest.assertEquals((String)processInstance.getProcessDefinitionId(), (String)task.getProcessDefinitionId());
        ExternalTaskServiceTest.assertEquals((String)"externalTaskWithPrio", (String)task.getActivityId());
        ExternalTaskServiceTest.assertEquals((String)"twoExternalTaskWithPriorityProcess", (String)task.getProcessDefinitionKey());
        ExternalTaskServiceTest.assertEquals((String)TOPIC_NAME, (String)task.getTopicName());
        ExternalTaskServiceTest.assertEquals((long)18L, (long)task.getPriority());
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId()).getActivityInstances("externalTaskWithPrio")[0];
        ExternalTaskServiceTest.assertEquals((String)activityInstance.getId(), (String)task.getActivityInstanceId());
        ExternalTaskServiceTest.assertEquals((String)activityInstance.getExecutionIds()[0], (String)task.getExecutionId());
        AssertUtil.assertEqualsSecondPrecision(this.nowPlus(10000L), task.getLockExpirationTime());
        ExternalTaskServiceTest.assertEquals((String)WORKER_ID, (String)task.getWorkerId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskWithPriorityProcess.bpmn20.xml"})
    public void testFetchWithPriorityOrdering() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(2, WORKER_ID, true).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)2, (int)externalTasks.size());
        ExternalTaskServiceTest.assertTrue((((LockedExternalTask)externalTasks.get(0)).getPriority() > ((LockedExternalTask)externalTasks.get(1)).getPriority() ? 1 : 0) != 0);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskWithPriorityProcess.bpmn20.xml"})
    public void testFetchNextWithPriority() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID, true).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)externalTasks.size());
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        long firstPrio = task.getPriority();
        AssertUtil.assertEqualsSecondPrecision(this.nowPlus(10000L), task.getLockExpirationTime());
        externalTasks = this.externalTaskService.fetchAndLock(1, "anotherWorkerId", true).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)externalTasks.size());
        ExternalTaskServiceTest.assertTrue((firstPrio >= ((LockedExternalTask)externalTasks.get(0)).getPriority() ? 1 : 0) != 0);
        ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID, true).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)externalTasks.size());
        ExternalTaskServiceTest.assertEquals((long)firstPrio, (long)((LockedExternalTask)externalTasks.get(0)).getPriority());
    }

    @Deployment
    public void testFetchTopicSelection() {
        this.runtimeService.startProcessInstanceByKey("twoTopicsProcess");
        List topic1Tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("topic1", 10000L).execute();
        List topic2Tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("topic2", 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)topic1Tasks.size());
        ExternalTaskServiceTest.assertEquals((String)"topic1", (String)((LockedExternalTask)topic1Tasks.get(0)).getTopicName());
        ExternalTaskServiceTest.assertEquals((int)1, (int)topic2Tasks.size());
        ExternalTaskServiceTest.assertEquals((String)"topic2", (String)((LockedExternalTask)topic2Tasks.get(0)).getTopicName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetchWithoutTopicName() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        try {
            this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(null, 10000L).execute();
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("topicName is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetchNullWorkerId() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        try {
            this.externalTaskService.fetchAndLock(1, null).topic(TOPIC_NAME, 10000L).execute();
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("workerId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetchNegativeNumberOfTasks() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        try {
            this.externalTaskService.fetchAndLock(-1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("maxResults is not greater than or equal to 0", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetchLessTasksThanExist() {
        for (int i = 0; i < 10; ++i) {
            this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        }
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)5, (int)externalTasks.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetchNegativeLockTime() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        try {
            this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, -1L).execute();
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("lockTime is not greater than 0", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetchZeroLockTime() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        try {
            this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 0L).execute();
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("lockTime is not greater than 0", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetchNoTopics() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)tasks.size());
    }

    @Deployment
    public void testFetchVariables() {
        this.runtimeService.startProcessInstanceByKey("subProcessExternalTask", (Map)Variables.createVariables().putValue("processVar1", (Object)42).putValue("processVar2", (Object)43));
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).variables(new String[]{"processVar1", "subProcessVar", "taskVar"}).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        VariableMap variables = task.getVariables();
        ExternalTaskServiceTest.assertEquals((int)3, (int)variables.size());
        ExternalTaskServiceTest.assertEquals((Object)42, (Object)variables.get((Object)"processVar1"));
        ExternalTaskServiceTest.assertEquals((Object)44L, (Object)variables.get((Object)"subProcessVar"));
        ExternalTaskServiceTest.assertEquals((Object)45L, (Object)variables.get((Object)"taskVar"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testFetchVariables.bpmn20.xml"})
    public void testShouldNotFetchSerializedVariables() {
        ExternalTaskCustomValue customValue = new ExternalTaskCustomValue();
        customValue.setTestValue("value1");
        this.runtimeService.startProcessInstanceByKey("subProcessExternalTask", (Map)Variables.createVariables().putValue("processVar1", (Object)customValue));
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).variables(new String[]{"processVar1"}).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        VariableMap variables = task.getVariables();
        ExternalTaskServiceTest.assertEquals((int)1, (int)variables.size());
        try {
            variables.get((Object)"processVar1");
            ExternalTaskServiceTest.fail((String)"did not receive an exception although variable was serialized");
        }
        catch (IllegalStateException e) {
            ExternalTaskServiceTest.assertEquals((String)"Object is not deserialized.", (String)e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testFetchVariables.bpmn20.xml"})
    public void testFetchSerializedVariables() {
        ExternalTaskCustomValue customValue = new ExternalTaskCustomValue();
        customValue.setTestValue("value1");
        this.runtimeService.startProcessInstanceByKey("subProcessExternalTask", (Map)Variables.createVariables().putValue("processVar1", (Object)customValue));
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).variables(new String[]{"processVar1"}).enableCustomObjectDeserialization().execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        VariableMap variables = task.getVariables();
        ExternalTaskServiceTest.assertEquals((int)1, (int)variables.size());
        ExternalTaskCustomValue receivedCustomValue = (ExternalTaskCustomValue)variables.get((Object)"processVar1");
        ExternalTaskServiceTest.assertNotNull((Object)receivedCustomValue);
        ExternalTaskServiceTest.assertNotNull((Object)receivedCustomValue.getTestValue());
        ExternalTaskServiceTest.assertEquals((String)"value1", (String)receivedCustomValue.getTestValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskVariablesTest.testExternalTaskVariablesLocal.bpmn20.xml"})
    public void testFetchOnlyLocalVariables() {
        VariableMap globalVars = Variables.putValue((String)"globalVar", (Object)"globalVal");
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", (Map)globalVars);
        String workerId = "workerId";
        String topicName = "testTopic";
        List lockedExternalTasks = this.externalTaskService.fetchAndLock(10, "workerId").topic("testTopic", 60000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)lockedExternalTasks.size());
        LockedExternalTask lockedExternalTask = (LockedExternalTask)lockedExternalTasks.get(0);
        VariableMap variables = lockedExternalTask.getVariables();
        ExternalTaskServiceTest.assertEquals((int)2, (int)variables.size());
        ExternalTaskServiceTest.assertEquals((String)"globalVal", (String)((String)variables.getValue("globalVar", String.class)));
        ExternalTaskServiceTest.assertEquals((String)"localVal", (String)((String)variables.getValue("localVar", String.class)));
        this.externalTaskService.unlock(lockedExternalTask.getId());
        lockedExternalTasks = this.externalTaskService.fetchAndLock(10, "workerId").topic("testTopic", 60000L).variables(new String[]{"globalVar", "localVar"}).localVariables().execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)lockedExternalTasks.size());
        lockedExternalTask = (LockedExternalTask)lockedExternalTasks.get(0);
        variables = lockedExternalTask.getVariables();
        ExternalTaskServiceTest.assertEquals((int)1, (int)variables.size());
        ExternalTaskServiceTest.assertEquals((String)"localVal", (String)((String)variables.getValue("localVar", String.class)));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskVariablesTest.testExternalTaskVariablesLocal.bpmn20.xml"})
    public void testFetchNonExistingLocalVariables() {
        VariableMap globalVars = Variables.putValue((String)"globalVar", (Object)"globalVal");
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", (Map)globalVars);
        String workerId = "workerId";
        String topicName = "testTopic";
        List lockedExternalTasks = this.externalTaskService.fetchAndLock(10, "workerId").topic("testTopic", 60000L).variables(new String[]{"globalVar", "nonExistingLocalVar"}).localVariables().execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)lockedExternalTasks.size());
        LockedExternalTask lockedExternalTask = (LockedExternalTask)lockedExternalTasks.get(0);
        VariableMap variables = lockedExternalTask.getVariables();
        ExternalTaskServiceTest.assertEquals((int)0, (int)variables.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testFetchVariables.bpmn20.xml"})
    public void testFetchAllVariables() {
        this.runtimeService.startProcessInstanceByKey("subProcessExternalTask", (Map)Variables.createVariables().putValue("processVar1", (Object)42).putValue("processVar2", (Object)43));
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        this.verifyVariables(task);
        this.runtimeService.startProcessInstanceByKey("subProcessExternalTask", (Map)Variables.createVariables().putValue("processVar1", (Object)42).putValue("processVar2", (Object)43));
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).variables((String[])null).execute();
        task = (LockedExternalTask)externalTasks.get(0);
        this.verifyVariables(task);
        this.runtimeService.startProcessInstanceByKey("subProcessExternalTask", (Map)Variables.createVariables().putValue("processVar1", (Object)42).putValue("processVar2", (Object)43));
        List list = null;
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).variables(list).execute();
        task = (LockedExternalTask)externalTasks.get(0);
        this.verifyVariables(task);
    }

    private void verifyVariables(LockedExternalTask task) {
        VariableMap variables = task.getVariables();
        ExternalTaskServiceTest.assertEquals((int)4, (int)variables.size());
        ExternalTaskServiceTest.assertEquals((Object)42, (Object)variables.get((Object)"processVar1"));
        ExternalTaskServiceTest.assertEquals((Object)43, (Object)variables.get((Object)"processVar2"));
        ExternalTaskServiceTest.assertEquals((Object)44L, (Object)variables.get((Object)"subProcessVar"));
        ExternalTaskServiceTest.assertEquals((Object)45L, (Object)variables.get((Object)"taskVar"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetchNonExistingVariable() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).variables(new String[]{"nonExistingVariable"}).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        ExternalTaskServiceTest.assertTrue((boolean)task.getVariables().isEmpty());
    }

    @Deployment
    public void testFetchMultipleTopics() {
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("topic1", 10000L).topic("topic2", 20000L).execute();
        ExternalTaskServiceTest.assertEquals((int)2, (int)tasks.size());
        LockedExternalTask topic1Task = "topic1".equals(((LockedExternalTask)tasks.get(0)).getTopicName()) ? (LockedExternalTask)tasks.get(0) : (LockedExternalTask)tasks.get(1);
        LockedExternalTask topic2Task = "topic2".equals(((LockedExternalTask)tasks.get(0)).getTopicName()) ? (LockedExternalTask)tasks.get(0) : (LockedExternalTask)tasks.get(1);
        ExternalTaskServiceTest.assertEquals((String)"topic1", (String)topic1Task.getTopicName());
        AssertUtil.assertEqualsSecondPrecision(this.nowPlus(10000L), topic1Task.getLockExpirationTime());
        ExternalTaskServiceTest.assertEquals((String)"topic2", (String)topic2Task.getTopicName());
        AssertUtil.assertEqualsSecondPrecision(this.nowPlus(20000L), topic2Task.getLockExpirationTime());
        tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("topic1", 10000L).topic("topic2", 20000L).topic("topic3", 30000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)tasks.size());
        LockedExternalTask topic3Task = (LockedExternalTask)tasks.get(0);
        ExternalTaskServiceTest.assertEquals((String)"topic3", (String)topic3Task.getTopicName());
        AssertUtil.assertEqualsSecondPrecision(this.nowPlus(30000L), topic3Task.getLockExpirationTime());
    }

    @Deployment
    public void testFetchMultipleTopicsWithVariables() {
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", (Map)Variables.createVariables().putValue("var1", (Object)0).putValue("var2", (Object)0));
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("topic1", 10000L).variables(new String[]{"var1", "var2"}).topic("topic2", 10000L).variables(new String[]{"var1"}).execute();
        LockedExternalTask topic1Task = "topic1".equals(((LockedExternalTask)tasks.get(0)).getTopicName()) ? (LockedExternalTask)tasks.get(0) : (LockedExternalTask)tasks.get(1);
        LockedExternalTask topic2Task = "topic2".equals(((LockedExternalTask)tasks.get(0)).getTopicName()) ? (LockedExternalTask)tasks.get(0) : (LockedExternalTask)tasks.get(1);
        ExternalTaskServiceTest.assertEquals((String)"topic1", (String)topic1Task.getTopicName());
        ExternalTaskServiceTest.assertEquals((String)"topic2", (String)topic2Task.getTopicName());
        VariableMap topic1Variables = topic1Task.getVariables();
        ExternalTaskServiceTest.assertEquals((int)2, (int)topic1Variables.size());
        ExternalTaskServiceTest.assertEquals((Object)1L, (Object)topic1Variables.get((Object)"var1"));
        ExternalTaskServiceTest.assertEquals((Object)1L, (Object)topic1Variables.get((Object)"var2"));
        VariableMap topic2Variables = topic2Task.getVariables();
        ExternalTaskServiceTest.assertEquals((int)1, (int)topic2Variables.size());
        ExternalTaskServiceTest.assertEquals((Object)2L, (Object)topic2Variables.get((Object)"var1"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testFetchMultipleTopics.bpmn20.xml"})
    public void testFetchMultipleTopicsMaxTasks() {
        for (int i = 0; i < 10; ++i) {
            this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess");
        }
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("topic1", 10000L).topic("topic2", 10000L).topic("topic3", 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)5, (int)tasks.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetchSuspendedTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)externalTasks.size());
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)externalTasks.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetchAndLockWithInitialBuilder() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ExternalTaskQueryBuilder initialBuilder = this.externalTaskService.fetchAndLock(1, WORKER_ID);
        initialBuilder.topic(TOPIC_NAME, 10000L);
        List tasks = initialBuilder.execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)tasks.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityProcess.bpmn20.xml"})
    public void testFetchByProcessDefinitionId() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess");
        String processDefinitionId2 = processInstance2.getProcessDefinitionId();
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).processDefinitionId(processDefinitionId2).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)externalTasks.size());
        ExternalTaskServiceTest.assertEquals((String)processDefinitionId2, (String)((LockedExternalTask)externalTasks.get(0)).getProcessDefinitionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/parallelExternalTaskProcess.bpmn20.xml"})
    public void testFetchByProcessDefinitionIdCombination() {
        String topicName1 = "topic1";
        String topicName2 = "topic2";
        String businessKey1 = "testBusinessKey1";
        String businessKey2 = "testBusinessKey2";
        Long lockDuration = 60000L;
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey1);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey2);
        String processDefinitionId2 = processInstance2.getProcessDefinitionId();
        List topicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, lockDuration.longValue()).topic(topicName2, lockDuration.longValue()).processDefinitionId(processDefinitionId2).execute();
        ExternalTaskServiceTest.assertEquals((int)3, (int)topicTasks.size());
        for (LockedExternalTask externalTask : topicTasks) {
            ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(externalTask.getProcessInstanceId()).singleResult();
            if (externalTask.getTopicName().equals(topicName1)) {
                ExternalTaskServiceTest.assertEquals((String)pi.getProcessDefinitionId(), (String)externalTask.getProcessDefinitionId());
                continue;
            }
            if (externalTask.getTopicName().equals(topicName2)) {
                ExternalTaskServiceTest.assertEquals((String)processDefinitionId2, (String)pi.getProcessDefinitionId());
                ExternalTaskServiceTest.assertEquals((String)processDefinitionId2, (String)externalTask.getProcessDefinitionId());
                continue;
            }
            ExternalTaskServiceTest.fail((String)"No other topic name values should be available!");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/parallelExternalTaskProcess.bpmn20.xml"})
    public void testFetchByProcessDefinitionIdIn() {
        String topicName1 = "topic1";
        String topicName2 = "topic2";
        String topicName3 = "topic3";
        String businessKey1 = "testBusinessKey1";
        String businessKey2 = "testBusinessKey2";
        String businessKey3 = "testBusinessKey3";
        Long lockDuration = 60000L;
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey1);
        String processDefinitionId1 = processInstance1.getProcessDefinitionId();
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey2);
        String processDefinitionId2 = processInstance2.getProcessDefinitionId();
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey3);
        String processDefinitionId3 = processInstance3.getProcessDefinitionId();
        List topicTasks = this.externalTaskService.fetchAndLock(2, "externalWorkerId").topic(topicName1, lockDuration.longValue()).processDefinitionIdIn(new String[]{processDefinitionId1}).processDefinitionKey("parallelExternalTaskProcess").topic(topicName2, lockDuration.longValue()).processDefinitionId(processDefinitionId2).businessKey(businessKey2).topic(topicName3, lockDuration.longValue()).processDefinitionId(processDefinitionId3).processDefinitionKeyIn(new String[]{"unexisting"}).execute();
        ExternalTaskServiceTest.assertEquals((int)2, (int)topicTasks.size());
        for (LockedExternalTask externalTask : topicTasks) {
            ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(externalTask.getProcessInstanceId()).singleResult();
            if (externalTask.getTopicName().equals(topicName1)) {
                ExternalTaskServiceTest.assertEquals((String)processDefinitionId1, (String)pi.getProcessDefinitionId());
                ExternalTaskServiceTest.assertEquals((String)processDefinitionId1, (String)externalTask.getProcessDefinitionId());
                continue;
            }
            if (externalTask.getTopicName().equals(topicName2)) {
                ExternalTaskServiceTest.assertEquals((String)processDefinitionId2, (String)pi.getProcessDefinitionId());
                ExternalTaskServiceTest.assertEquals((String)processDefinitionId2, (String)externalTask.getProcessDefinitionId());
                continue;
            }
            ExternalTaskServiceTest.fail((String)"No other topic name values should be available!");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityProcess.bpmn20.xml"})
    public void testFetchByProcessDefinitionIds() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        String processDefinitionId1 = processInstance1.getProcessDefinitionId();
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess");
        String processDefinitionId2 = processInstance2.getProcessDefinitionId();
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).processDefinitionId(processDefinitionId2).processDefinitionIdIn(new String[]{processDefinitionId1}).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)externalTasks.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityProcess.bpmn20.xml"})
    public void testFetchByProcessDefinitionKey() {
        String processDefinitionKey1 = "oneExternalTaskProcess";
        this.runtimeService.startProcessInstanceByKey(processDefinitionKey1);
        String processDefinitionKey2 = "twoExternalTaskWithPriorityProcess";
        this.runtimeService.startProcessInstanceByKey(processDefinitionKey2);
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).processDefinitionKey(processDefinitionKey2).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)externalTasks.size());
        ExternalTaskServiceTest.assertEquals((String)processDefinitionKey2, (String)((LockedExternalTask)externalTasks.get(0)).getProcessDefinitionKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityProcess.bpmn20.xml"})
    public void testFetchByProcessDefinitionKeyIn() {
        String processDefinitionKey1 = "oneExternalTaskProcess";
        this.runtimeService.startProcessInstanceByKey(processDefinitionKey1);
        String processDefinitionKey2 = "twoExternalTaskWithPriorityProcess";
        this.runtimeService.startProcessInstanceByKey(processDefinitionKey2);
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).processDefinitionKeyIn(new String[]{processDefinitionKey2}).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)externalTasks.size());
        ExternalTaskServiceTest.assertEquals((String)processDefinitionKey2, (String)((LockedExternalTask)externalTasks.get(0)).getProcessDefinitionKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityProcess.bpmn20.xml"})
    public void testFetchByProcessDefinitionKeys() {
        String processDefinitionKey1 = "oneExternalTaskProcess";
        this.runtimeService.startProcessInstanceByKey(processDefinitionKey1);
        String processDefinitionKey2 = "twoExternalTaskWithPriorityProcess";
        this.runtimeService.startProcessInstanceByKey(processDefinitionKey2);
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).processDefinitionKey(processDefinitionKey1).processDefinitionKeyIn(new String[]{processDefinitionKey2}).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)externalTasks.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/parallelExternalTaskProcess.bpmn20.xml"})
    public void testFetchByProcessDefinitionIdAndKey() {
        String topicName1 = "topic1";
        String topicName2 = "topic2";
        String businessKey1 = "testBusinessKey1";
        String businessKey2 = "testBusinessKey2";
        String businessKey3 = "testBusinessKey3";
        Long lockDuration = 60000L;
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey1);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey2);
        String processDefinitionId2 = processInstance2.getProcessDefinitionId();
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey3);
        String processDefinitionId3 = processInstance3.getProcessDefinitionId();
        List topicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, lockDuration.longValue()).topic(topicName2, lockDuration.longValue()).processDefinitionIdIn(new String[]{processDefinitionId2, processDefinitionId3}).topic("topic3", lockDuration.longValue()).processDefinitionIdIn(new String[]{"unexisting"}).execute();
        ExternalTaskServiceTest.assertEquals((int)3, (int)topicTasks.size());
        for (LockedExternalTask externalTask : topicTasks) {
            ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(externalTask.getProcessInstanceId()).singleResult();
            if (externalTask.getTopicName().equals(topicName1)) {
                ExternalTaskServiceTest.assertEquals((String)pi.getProcessDefinitionId(), (String)externalTask.getProcessDefinitionId());
                continue;
            }
            if (externalTask.getTopicName().equals(topicName2)) {
                ExternalTaskServiceTest.assertEquals((String)processDefinitionId2, (String)pi.getProcessDefinitionId());
                ExternalTaskServiceTest.assertEquals((String)processDefinitionId2, (String)externalTask.getProcessDefinitionId());
                continue;
            }
            ExternalTaskServiceTest.fail((String)"No other topic name values should be available!");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetchWithoutTenant() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).withoutTenantId().execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)externalTasks.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testComplete() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        this.externalTaskService.complete(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID);
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)externalTasks.size());
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("afterExternalTask").done());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testCompleteWithVariables() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        this.externalTaskService.complete(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, (Map)Variables.createVariables().putValue("var", (Object)42));
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("afterExternalTask").done());
        ExternalTaskServiceTest.assertEquals((Object)42, (Object)this.runtimeService.getVariable(processInstance.getId(), "var"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testCompleteWithWrongWorkerId() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        try {
            this.externalTaskService.complete(((LockedExternalTask)externalTasks.get(0)).getId(), "someCrazyWorkerId");
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            this.assertTextPresent("cannot be completed by worker 'someCrazyWorkerId'. It is locked by worker 'aWorkerId'.", e.getMessage());
        }
    }

    public void testCompleteNonExistingTask() {
        try {
            this.externalTaskService.complete("nonExistingTaskId", WORKER_ID);
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (NotFoundException e) {
            this.assertTextPresent("Cannot find external task with id nonExistingTaskId", e.getMessage());
        }
    }

    public void testCompleteNullTaskId() {
        try {
            this.externalTaskService.complete(null, WORKER_ID);
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot find external task with id " + null, e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testCompleteNullWorkerId() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        try {
            this.externalTaskService.complete(task.getId(), null);
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("workerId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testCompleteSuspendedTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        try {
            this.externalTaskService.complete(task.getId(), WORKER_ID);
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("ExternalTask with id '" + task.getId() + "' is suspended", e.getMessage());
        }
        this.assertProcessNotEnded(processInstance.getId());
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        this.externalTaskService.complete(task.getId(), WORKER_ID);
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testLocking() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)externalTasks.size());
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        AssertUtil.assertEqualsSecondPrecision(this.nowPlus(10000L), task.getLockExpirationTime());
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)externalTasks.size());
        ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)externalTasks.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testCompleteLockExpiredTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
        this.externalTaskService.complete(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID);
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)externalTasks.size());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testCompleteReclaimedLockExpiredTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
        List reclaimedTasks = this.externalTaskService.fetchAndLock(1, "anotherWorkerId").topic(TOPIC_NAME, 10000L).execute();
        try {
            this.externalTaskService.complete(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID);
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("cannot be completed by worker 'aWorkerId'. It is locked by worker 'anotherWorkerId'.", e.getMessage());
        }
        this.externalTaskService.complete(((LockedExternalTask)reclaimedTasks.get(0)).getId(), "anotherWorkerId");
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)externalTasks.size());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testDeleteProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        ExternalTaskServiceTest.assertEquals((int)0, (int)this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().size());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testExternalTaskExecutionTreeExpansion() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("boundaryExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask externalTask = (LockedExternalTask)tasks.get(0);
        this.runtimeService.correlateMessage("Message");
        this.externalTaskService.complete(externalTask.getId(), WORKER_ID);
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("afterBoundaryTask").done());
        Task afterBoundaryTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(afterBoundaryTask.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testExternalTaskExecutionTreeCompaction() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("concurrentExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask externalTask = (LockedExternalTask)tasks.get(0);
        Task userTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(userTask.getId());
        this.externalTaskService.complete(externalTask.getId(), WORKER_ID);
        tasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)tasks.size());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testUnlock() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        this.externalTaskService.unlock(task.getId());
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)externalTasks.size());
        LockedExternalTask reAcquiredTask = (LockedExternalTask)externalTasks.get(0);
        ExternalTaskServiceTest.assertEquals((String)task.getId(), (String)reAcquiredTask.getId());
    }

    public void testUnlockNullTaskId() {
        try {
            this.externalTaskService.unlock(null);
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"externalTaskId is null"));
        }
    }

    public void testUnlockNonExistingTask() {
        try {
            this.externalTaskService.unlock("nonExistingId");
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (NotFoundException e) {
            this.assertTextPresent("Cannot find external task with id nonExistingId", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailure() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        ClockUtil.setCurrentTime((Date)this.nowPlus(3000L));
        String errorMessage = "errorMessage";
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, errorMessage, 5, 3000L);
        tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)tasks.size());
        ExternalTaskServiceTest.assertEquals((long)0L, (long)this.runtimeService.createIncidentQuery().count());
        ClockUtil.setCurrentTime((Date)this.nowPlus(4000L));
        tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)tasks.size());
        task = (LockedExternalTask)tasks.get(0);
        ExternalTaskServiceTest.assertEquals((String)errorMessage, (String)task.getErrorMessage());
        ExternalTaskServiceTest.assertEquals((int)5, (int)task.getRetries());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailureWithErrorDetails() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        ClockUtil.setCurrentTime((Date)this.nowPlus(3000L));
        try {
            RuntimeSqlException cause = new RuntimeSqlException("test cause");
            for (int i = 0; i < 10; ++i) {
                cause = new RuntimeSqlException((Throwable)cause);
            }
            throw cause;
        }
        catch (RuntimeException e) {
            String exceptionStackTrace = ExceptionUtils.getStackTrace((Throwable)e);
            String errorMessage = e.getMessage();
            while (errorMessage.length() < 1000) {
                errorMessage = errorMessage + ":" + e.getMessage();
            }
            Assert.assertThat((Object)exceptionStackTrace, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Assert.assertThat((Object)exceptionStackTrace.length(), (Matcher)Is.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(4000))));
            this.externalTaskService.handleFailure(task.getId(), WORKER_ID, errorMessage, exceptionStackTrace, 5, 3000L);
            ClockUtil.setCurrentTime((Date)this.nowPlus(4000L));
            tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
            Assert.assertThat((Object)tasks.size(), (Matcher)Is.is((Object)1));
            task = (LockedExternalTask)tasks.get(0);
            Assert.assertThat((Object)task.getErrorMessage(), (Matcher)Is.is((Object)errorMessage.substring(0, 666)));
            Assert.assertThat((Object)task.getRetries(), (Matcher)Is.is((Object)5));
            Assert.assertThat((Object)this.externalTaskService.getExternalTaskErrorDetails(task.getId()), (Matcher)Is.is((Object)exceptionStackTrace));
            Assert.assertThat((Object)task.getErrorDetails(), (Matcher)Is.is((Object)exceptionStackTrace));
            return;
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailureZeroRetries() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        ClockUtil.setCurrentTime((Date)this.nowPlus(3000L));
        String errorMessage = "errorMessage";
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, errorMessage, 0, 3000L);
        ClockUtil.setCurrentTime((Date)this.nowPlus(4000L));
        tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)tasks.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        ExternalTaskServiceTest.assertNotNull((Object)incident);
        ExternalTaskServiceTest.assertNotNull((Object)incident.getId());
        ExternalTaskServiceTest.assertEquals((String)errorMessage, (String)incident.getIncidentMessage());
        ExternalTaskServiceTest.assertEquals((String)task.getExecutionId(), (String)incident.getExecutionId());
        ExternalTaskServiceTest.assertEquals((String)"externalTask", (String)incident.getActivityId());
        ExternalTaskServiceTest.assertEquals((String)incident.getId(), (String)incident.getCauseIncidentId());
        ExternalTaskServiceTest.assertEquals((String)"failedExternalTask", (String)incident.getIncidentType());
        ExternalTaskServiceTest.assertEquals((String)task.getProcessDefinitionId(), (String)incident.getProcessDefinitionId());
        ExternalTaskServiceTest.assertEquals((String)task.getProcessInstanceId(), (String)incident.getProcessInstanceId());
        ExternalTaskServiceTest.assertEquals((String)incident.getId(), (String)incident.getRootCauseIncidentId());
        AssertUtil.assertEqualsSecondPrecision(this.nowMinus(4000L), incident.getIncidentTimestamp());
        ExternalTaskServiceTest.assertEquals((String)task.getId(), (String)incident.getConfiguration());
        ExternalTaskServiceTest.assertNull((Object)incident.getJobDefinitionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailureAndDeleteProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, "someError", 0, 10000L);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailureThenComplete() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, "someError", 0, 10000L);
        this.externalTaskService.complete(task.getId(), WORKER_ID);
        Task followingTask = (Task)this.taskService.createTaskQuery().singleResult();
        ExternalTaskServiceTest.assertNotNull((Object)followingTask);
        ExternalTaskServiceTest.assertEquals((String)"afterExternalTask", (String)followingTask.getTaskDefinitionKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailureWithWrongWorkerId() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        try {
            this.externalTaskService.handleFailure(((LockedExternalTask)externalTasks.get(0)).getId(), "someCrazyWorkerId", "error", 5, 10000L);
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            this.assertTextPresent("Failure of External Task " + ((LockedExternalTask)externalTasks.get(0)).getId() + " cannot be reported by worker 'someCrazyWorkerId'. It is locked by worker '" + WORKER_ID + "'.", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailureNonExistingTask() {
        try {
            this.externalTaskService.handleFailure("nonExistingTaskId", WORKER_ID, "error", 5, 10000L);
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (NotFoundException e) {
            this.assertTextPresent("Cannot find external task with id nonExistingTaskId", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailureNullTaskId() {
        try {
            this.externalTaskService.handleFailure(null, WORKER_ID, "error", 5, 10000L);
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot find external task with id " + null, e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailureNullWorkerId() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        try {
            this.externalTaskService.handleFailure(((LockedExternalTask)externalTasks.get(0)).getId(), null, "error", 5, 10000L);
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (NullValueException e) {
            this.assertTextPresent("workerId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailureNegativeLockDuration() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        try {
            this.externalTaskService.handleFailure(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, "error", 5, -10000L);
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("retryDuration is not greater than or equal to 0", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailureNegativeRetries() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        try {
            this.externalTaskService.handleFailure(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, "error", -5, 10000L);
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("retries is not greater than or equal to 0", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailureNullErrorMessage() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        this.externalTaskService.handleFailure(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, null, 5, 10000L);
        ExternalTask task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        ExternalTaskServiceTest.assertEquals((int)5, (int)task.getRetries());
        ExternalTaskServiceTest.assertNull((Object)task.getErrorMessage());
        ExternalTaskServiceTest.assertNull((Object)this.externalTaskService.getExternalTaskErrorDetails(task.getId()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleFailureSuspendedTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        try {
            this.externalTaskService.handleFailure(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, "error", 5, 10000L);
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("ExternalTask with id '" + task.getId() + "' is suspended", e.getMessage());
        }
        this.assertProcessNotEnded(processInstance.getId());
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        this.externalTaskService.handleFailure(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, "error", 5, 10000L);
        ExternalTask updatedTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        ExternalTaskServiceTest.assertEquals((int)5, (int)updatedTask.getRetries());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testSetRetries() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        this.externalTaskService.setRetries(((LockedExternalTask)externalTasks.get(0)).getId(), 5);
        ExternalTask task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        ExternalTaskServiceTest.assertEquals((int)5, (int)task.getRetries());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testSetRetriesResolvesFailureIncident() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask lockedTask = (LockedExternalTask)externalTasks.get(0);
        this.externalTaskService.handleFailure(lockedTask.getId(), WORKER_ID, "error", 0, 10000L);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        this.externalTaskService.setRetries(lockedTask.getId(), 5);
        ExternalTaskServiceTest.assertEquals((long)0L, (long)this.runtimeService.createIncidentQuery().count());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_FULL.getId()) {
            HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
            ExternalTaskServiceTest.assertNotNull((Object)historicIncident);
            ExternalTaskServiceTest.assertEquals((String)incident.getId(), (String)historicIncident.getId());
            ExternalTaskServiceTest.assertTrue((boolean)historicIncident.isResolved());
        }
        ClockUtil.setCurrentTime((Date)this.nowPlus(13000L));
        externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)externalTasks.size());
        ExternalTaskServiceTest.assertEquals((String)lockedTask.getId(), (String)((LockedExternalTask)externalTasks.get(0)).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testSetRetriesToZero() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask lockedTask = (LockedExternalTask)externalTasks.get(0);
        this.externalTaskService.setRetries(lockedTask.getId(), 0);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        ExternalTaskServiceTest.assertNotNull((Object)incident);
        ExternalTaskServiceTest.assertEquals((String)lockedTask.getId(), (String)incident.getConfiguration());
        this.externalTaskService.setRetries(lockedTask.getId(), 5);
        ExternalTaskServiceTest.assertEquals((long)0L, (long)this.runtimeService.createIncidentQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testSetRetriesNegative() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        try {
            this.externalTaskService.setRetries(((LockedExternalTask)externalTasks.get(0)).getId(), -5);
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("retries is not greater than or equal to 0", e.getMessage());
        }
    }

    public void testSetRetriesNonExistingTask() {
        try {
            this.externalTaskService.setRetries("someExternalTaskId", 5);
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (NotFoundException e) {
            this.assertTextPresent("externalTask is null", e.getMessage());
        }
    }

    public void testSetRetriesNullTaskId() {
        try {
            this.externalTaskService.setRetries((String)null, 5);
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"externalTaskId is null"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testSetPriority() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        this.externalTaskService.setPriority(((LockedExternalTask)externalTasks.get(0)).getId(), 5L);
        ExternalTask task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        ExternalTaskServiceTest.assertEquals((int)5, (int)((int)task.getPriority()));
    }

    public void testSetPriorityNonExistingTask() {
        try {
            this.externalTaskService.setPriority("someExternalTaskId", 5L);
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (NotFoundException e) {
            this.assertTextPresent("externalTask is null", e.getMessage());
        }
    }

    public void testSetPriorityNullTaskId() {
        try {
            this.externalTaskService.setPriority(null, 5L);
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"externalTaskId is null"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskWithPriorityProcess.bpmn20.xml"})
    public void testAfterSetPriorityFetchHigherTask() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(2, WORKER_ID, true).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)2, (int)externalTasks.size());
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(1);
        ExternalTaskServiceTest.assertEquals((long)0L, (long)task.getPriority());
        this.externalTaskService.setPriority(task.getId(), 9L);
        ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
        externalTasks = this.externalTaskService.fetchAndLock(1, "anotherWorkerId", true).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((long)((LockedExternalTask)externalTasks.get(0)).getPriority(), (long)9L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testSetPriorityLockExpiredTask() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
        this.externalTaskService.setPriority(((LockedExternalTask)externalTasks.get(0)).getId(), 9L);
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID, true).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)externalTasks.size());
        ExternalTaskServiceTest.assertEquals((long)((LockedExternalTask)externalTasks.get(0)).getPriority(), (long)9L);
    }

    @Deployment
    public void testCancelExternalTaskWithBoundaryEvent() {
        this.runtimeService.startProcessInstanceByKey("boundaryExternalTaskProcess");
        ExternalTaskServiceTest.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().count());
        this.runtimeService.correlateMessage("Message");
        ExternalTaskServiceTest.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().count());
        Task afterBoundaryTask = (Task)this.taskService.createTaskQuery().singleResult();
        ExternalTaskServiceTest.assertNotNull((Object)afterBoundaryTask);
        ExternalTaskServiceTest.assertEquals((String)"afterBoundaryTask", (String)afterBoundaryTask.getTaskDefinitionKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testHandleBpmnError() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        List<LockedExternalTask> externalTasks = this.helperHandleBpmnError(1, WORKER_ID, TOPIC_NAME, 10000L, "ERROR-OCCURED");
        ExternalTaskServiceTest.assertEquals((int)0, (int)externalTasks.size());
        ExternalTaskServiceTest.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().count());
        Task afterBpmnError = (Task)this.taskService.createTaskQuery().singleResult();
        ExternalTaskServiceTest.assertNotNull((Object)afterBpmnError);
        ExternalTaskServiceTest.assertEquals((String)afterBpmnError.getTaskDefinitionKey(), (String)"afterBpmnError");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleBpmnErrorWithoutDefinedBoundary() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List<LockedExternalTask> externalTasks = this.helperHandleBpmnError(1, WORKER_ID, TOPIC_NAME, 10000L, "ERROR-OCCURED");
        ExternalTaskServiceTest.assertEquals((int)0, (int)externalTasks.size());
        ExternalTaskServiceTest.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().count());
        Task afterBpmnError = (Task)this.taskService.createTaskQuery().singleResult();
        ExternalTaskServiceTest.assertNull((Object)afterBpmnError);
        this.assertProcessEnded(processInstance.getId());
    }

    public List<LockedExternalTask> helperHandleBpmnError(int taskCount, String workerID, String topicName, long lockTime, String errorCode) {
        List externalTasks = this.externalTaskService.fetchAndLock(taskCount, workerID).topic(topicName, lockTime).execute();
        this.externalTaskService.handleBpmnError(((LockedExternalTask)externalTasks.get(0)).getId(), workerID, errorCode);
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        return externalTasks;
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testHandleBpmnErrorLockExpiredTask() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
        this.externalTaskService.handleBpmnError(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, "ERROR-OCCURED");
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)externalTasks.size());
        ExternalTaskServiceTest.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().count());
        Task afterBpmnError = (Task)this.taskService.createTaskQuery().singleResult();
        ExternalTaskServiceTest.assertNotNull((Object)afterBpmnError);
        ExternalTaskServiceTest.assertEquals((String)afterBpmnError.getTaskDefinitionKey(), (String)"afterBpmnError");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleBpmnErrorReclaimedLockExpiredTaskWithoutDefinedBoundary() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        this.handleBpmnErrorReclaimedLockExpiredTask(false);
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testHandleBpmnErrorReclaimedLockExpiredTaskWithBoundary() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        this.handleBpmnErrorReclaimedLockExpiredTask(false);
    }

    public void handleBpmnErrorReclaimedLockExpiredTask(boolean includeVariables) {
        List reclaimedTasks;
        List externalTasks;
        block2: {
            externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
            ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
            reclaimedTasks = this.externalTaskService.fetchAndLock(1, "anotherWorkerId").topic(TOPIC_NAME, 10000L).execute();
            try {
                this.externalTaskService.handleBpmnError(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, "ERROR-OCCURED");
                ExternalTaskServiceTest.fail((String)"exception expected");
            }
            catch (ProcessEngineException e) {
                this.assertTextPresent("Bpmn error of External Task " + ((LockedExternalTask)externalTasks.get(0)).getId() + " cannot be reported by worker '" + WORKER_ID + "'. It is locked by worker 'anotherWorkerId'.", e.getMessage());
                if (!includeVariables) break block2;
                List list = this.runtimeService.createVariableInstanceQuery().list();
                ExternalTaskServiceTest.assertEquals((int)0, (int)list.size());
            }
        }
        this.externalTaskService.complete(((LockedExternalTask)reclaimedTasks.get(0)).getId(), "anotherWorkerId");
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)externalTasks.size());
    }

    public void testHandleBpmnErrorNonExistingTask() {
        try {
            this.externalTaskService.handleBpmnError("nonExistingTaskId", WORKER_ID, "ERROR-OCCURED");
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (NotFoundException e) {
            this.assertTextPresent("Cannot find external task with id nonExistingTaskId", e.getMessage());
        }
    }

    public void testHandleBpmnNullTaskId() {
        try {
            this.externalTaskService.handleBpmnError(null, WORKER_ID, "ERROR-OCCURED");
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot find external task with id " + null, e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleBpmnNullErrorCode() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        try {
            this.externalTaskService.handleBpmnError(task.getId(), WORKER_ID, null);
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("errorCode is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleBpmnErrorNullWorkerId() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        try {
            this.externalTaskService.handleBpmnError(task.getId(), null, "ERROR-OCCURED");
            ExternalTaskServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("workerId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testHandleBpmnErrorSuspendedTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        try {
            this.externalTaskService.handleBpmnError(task.getId(), WORKER_ID, "ERROR-OCCURED");
            ExternalTaskServiceTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("ExternalTask with id '" + task.getId() + "' is suspended", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testHandleBpmnErrorPassVariablesBoundryEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        variables.put("transientVar", (String)Variables.integerValue((Integer)1, (boolean)true));
        this.externalTaskService.handleBpmnError(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, "ERROR-OCCURED", null, variables);
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)externalTasks.size());
        ExternalTaskServiceTest.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().count());
        Task afterBpmnError = (Task)this.taskService.createTaskQuery().singleResult();
        ExternalTaskServiceTest.assertNotNull((Object)afterBpmnError);
        ExternalTaskServiceTest.assertEquals((String)afterBpmnError.getTaskDefinitionKey(), (String)"afterBpmnError");
        List list = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{pi.getId()}).list();
        ExternalTaskServiceTest.assertEquals((int)1, (int)list.size());
        ExternalTaskServiceTest.assertEquals((String)"foo", (String)((VariableInstance)list.get(0)).getName());
    }

    public void testHandleBpmnErrorPassVariablesEventSubProcess() {
        BpmnModelInstance process = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").serviceTask("externalTask").camundaType("external")).camundaTopic(TOPIC_NAME)).endEvent("endEvent").done();
        BpmnModelInstance subProcess = ((StartEventBuilder)((SubProcessBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(process).addSubProcessTo("process").id("eventSubProcess")).triggerByEvent()).embeddedSubProcess().startEvent("eventSubProcessStart").error("ERROR-SPEC-10")).userTask("afterBpmnError").endEvent().subProcessDone().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(subProcess);
        this.deploymentId = this.deployment(new BpmnModelInstance[]{targetProcess});
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        variables.put("transientVar", (String)Variables.integerValue((Integer)1, (boolean)true));
        this.externalTaskService.handleBpmnError(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, "ERROR-SPEC-10", null, variables);
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)externalTasks.size());
        ExternalTaskServiceTest.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().count());
        Task afterBpmnError = (Task)this.taskService.createTaskQuery().singleResult();
        ExternalTaskServiceTest.assertNotNull((Object)afterBpmnError);
        ExternalTaskServiceTest.assertEquals((String)afterBpmnError.getTaskDefinitionKey(), (String)"afterBpmnError");
        List list = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{pi.getId()}).list();
        ExternalTaskServiceTest.assertEquals((int)1, (int)list.size());
        ExternalTaskServiceTest.assertEquals((String)"foo", (String)((VariableInstance)list.get(0)).getName());
    }

    @Deployment
    public void testHandleBpmnErrorPassMessageEventSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
        String anErrorMessage = "Some meaningful message";
        this.externalTaskService.handleBpmnError(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, "ERROR-SPEC-10", anErrorMessage);
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ExternalTaskServiceTest.assertEquals((int)0, (int)externalTasks.size());
        ExternalTaskServiceTest.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().count());
        Task afterBpmnError = (Task)this.taskService.createTaskQuery().singleResult();
        ExternalTaskServiceTest.assertNotNull((Object)afterBpmnError);
        ExternalTaskServiceTest.assertEquals((String)afterBpmnError.getTaskDefinitionKey(), (String)"afterBpmnError");
        List list = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{pi.getId()}).list();
        ExternalTaskServiceTest.assertEquals((int)1, (int)list.size());
        ExternalTaskServiceTest.assertEquals((String)"errorMessageVariable", (String)((VariableInstance)list.get(0)).getName());
        ExternalTaskServiceTest.assertEquals((Object)anErrorMessage, (Object)((VariableInstance)list.get(0)).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    public void testHandleBpmnErrorReclaimedLockExpiredTaskWithBoundaryAndPassVariables() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        this.handleBpmnErrorReclaimedLockExpiredTask(true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testUpdateRetriesByExternalTaskIds() {
        this.startProcessInstance("oneExternalTaskProcess", 5);
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        List<String> externalTaskIds = Arrays.asList(((ExternalTask)tasks.get(0)).getId(), ((ExternalTask)tasks.get(1)).getId(), ((ExternalTask)tasks.get(2)).getId(), ((ExternalTask)tasks.get(3)).getId(), ((ExternalTask)tasks.get(4)).getId());
        this.externalTaskService.updateRetries().externalTaskIds(externalTaskIds).set(5);
        tasks = this.externalTaskService.createExternalTaskQuery().list();
        ExternalTaskServiceTest.assertEquals((int)5, (int)tasks.size());
        for (ExternalTask task : tasks) {
            ExternalTaskServiceTest.assertEquals((int)5, (int)task.getRetries());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testUpdateRetriesByExternalTaskIdArray() {
        this.startProcessInstance("oneExternalTaskProcess", 5);
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        List<String> externalTaskIds = Arrays.asList(((ExternalTask)tasks.get(0)).getId(), ((ExternalTask)tasks.get(1)).getId(), ((ExternalTask)tasks.get(2)).getId(), ((ExternalTask)tasks.get(3)).getId(), ((ExternalTask)tasks.get(4)).getId());
        this.externalTaskService.updateRetries().externalTaskIds(externalTaskIds.toArray(new String[externalTaskIds.size()])).set(5);
        tasks = this.externalTaskService.createExternalTaskQuery().list();
        ExternalTaskServiceTest.assertEquals((int)5, (int)tasks.size());
        for (ExternalTask task : tasks) {
            ExternalTaskServiceTest.assertEquals((int)5, (int)task.getRetries());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testUpdateRetriesByProcessInstanceIds() {
        List<String> processInstances = this.startProcessInstance("oneExternalTaskProcess", 5);
        this.externalTaskService.updateRetries().processInstanceIds(processInstances).set(5);
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        ExternalTaskServiceTest.assertEquals((int)5, (int)tasks.size());
        for (ExternalTask task : tasks) {
            ExternalTaskServiceTest.assertEquals((int)5, (int)task.getRetries());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testUpdateRetriesByProcessInstanceIdArray() {
        List<String> processInstances = this.startProcessInstance("oneExternalTaskProcess", 5);
        this.externalTaskService.updateRetries().processInstanceIds(processInstances.toArray(new String[processInstances.size()])).set(5);
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        ExternalTaskServiceTest.assertEquals((int)5, (int)tasks.size());
        for (ExternalTask task : tasks) {
            ExternalTaskServiceTest.assertEquals((int)5, (int)task.getRetries());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testUpdateRetriesByExternalTaskQuery() {
        this.startProcessInstance("oneExternalTaskProcess", 5);
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        this.externalTaskService.updateRetries().externalTaskQuery(query).set(5);
        List tasks = query.list();
        ExternalTaskServiceTest.assertEquals((int)5, (int)tasks.size());
        for (ExternalTask task : tasks) {
            ExternalTaskServiceTest.assertEquals((int)5, (int)task.getRetries());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testUpdateRetriesByProcessInstanceQuery() {
        this.startProcessInstance("oneExternalTaskProcess", 5);
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneExternalTaskProcess");
        this.externalTaskService.updateRetries().processInstanceQuery(processInstanceQuery).set(5);
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        ExternalTaskServiceTest.assertEquals((int)5, (int)tasks.size());
        for (ExternalTask task : tasks) {
            ExternalTaskServiceTest.assertEquals((int)5, (int)task.getRetries());
        }
    }

    @RequiredHistoryLevel(value="audit")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testUpdateRetriesByHistoricProcessInstanceQuery() {
        this.startProcessInstance("oneExternalTaskProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("oneExternalTaskProcess");
        this.externalTaskService.updateRetries().historicProcessInstanceQuery(query).set(5);
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        ExternalTaskServiceTest.assertEquals((int)5, (int)tasks.size());
        for (ExternalTask task : tasks) {
            ExternalTaskServiceTest.assertEquals((int)5, (int)task.getRetries());
        }
    }

    @RequiredHistoryLevel(value="audit")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testUpdateRetriesByAllParameters() {
        List<String> ids = this.startProcessInstance("oneExternalTaskProcess", 5);
        ExternalTask externalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(ids.get(0)).singleResult();
        ExternalTaskQuery externalTaskQuery = this.externalTaskService.createExternalTaskQuery().processInstanceId(ids.get(1));
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(ids.get(2));
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery().processInstanceId(ids.get(3));
        this.externalTaskService.updateRetries().externalTaskIds(new String[]{externalTask.getId()}).externalTaskQuery(externalTaskQuery).processInstanceQuery(processInstanceQuery).historicProcessInstanceQuery(historicProcessInstanceQuery).processInstanceIds(new String[]{ids.get(4)}).set(5);
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        ExternalTaskServiceTest.assertEquals((int)5, (int)tasks.size());
        for (ExternalTask task : tasks) {
            ExternalTaskServiceTest.assertEquals((Object)5, (Object)task.getRetries());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testExtendLockTime() {
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        try {
            this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
            ClockUtil.setCurrentTime((Date)this.nowMinus(1000L));
            List lockedTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
            Date extendLockTime = new Date();
            ClockUtil.setCurrentTime((Date)extendLockTime);
            this.externalTaskService.extendLock(((LockedExternalTask)lockedTasks.get(0)).getId(), WORKER_ID, 10000L);
            ExternalTask taskWithExtendedLock = (ExternalTask)this.externalTaskService.createExternalTaskQuery().locked().singleResult();
            ExternalTaskServiceTest.assertNotNull((Object)taskWithExtendedLock);
            AssertUtil.assertEqualsSecondPrecision(new Date(extendLockTime.getTime() + 10000L), taskWithExtendedLock.getLockExpirationTime());
        }
        finally {
            ClockUtil.setCurrentTime((Date)oldCurrentTime);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testExtendLockTimeThatExpired() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List lockedTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 1L).execute();
        ExternalTaskServiceTest.assertNotNull((Object)lockedTasks);
        ExternalTaskServiceTest.assertEquals((int)1, (int)lockedTasks.size());
        ClockUtil.setCurrentTime((Date)this.nowPlus(2L));
        try {
            this.externalTaskService.extendLock(((LockedExternalTask)lockedTasks.get(0)).getId(), WORKER_ID, 100L);
            ExternalTaskServiceTest.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            ExternalTaskServiceTest.assertTrue((boolean)e.getMessage().contains("Cannot extend a lock that expired"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testExtendLockTimeWithoutLock() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ExternalTask externalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        try {
            this.externalTaskService.extendLock(externalTask.getId(), WORKER_ID, 100L);
            ExternalTaskServiceTest.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            ExternalTaskServiceTest.assertTrue((boolean)e.getMessage().contains("The lock of the External Task " + externalTask.getId() + " cannot be extended by worker '" + WORKER_ID));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testExtendLockTimeWithNullLockTime() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List lockedTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 1L).execute();
        ExternalTaskServiceTest.assertNotNull((Object)lockedTasks);
        ExternalTaskServiceTest.assertEquals((int)1, (int)lockedTasks.size());
        try {
            this.externalTaskService.extendLock(((LockedExternalTask)lockedTasks.get(0)).getId(), WORKER_ID, 0L);
            ExternalTaskServiceTest.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            ExternalTaskServiceTest.assertTrue((boolean)e.getMessage().contains("lockTime is not greater than 0"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testExtendLockTimeWithNegativeLockTime() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List lockedTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 1L).execute();
        ExternalTaskServiceTest.assertNotNull((Object)lockedTasks);
        ExternalTaskServiceTest.assertEquals((int)1, (int)lockedTasks.size());
        try {
            this.externalTaskService.extendLock(((LockedExternalTask)lockedTasks.get(0)).getId(), WORKER_ID, -1L);
            ExternalTaskServiceTest.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            ExternalTaskServiceTest.assertTrue((boolean)e.getMessage().contains("lockTime is not greater than 0"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testExtendLockTimeWithNullWorkerId() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List lockedTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 1L).execute();
        ExternalTaskServiceTest.assertNotNull((Object)lockedTasks);
        ExternalTaskServiceTest.assertEquals((int)1, (int)lockedTasks.size());
        try {
            this.externalTaskService.extendLock(((LockedExternalTask)lockedTasks.get(0)).getId(), null, 100L);
            ExternalTaskServiceTest.fail((String)"Exception expected");
        }
        catch (NullValueException e) {
            ExternalTaskServiceTest.assertTrue((boolean)e.getMessage().contains("workerId is null"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testExtendLockTimeWithDifferentWorkerId() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List lockedTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 1L).execute();
        ExternalTaskServiceTest.assertNotNull((Object)lockedTasks);
        ExternalTaskServiceTest.assertEquals((int)1, (int)lockedTasks.size());
        LockedExternalTask task = (LockedExternalTask)lockedTasks.get(0);
        try {
            this.externalTaskService.extendLock(task.getId(), "anAnotherWorkerId", 100L);
            ExternalTaskServiceTest.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            ExternalTaskServiceTest.assertTrue((boolean)e.getMessage().contains("The lock of the External Task " + task.getId() + " cannot be extended by worker 'anAnotherWorkerId'"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testExtendLockTimeWithNullExternalTask() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List lockedTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 1L).execute();
        ExternalTaskServiceTest.assertNotNull((Object)lockedTasks);
        ExternalTaskServiceTest.assertEquals((int)1, (int)lockedTasks.size());
        try {
            this.externalTaskService.extendLock(null, WORKER_ID, 100L);
            ExternalTaskServiceTest.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            ExternalTaskServiceTest.assertTrue((boolean)e.getMessage().contains("Cannot find external task with id null"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testExtendLockTimeForUnexistingExternalTask() {
        try {
            this.externalTaskService.extendLock("unexisting", WORKER_ID, 100L);
            ExternalTaskServiceTest.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            ExternalTaskServiceTest.assertTrue((boolean)e.getMessage().contains("Cannot find external task with id unexisting"));
        }
    }

    public void testCompleteWithLocalVariables() {
        BpmnModelInstance instance = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().serviceTask("externalTask").camundaType("external")).camundaTopic("foo")).camundaTaskPriority("100")).camundaExecutionListenerClass("end", ReadLocalVariableListenerImpl.class)).userTask("user").endEvent().done();
        this.deployment(new BpmnModelInstance[]{instance});
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        List lockedTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic("foo", 1L).execute();
        this.externalTaskService.complete(((LockedExternalTask)lockedTasks.get(0)).getId(), WORKER_ID, null, (Map)Variables.createVariables().putValue("abc", (Object)"bar"));
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).singleResult();
        ExternalTaskServiceTest.assertNull((Object)variableInstance);
        if (this.processEngineConfiguration.getHistoryLevel() == HistoryLevel.HISTORY_LEVEL_AUDIT || this.processEngineConfiguration.getHistoryLevel() == HistoryLevel.HISTORY_LEVEL_FULL) {
            HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().activityInstanceIdIn(new String[]{((LockedExternalTask)lockedTasks.get(0)).getActivityInstanceId()}).singleResult();
            ExternalTaskServiceTest.assertNotNull((Object)historicVariableInstance);
            ExternalTaskServiceTest.assertEquals((String)"abc", (String)historicVariableInstance.getName());
            ExternalTaskServiceTest.assertEquals((Object)"bar", (Object)historicVariableInstance.getValue());
        }
    }

    public void testCompleteWithNonLocalVariables() {
        BpmnModelInstance instance = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().serviceTask("externalTask").camundaType("external")).camundaTopic("foo")).camundaTaskPriority("100")).camundaExecutionListenerClass("end", ReadLocalVariableListenerImpl.class)).userTask("user").endEvent().done();
        this.deployment(new BpmnModelInstance[]{instance});
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        List lockedTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic("foo", 1L).execute();
        this.externalTaskService.complete(((LockedExternalTask)lockedTasks.get(0)).getId(), WORKER_ID, (Map)Variables.createVariables().putValue("abc", (Object)"bar"), null);
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).singleResult();
        ExternalTaskServiceTest.assertNotNull((Object)variableInstance);
        ExternalTaskServiceTest.assertEquals((Object)"bar", (Object)variableInstance.getValue());
        ExternalTaskServiceTest.assertEquals((String)"abc", (String)variableInstance.getName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testFetchWithEmptyListOfVariables() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).variables(new String[0]).execute();
        ExternalTaskServiceTest.assertEquals((int)1, (int)tasks.size());
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        ExternalTaskServiceTest.assertNotNull((Object)task.getId());
        ExternalTaskServiceTest.assertEquals((int)0, (int)task.getVariables().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/parallelExternalTaskProcess.bpmn20.xml"})
    public void testQueryByBusinessKey() {
        String topicName1 = "topic1";
        String topicName2 = "topic2";
        String topicName3 = "topic3";
        String businessKey1 = "testBusinessKey1";
        String businessKey2 = "testBusinessKey2";
        Long lockDuration = 60000L;
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey1);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey2);
        List topicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, lockDuration.longValue()).businessKey(businessKey1).topic(topicName2, lockDuration.longValue()).businessKey(businessKey2).topic(topicName3, lockDuration.longValue()).businessKey("fakeBusinessKey").execute();
        ExternalTaskServiceTest.assertEquals((int)2, (int)topicTasks.size());
        for (LockedExternalTask externalTask : topicTasks) {
            ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(externalTask.getProcessInstanceId()).singleResult();
            if (externalTask.getTopicName().equals(topicName1)) {
                ExternalTaskServiceTest.assertEquals((String)businessKey1, (String)pi.getBusinessKey());
                ExternalTaskServiceTest.assertEquals((String)businessKey1, (String)externalTask.getBusinessKey());
                continue;
            }
            if (externalTask.getTopicName().equals(topicName2)) {
                ExternalTaskServiceTest.assertEquals((String)businessKey2, (String)pi.getBusinessKey());
                ExternalTaskServiceTest.assertEquals((String)businessKey2, (String)externalTask.getBusinessKey());
                continue;
            }
            ExternalTaskServiceTest.fail((String)"No other topic name values should be available!");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/parallelExternalTaskProcess.bpmn20.xml"})
    public void testQueryByBusinessKeyCombination1() {
        String topicName1 = "topic1";
        String topicName2 = "topic2";
        String businessKey1 = "testBusinessKey1";
        String businessKey2 = "testBusinessKey2";
        Long lockDuration = 60000L;
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey1);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey2);
        List topicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, lockDuration.longValue()).businessKey(businessKey1).topic(topicName2, lockDuration.longValue()).execute();
        ExternalTaskServiceTest.assertEquals((int)3, (int)topicTasks.size());
        for (LockedExternalTask externalTask : topicTasks) {
            ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(externalTask.getProcessInstanceId()).singleResult();
            if (externalTask.getTopicName().equals(topicName1)) {
                ExternalTaskServiceTest.assertEquals((String)businessKey1, (String)pi.getBusinessKey());
                ExternalTaskServiceTest.assertEquals((String)businessKey1, (String)externalTask.getBusinessKey());
                continue;
            }
            if (externalTask.getTopicName().equals(topicName2)) {
                ExternalTaskServiceTest.assertEquals((String)pi.getBusinessKey(), (String)externalTask.getBusinessKey());
                continue;
            }
            ExternalTaskServiceTest.fail((String)"No other topic name values should be available!");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/parallelExternalTaskProcess.bpmn20.xml"})
    public void testQueryByBusinessKeyCombination2() {
        String topicName1 = "topic1";
        String topicName2 = "topic2";
        String businessKey1 = "testBusinessKey1";
        String businessKey2 = "testBusinessKey2";
        Long lockDuration = 60000L;
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey1);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey2);
        List topicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, lockDuration.longValue()).topic(topicName2, lockDuration.longValue()).businessKey(businessKey2).execute();
        ExternalTaskServiceTest.assertEquals((int)3, (int)topicTasks.size());
        for (LockedExternalTask externalTask : topicTasks) {
            ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(externalTask.getProcessInstanceId()).singleResult();
            if (externalTask.getTopicName().equals(topicName1)) {
                ExternalTaskServiceTest.assertEquals((String)pi.getBusinessKey(), (String)externalTask.getBusinessKey());
                continue;
            }
            if (externalTask.getTopicName().equals(topicName2)) {
                ExternalTaskServiceTest.assertEquals((String)businessKey2, (String)pi.getBusinessKey());
                ExternalTaskServiceTest.assertEquals((String)businessKey2, (String)externalTask.getBusinessKey());
                continue;
            }
            ExternalTaskServiceTest.fail((String)"No other topic name values should be available!");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/parallelExternalTaskProcess.bpmn20.xml"})
    public void testQueryByBusinessKeyLocking() {
        String topicName1 = "topic1";
        String topicName2 = "topic2";
        String topicName3 = "topic3";
        String businessKey1 = "testBusinessKey1";
        String businessKey2 = "testBusinessKey2";
        Long lockDuration = 60000L;
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey1);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey2);
        List lockedTopicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, lockDuration.longValue()).businessKey(businessKey1).topic(topicName2, lockDuration.longValue()).businessKey(businessKey2).topic(topicName3, lockDuration.longValue()).businessKey("fakeBusinessKey").execute();
        List topicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, lockDuration.longValue()).businessKey(businessKey1).topic(topicName2, 2L * lockDuration).businessKey(businessKey2).topic(topicName3, 2L * lockDuration).businessKey(businessKey1).execute();
        ExternalTaskServiceTest.assertEquals((int)2, (int)lockedTopicTasks.size());
        ExternalTaskServiceTest.assertEquals((int)1, (int)topicTasks.size());
        LockedExternalTask externalTask = (LockedExternalTask)topicTasks.get(0);
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(externalTask.getProcessInstanceId()).singleResult();
        ExternalTaskServiceTest.assertEquals((String)businessKey1, (String)pi.getBusinessKey());
        ExternalTaskServiceTest.assertEquals((String)businessKey1, (String)externalTask.getBusinessKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testVariableValueTopicQuery.bpmn20.xml"})
    public void testTopicQueryByVariableValue() {
        String topicName1 = "testTopic1";
        String topicName2 = "testTopic2";
        String variableName = "testVariable";
        String variableValue1 = "testValue1";
        String variableValue2 = "testValue2";
        HashMap<String, String> variables = new HashMap<String, String>();
        Long lockDuration = 60000L;
        variables.put(variableName, variableValue1);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcessTopicQueryVariableValues", variables);
        variables.put(variableName, variableValue2);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcessTopicQueryVariableValues", variables);
        List topicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, lockDuration.longValue()).processInstanceVariableEquals(variableName, (Object)variableValue1).topic(topicName2, lockDuration.longValue()).processInstanceVariableEquals(variableName, (Object)variableValue2).execute();
        ExternalTaskServiceTest.assertEquals((int)2, (int)topicTasks.size());
        for (LockedExternalTask externalTask : topicTasks) {
            if (externalTask.getTopicName().equals(topicName1)) {
                ExternalTaskServiceTest.assertEquals((Object)variableValue1, (Object)externalTask.getVariables().get((Object)variableName));
                continue;
            }
            if (externalTask.getTopicName().equals(topicName2)) {
                ExternalTaskServiceTest.assertEquals((Object)variableValue2, (Object)externalTask.getVariables().get((Object)variableName));
                continue;
            }
            ExternalTaskServiceTest.fail((String)"No other topic name values should be available!");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testVariableValueTopicQuery.bpmn20.xml"})
    public void testTopicQueryByVariableValueLocking() {
        String topicName1 = "testTopic1";
        String topicName2 = "testTopic2";
        String topicName3 = "testTopic3";
        String variableName = "testVariable";
        String variableValue1 = "testValue1";
        String variableValue2 = "testValue2";
        HashMap<String, String> variables = new HashMap<String, String>();
        Long lockDuration = 60000L;
        variables.put(variableName, variableValue1);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcessTopicQueryVariableValues", variables);
        variables.put(variableName, variableValue2);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcessTopicQueryVariableValues", variables);
        List lockedTopicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, lockDuration.longValue()).processInstanceVariableEquals(variableName, (Object)variableValue1).topic(topicName2, lockDuration.longValue()).processInstanceVariableEquals(variableName, (Object)variableValue2).execute();
        List topicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, 2L * lockDuration).processInstanceVariableEquals(variableName, (Object)variableValue1).topic(topicName2, 2L * lockDuration).processInstanceVariableEquals(variableName, (Object)variableValue2).topic(topicName3, lockDuration.longValue()).processInstanceVariableEquals(variableName, (Object)variableValue2).execute();
        ExternalTaskServiceTest.assertEquals((int)2, (int)lockedTopicTasks.size());
        ExternalTaskServiceTest.assertEquals((int)1, (int)topicTasks.size());
        LockedExternalTask externalTask = (LockedExternalTask)topicTasks.get(0);
        ExternalTaskServiceTest.assertEquals((String)topicName3, (String)externalTask.getTopicName());
        ExternalTaskServiceTest.assertEquals((Object)variableValue2, (Object)externalTask.getVariables().get((Object)variableName));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testVariableValueTopicQuery.bpmn20.xml"})
    public void testTopicQueryByVariableValues() {
        String topicName1 = "testTopic1";
        String topicName2 = "testTopic2";
        String topicName3 = "testTopic3";
        String variableName1 = "testVariable1";
        String variableName2 = "testVariable2";
        String variableName3 = "testVariable3";
        String variableValue1 = "testValue1";
        String variableValue2 = "testValue2";
        String variableValue3 = "testValue3";
        String variableValue4 = "testValue4";
        String variableValue5 = "testValue5";
        String variableValue6 = "testValue6";
        HashMap<String, String> variables = new HashMap<String, String>();
        Long lockDuration = 60000L;
        variables.put(variableName1, variableValue1);
        variables.put(variableName2, variableValue2);
        variables.put(variableName3, variableValue3);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcessTopicQueryVariableValues", variables);
        variables.put(variableName1, variableValue4);
        variables.put(variableName2, variableValue5);
        variables.put(variableName3, variableValue6);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcessTopicQueryVariableValues", variables);
        List topicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, lockDuration.longValue()).processInstanceVariableEquals(variableName1, (Object)variableValue1).processInstanceVariableEquals(variableName2, (Object)variableValue2).topic(topicName2, lockDuration.longValue()).processInstanceVariableEquals(variableName2, (Object)variableValue5).processInstanceVariableEquals(variableName3, (Object)variableValue6).topic(topicName3, lockDuration.longValue()).processInstanceVariableEquals(variableName1, (Object)"fakeVariableValue").execute();
        ExternalTaskServiceTest.assertEquals((int)2, (int)topicTasks.size());
        for (LockedExternalTask externalTask : topicTasks) {
            if (externalTask.getTopicName().equals(topicName1)) {
                ExternalTaskServiceTest.assertEquals((Object)variableValue1, (Object)externalTask.getVariables().get((Object)variableName1));
                ExternalTaskServiceTest.assertEquals((Object)variableValue2, (Object)externalTask.getVariables().get((Object)variableName2));
                continue;
            }
            if (externalTask.getTopicName().equals(topicName2)) {
                ExternalTaskServiceTest.assertEquals((Object)variableValue5, (Object)externalTask.getVariables().get((Object)variableName2));
                ExternalTaskServiceTest.assertEquals((Object)variableValue6, (Object)externalTask.getVariables().get((Object)variableName3));
                continue;
            }
            ExternalTaskServiceTest.fail((String)"No other topic name values should be available!");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testVariableValueTopicQuery.bpmn20.xml"})
    public void testTopicQueryByBusinessKeyAndVariableValue() {
        String topicName1 = "testTopic1";
        String topicName2 = "testTopic2";
        String topicName3 = "testTopic3";
        String businessKey1 = "testBusinessKey1";
        String businessKey2 = "testBusinessKey2";
        String variableName = "testVariable1";
        String variableValue1 = "testValue1";
        String variableValue2 = "testValue2";
        HashMap<String, String> variables = new HashMap<String, String>();
        Long lockDuration = 60000L;
        variables.put(variableName, variableValue1);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcessTopicQueryVariableValues", businessKey1, variables);
        variables.put(variableName, variableValue2);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcessTopicQueryVariableValues", businessKey2, variables);
        List topicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, lockDuration.longValue()).businessKey(businessKey1).processInstanceVariableEquals(variableName, (Object)variableValue1).topic(topicName2, lockDuration.longValue()).businessKey(businessKey2).processInstanceVariableEquals(variableName, (Object)variableValue2).topic(topicName3, lockDuration.longValue()).businessKey("fakeBusinessKey").execute();
        ExternalTaskServiceTest.assertEquals((int)2, (int)topicTasks.size());
        for (LockedExternalTask externalTask : topicTasks) {
            ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(externalTask.getProcessInstanceId()).singleResult();
            if (externalTask.getTopicName().equals(topicName1)) {
                ExternalTaskServiceTest.assertEquals((String)businessKey1, (String)pi.getBusinessKey());
                ExternalTaskServiceTest.assertEquals((Object)variableValue1, (Object)externalTask.getVariables().get((Object)variableName));
                continue;
            }
            if (externalTask.getTopicName().equals(topicName2)) {
                ExternalTaskServiceTest.assertEquals((String)businessKey2, (String)pi.getBusinessKey());
                ExternalTaskServiceTest.assertEquals((Object)variableValue2, (Object)externalTask.getVariables().get((Object)variableName));
                continue;
            }
            ExternalTaskServiceTest.fail((String)"No other topic name values should be available!");
        }
    }

    protected Date nowPlus(long millis) {
        return new Date(ClockUtil.getCurrentTime().getTime() + millis);
    }

    protected Date nowMinus(long millis) {
        return new Date(ClockUtil.getCurrentTime().getTime() - millis);
    }

    protected List<String> startProcessInstance(String key, int instances) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < instances; ++i) {
            ids.add(this.runtimeService.startProcessInstanceByKey(key, String.valueOf(i)).getId());
        }
        return ids;
    }

    public static class ReadLocalVariableListenerImpl
    implements ExecutionListener {
        public void notify(DelegateExecution execution) throws Exception {
            String value = (String)execution.getVariable("abc");
            TestCase.assertEquals((String)"bar", (String)value);
        }
    }
}

