/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.form;

import java.util.Map;
import org.camunda.bpm.engine.impl.form.engine.HtmlDocumentBuilder;
import org.camunda.bpm.engine.impl.form.engine.HtmlElementWriter;
import org.camunda.bpm.engine.impl.form.engine.HtmlFormEngine;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class HtmlFormEngineTest
extends PluggableProcessEngineTestCase {
    public void testIsDefaultFormEngine() {
        Map formEngines = this.processEngineConfiguration.getFormEngines();
        HtmlFormEngineTest.assertTrue((boolean)(formEngines.get(null) instanceof HtmlFormEngine));
    }

    public void testTransformNullFormData() {
        HtmlFormEngine formEngine = new HtmlFormEngine();
        HtmlFormEngineTest.assertNull((Object)formEngine.renderStartForm(null));
        HtmlFormEngineTest.assertNull((Object)formEngine.renderTaskForm(null));
    }

    public void testHtmlElementWriter() {
        String htmlString = new HtmlDocumentBuilder(new HtmlElementWriter("someTagName")).endElement().getHtmlString();
        this.assertHtmlEquals("<someTagName></someTagName>", htmlString);
        htmlString = new HtmlDocumentBuilder(new HtmlElementWriter("someTagName", true)).endElement().getHtmlString();
        this.assertHtmlEquals("<someTagName />", htmlString);
        htmlString = new HtmlDocumentBuilder(new HtmlElementWriter("someTagName", true).attribute("someAttr", "someAttrValue")).endElement().getHtmlString();
        this.assertHtmlEquals("<someTagName someAttr=\"someAttrValue\" />", htmlString);
        htmlString = new HtmlDocumentBuilder(new HtmlElementWriter("someTagName").attribute("someAttr", "someAttrValue")).endElement().getHtmlString();
        this.assertHtmlEquals("<someTagName someAttr=\"someAttrValue\"></someTagName>", htmlString);
        htmlString = new HtmlDocumentBuilder(new HtmlElementWriter("someTagName").attribute("someAttr", null)).endElement().getHtmlString();
        this.assertHtmlEquals("<someTagName someAttr></someTagName>", htmlString);
        htmlString = new HtmlDocumentBuilder(new HtmlElementWriter("someTagName").textContent("someTextContent")).endElement().getHtmlString();
        this.assertHtmlEquals("<someTagName>someTextContent</someTagName>", htmlString);
        htmlString = new HtmlDocumentBuilder(new HtmlElementWriter("someTagName")).startElement(new HtmlElementWriter("someChildTag")).endElement().endElement().getHtmlString();
        this.assertHtmlEquals("<someTagName><someChildTag></someChildTag></someTagName>", htmlString);
        htmlString = new HtmlDocumentBuilder(new HtmlElementWriter("someTagName")).startElement(new HtmlElementWriter("someChildTag").textContent("someTextContent")).endElement().endElement().getHtmlString();
        this.assertHtmlEquals("<someTagName><someChildTag>someTextContent</someChildTag></someTagName>", htmlString);
        htmlString = new HtmlDocumentBuilder(new HtmlElementWriter("someTagName").textContent("someTextContent")).startElement(new HtmlElementWriter("someChildTag")).endElement().endElement().getHtmlString();
        this.assertHtmlEquals("<someTagName><someChildTag></someChildTag>someTextContent</someTagName>", htmlString);
        try {
            new HtmlElementWriter("sometagname", true).textContent("sometextcontet");
        }
        catch (IllegalStateException e) {
            HtmlFormEngineTest.assertTrue((boolean)e.getMessage().contains("Self-closing element cannot have text content"));
        }
    }

    @Deployment
    public void testRenderEmptyStartForm() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HtmlFormEngineTest.assertNull((Object)this.formService.getRenderedStartForm(processDefinition.getId()));
    }

    @Deployment
    public void testRenderStartForm() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        String renderedForm = (String)this.formService.getRenderedStartForm(processDefinition.getId());
        String expectedForm = IoUtil.readFileAsString((String)"org/camunda/bpm/engine/test/api/form/HtmlFormEngineTest.testRenderStartForm.html");
        this.assertHtmlEquals(expectedForm, renderedForm);
    }

    @Deployment
    public void testRenderEnumField() {
        this.runtimeService.startProcessInstanceByKey("HtmlFormEngineTest.testRenderEnumField");
        Task t = (Task)this.taskService.createTaskQuery().singleResult();
        String renderedForm = (String)this.formService.getRenderedTaskForm(t.getId());
        String expectedForm = IoUtil.readFileAsString((String)"org/camunda/bpm/engine/test/api/form/HtmlFormEngineTest.testRenderEnumField.html");
        this.assertHtmlEquals(expectedForm, renderedForm);
    }

    @Deployment
    public void testRenderTaskForm() {
        this.runtimeService.startProcessInstanceByKey("HtmlFormEngineTest.testRenderTaskForm");
        Task t = (Task)this.taskService.createTaskQuery().singleResult();
        String renderedForm = (String)this.formService.getRenderedTaskForm(t.getId());
        String expectedForm = IoUtil.readFileAsString((String)"org/camunda/bpm/engine/test/api/form/HtmlFormEngineTest.testRenderTaskForm.html");
        this.assertHtmlEquals(expectedForm, renderedForm);
    }

    @Deployment
    public void testRenderDateField() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        String renderedForm = (String)this.formService.getRenderedStartForm(processDefinition.getId());
        String expectedForm = IoUtil.readFileAsString((String)"org/camunda/bpm/engine/test/api/form/HtmlFormEngineTest.testRenderDateField.html");
        this.assertHtmlEquals(expectedForm, renderedForm);
    }

    @Deployment
    public void testRenderDateFieldWithPattern() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        String renderedForm = (String)this.formService.getRenderedStartForm(processDefinition.getId());
        String expectedForm = IoUtil.readFileAsString((String)"org/camunda/bpm/engine/test/api/form/HtmlFormEngineTest.testRenderDateFieldWithPattern.html");
        this.assertHtmlEquals(expectedForm, renderedForm);
    }

    @Deployment
    public void testLegacyFormPropertySupport() {
        this.runtimeService.startProcessInstanceByKey("HtmlFormEngineTest.testLegacyFormPropertySupport");
        Task t = (Task)this.taskService.createTaskQuery().singleResult();
        String renderedForm = (String)this.formService.getRenderedTaskForm(t.getId());
        String expectedForm = IoUtil.readFileAsString((String)"org/camunda/bpm/engine/test/api/form/HtmlFormEngineTest.testLegacyFormPropertySupport.html");
        this.assertHtmlEquals(expectedForm, renderedForm);
    }

    @Deployment
    public void testLegacyFormPropertySupportReadOnly() {
        this.runtimeService.startProcessInstanceByKey("HtmlFormEngineTest.testLegacyFormPropertySupportReadOnly");
        Task t = (Task)this.taskService.createTaskQuery().singleResult();
        String renderedForm = (String)this.formService.getRenderedTaskForm(t.getId());
        String expectedForm = IoUtil.readFileAsString((String)"org/camunda/bpm/engine/test/api/form/HtmlFormEngineTest.testLegacyFormPropertySupportReadOnly.html");
        this.assertHtmlEquals(expectedForm, renderedForm);
    }

    @Deployment
    public void testLegacyFormPropertySupportRequired() {
        this.runtimeService.startProcessInstanceByKey("HtmlFormEngineTest.testLegacyFormPropertySupportRequired");
        Task t = (Task)this.taskService.createTaskQuery().singleResult();
        String renderedForm = (String)this.formService.getRenderedTaskForm(t.getId());
        String expectedForm = IoUtil.readFileAsString((String)"org/camunda/bpm/engine/test/api/form/HtmlFormEngineTest.testLegacyFormPropertySupportRequired.html");
        this.assertHtmlEquals(expectedForm, renderedForm);
    }

    @Deployment
    public void testBusinessKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        String renderedForm = (String)this.formService.getRenderedStartForm(processDefinition.getId());
        String expectedForm = IoUtil.readFileAsString((String)"org/camunda/bpm/engine/test/api/form/HtmlFormEngineTest.testBusinessKey.html");
        this.assertHtmlEquals(expectedForm, renderedForm);
    }

    public void assertHtmlEquals(String expected, String actual) {
        HtmlFormEngineTest.assertEquals((String)this.filterWhitespace(expected), (String)this.filterWhitespace(actual));
    }

    protected String filterWhitespace(String tofilter) {
        return tofilter.replaceAll("\\n", "").replaceAll("\\s", "");
    }
}

