/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class BatchHistoricDecisionInstanceDeletionUserOperationTest {
    protected static String DECISION = "decision";
    public static final String USER_ID = "userId";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected DecisionService decisionService;
    protected HistoryService historyService;
    protected ManagementService managementService;
    protected IdentityService identityService;
    protected List<String> decisionInstanceIds;

    @Before
    public void setup() {
        this.historyService = this.engineRule.getHistoryService();
        this.decisionService = this.engineRule.getDecisionService();
        this.managementService = this.engineRule.getManagementService();
        this.identityService = this.engineRule.getIdentityService();
        this.decisionInstanceIds = new ArrayList<String>();
    }

    @Before
    public void evaluateDecisionInstances() {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/dmn/Example.dmn");
        VariableMap variables = Variables.createVariables().putValue("status", (Object)"silver").putValue("sum", (Object)723);
        for (int i = 0; i < 10; ++i) {
            this.decisionService.evaluateDecisionByKey(DECISION).variables((Map)variables).evaluate();
        }
        List decisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        for (HistoricDecisionInstance decisionInstance : decisionInstances) {
            this.decisionInstanceIds.add(decisionInstance.getId());
        }
    }

    @After
    public void removeBatches() {
        for (Batch batch : this.managementService.createBatchQuery().list()) {
            this.managementService.deleteBatch(batch.getId(), true);
        }
        for (HistoricBatch historicBatch : this.historyService.createHistoricBatchQuery().list()) {
            this.historyService.deleteHistoricBatch(historicBatch.getId());
        }
    }

    @After
    public void clearAuthentication() {
        this.identityService.clearAuthentication();
    }

    @Test
    public void testCreationByIds() {
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.historyService.deleteHistoricDecisionInstancesAsync(this.decisionInstanceIds, "a-delete-reason");
        this.identityService.clearAuthentication();
        List opLogEntries = this.engineRule.getHistoryService().createUserOperationLogQuery().list();
        Assert.assertEquals((long)4L, (long)opLogEntries.size());
        Map<String, UserOperationLogEntry> entries = this.asMap(opLogEntries);
        UserOperationLogEntry typeEntry = entries.get("type");
        Assert.assertNotNull((Object)typeEntry);
        Assert.assertEquals((Object)"DecisionInstance", (Object)typeEntry.getEntityType());
        Assert.assertEquals((Object)"Delete", (Object)typeEntry.getOperationType());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionId());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)typeEntry.getProcessInstanceId());
        Assert.assertNull((Object)typeEntry.getOrgValue());
        Assert.assertEquals((Object)"history", (Object)typeEntry.getNewValue());
        UserOperationLogEntry asyncEntry = entries.get("async");
        Assert.assertNotNull((Object)asyncEntry);
        Assert.assertEquals((Object)"DecisionInstance", (Object)typeEntry.getEntityType());
        Assert.assertEquals((Object)"Delete", (Object)typeEntry.getOperationType());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionId());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)typeEntry.getProcessInstanceId());
        Assert.assertNull((Object)typeEntry.getOrgValue());
        Assert.assertEquals((Object)"true", (Object)asyncEntry.getNewValue());
        UserOperationLogEntry numInstancesEntry = entries.get("nrOfInstances");
        Assert.assertNotNull((Object)numInstancesEntry);
        Assert.assertEquals((Object)"DecisionInstance", (Object)typeEntry.getEntityType());
        Assert.assertEquals((Object)"Delete", (Object)typeEntry.getOperationType());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionId());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)typeEntry.getProcessInstanceId());
        Assert.assertNull((Object)typeEntry.getOrgValue());
        Assert.assertEquals((Object)"10", (Object)numInstancesEntry.getNewValue());
        UserOperationLogEntry deleteReasonEntry = entries.get("deleteReason");
        Assert.assertNotNull((Object)deleteReasonEntry);
        Assert.assertEquals((Object)"DecisionInstance", (Object)typeEntry.getEntityType());
        Assert.assertEquals((Object)"Delete", (Object)typeEntry.getOperationType());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionId());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)typeEntry.getProcessInstanceId());
        Assert.assertNull((Object)typeEntry.getOrgValue());
        Assert.assertEquals((Object)"a-delete-reason", (Object)deleteReasonEntry.getNewValue());
        Assert.assertEquals((Object)typeEntry.getOperationId(), (Object)asyncEntry.getOperationId());
        Assert.assertEquals((Object)asyncEntry.getOperationId(), (Object)deleteReasonEntry.getOperationId());
        Assert.assertEquals((Object)numInstancesEntry.getOperationId(), (Object)deleteReasonEntry.getOperationId());
    }

    @Test
    public void testCreationByQuery() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION);
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.historyService.deleteHistoricDecisionInstancesAsync(query, "a-delete-reason");
        this.identityService.clearAuthentication();
        List opLogEntries = this.engineRule.getHistoryService().createUserOperationLogQuery().list();
        Assert.assertEquals((long)4L, (long)opLogEntries.size());
        Map<String, UserOperationLogEntry> entries = this.asMap(opLogEntries);
        UserOperationLogEntry typeEntry = entries.get("type");
        Assert.assertNotNull((Object)typeEntry);
        Assert.assertEquals((Object)"DecisionInstance", (Object)typeEntry.getEntityType());
        Assert.assertEquals((Object)"Delete", (Object)typeEntry.getOperationType());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionId());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)typeEntry.getProcessInstanceId());
        Assert.assertNull((Object)typeEntry.getOrgValue());
        Assert.assertEquals((Object)"history", (Object)typeEntry.getNewValue());
        UserOperationLogEntry asyncEntry = entries.get("async");
        Assert.assertNotNull((Object)asyncEntry);
        Assert.assertEquals((Object)"DecisionInstance", (Object)typeEntry.getEntityType());
        Assert.assertEquals((Object)"Delete", (Object)typeEntry.getOperationType());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionId());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)typeEntry.getProcessInstanceId());
        Assert.assertNull((Object)typeEntry.getOrgValue());
        Assert.assertEquals((Object)"true", (Object)asyncEntry.getNewValue());
        UserOperationLogEntry numInstancesEntry = entries.get("nrOfInstances");
        Assert.assertNotNull((Object)numInstancesEntry);
        Assert.assertEquals((Object)"DecisionInstance", (Object)typeEntry.getEntityType());
        Assert.assertEquals((Object)"Delete", (Object)typeEntry.getOperationType());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionId());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)typeEntry.getProcessInstanceId());
        Assert.assertNull((Object)typeEntry.getOrgValue());
        Assert.assertEquals((Object)"10", (Object)numInstancesEntry.getNewValue());
        UserOperationLogEntry deleteReasonEntry = entries.get("deleteReason");
        Assert.assertNotNull((Object)deleteReasonEntry);
        Assert.assertEquals((Object)"DecisionInstance", (Object)typeEntry.getEntityType());
        Assert.assertEquals((Object)"Delete", (Object)typeEntry.getOperationType());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionId());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)typeEntry.getProcessInstanceId());
        Assert.assertNull((Object)typeEntry.getOrgValue());
        Assert.assertEquals((Object)"a-delete-reason", (Object)deleteReasonEntry.getNewValue());
        Assert.assertEquals((Object)typeEntry.getOperationId(), (Object)asyncEntry.getOperationId());
        Assert.assertEquals((Object)asyncEntry.getOperationId(), (Object)numInstancesEntry.getOperationId());
        Assert.assertEquals((Object)numInstancesEntry.getOperationId(), (Object)deleteReasonEntry.getOperationId());
    }

    @Test
    public void testCreationByIdsAndQuery() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION);
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.historyService.deleteHistoricDecisionInstancesAsync(this.decisionInstanceIds, query, "a-delete-reason");
        this.identityService.clearAuthentication();
        List opLogEntries = this.engineRule.getHistoryService().createUserOperationLogQuery().list();
        Assert.assertEquals((long)4L, (long)opLogEntries.size());
        Map<String, UserOperationLogEntry> entries = this.asMap(opLogEntries);
        UserOperationLogEntry typeEntry = entries.get("type");
        Assert.assertNotNull((Object)typeEntry);
        Assert.assertEquals((Object)"DecisionInstance", (Object)typeEntry.getEntityType());
        Assert.assertEquals((Object)"Delete", (Object)typeEntry.getOperationType());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionId());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)typeEntry.getProcessInstanceId());
        Assert.assertNull((Object)typeEntry.getOrgValue());
        Assert.assertEquals((Object)"history", (Object)typeEntry.getNewValue());
        UserOperationLogEntry asyncEntry = entries.get("async");
        Assert.assertNotNull((Object)asyncEntry);
        Assert.assertEquals((Object)"DecisionInstance", (Object)typeEntry.getEntityType());
        Assert.assertEquals((Object)"Delete", (Object)typeEntry.getOperationType());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionId());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)typeEntry.getProcessInstanceId());
        Assert.assertNull((Object)typeEntry.getOrgValue());
        Assert.assertEquals((Object)"true", (Object)asyncEntry.getNewValue());
        UserOperationLogEntry numInstancesEntry = entries.get("nrOfInstances");
        Assert.assertNotNull((Object)numInstancesEntry);
        Assert.assertEquals((Object)"DecisionInstance", (Object)typeEntry.getEntityType());
        Assert.assertEquals((Object)"Delete", (Object)typeEntry.getOperationType());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionId());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)typeEntry.getProcessInstanceId());
        Assert.assertNull((Object)typeEntry.getOrgValue());
        Assert.assertEquals((Object)"10", (Object)numInstancesEntry.getNewValue());
        UserOperationLogEntry deleteReasonEntry = entries.get("deleteReason");
        Assert.assertNotNull((Object)deleteReasonEntry);
        Assert.assertEquals((Object)"DecisionInstance", (Object)typeEntry.getEntityType());
        Assert.assertEquals((Object)"Delete", (Object)typeEntry.getOperationType());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionId());
        Assert.assertNull((Object)typeEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)typeEntry.getProcessInstanceId());
        Assert.assertNull((Object)typeEntry.getOrgValue());
        Assert.assertEquals((Object)"a-delete-reason", (Object)deleteReasonEntry.getNewValue());
        Assert.assertEquals((Object)typeEntry.getOperationId(), (Object)asyncEntry.getOperationId());
        Assert.assertEquals((Object)asyncEntry.getOperationId(), (Object)numInstancesEntry.getOperationId());
        Assert.assertEquals((Object)numInstancesEntry.getOperationId(), (Object)deleteReasonEntry.getOperationId());
    }

    @Test
    public void testNoCreationOnSyncBatchJobExecution() {
        Batch batch = this.historyService.deleteHistoricDecisionInstancesAsync(this.decisionInstanceIds, null);
        this.engineRule.getIdentityService().setAuthenticatedUserId(USER_ID);
        this.executeJobs(batch);
        this.engineRule.getIdentityService().clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.engineRule.getHistoryService().createUserOperationLogQuery().count());
    }

    @Test
    public void testNoCreationOnSyncBatchJobExecutionByIds() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION);
        Batch batch = this.historyService.deleteHistoricDecisionInstancesAsync(query, null);
        this.engineRule.getIdentityService().setAuthenticatedUserId(USER_ID);
        this.executeJobs(batch);
        this.engineRule.getIdentityService().clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.engineRule.getHistoryService().createUserOperationLogQuery().count());
    }

    @Test
    public void testNoCreationOnSyncBatchJobExecutionByIdsAndQuery() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION);
        Batch batch = this.historyService.deleteHistoricDecisionInstancesAsync(this.decisionInstanceIds, query, null);
        this.engineRule.getIdentityService().setAuthenticatedUserId(USER_ID);
        this.executeJobs(batch);
        this.engineRule.getIdentityService().clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.engineRule.getHistoryService().createUserOperationLogQuery().count());
    }

    @Test
    public void testNoCreationOnJobExecutorBatchJobExecutionByIds() {
        this.historyService.deleteHistoricDecisionInstancesAsync(this.decisionInstanceIds, null);
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        Assert.assertEquals((long)0L, (long)this.engineRule.getHistoryService().createUserOperationLogQuery().count());
    }

    @Test
    public void testNoCreationOnJobExecutorBatchJobExecutionByQuery() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION);
        this.historyService.deleteHistoricDecisionInstancesAsync(query, null);
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        Assert.assertEquals((long)0L, (long)this.engineRule.getHistoryService().createUserOperationLogQuery().count());
    }

    @Test
    public void testNoCreationOnJobExecutorBatchJobExecutionByIdsAndQuery() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION);
        this.historyService.deleteHistoricDecisionInstancesAsync(this.decisionInstanceIds, query, null);
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        Assert.assertEquals((long)0L, (long)this.engineRule.getHistoryService().createUserOperationLogQuery().count());
    }

    protected Map<String, UserOperationLogEntry> asMap(List<UserOperationLogEntry> logEntries) {
        HashMap<String, UserOperationLogEntry> map = new HashMap<String, UserOperationLogEntry>();
        for (UserOperationLogEntry entry : logEntries) {
            UserOperationLogEntry previousValue = map.put(entry.getProperty(), entry);
            if (previousValue == null) continue;
            Assert.fail((String)"expected only entry for every property");
        }
        return map;
    }

    protected void executeJobs(Batch batch) {
        Job job = (Job)this.managementService.createJobQuery().jobDefinitionId(batch.getSeedJobDefinitionId()).singleResult();
        this.managementService.executeJob(job.getId());
        for (Job pending : this.managementService.createJobQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).list()) {
            this.managementService.executeJob(pending.getId());
        }
    }
}

