/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history.removaltime.cleanup;

import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.api.history.removaltime.cleanup.AbstractHistoryCleanupSchedulerTest;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class HistoryCleanupSchedulerVariableInstancesTest
extends AbstractHistoryCleanupSchedulerTest {
    public ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            return HistoryCleanupSchedulerVariableInstancesTest.this.configure(configuration, HistoryEventTypes.VARIABLE_INSTANCE_CREATE);
        }
    };
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected final String PROCESS_KEY = "process";
    protected final BpmnModelInstance PROCESS = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().userTask().endEvent().done();
    protected final Date END_DATE = new Date(1363608000000L);

    @Before
    public void init() {
        engineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.initEngineConfiguration(engineConfiguration);
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
    }

    @Test
    public void shouldScheduleToNow() {
        this.testRule.deploy(this.PROCESS);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        for (int i = 0; i < 5; ++i) {
            this.runtimeService.setVariable(processInstanceId, "aVariableName" + i, (Object)"aVariableValue");
        }
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        engineConfiguration.setHistoryCleanupBatchSize(5);
        engineConfiguration.initHistoryCleanup();
        Date removalTime = DateUtils.addDays((Date)this.END_DATE, (int)5);
        ClockUtil.setCurrentTime((Date)removalTime);
        this.runHistoryCleanup();
        Job job = (Job)this.historyService.findHistoryCleanupJobs().get(0);
        Assert.assertThat((Object)job.getDuedate(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldScheduleToLater() {
        this.testRule.deploy(this.PROCESS);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        for (int i = 0; i < 5; ++i) {
            this.runtimeService.setVariable(processInstanceId, "aVariableName" + i, (Object)"aVariableValue");
        }
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        engineConfiguration.setHistoryCleanupBatchSize(6);
        engineConfiguration.initHistoryCleanup();
        Date removalTime = DateUtils.addDays((Date)this.END_DATE, (int)5);
        ClockUtil.setCurrentTime((Date)removalTime);
        this.runHistoryCleanup();
        Job job = (Job)this.historyService.findHistoryCleanupJobs().get(0);
        Assert.assertThat((Object)job.getDuedate(), (Matcher)Is.is((Object)DateUtils.addSeconds((Date)removalTime, (int)10)));
    }
}

