/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.authorization.MissingAuthorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.ProcessInstancePermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestUtil;

public class AuthorizationServiceAuthorizationsTest
extends PluggableProcessEngineTestCase {
    private static final String jonny2 = "jonny2";

    protected void tearDown() throws Exception {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.cleanupAfterTest();
        super.tearDown();
    }

    public void testCreateAuthorization() {
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.AUTHORIZATION);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.CREATE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.authorizationService.createNewAuthorization(0);
            AuthorizationServiceAuthorizationsTest.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            AuthorizationServiceAuthorizationsTest.assertEquals((int)1, (int)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            AuthorizationServiceAuthorizationsTest.assertEquals((String)jonny2, (String)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.CREATE.getName(), Resources.AUTHORIZATION.resourceName(), null, info);
        }
        AuthorizationEntity authorization = new AuthorizationEntity(2);
        authorization.setUserId("someUserId");
        authorization.setResource((Resource)Resources.APPLICATION);
        try {
            this.authorizationService.saveAuthorization((Authorization)authorization);
            AuthorizationServiceAuthorizationsTest.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            AuthorizationServiceAuthorizationsTest.assertEquals((int)1, (int)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            AuthorizationServiceAuthorizationsTest.assertEquals((String)jonny2, (String)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.CREATE.getName(), Resources.AUTHORIZATION.resourceName(), null, info);
        }
    }

    public void testDeleteAuthorization() {
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.AUTHORIZATION);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.DELETE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.authorizationService.deleteAuthorization(basePerms.getId());
            AuthorizationServiceAuthorizationsTest.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            AuthorizationServiceAuthorizationsTest.assertEquals((int)1, (int)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            AuthorizationServiceAuthorizationsTest.assertEquals((String)jonny2, (String)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.DELETE.getName(), Resources.AUTHORIZATION.resourceName(), basePerms.getId(), info);
        }
    }

    public void testUserUpdateAuthorizations() {
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.AUTHORIZATION);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.UPDATE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        basePerms = (Authorization)this.authorizationService.createAuthorizationQuery().singleResult();
        basePerms.addPermission((Permission)Permissions.ALL);
        try {
            this.authorizationService.saveAuthorization(basePerms);
            AuthorizationServiceAuthorizationsTest.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            AuthorizationServiceAuthorizationsTest.assertEquals((int)1, (int)e.getMissingAuthorizations().size());
            MissingAuthorization info = (MissingAuthorization)e.getMissingAuthorizations().get(0);
            AuthorizationServiceAuthorizationsTest.assertEquals((String)jonny2, (String)e.getUserId());
            AuthorizationTestUtil.assertExceptionInfo(Permissions.UPDATE.getName(), Resources.AUTHORIZATION.resourceName(), basePerms.getId(), info);
        }
        Authorization newAuth = this.authorizationService.createNewAuthorization(1);
        newAuth.setUserId(jonny2);
        newAuth.setResource((Resource)Resources.AUTHORIZATION);
        newAuth.setResourceId("*");
        newAuth.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(newAuth);
    }

    public void testAuthorizationQueryAuthorizations() {
        String authUserId = jonny2;
        this.identityService.setAuthenticatedUserId(authUserId);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.AUTHORIZATION);
        basePerms.setResourceId("*");
        this.authorizationService.saveAuthorization(basePerms);
        AuthorizationServiceAuthorizationsTest.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().count());
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        AuthorizationServiceAuthorizationsTest.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().count());
    }

    public void testSaveAuthorizationAddPermissionWithInvalidResource() throws Exception {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("userId");
        authorization.addPermission((Permission)BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES);
        authorization.setResource((Resource)Resources.APPLICATION);
        authorization.setResourceId("*");
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        try {
            this.authorizationService.saveAuthorization(authorization);
            AuthorizationServiceAuthorizationsTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            AuthorizationServiceAuthorizationsTest.assertTrue((boolean)e.getMessage().contains("The resource type with id:'0' is not valid for 'CREATE_BATCH_MIGRATE_PROCESS_INSTANCES' permission."));
        }
        authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("userId");
        authorization.addPermission((Permission)Permissions.ACCESS);
        authorization.setResource((Resource)Resources.BATCH);
        try {
            this.authorizationService.saveAuthorization(authorization);
            AuthorizationServiceAuthorizationsTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            AuthorizationServiceAuthorizationsTest.assertTrue((boolean)e.getMessage().contains("The resource type with id:'13' is not valid for 'ACCESS' permission."));
        }
    }

    public void testSaveAuthorizationMultipleResourcesIncludingInvalidResource() throws Exception {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("userId");
        authorization.addPermission((Permission)Permissions.READ_HISTORY);
        authorization.addPermission((Permission)BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES);
        authorization.setResource((Resource)Resources.PROCESS_DEFINITION);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        try {
            this.authorizationService.saveAuthorization(authorization);
            AuthorizationServiceAuthorizationsTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            AuthorizationServiceAuthorizationsTest.assertTrue((boolean)e.getMessage().contains("The resource type with id:'6' is not valid for 'CREATE_BATCH_MIGRATE_PROCESS_INSTANCES' permission."));
        }
    }

    public void testSaveAuthorizationRemovePermissionWithInvalidResource() throws Exception {
        Authorization authorization = this.authorizationService.createNewAuthorization(2);
        authorization.setUserId("userId");
        authorization.removePermission((Permission)BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES);
        authorization.setResource((Resource)Resources.PROCESS_DEFINITION);
        authorization.setResourceId("*");
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        try {
            this.authorizationService.saveAuthorization(authorization);
            AuthorizationServiceAuthorizationsTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            AuthorizationServiceAuthorizationsTest.assertTrue((boolean)e.getMessage().contains("The resource type with id:'6' is not valid for 'CREATE_BATCH_MIGRATE_PROCESS_INSTANCES' permission."));
        }
        authorization = this.authorizationService.createNewAuthorization(2);
        authorization.setUserId("userId");
        authorization.addPermission((Permission)Permissions.ACCESS);
        authorization.setResource((Resource)Resources.PROCESS_DEFINITION);
        try {
            this.authorizationService.saveAuthorization(authorization);
            AuthorizationServiceAuthorizationsTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            AuthorizationServiceAuthorizationsTest.assertTrue((boolean)e.getMessage().contains("The resource type with id:'6' is not valid for 'ACCESS' permission."));
        }
    }

    public void testSaveAuthorizationSetPermissionsWithInvalidResource() throws Exception {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("userId");
        authorization.setPermissions((Permission[])new BatchPermissions[]{BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES});
        authorization.setResource((Resource)Resources.PROCESS_INSTANCE);
        authorization.setResourceId("*");
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        try {
            this.authorizationService.saveAuthorization(authorization);
            AuthorizationServiceAuthorizationsTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            AuthorizationServiceAuthorizationsTest.assertTrue((boolean)e.getMessage().contains("The resource type with id:'8' is not valid for 'CREATE_BATCH_MIGRATE_PROCESS_INSTANCES' permission."));
        }
        authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("userId");
        authorization.setPermissions((Permission[])new Permissions[]{Permissions.CREATE, Permissions.ACCESS});
        authorization.setResource((Resource)Resources.PROCESS_INSTANCE);
        try {
            this.authorizationService.saveAuthorization(authorization);
            AuthorizationServiceAuthorizationsTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            AuthorizationServiceAuthorizationsTest.assertTrue((boolean)e.getMessage().contains("The resource type with id:'8' is not valid for 'ACCESS' permission."));
        }
    }

    public void testSaveAuthorizationSetPermissionsWithValidResource() throws Exception {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("userId");
        authorization.addPermission((Permission)Permissions.ACCESS);
        authorization.setPermissions((Permission[])new BatchPermissions[]{BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES, BatchPermissions.CREATE_BATCH_DELETE_DECISION_INSTANCES});
        authorization.setResource((Resource)Resources.BATCH);
        authorization.setResourceId("*");
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.authorizationService.saveAuthorization(authorization);
        Authorization authorizationResult = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.BATCH).singleResult();
        AuthorizationServiceAuthorizationsTest.assertNotNull((Object)authorizationResult);
        AuthorizationServiceAuthorizationsTest.assertTrue((boolean)authorizationResult.isPermissionGranted((Permission)BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES));
        AuthorizationServiceAuthorizationsTest.assertTrue((boolean)authorizationResult.isPermissionGranted((Permission)BatchPermissions.CREATE_BATCH_DELETE_DECISION_INSTANCES));
    }

    public void testIsUserAuthorizedWithInvalidResource() {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        String userId = "userId";
        authorization.setUserId(userId);
        authorization.addPermission((Permission)Permissions.ACCESS);
        authorization.setResource((Resource)Resources.APPLICATION);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        AuthorizationServiceAuthorizationsTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(userId, null, (Permission)Permissions.ACCESS, (Resource)Resources.APPLICATION));
        AuthorizationServiceAuthorizationsTest.assertEquals((boolean)false, (boolean)this.authorizationService.isUserAuthorized(userId, null, (Permission)BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES, (Resource)Resources.BATCH));
        AuthorizationServiceAuthorizationsTest.assertEquals((boolean)false, (boolean)this.authorizationService.isUserAuthorized(userId, null, (Permission)ProcessDefinitionPermissions.RETRY_JOB, (Resource)Resources.PROCESS_DEFINITION));
        AuthorizationServiceAuthorizationsTest.assertEquals((boolean)false, (boolean)this.authorizationService.isUserAuthorized(userId, null, (Permission)ProcessInstancePermissions.RETRY_JOB, (Resource)Resources.PROCESS_INSTANCE));
        try {
            this.authorizationService.isUserAuthorized(userId, null, (Permission)BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES, (Resource)Resources.APPLICATION);
            AuthorizationServiceAuthorizationsTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            AuthorizationServiceAuthorizationsTest.assertTrue((boolean)e.getMessage().contains("The resource type 'Application' is not valid"));
            AuthorizationServiceAuthorizationsTest.assertTrue((boolean)e.getMessage().contains(BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES.getName()));
        }
        try {
            this.authorizationService.isUserAuthorized(userId, null, (Permission)ProcessDefinitionPermissions.RETRY_JOB, (Resource)Resources.APPLICATION);
            AuthorizationServiceAuthorizationsTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            AuthorizationServiceAuthorizationsTest.assertTrue((boolean)e.getMessage().contains("The resource type 'Application' is not valid"));
            AuthorizationServiceAuthorizationsTest.assertTrue((boolean)e.getMessage().contains(ProcessDefinitionPermissions.RETRY_JOB.getName()));
        }
        try {
            this.authorizationService.isUserAuthorized(userId, null, (Permission)ProcessInstancePermissions.RETRY_JOB, (Resource)Resources.APPLICATION);
            AuthorizationServiceAuthorizationsTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            AuthorizationServiceAuthorizationsTest.assertTrue((boolean)e.getMessage().contains("The resource type 'Application' is not valid"));
            AuthorizationServiceAuthorizationsTest.assertTrue((boolean)e.getMessage().contains(ProcessInstancePermissions.RETRY_JOB.getName()));
        }
    }

    public void testIsUserAuthorizedWithInvalidResourceMultiplePermissions() {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        String userId = "userId";
        authorization.setUserId(userId);
        authorization.addPermission((Permission)ProcessInstancePermissions.READ);
        authorization.addPermission((Permission)ProcessInstancePermissions.RETRY_JOB);
        authorization.setResource((Resource)Resources.PROCESS_INSTANCE);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        AuthorizationServiceAuthorizationsTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(userId, null, (Permission)Permissions.READ, (Resource)Resources.PROCESS_INSTANCE));
        AuthorizationServiceAuthorizationsTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(userId, null, (Permission)ProcessInstancePermissions.RETRY_JOB, (Resource)Resources.PROCESS_INSTANCE));
        AuthorizationServiceAuthorizationsTest.assertEquals((boolean)false, (boolean)this.authorizationService.isUserAuthorized(userId, null, (Permission)BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES, (Resource)Resources.BATCH));
        AuthorizationServiceAuthorizationsTest.assertEquals((boolean)false, (boolean)this.authorizationService.isUserAuthorized(userId, null, (Permission)ProcessDefinitionPermissions.RETRY_JOB, (Resource)Resources.PROCESS_DEFINITION));
        AuthorizationServiceAuthorizationsTest.assertEquals((boolean)false, (boolean)this.authorizationService.isUserAuthorized(userId, null, (Permission)Permissions.ACCESS, (Resource)Resources.APPLICATION));
        try {
            this.authorizationService.isUserAuthorized(userId, null, (Permission)ProcessDefinitionPermissions.RETRY_JOB, (Resource)Resources.PROCESS_INSTANCE);
            AuthorizationServiceAuthorizationsTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            AuthorizationServiceAuthorizationsTest.assertTrue((boolean)e.getMessage().contains("The resource type 'ProcessInstance' is not valid"));
            AuthorizationServiceAuthorizationsTest.assertTrue((boolean)e.getMessage().contains(ProcessDefinitionPermissions.RETRY_JOB.getName()));
        }
    }

    public void testIsUserAuthorizedWithValidResourceImpl() {
        ResourceImpl resource = new ResourceImpl("authorization", 0);
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        String userId = "userId";
        authorization.setUserId(userId);
        authorization.addPermission((Permission)Permissions.ACCESS);
        authorization.setResource((Resource)Resources.APPLICATION);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        AuthorizationServiceAuthorizationsTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(userId, null, (Permission)Permissions.ACCESS, (Resource)resource));
    }

    protected void cleanupAfterTest() {
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
    }

    class ResourceImpl
    implements Resource {
        String resourceName;
        int resourceType;

        public ResourceImpl(String resourceName, int resourceType) {
            this.resourceName = resourceName;
            this.resourceType = resourceType;
        }

        public String resourceName() {
            return this.resourceName;
        }

        public int resourceType() {
            return this.resourceType;
        }
    }
}

