/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.ProcessInstancePermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.test.api.identity.TestPermissions;
import org.camunda.bpm.engine.test.api.identity.TestResource;

public class AuthorizationServiceTest
extends PluggableProcessEngineTestCase {
    protected String userId = "test";
    protected String groupId = "accounting";

    protected void tearDown() throws Exception {
        this.cleanupAfterTest();
        super.tearDown();
    }

    public void testGlobalAuthorizationType() {
        Authorization globalAuthorization = this.authorizationService.createNewAuthorization(0);
        globalAuthorization.setUserId(null);
        globalAuthorization.setUserId("*");
        try {
            globalAuthorization.setUserId("something");
            AuthorizationServiceTest.fail((String)"exception expected");
        }
        catch (Exception e) {
            this.assertTextPresent("ENGINE-03028 Illegal value 'something' for userId for GLOBAL authorization. Must be '*'", e.getMessage());
        }
        globalAuthorization.setGroupId(null);
        try {
            globalAuthorization.setGroupId("something");
            AuthorizationServiceTest.fail((String)"exception expected");
        }
        catch (Exception e) {
            this.assertTextPresent("ENGINE-03027 Cannot use 'groupId' for GLOBAL authorization", e.getMessage());
        }
    }

    public void testGrantAuthorizationType() {
        Authorization grantAuthorization = this.authorizationService.createNewAuthorization(1);
        grantAuthorization.setUserId(null);
        grantAuthorization.setUserId("*");
        grantAuthorization.setUserId("something");
        grantAuthorization.setGroupId(null);
        grantAuthorization.setGroupId("something");
    }

    public void testRevokeAuthorizationType() {
        Authorization revokeAuthorization = this.authorizationService.createNewAuthorization(2);
        revokeAuthorization.setUserId(null);
        revokeAuthorization.setUserId("*");
        revokeAuthorization.setUserId("something");
        revokeAuthorization.setGroupId(null);
        revokeAuthorization.setGroupId("something");
    }

    public void testDeleteNonExistingAuthorization() {
        try {
            this.authorizationService.deleteAuthorization("nonExisiting");
            AuthorizationServiceTest.fail();
        }
        catch (Exception e) {
            this.assertTextPresent("Authorization for Id 'nonExisiting' does not exist: authorization is null", e.getMessage());
        }
    }

    public void testCreateAuthorizationWithUserId() {
        TestResource resource1 = TestResource.RESOURCE1;
        AuthorizationServiceTest.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().count());
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("aUserId");
        authorization.setResource((Resource)resource1);
        this.authorizationService.saveAuthorization(authorization);
        AuthorizationServiceTest.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().count());
        this.authorizationService.deleteAuthorization(authorization.getId());
        AuthorizationServiceTest.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().count());
    }

    public void testCreateAuthorizationWithGroupId() {
        TestResource resource1 = TestResource.RESOURCE1;
        AuthorizationServiceTest.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().count());
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setGroupId("aGroupId");
        authorization.setResource((Resource)resource1);
        this.authorizationService.saveAuthorization(authorization);
        AuthorizationServiceTest.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().count());
        this.authorizationService.deleteAuthorization(authorization.getId());
        AuthorizationServiceTest.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().count());
    }

    public void testInvalidCreateAuthorization() {
        TestResource resource1 = TestResource.RESOURCE1;
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setResource((Resource)resource1);
        try {
            this.authorizationService.saveAuthorization(authorization);
            AuthorizationServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            AuthorizationServiceTest.assertTrue((boolean)e.getMessage().contains("Authorization must either have a 'userId' or a 'groupId'."));
        }
        authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setGroupId("someId");
        authorization.setUserId("someOtherId");
        authorization.setResource((Resource)resource1);
        try {
            this.authorizationService.saveAuthorization(authorization);
            AuthorizationServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Authorization must either have a 'userId' or a 'groupId'.", e.getMessage());
        }
        authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("someId");
        try {
            this.authorizationService.saveAuthorization(authorization);
            AuthorizationServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            AuthorizationServiceTest.assertTrue((boolean)e.getMessage().contains("Authorization 'resourceType' cannot be null."));
        }
        authorization = this.authorizationService.createNewAuthorization(2);
        authorization.setUserId("someId");
        try {
            this.authorizationService.saveAuthorization(authorization);
            AuthorizationServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            AuthorizationServiceTest.assertTrue((boolean)e.getMessage().contains("Authorization 'resourceType' cannot be null."));
        }
    }

    public void testUniqueUserConstraints() {
        TestResource resource1 = TestResource.RESOURCE1;
        Authorization authorization1 = this.authorizationService.createNewAuthorization(1);
        Authorization authorization2 = this.authorizationService.createNewAuthorization(1);
        authorization1.setResource((Resource)resource1);
        authorization1.setResourceId("someId");
        authorization1.setUserId("someUser");
        authorization2.setResource((Resource)resource1);
        authorization2.setResourceId("someId");
        authorization2.setUserId("someUser");
        this.authorizationService.saveAuthorization(authorization1);
        try {
            this.authorizationService.saveAuthorization(authorization2);
            AuthorizationServiceTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        Authorization authorization3 = this.authorizationService.createNewAuthorization(2);
        authorization3.setResource((Resource)resource1);
        authorization3.setResourceId("someId");
        authorization3.setUserId("someUser");
        this.authorizationService.saveAuthorization(authorization3);
        Authorization authorization4 = this.authorizationService.createNewAuthorization(2);
        authorization4.setResource((Resource)resource1);
        authorization4.setResourceId("someId");
        authorization4.setUserId("someUser");
        try {
            this.authorizationService.saveAuthorization(authorization4);
            AuthorizationServiceTest.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testUniqueGroupConstraints() {
        TestResource resource1 = TestResource.RESOURCE1;
        Authorization authorization1 = this.authorizationService.createNewAuthorization(1);
        Authorization authorization2 = this.authorizationService.createNewAuthorization(1);
        authorization1.setResource((Resource)resource1);
        authorization1.setResourceId("someId");
        authorization1.setGroupId("someGroup");
        authorization2.setResource((Resource)resource1);
        authorization2.setResourceId("someId");
        authorization2.setGroupId("someGroup");
        this.authorizationService.saveAuthorization(authorization1);
        try {
            this.authorizationService.saveAuthorization(authorization2);
            AuthorizationServiceTest.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Authorization authorization3 = this.authorizationService.createNewAuthorization(2);
        authorization3.setResource((Resource)resource1);
        authorization3.setResourceId("someId");
        authorization3.setGroupId("someGroup");
        this.authorizationService.saveAuthorization(authorization3);
        Authorization authorization4 = this.authorizationService.createNewAuthorization(2);
        authorization4.setResource((Resource)resource1);
        authorization4.setResourceId("someId");
        authorization4.setGroupId("someGroup");
        try {
            this.authorizationService.saveAuthorization(authorization4);
            AuthorizationServiceTest.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGlobalUniqueConstraints() {
        TestResource resource1 = TestResource.RESOURCE1;
        Authorization authorization1 = this.authorizationService.createNewAuthorization(0);
        Authorization authorization2 = this.authorizationService.createNewAuthorization(0);
        authorization1.setResource((Resource)resource1);
        authorization1.setResourceId("someId");
        authorization2.setResource((Resource)resource1);
        authorization2.setResourceId("someId");
        this.authorizationService.saveAuthorization(authorization1);
        try {
            this.authorizationService.saveAuthorization(authorization2);
            AuthorizationServiceTest.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testUpdateNewAuthorization() {
        TestResource resource1 = TestResource.RESOURCE1;
        TestResource resource2 = TestResource.RESOURCE2;
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("aUserId");
        authorization.setResource((Resource)resource1);
        authorization.setResourceId("aResourceId");
        authorization.addPermission((Permission)TestPermissions.ACCESS);
        this.authorizationService.saveAuthorization(authorization);
        Authorization savedAuthorization = (Authorization)this.authorizationService.createAuthorizationQuery().singleResult();
        AuthorizationServiceTest.assertEquals((String)"aUserId", (String)savedAuthorization.getUserId());
        AuthorizationServiceTest.assertEquals((int)resource1.resourceType(), (int)savedAuthorization.getResourceType());
        AuthorizationServiceTest.assertEquals((String)"aResourceId", (String)savedAuthorization.getResourceId());
        AuthorizationServiceTest.assertTrue((boolean)savedAuthorization.isPermissionGranted((Permission)TestPermissions.ACCESS));
        authorization.setUserId("anotherUserId");
        authorization.setResource((Resource)resource2);
        authorization.setResourceId("anotherResourceId");
        authorization.addPermission((Permission)TestPermissions.DELETE);
        this.authorizationService.saveAuthorization(authorization);
        savedAuthorization = (Authorization)this.authorizationService.createAuthorizationQuery().singleResult();
        AuthorizationServiceTest.assertEquals((String)"anotherUserId", (String)savedAuthorization.getUserId());
        AuthorizationServiceTest.assertEquals((int)resource2.resourceType(), (int)savedAuthorization.getResourceType());
        AuthorizationServiceTest.assertEquals((String)"anotherResourceId", (String)savedAuthorization.getResourceId());
        AuthorizationServiceTest.assertTrue((boolean)savedAuthorization.isPermissionGranted((Permission)TestPermissions.ACCESS));
        AuthorizationServiceTest.assertTrue((boolean)savedAuthorization.isPermissionGranted((Permission)TestPermissions.DELETE));
    }

    public void testUpdatePersistentAuthorization() {
        TestResource resource1 = TestResource.RESOURCE1;
        TestResource resource2 = TestResource.RESOURCE2;
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("aUserId");
        authorization.setResource((Resource)resource1);
        authorization.setResourceId("aResourceId");
        authorization.addPermission((Permission)TestPermissions.ACCESS);
        this.authorizationService.saveAuthorization(authorization);
        Authorization savedAuthorization = (Authorization)this.authorizationService.createAuthorizationQuery().singleResult();
        AuthorizationServiceTest.assertEquals((String)"aUserId", (String)savedAuthorization.getUserId());
        AuthorizationServiceTest.assertEquals((int)resource1.resourceType(), (int)savedAuthorization.getResourceType());
        AuthorizationServiceTest.assertEquals((String)"aResourceId", (String)savedAuthorization.getResourceId());
        AuthorizationServiceTest.assertTrue((boolean)savedAuthorization.isPermissionGranted((Permission)TestPermissions.ACCESS));
        savedAuthorization.setUserId("anotherUserId");
        savedAuthorization.setResource((Resource)resource2);
        savedAuthorization.setResourceId("anotherResourceId");
        savedAuthorization.addPermission((Permission)TestPermissions.DELETE);
        this.authorizationService.saveAuthorization(savedAuthorization);
        savedAuthorization = (Authorization)this.authorizationService.createAuthorizationQuery().singleResult();
        AuthorizationServiceTest.assertEquals((String)"anotherUserId", (String)savedAuthorization.getUserId());
        AuthorizationServiceTest.assertEquals((int)resource2.resourceType(), (int)savedAuthorization.getResourceType());
        AuthorizationServiceTest.assertEquals((String)"anotherResourceId", (String)savedAuthorization.getResourceId());
        AuthorizationServiceTest.assertTrue((boolean)savedAuthorization.isPermissionGranted((Permission)TestPermissions.ACCESS));
        AuthorizationServiceTest.assertTrue((boolean)savedAuthorization.isPermissionGranted((Permission)TestPermissions.DELETE));
    }

    public void testPermissions() {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setResource((Resource)Resources.USER);
        AuthorizationServiceTest.assertEquals((int)1, (int)authorization.getPermissions((Permission[])Permissions.values()).length);
        AuthorizationServiceTest.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.CREATE));
        AuthorizationServiceTest.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.DELETE));
        AuthorizationServiceTest.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        AuthorizationServiceTest.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        authorization.addPermission((Permission)Permissions.CREATE);
        AuthorizationServiceTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.CREATE));
        AuthorizationServiceTest.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.DELETE));
        AuthorizationServiceTest.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        AuthorizationServiceTest.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        authorization.addPermission((Permission)Permissions.DELETE);
        AuthorizationServiceTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.CREATE));
        AuthorizationServiceTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.DELETE));
        AuthorizationServiceTest.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        AuthorizationServiceTest.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        authorization.addPermission((Permission)Permissions.READ);
        AuthorizationServiceTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.CREATE));
        AuthorizationServiceTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.DELETE));
        AuthorizationServiceTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        AuthorizationServiceTest.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        authorization.addPermission((Permission)Permissions.UPDATE);
        AuthorizationServiceTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.CREATE));
        AuthorizationServiceTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.DELETE));
        AuthorizationServiceTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        AuthorizationServiceTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        authorization.removePermission((Permission)Permissions.CREATE);
        AuthorizationServiceTest.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.CREATE));
        AuthorizationServiceTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.DELETE));
        AuthorizationServiceTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        AuthorizationServiceTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        authorization.removePermission((Permission)Permissions.DELETE);
        AuthorizationServiceTest.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.CREATE));
        AuthorizationServiceTest.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.DELETE));
        AuthorizationServiceTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        AuthorizationServiceTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        authorization.removePermission((Permission)Permissions.READ);
        AuthorizationServiceTest.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.CREATE));
        AuthorizationServiceTest.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.DELETE));
        AuthorizationServiceTest.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        AuthorizationServiceTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        authorization.removePermission((Permission)Permissions.UPDATE);
        AuthorizationServiceTest.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.CREATE));
        AuthorizationServiceTest.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.DELETE));
        AuthorizationServiceTest.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        AuthorizationServiceTest.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
    }

    public void testGrantAuthPermissions() {
        AuthorizationEntity authorization = new AuthorizationEntity(1);
        authorization.setResource((Resource)Resources.DEPLOYMENT);
        AuthorizationServiceTest.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.ALL));
        AuthorizationServiceTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.NONE));
        List<Permission> perms = Arrays.asList(authorization.getPermissions((Permission[])Permissions.values()));
        AuthorizationServiceTest.assertTrue((boolean)perms.contains(Permissions.NONE));
        AuthorizationServiceTest.assertEquals((int)1, (int)perms.size());
        authorization.addPermission((Permission)Permissions.READ);
        perms = Arrays.asList(authorization.getPermissions((Permission[])Permissions.values()));
        AuthorizationServiceTest.assertTrue((boolean)perms.contains(Permissions.NONE));
        AuthorizationServiceTest.assertTrue((boolean)perms.contains(Permissions.READ));
        AuthorizationServiceTest.assertEquals((int)2, (int)perms.size());
        AuthorizationServiceTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        AuthorizationServiceTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.NONE));
        try {
            authorization.isPermissionRevoked((Permission)Permissions.READ);
            AuthorizationServiceTest.fail((String)"Exception expected");
        }
        catch (IllegalStateException e) {
            this.assertTextPresent("ENGINE-03026 Method 'isPermissionRevoked' cannot be used for authorization with type 'GRANT'.", e.getMessage());
        }
    }

    public void testGlobalAuthPermissions() {
        AuthorizationEntity authorization = new AuthorizationEntity(1);
        authorization.setResource((Resource)Resources.DEPLOYMENT);
        AuthorizationServiceTest.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.ALL));
        AuthorizationServiceTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.NONE));
        List<Permission> perms = Arrays.asList(authorization.getPermissions((Permission[])Permissions.values()));
        AuthorizationServiceTest.assertTrue((boolean)perms.contains(Permissions.NONE));
        AuthorizationServiceTest.assertEquals((int)1, (int)perms.size());
        authorization.addPermission((Permission)Permissions.READ);
        perms = Arrays.asList(authorization.getPermissions((Permission[])Permissions.values()));
        AuthorizationServiceTest.assertTrue((boolean)perms.contains(Permissions.NONE));
        AuthorizationServiceTest.assertTrue((boolean)perms.contains(Permissions.READ));
        AuthorizationServiceTest.assertEquals((int)2, (int)perms.size());
        AuthorizationServiceTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        AuthorizationServiceTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.NONE));
        try {
            authorization.isPermissionRevoked((Permission)Permissions.READ);
            AuthorizationServiceTest.fail((String)"Exception expected");
        }
        catch (IllegalStateException e) {
            this.assertTextPresent("ENGINE-03026 Method 'isPermissionRevoked' cannot be used for authorization with type 'GRANT'.", e.getMessage());
        }
    }

    public void testRevokeAuthPermissions() {
        AuthorizationEntity authorization = new AuthorizationEntity(2);
        authorization.setResource((Resource)Resources.DEPLOYMENT);
        AuthorizationServiceTest.assertFalse((boolean)authorization.isPermissionRevoked((Permission)Permissions.ALL));
        List<Permission> perms = Arrays.asList(authorization.getPermissions((Permission[])Permissions.values()));
        AuthorizationServiceTest.assertEquals((int)0, (int)perms.size());
        authorization.removePermission((Permission)Permissions.READ);
        perms = Arrays.asList(authorization.getPermissions((Permission[])Permissions.values()));
        AuthorizationServiceTest.assertTrue((boolean)perms.contains(Permissions.READ));
        AuthorizationServiceTest.assertTrue((boolean)perms.contains(Permissions.ALL));
        AuthorizationServiceTest.assertEquals((int)2, (int)perms.size());
        try {
            authorization.isPermissionGranted((Permission)Permissions.READ);
            AuthorizationServiceTest.fail((String)"Exception expected");
        }
        catch (IllegalStateException e) {
            this.assertTextPresent("ENGINE-03026 Method 'isPermissionGranted' cannot be used for authorization with type 'REVOKE'.", e.getMessage());
        }
    }

    public void testGlobalGrantAuthorizationCheck() {
        TestResource resource1 = TestResource.RESOURCE1;
        Authorization globalAuth = this.authorizationService.createNewAuthorization(0);
        globalAuth.setResource((Resource)resource1);
        globalAuth.setResourceId("*");
        globalAuth.addPermission((Permission)TestPermissions.ALL);
        this.authorizationService.saveAuthorization(globalAuth);
        List<String> jonnysGroups = Arrays.asList("sales", "marketing");
        List<String> someOneElsesGroups = Arrays.asList("marketing");
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        AuthorizationServiceTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.ALL, (Resource)resource1));
        AuthorizationServiceTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)TestPermissions.ALL, (Resource)resource1));
        AuthorizationServiceTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone", null, (Permission)TestPermissions.ACCESS, (Resource)resource1));
        AuthorizationServiceTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone", someOneElsesGroups, (Permission)TestPermissions.ACCESS, (Resource)resource1));
        AuthorizationServiceTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)TestPermissions.DELETE, (Resource)resource1));
        AuthorizationServiceTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.ALL, (Resource)resource1, "someId"));
        AuthorizationServiceTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)TestPermissions.ALL, (Resource)resource1, "someId"));
        AuthorizationServiceTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone", null, (Permission)TestPermissions.ACCESS, (Resource)resource1, "someId"));
        AuthorizationServiceTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)TestPermissions.DELETE, (Resource)resource1, "someOtherId"));
        this.processEngineConfiguration.setAuthorizationEnabled(true);
    }

    public void testDisabledAuthorizationCheck() {
        TestResource resource1 = TestResource.RESOURCE1;
        boolean isAuthorized = this.authorizationService.isUserAuthorized("jonny", null, (Permission)Permissions.UPDATE, (Resource)resource1);
        AuthorizationServiceTest.assertTrue((boolean)isAuthorized);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentIsUserAuthorized() throws Exception {
        int threadCount = 2;
        int invocationCount = 500;
        ExecutorService executorService = Executors.newFixedThreadPool(threadCount);
        try {
            ArrayList<1> callables = new ArrayList<1>();
            for (int i = 0; i < invocationCount; ++i) {
                callables.add(new Callable<Exception>(){

                    @Override
                    public Exception call() throws Exception {
                        try {
                            AuthorizationServiceTest.this.authorizationService.isUserAuthorized("jonny", null, (Permission)Permissions.UPDATE, (Resource)TestResource.RESOURCE1, "*");
                        }
                        catch (Exception e) {
                            return e;
                        }
                        return null;
                    }
                });
            }
            List futures = executorService.invokeAll(callables);
            for (Future future : futures) {
                Exception exception = (Exception)future.get();
                if (exception == null) continue;
                AuthorizationServiceTest.fail((String)("No exception expected: " + exception.getMessage()));
            }
        }
        finally {
            executorService.shutdownNow();
            executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
    }

    public void testReportResourceAuthorization() {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId(this.userId);
        authorization.addPermission((Permission)Permissions.ALL);
        authorization.setResource((Resource)Resources.REPORT);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        AuthorizationServiceTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId, Arrays.asList(this.groupId), (Permission)Permissions.ALL, (Resource)Resources.REPORT));
        this.processEngineConfiguration.setAuthorizationEnabled(false);
    }

    public void testReportResourcePermissions() {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId(this.userId);
        authorization.addPermission((Permission)Permissions.CREATE);
        authorization.addPermission((Permission)Permissions.READ);
        authorization.addPermission((Permission)Permissions.UPDATE);
        authorization.addPermission((Permission)Permissions.DELETE);
        authorization.setResource((Resource)Resources.REPORT);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        AuthorizationServiceTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)Permissions.CREATE, (Resource)Resources.REPORT));
        AuthorizationServiceTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)Permissions.READ, (Resource)Resources.REPORT));
        AuthorizationServiceTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)Permissions.UPDATE, (Resource)Resources.REPORT));
        AuthorizationServiceTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)Permissions.DELETE, (Resource)Resources.REPORT));
        this.processEngineConfiguration.setAuthorizationEnabled(false);
    }

    public void testDashboardResourceAuthorization() {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId(this.userId);
        authorization.addPermission((Permission)Permissions.ALL);
        authorization.setResource((Resource)Resources.DASHBOARD);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        AuthorizationServiceTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId, Arrays.asList(this.groupId), (Permission)Permissions.ALL, (Resource)Resources.DASHBOARD));
        this.processEngineConfiguration.setAuthorizationEnabled(false);
    }

    public void testDashboardResourcePermission() {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId(this.userId);
        authorization.addPermission((Permission)Permissions.CREATE);
        authorization.addPermission((Permission)Permissions.READ);
        authorization.addPermission((Permission)Permissions.UPDATE);
        authorization.addPermission((Permission)Permissions.DELETE);
        authorization.setResource((Resource)Resources.DASHBOARD);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        AuthorizationServiceTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)Permissions.CREATE, (Resource)Resources.DASHBOARD));
        AuthorizationServiceTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)Permissions.READ, (Resource)Resources.DASHBOARD));
        AuthorizationServiceTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)Permissions.UPDATE, (Resource)Resources.DASHBOARD));
        AuthorizationServiceTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)Permissions.DELETE, (Resource)Resources.DASHBOARD));
        this.processEngineConfiguration.setAuthorizationEnabled(false);
    }

    public void testIsPermissionGrantedAccess() {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        String userId = "userId";
        authorization.setUserId(userId);
        authorization.addPermission((Permission)Permissions.ACCESS);
        authorization.setResource((Resource)Resources.APPLICATION);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        Authorization authorizationResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{userId}).singleResult();
        AuthorizationServiceTest.assertTrue((boolean)authorizationResult.isPermissionGranted((Permission)Permissions.ACCESS));
        AuthorizationServiceTest.assertFalse((boolean)authorizationResult.isPermissionGranted((Permission)BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES));
        AuthorizationServiceTest.assertFalse((boolean)authorizationResult.isPermissionGranted((Permission)ProcessInstancePermissions.RETRY_JOB));
        AuthorizationServiceTest.assertFalse((boolean)authorizationResult.isPermissionGranted((Permission)ProcessDefinitionPermissions.RETRY_JOB));
    }

    public void testIsPermissionGrantedRetryJob() {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        String userId = "userId";
        authorization.setUserId(userId);
        authorization.addPermission((Permission)ProcessInstancePermissions.RETRY_JOB);
        authorization.setResource((Resource)Resources.PROCESS_INSTANCE);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        Authorization authorizationResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{userId}).singleResult();
        AuthorizationServiceTest.assertTrue((boolean)authorizationResult.isPermissionGranted((Permission)ProcessInstancePermissions.RETRY_JOB));
        AuthorizationServiceTest.assertFalse((boolean)authorizationResult.isPermissionGranted((Permission)Permissions.ACCESS));
        AuthorizationServiceTest.assertFalse((boolean)authorizationResult.isPermissionGranted((Permission)BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES));
        AuthorizationServiceTest.assertFalse((boolean)authorizationResult.isPermissionGranted((Permission)ProcessDefinitionPermissions.RETRY_JOB));
    }

    public void testIsPermissionGrantedBatchResource() {
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        String userId = "userId";
        authorization.setUserId(userId);
        authorization.addPermission((Permission)BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES);
        authorization.addPermission((Permission)BatchPermissions.CREATE_BATCH_DELETE_FINISHED_PROCESS_INSTANCES);
        authorization.addPermission((Permission)BatchPermissions.CREATE_BATCH_DELETE_RUNNING_PROCESS_INSTANCES);
        authorization.setResource((Resource)Resources.BATCH);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        Authorization authorizationResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{userId}).singleResult();
        AuthorizationServiceTest.assertTrue((boolean)authorizationResult.isPermissionGranted((Permission)BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES));
        AuthorizationServiceTest.assertTrue((boolean)authorizationResult.isPermissionGranted((Permission)BatchPermissions.CREATE_BATCH_DELETE_FINISHED_PROCESS_INSTANCES));
        AuthorizationServiceTest.assertTrue((boolean)authorizationResult.isPermissionGranted((Permission)BatchPermissions.CREATE_BATCH_DELETE_RUNNING_PROCESS_INSTANCES));
        AuthorizationServiceTest.assertFalse((boolean)authorizationResult.isPermissionGranted((Permission)BatchPermissions.CREATE_BATCH_MODIFY_PROCESS_INSTANCES));
        AuthorizationServiceTest.assertFalse((boolean)authorizationResult.isPermissionGranted((Permission)Permissions.ACCESS));
        AuthorizationServiceTest.assertFalse((boolean)authorizationResult.isPermissionGranted((Permission)Permissions.CREATE));
    }

    public void testIsPermissionRevokedAccess() {
        Authorization authorization = this.authorizationService.createNewAuthorization(2);
        String userId = "userId";
        authorization.setUserId(userId);
        authorization.removePermission((Permission)Permissions.ACCESS);
        authorization.setResource((Resource)Resources.APPLICATION);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        Authorization authorizationResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{userId}).singleResult();
        AuthorizationServiceTest.assertTrue((boolean)authorizationResult.isPermissionRevoked((Permission)Permissions.ACCESS));
        AuthorizationServiceTest.assertFalse((boolean)authorizationResult.isPermissionRevoked((Permission)BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES));
        AuthorizationServiceTest.assertFalse((boolean)authorizationResult.isPermissionRevoked((Permission)ProcessInstancePermissions.RETRY_JOB));
        AuthorizationServiceTest.assertFalse((boolean)authorizationResult.isPermissionRevoked((Permission)ProcessDefinitionPermissions.RETRY_JOB));
    }

    public void testIsPermissionRevokedRetryJob() {
        Authorization authorization = this.authorizationService.createNewAuthorization(2);
        String userId = "userId";
        authorization.setUserId(userId);
        authorization.removePermission((Permission)ProcessInstancePermissions.RETRY_JOB);
        authorization.setResource((Resource)Resources.PROCESS_INSTANCE);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        Authorization authorizationResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{userId}).singleResult();
        AuthorizationServiceTest.assertTrue((boolean)authorizationResult.isPermissionRevoked((Permission)ProcessInstancePermissions.RETRY_JOB));
        AuthorizationServiceTest.assertFalse((boolean)authorizationResult.isPermissionRevoked((Permission)Permissions.ACCESS));
        AuthorizationServiceTest.assertFalse((boolean)authorizationResult.isPermissionRevoked((Permission)BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES));
        AuthorizationServiceTest.assertFalse((boolean)authorizationResult.isPermissionRevoked((Permission)ProcessDefinitionPermissions.RETRY_JOB));
    }

    public void testIsPermissionRevokedBatchResource() {
        Authorization authorization = this.authorizationService.createNewAuthorization(2);
        String userId = "userId";
        authorization.setUserId(userId);
        authorization.removePermission((Permission)BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES);
        authorization.removePermission((Permission)BatchPermissions.CREATE_BATCH_DELETE_FINISHED_PROCESS_INSTANCES);
        authorization.removePermission((Permission)BatchPermissions.CREATE_BATCH_DELETE_RUNNING_PROCESS_INSTANCES);
        authorization.setResource((Resource)Resources.BATCH);
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        Authorization authorizationResult = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{userId}).singleResult();
        AuthorizationServiceTest.assertTrue((boolean)authorizationResult.isPermissionRevoked((Permission)BatchPermissions.CREATE_BATCH_MIGRATE_PROCESS_INSTANCES));
        AuthorizationServiceTest.assertTrue((boolean)authorizationResult.isPermissionRevoked((Permission)BatchPermissions.CREATE_BATCH_DELETE_FINISHED_PROCESS_INSTANCES));
        AuthorizationServiceTest.assertTrue((boolean)authorizationResult.isPermissionRevoked((Permission)BatchPermissions.CREATE_BATCH_DELETE_RUNNING_PROCESS_INSTANCES));
        AuthorizationServiceTest.assertFalse((boolean)authorizationResult.isPermissionRevoked((Permission)BatchPermissions.CREATE_BATCH_MODIFY_PROCESS_INSTANCES));
        AuthorizationServiceTest.assertFalse((boolean)authorizationResult.isPermissionRevoked((Permission)Permissions.ACCESS));
        AuthorizationServiceTest.assertFalse((boolean)authorizationResult.isPermissionRevoked((Permission)Permissions.CREATE));
    }

    protected void cleanupAfterTest() {
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
    }
}

