/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.test.api.identity.TestPermissions;
import org.camunda.bpm.engine.test.api.identity.TestResource;

public class AuthorizationServiceWithEnabledAuthorizationTest
extends PluggableProcessEngineTestCase {
    public void setUp() throws Exception {
        super.setUp();
        this.processEngineConfiguration.setAuthorizationEnabled(true);
    }

    public void tearDown() throws Exception {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.cleanupAfterTest();
        super.tearDown();
    }

    public void testAuthorizationCheckEmptyDb() {
        TestResource resource1 = TestResource.RESOURCE1;
        TestResource resource2 = TestResource.RESOURCE2;
        List<String> jonnysGroups = Arrays.asList("sales", "marketing");
        List<String> someOneElsesGroups = Collections.singletonList("marketing");
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)TestPermissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone", someOneElsesGroups, (Permission)TestPermissions.CREATE, (Resource)resource2));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)TestPermissions.DELETE, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)TestPermissions.ALL, (Resource)resource1, "someId"));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone", someOneElsesGroups, (Permission)TestPermissions.CREATE, (Resource)resource2, "someId"));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)TestPermissions.DELETE, (Resource)resource1, "someOtherId"));
    }

    public void testUserOverrideGlobalGrantAuthorizationCheck() {
        TestResource resource1 = TestResource.RESOURCE1;
        Authorization globalGrant = this.authorizationService.createNewAuthorization(0);
        globalGrant.setResource((Resource)resource1);
        globalGrant.setResourceId("*");
        globalGrant.addPermission((Permission)TestPermissions.ALL);
        this.authorizationService.saveAuthorization(globalGrant);
        Authorization localRevoke = this.authorizationService.createNewAuthorization(2);
        localRevoke.setUserId("jonny");
        localRevoke.setResource((Resource)resource1);
        localRevoke.setResourceId("*");
        localRevoke.removePermission((Permission)TestPermissions.READ);
        this.authorizationService.saveAuthorization(localRevoke);
        List<String> jonnysGroups = Arrays.asList("sales", "marketing");
        List<String> someOneElsesGroups = Collections.singletonList("marketing");
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)TestPermissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)TestPermissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)TestPermissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", someOneElsesGroups, (Permission)TestPermissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)TestPermissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", someOneElsesGroups, (Permission)TestPermissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.DELETE, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)TestPermissions.DELETE, (Resource)resource1));
    }

    public void testGroupOverrideGlobalGrantAuthorizationCheck() {
        TestResource resource1 = TestResource.RESOURCE1;
        Authorization globalGrant = this.authorizationService.createNewAuthorization(0);
        globalGrant.setResource((Resource)resource1);
        globalGrant.setResourceId("*");
        globalGrant.addPermission((Permission)TestPermissions.ALL);
        this.authorizationService.saveAuthorization(globalGrant);
        Authorization groupRevoke = this.authorizationService.createNewAuthorization(2);
        groupRevoke.setGroupId("sales");
        groupRevoke.setResource((Resource)resource1);
        groupRevoke.setResourceId("*");
        groupRevoke.removePermission((Permission)TestPermissions.READ);
        this.authorizationService.saveAuthorization(groupRevoke);
        List<String> jonnysGroups = Arrays.asList("sales", "marketing");
        List<String> someOneElsesGroups = Collections.singletonList("marketing");
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)TestPermissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)TestPermissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", someOneElsesGroups, (Permission)TestPermissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", someOneElsesGroups, (Permission)TestPermissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)TestPermissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)TestPermissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", jonnysGroups, (Permission)TestPermissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", jonnysGroups, (Permission)TestPermissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)TestPermissions.DELETE, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.DELETE, (Resource)resource1));
    }

    public void testUserOverrideGlobalRevokeAuthorizationCheck() {
        TestResource resource1 = TestResource.RESOURCE1;
        Authorization globalGrant = this.authorizationService.createNewAuthorization(0);
        globalGrant.setResource((Resource)resource1);
        globalGrant.setResourceId("*");
        globalGrant.removePermission((Permission)TestPermissions.ALL);
        this.authorizationService.saveAuthorization(globalGrant);
        Authorization localRevoke = this.authorizationService.createNewAuthorization(1);
        localRevoke.setUserId("jonny");
        localRevoke.setResource((Resource)resource1);
        localRevoke.setResourceId("*");
        localRevoke.addPermission((Permission)TestPermissions.READ);
        this.authorizationService.saveAuthorization(localRevoke);
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.DELETE, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)TestPermissions.ALL, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)TestPermissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)TestPermissions.DELETE, (Resource)resource1));
    }

    public void testNullAuthorizationCheckUserGroup() {
        try {
            this.authorizationService.isUserAuthorized(null, null, (Permission)TestPermissions.UPDATE, (Resource)TestResource.RESOURCE1);
            AuthorizationServiceWithEnabledAuthorizationTest.fail((String)"Expected NullValueException");
        }
        catch (NullValueException e) {
            AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)e.getMessage().contains("Authorization must have a 'userId' or/and a 'groupId'"));
        }
    }

    public void testNullAuthorizationCheckPermission() {
        try {
            this.authorizationService.isUserAuthorized("jonny", null, null, (Resource)TestResource.RESOURCE1);
            AuthorizationServiceWithEnabledAuthorizationTest.fail((String)"Expected NullValueException");
        }
        catch (NullValueException e) {
            AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)e.getMessage().contains("Invalid permission for an authorization"));
        }
    }

    public void testNullAuthorizationCheckResource() {
        try {
            this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.UPDATE, null);
            AuthorizationServiceWithEnabledAuthorizationTest.fail((String)"Expected NullValueException");
        }
        catch (NullValueException e) {
            AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)e.getMessage().contains("Invalid resource for an authorization"));
        }
    }

    public void testUserOverrideGroupOverrideGlobalAuthorizationCheck() {
        TestResource resource1 = TestResource.RESOURCE1;
        Authorization globalGrant = this.authorizationService.createNewAuthorization(0);
        globalGrant.setResource((Resource)resource1);
        globalGrant.setResourceId("*");
        globalGrant.addPermission((Permission)TestPermissions.ALL);
        this.authorizationService.saveAuthorization(globalGrant);
        Authorization groupRevoke = this.authorizationService.createNewAuthorization(2);
        groupRevoke.setGroupId("sales");
        groupRevoke.setResource((Resource)resource1);
        groupRevoke.setResourceId("*");
        groupRevoke.removePermission((Permission)TestPermissions.READ);
        this.authorizationService.saveAuthorization(groupRevoke);
        Authorization userGrant = this.authorizationService.createNewAuthorization(1);
        userGrant.setUserId("jonny");
        userGrant.setResource((Resource)resource1);
        userGrant.setResourceId("*");
        userGrant.addPermission((Permission)TestPermissions.READ);
        this.authorizationService.saveAuthorization(userGrant);
        List<String> jonnysGroups = Arrays.asList("sales", "marketing");
        List<String> someOneElsesGroups = Collections.singletonList("marketing");
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)TestPermissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", jonnysGroups, (Permission)TestPermissions.READ, (Resource)resource1));
        AuthorizationServiceWithEnabledAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", someOneElsesGroups, (Permission)TestPermissions.READ, (Resource)resource1));
    }

    public void testEnabledAuthorizationCheck() {
        TestResource resource1 = TestResource.RESOURCE1;
        boolean isAuthorized = this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.UPDATE, (Resource)resource1);
        AuthorizationServiceWithEnabledAuthorizationTest.assertFalse((boolean)isAuthorized);
    }

    protected void cleanupAfterTest() {
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
    }
}

