/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class JobEntityTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected List<String> jobIds = new ArrayList<String>();
    protected HistoryService historyService;
    protected ManagementService managementService;
    protected RuntimeService runtimeService;
    protected static final Date CREATE_DATE = new Date(1363607000000L);

    @Before
    public void setUp() {
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.jobIds = new ArrayList<String>();
    }

    @Before
    public void setClock() {
        ClockUtil.setCurrentTime((Date)CREATE_DATE);
    }

    @After
    public void resetClock() {
        ClockUtil.reset();
    }

    @After
    public void cleanup() {
        for (String jobId : this.jobIds) {
            this.managementService.deleteJob(jobId);
        }
        if (!this.testRule.isHistoryLevelNone()) {
            this.cleanupJobLog();
        }
    }

    @Test
    public void shouldCheckCreateTimeOnMessage() {
        this.testRule.deploy(((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().camundaAsyncBefore()).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("process");
        Job messageJob = (Job)this.managementService.createJobQuery().singleResult();
        MatcherAssert.assertThat((Object)messageJob.getCreateTime(), (Matcher)Matchers.is((Object)CREATE_DATE));
        MatcherAssert.assertThat((Object)messageJob.getClass().getSimpleName(), (Matcher)Matchers.is((Object)"MessageEntity"));
        this.jobIds.add(messageJob.getId());
    }

    @Test
    public void shouldCheckCreateTimeOnTimer() {
        this.testRule.deploy(((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().timerWithDuration("PT5S")).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("process");
        Job timerJob = (Job)this.managementService.createJobQuery().singleResult();
        MatcherAssert.assertThat((Object)timerJob.getCreateTime(), (Matcher)Matchers.is((Object)CREATE_DATE));
        MatcherAssert.assertThat((Object)timerJob.getClass().getSimpleName(), (Matcher)Matchers.is((Object)"TimerEntity"));
        this.jobIds.add(timerJob.getId());
    }

    @Test
    public void shouldCheckCreateTimeOnEverLivingJob() {
        this.historyService.cleanUpHistoryAsync(true);
        Job everLivingJob = (Job)this.managementService.createJobQuery().singleResult();
        MatcherAssert.assertThat((Object)everLivingJob.getCreateTime(), (Matcher)Matchers.is((Object)CREATE_DATE));
        MatcherAssert.assertThat((Object)everLivingJob.getClass().getSimpleName(), (Matcher)Matchers.is((Object)"EverLivingJobEntity"));
        this.jobIds.add(everLivingJob.getId());
    }

    protected void cleanupJobLog() {
        this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                for (String jobId : JobEntityTest.this.jobIds) {
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
                }
                return null;
            }
        });
    }
}

