/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.Calendar;
import java.util.Date;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.impl.identity.Authentication;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.delegate.AssertingJavaDelegate;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyJobExecutorTest {
    protected static final String TENANT_ID = "tenant1";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Test
    public void setAuthenticatedTenantForTimerStartEvent() {
        this.testRule.deployForTenant(TENANT_ID, ((ServiceTaskBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().timerWithDuration("PT1M")).serviceTask().camundaClass(AssertingJavaDelegate.class.getName())).userTask().endEvent().done());
        AssertingJavaDelegate.addAsserts(MultiTenancyJobExecutorTest.hasAuthenticatedTenantId(TENANT_ID));
        ClockUtil.setCurrentTime((Date)this.tomorrow());
        this.testRule.waitForJobExecutorToProcessAllJobs();
        Assert.assertThat((Object)this.engineRule.getTaskService().createTaskQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void setAuthenticatedTenantForIntermediateTimerEvent() {
        this.testRule.deployForTenant(TENANT_ID, ((ServiceTaskBuilder)((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().intermediateCatchEvent().timerWithDuration("PT1M")).serviceTask().camundaClass(AssertingJavaDelegate.class.getName())).endEvent().done());
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        AssertingJavaDelegate.addAsserts(MultiTenancyJobExecutorTest.hasAuthenticatedTenantId(TENANT_ID));
        ClockUtil.setCurrentTime((Date)this.tomorrow());
        this.testRule.waitForJobExecutorToProcessAllJobs();
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void setAuthenticatedTenantForAsyncJob() {
        this.testRule.deployForTenant(TENANT_ID, ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask().camundaAsyncBefore()).camundaClass(AssertingJavaDelegate.class.getName())).endEvent().done());
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        AssertingJavaDelegate.addAsserts(MultiTenancyJobExecutorTest.hasAuthenticatedTenantId(TENANT_ID));
        this.testRule.waitForJobExecutorToProcessAllJobs();
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void dontSetAuthenticatedTenantForJobWithoutTenant() {
        this.testRule.deploy(((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask().camundaAsyncBefore()).camundaClass(AssertingJavaDelegate.class.getName())).endEvent().done());
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        AssertingJavaDelegate.addAsserts(MultiTenancyJobExecutorTest.hasNoAuthenticatedTenantId());
        this.testRule.waitForJobExecutorToProcessAllJobs();
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void dontSetAuthenticatedTenantWhileManualJobExecution() {
        this.testRule.deployForTenant(TENANT_ID, ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask().camundaAsyncBefore()).camundaClass(AssertingJavaDelegate.class.getName())).endEvent().done());
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        AssertingJavaDelegate.addAsserts(MultiTenancyJobExecutorTest.hasNoAuthenticatedTenantId());
        this.testRule.executeAvailableJobs();
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    protected static AssertingJavaDelegate.DelegateExecutionAsserter hasAuthenticatedTenantId(final String expectedTenantId) {
        return new AssertingJavaDelegate.DelegateExecutionAsserter(){

            @Override
            public void doAssert(DelegateExecution execution) {
                IdentityService identityService = execution.getProcessEngineServices().getIdentityService();
                Authentication currentAuthentication = identityService.getCurrentAuthentication();
                Assert.assertThat((Object)currentAuthentication, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
                Assert.assertThat((Object)currentAuthentication.getTenantIds(), (Matcher)CoreMatchers.hasItem((Object)expectedTenantId));
            }
        };
    }

    protected static AssertingJavaDelegate.DelegateExecutionAsserter hasNoAuthenticatedTenantId() {
        return new AssertingJavaDelegate.DelegateExecutionAsserter(){

            @Override
            public void doAssert(DelegateExecution execution) {
                IdentityService identityService = execution.getProcessEngineServices().getIdentityService();
                Authentication currentAuthentication = identityService.getCurrentAuthentication();
                Assert.assertThat((Object)currentAuthentication, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
            }
        };
    }

    protected Date tomorrow() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        return calendar.getTime();
    }

    @After
    public void tearDown() throws Exception {
        AssertingJavaDelegate.clear();
    }
}

