/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.optimize;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.history.HistoricDecisionInputInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionOutputInstance;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.OptimizeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class GetHistoricDecisionInstancesForOptimizeTest {
    public static final String DECISION_PROCESS = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml";
    public static final String DECISION_SINGLE_OUTPUT_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml";
    protected static final String VARIABLE_NAME = "aVariableName";
    protected static final String VARIABLE_VALUE = "aVariableValue";
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    protected String userId = "test";
    private OptimizeService optimizeService;
    private IdentityService identityService;
    private RuntimeService runtimeService;
    private AuthorizationService authorizationService;

    @Before
    public void init() {
        ProcessEngineConfigurationImpl config = this.engineRule.getProcessEngineConfiguration();
        this.optimizeService = config.getOptimizeService();
        this.identityService = this.engineRule.getIdentityService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.authorizationService = this.engineRule.getAuthorizationService();
        this.createUser(this.userId);
    }

    @After
    public void cleanUp() {
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
        ClockUtil.reset();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void getCompletedHistoricDecisionInstances() {
        VariableMap variables = Variables.createVariables();
        variables.put((Object)"input1", null);
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
        List decisionInstances = this.optimizeService.getHistoricDecisionInstances(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)decisionInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        this.assertThatDecisionsHaveAllImportantInformation(decisionInstances);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void decisionInputInstanceProperties() {
        VariableMap variables = Variables.createVariables();
        variables.put((Object)"input1", null);
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
        List decisionInstances = this.optimizeService.getHistoricDecisionInstances(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)decisionInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionInstance decisionInstance = (HistoricDecisionInstance)decisionInstances.get(0);
        List inputs = decisionInstance.getInputs();
        MatcherAssert.assertThat((Object)inputs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)inputs.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionInputInstance input = (HistoricDecisionInputInstance)inputs.get(0);
        MatcherAssert.assertThat((Object)input.getDecisionInstanceId(), (Matcher)CoreMatchers.is((Object)decisionInstance.getId()));
        MatcherAssert.assertThat((Object)input.getClauseId(), (Matcher)CoreMatchers.is((Object)"in"));
        MatcherAssert.assertThat((Object)input.getClauseName(), (Matcher)CoreMatchers.is((Object)"input"));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void decisionOutputInstanceProperties() {
        VariableMap variables = Variables.createVariables();
        variables.put((Object)"input1", null);
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
        List decisionInstances = this.optimizeService.getHistoricDecisionInstances(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)decisionInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionInstance decisionInstance = (HistoricDecisionInstance)decisionInstances.get(0);
        List outputs = decisionInstance.getOutputs();
        MatcherAssert.assertThat((Object)outputs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)outputs.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionOutputInstance output = (HistoricDecisionOutputInstance)outputs.get(0);
        MatcherAssert.assertThat((Object)output.getDecisionInstanceId(), (Matcher)CoreMatchers.is((Object)decisionInstance.getId()));
        MatcherAssert.assertThat((Object)output.getClauseId(), (Matcher)CoreMatchers.is((Object)"out"));
        MatcherAssert.assertThat((Object)output.getClauseName(), (Matcher)CoreMatchers.is((Object)"output"));
        MatcherAssert.assertThat((Object)output.getRuleId(), (Matcher)CoreMatchers.is((Object)"rule"));
        MatcherAssert.assertThat((Object)output.getRuleOrder(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)output.getVariableName(), (Matcher)CoreMatchers.is((Object)"result"));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void fishedAfterParameterWorks() {
        VariableMap variables = Variables.createVariables();
        variables.put((Object)"input1", null);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        ProcessInstance secondProcessInstance = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
        List decisionInstances = this.optimizeService.getHistoricDecisionInstances(now, null, 10);
        MatcherAssert.assertThat((Object)decisionInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionInstance decisionInstance = (HistoricDecisionInstance)decisionInstances.get(0);
        MatcherAssert.assertThat((Object)decisionInstance.getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)secondProcessInstance.getId()));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void fishedAtParameterWorks() {
        VariableMap variables = Variables.createVariables();
        variables.put((Object)"input1", null);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        ProcessInstance firstProcessInstance = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
        List decisionInstances = this.optimizeService.getHistoricDecisionInstances(null, now, 10);
        MatcherAssert.assertThat((Object)decisionInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionInstance decisionInstance = (HistoricDecisionInstance)decisionInstances.get(0);
        MatcherAssert.assertThat((Object)decisionInstance.getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)firstProcessInstance.getId()));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void fishedAfterAndFinishedAtParameterWorks() {
        VariableMap variables = Variables.createVariables();
        variables.put((Object)"input1", null);
        Date now = new Date();
        Date nowMinus2Seconds = new Date(now.getTime() - 2000L);
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowMinus2Seconds);
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
        ClockUtil.setCurrentTime((Date)now);
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
        List decisionInstances = this.optimizeService.getHistoricDecisionInstances(now, now, 10);
        MatcherAssert.assertThat((Object)decisionInstances.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void maxResultsParameterWorks() {
        VariableMap variables = Variables.createVariables();
        variables.put((Object)"input1", null);
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
        List decisionInstances = this.optimizeService.getHistoricDecisionInstances(null, null, 2);
        MatcherAssert.assertThat((Object)decisionInstances.size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void resultIsSortedByEvaluationTime() {
        VariableMap variables = Variables.createVariables();
        variables.put((Object)"input1", null);
        Date now = new Date();
        Date nowMinus2Seconds = new Date(now.getTime() - 2000L);
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowMinus2Seconds);
        ProcessInstance firstProcessInstance = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
        ClockUtil.setCurrentTime((Date)now);
        ProcessInstance secondProcessInstance = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        ProcessInstance thirdProcessInstance = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
        List decisionInstances = this.optimizeService.getHistoricDecisionInstances(this.pastDate(), null, 3);
        MatcherAssert.assertThat((Object)decisionInstances.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((HistoricDecisionInstance)decisionInstances.get(0)).getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)firstProcessInstance.getId()));
        MatcherAssert.assertThat((Object)((HistoricDecisionInstance)decisionInstances.get(1)).getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)secondProcessInstance.getId()));
        MatcherAssert.assertThat((Object)((HistoricDecisionInstance)decisionInstances.get(2)).getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)thirdProcessInstance.getId()));
    }

    private Date pastDate() {
        return new Date(2L);
    }

    protected void createUser(String userId) {
        User user = this.identityService.newUser(userId);
        this.identityService.saveUser(user);
    }

    private void assertThatDecisionsHaveAllImportantInformation(List<HistoricDecisionInstance> decisionInstances) {
        MatcherAssert.assertThat((Object)decisionInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricDecisionInstance decisionInstance = decisionInstances.get(0);
        MatcherAssert.assertThat((Object)decisionInstance, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)decisionInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)"testProcess"));
        MatcherAssert.assertThat((Object)decisionInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)decisionInstance.getDecisionDefinitionId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)decisionInstance.getDecisionDefinitionKey(), (Matcher)CoreMatchers.is((Object)"testDecision"));
        MatcherAssert.assertThat((Object)decisionInstance.getDecisionDefinitionName(), (Matcher)CoreMatchers.is((Object)"sample decision"));
        MatcherAssert.assertThat((Object)decisionInstance.getActivityId(), (Matcher)CoreMatchers.is((Object)"task"));
        MatcherAssert.assertThat((Object)decisionInstance.getActivityInstanceId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)decisionInstance.getProcessInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)decisionInstance.getRootProcessInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)decisionInstance.getCaseDefinitionKey(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)decisionInstance.getCaseDefinitionId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)decisionInstance.getCaseInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)decisionInstance.getRootDecisionInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)decisionInstance.getDecisionRequirementsDefinitionId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)decisionInstance.getDecisionRequirementsDefinitionKey(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)decisionInstance.getEvaluationTime(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

