/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.NativeProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.DummySerializable;
import org.camunda.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.camunda.bpm.engine.test.api.runtime.migration.models.CompensationModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.EndEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class ProcessInstanceQueryTest {
    public static final BpmnModelInstance FORK_JOIN_SUB_PROCESS_MODEL = ((UserTaskBuilder)ProcessModels.newModel().startEvent().subProcess("subProcess").embeddedSubProcess().startEvent().parallelGateway("fork").userTask("userTask1").name("completeMe")).parallelGateway("join").endEvent().moveToNode("fork").userTask("userTask2").connectTo("join").subProcessDone().endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    private static String PROCESS_DEFINITION_KEY = "oneTaskProcess";
    private static String PROCESS_DEFINITION_KEY_2 = "otherOneTaskProcess";
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;
    protected ManagementService managementService;
    protected CaseService caseService;
    protected List<String> processInstanceIds;

    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.managementService = this.engineRule.getManagementService();
        this.caseService = this.engineRule.getCaseService();
    }

    @Before
    public void deployTestProcesses() throws Exception {
        org.camunda.bpm.engine.repository.Deployment deployment = this.engineRule.getRepositoryService().createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/api/runtime/otherOneTaskProcess.bpmn20.xml").deploy();
        this.engineRule.manageDeployment(deployment);
        RuntimeService runtimeService = this.engineRule.getRuntimeService();
        this.processInstanceIds = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            this.processInstanceIds.add(runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY, i + "").getId());
        }
        this.processInstanceIds.add(runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY_2, "businessKey_123").getId());
    }

    @Test
    public void testQueryNoSpecificsList() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertEquals((long)5L, (long)query.count());
        Assert.assertEquals((long)5L, (long)query.list().size());
    }

    @Test
    public void testQueryNoSpecificsSingleResult() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        try {
            query.singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByProcessDefinitionKeySingleResult() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY_2);
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertNotNull((Object)query.singleResult());
    }

    @Test
    public void testQueryByInvalidProcessDefinitionKey() {
        Assert.assertNull((Object)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("invalid").singleResult());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("invalid").list().size());
    }

    @Test
    public void testQueryByProcessDefinitionKeyMultipleResults() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY);
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertEquals((long)4L, (long)query.list().size());
        try {
            query.singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByProcessInstanceId() {
        for (String processInstanceId : this.processInstanceIds) {
            Assert.assertNotNull((Object)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult());
            Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).list().size());
        }
    }

    @Test
    public void testQueryByBusinessKeyAndProcessDefinitionKey() {
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("0", PROCESS_DEFINITION_KEY).count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("1", PROCESS_DEFINITION_KEY).count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("2", PROCESS_DEFINITION_KEY).count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("3", PROCESS_DEFINITION_KEY).count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("businessKey_123", PROCESS_DEFINITION_KEY_2).count());
    }

    @Test
    public void testQueryByBusinessKey() {
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("0").count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("1").count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("businessKey_123").count());
    }

    @Test
    public void testQueryByBusinessKeyLike() {
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKeyLike("business%").count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKeyLike("%sinessKey\\_123").count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKeyLike("%siness%").count());
    }

    @Test
    public void testQueryByInvalidBusinessKey() {
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("invalid").count());
        try {
            this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(null).count();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByInvalidProcessInstanceId() {
        Assert.assertNull((Object)this.runtimeService.createProcessInstanceQuery().processInstanceId("I do not exist").singleResult());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceId("I do not exist").list().size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testQueryBySuperProcessInstanceId() {
        ProcessInstance superProcessInstance = this.runtimeService.startProcessInstanceByKey("subProcessQueryTest");
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(superProcessInstance.getId());
        ProcessInstance subProcessInstance = (ProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)subProcessInstance);
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testQueryByInvalidSuperProcessInstanceId() {
        Assert.assertNull((Object)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId("invalid").singleResult());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId("invalid").list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    @Test
    public void testQueryBySubProcessInstanceId() {
        ProcessInstance superProcessInstance = this.runtimeService.startProcessInstanceByKey("subProcessQueryTest");
        ProcessInstance subProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(superProcessInstance.getId()).singleResult();
        Assert.assertNotNull((Object)subProcessInstance);
        Assert.assertEquals((Object)superProcessInstance.getId(), (Object)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().subProcessInstanceId(subProcessInstance.getId()).singleResult()).getId());
    }

    @Test
    public void testQueryByInvalidSubProcessInstanceId() {
        Assert.assertNull((Object)this.runtimeService.createProcessInstanceQuery().subProcessInstanceId("invalid").singleResult());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().subProcessInstanceId("invalid").list().size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcessWithNestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/nestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testQueryBySuperProcessInstanceIdNested() {
        ProcessInstance superProcessInstance = this.runtimeService.startProcessInstanceByKey("nestedSubProcessQueryTest");
        ProcessInstance subProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(superProcessInstance.getId()).singleResult();
        Assert.assertNotNull((Object)subProcessInstance);
        ProcessInstance nestedSubProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(subProcessInstance.getId()).singleResult();
        Assert.assertNotNull((Object)nestedSubProcessInstance);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcessWithNestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/nestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testQueryBySubProcessInstanceIdNested() {
        ProcessInstance superProcessInstance = this.runtimeService.startProcessInstanceByKey("nestedSubProcessQueryTest");
        ProcessInstance subProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(superProcessInstance.getId()).singleResult();
        Assert.assertEquals((Object)superProcessInstance.getId(), (Object)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().subProcessInstanceId(subProcessInstance.getId()).singleResult()).getId());
        ProcessInstance nestedSubProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(subProcessInstance.getId()).singleResult();
        Assert.assertEquals((Object)subProcessInstance.getId(), (Object)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().subProcessInstanceId(nestedSubProcessInstance.getId()).singleResult()).getId());
    }

    @Test
    public void testQueryPaging() {
        Assert.assertEquals((long)4L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).count());
        Assert.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).listPage(0, 2).size());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).listPage(1, 3).size());
    }

    @Test
    public void testQuerySorting() {
        List processInstances = ((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().orderByProcessInstanceId().asc()).list();
        Assert.assertEquals((long)5L, (long)processInstances.size());
        TestOrderingUtil.verifySorting(processInstances, TestOrderingUtil.processInstanceByProcessInstanceId());
        processInstances = ((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().orderByProcessDefinitionId().asc()).list();
        Assert.assertEquals((long)5L, (long)processInstances.size());
        TestOrderingUtil.verifySorting(processInstances, TestOrderingUtil.processInstanceByProcessDefinitionId());
        processInstances = ((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().orderByBusinessKey().asc()).list();
        Assert.assertEquals((long)5L, (long)processInstances.size());
        TestOrderingUtil.verifySorting(processInstances, TestOrderingUtil.processInstanceByBusinessKey());
        Assert.assertEquals((long)5L, (long)((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().orderByProcessDefinitionKey().asc()).list().size());
        Assert.assertEquals((long)5L, (long)((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().orderByProcessInstanceId().desc()).list().size());
        Assert.assertEquals((long)5L, (long)((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().orderByProcessDefinitionId().desc()).list().size());
        Assert.assertEquals((long)5L, (long)((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().orderByProcessDefinitionKey().desc()).list().size());
        Assert.assertEquals((long)5L, (long)((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().orderByBusinessKey().desc()).list().size());
        Assert.assertEquals((long)4L, (long)((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).orderByProcessInstanceId().asc()).list().size());
        Assert.assertEquals((long)4L, (long)((ProcessInstanceQuery)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).orderByProcessInstanceId().desc()).list().size());
    }

    @Test
    public void testQueryInvalidSorting() {
        try {
            this.runtimeService.createProcessInstanceQuery().orderByProcessDefinitionId().list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryStringVariable() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("stringVar", "abcdef");
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "abcdef");
        vars.put("stringVar2", "ghijkl");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "azerty");
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("stringVar", (Object)"abcdef");
        List processInstances = query.list();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)2L, (long)processInstances.size());
        query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("stringVar", (Object)"abcdef").variableValueEquals("stringVar2", (Object)"ghijkl");
        ProcessInstance resultInstance = (ProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance2.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("stringVar", (Object)"abcdef").singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("stringVar", (Object)"abcdef").singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("stringVar", (Object)"z").singleResult();
        Assert.assertNull((Object)resultInstance);
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("stringVar", (Object)"abcdef").count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("stringVar", (Object)"z").count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThan("stringVar", (Object)"abcdeg").list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
        List<String> expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(((ProcessInstance)processInstances.get(0)).getId(), ((ProcessInstance)processInstances.get(1)).getId()));
        ids.removeAll(expecedIds);
        Assert.assertTrue((boolean)ids.isEmpty());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("stringVar", (Object)"abcdef").count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("stringVar", (Object)"z").count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("stringVar", (Object)"abcdef").list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
        expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ids = new ArrayList<String>(Arrays.asList(((ProcessInstance)processInstances.get(0)).getId(), ((ProcessInstance)processInstances.get(1)).getId()));
        ids.removeAll(expecedIds);
        Assert.assertTrue((boolean)ids.isEmpty());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("stringVar", (Object)"z").count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("stringVar", (Object)"aa").count());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueLike("stringVar", "azert%").singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueLike("stringVar", "%y").singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueLike("stringVar", "%zer%").singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLike("stringVar", "a%").count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLike("stringVar", "%x%").count());
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance3.getId(), "test");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryLongVariable() {
        HashMap<String, Long> vars = new HashMap<String, Long>();
        vars.put("longVar", 12345L);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("longVar", 12345L);
        vars.put("longVar2", 67890L);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("longVar", 55555L);
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("longVar", (Object)12345L);
        List processInstances = query.list();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)2L, (long)processInstances.size());
        query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("longVar", (Object)12345L).variableValueEquals("longVar2", (Object)67890L);
        ProcessInstance resultInstance = (ProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance2.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueEquals("longVar", (Object)999L).singleResult();
        Assert.assertNull((Object)resultInstance);
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("longVar", (Object)12345L).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("longVar", (Object)44444L).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("longVar", (Object)55555L).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("longVar", (Object)1L).count());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("longVar", (Object)44444L).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("longVar", (Object)55555L).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("longVar", (Object)1L).count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThan("longVar", (Object)55555L).list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
        List<String> expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(((ProcessInstance)processInstances.get(0)).getId(), ((ProcessInstance)processInstances.get(1)).getId()));
        ids.removeAll(expecedIds);
        Assert.assertTrue((boolean)ids.isEmpty());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("longVar", (Object)12345L).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("longVar", (Object)66666L).count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("longVar", (Object)55555L).list();
        Assert.assertEquals((long)3L, (long)processInstances.size());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("longVar", (Object)12344L).count());
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance3.getId(), "test");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryDoubleVariable() {
        HashMap<String, Double> vars = new HashMap<String, Double>();
        vars.put("doubleVar", 12345.6789);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("doubleVar", 12345.6789);
        vars.put("doubleVar2", 9876.54321);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("doubleVar", 55555.5555);
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("doubleVar", (Object)12345.6789);
        List processInstances = query.list();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)2L, (long)processInstances.size());
        query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("doubleVar", (Object)12345.6789).variableValueEquals("doubleVar2", (Object)9876.54321);
        ProcessInstance resultInstance = (ProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance2.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueEquals("doubleVar", (Object)9999.99).singleResult();
        Assert.assertNull((Object)resultInstance);
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("doubleVar", (Object)12345.6789).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("doubleVar", (Object)44444.4444).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("doubleVar", (Object)55555.5555).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("doubleVar", (Object)1.234).count());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("doubleVar", (Object)44444.4444).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("doubleVar", (Object)55555.5555).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("doubleVar", (Object)1.234).count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThan("doubleVar", (Object)55555.5555).list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
        List<String> expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(((ProcessInstance)processInstances.get(0)).getId(), ((ProcessInstance)processInstances.get(1)).getId()));
        ids.removeAll(expecedIds);
        Assert.assertTrue((boolean)ids.isEmpty());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("doubleVar", (Object)12345.6789).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("doubleVar", (Object)66666.6666).count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("doubleVar", (Object)55555.5555).list();
        Assert.assertEquals((long)3L, (long)processInstances.size());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("doubleVar", (Object)12344.6789).count());
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance3.getId(), "test");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryIntegerVariable() {
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("integerVar", 12345);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("integerVar", 12345);
        vars.put("integerVar2", 67890);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("integerVar", 55555);
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("integerVar", (Object)12345);
        List processInstances = query.list();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)2L, (long)processInstances.size());
        query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("integerVar", (Object)12345).variableValueEquals("integerVar2", (Object)67890);
        ProcessInstance resultInstance = (ProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance2.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueEquals("integerVar", (Object)9999).singleResult();
        Assert.assertNull((Object)resultInstance);
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("integerVar", (Object)12345).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("integerVar", (Object)44444).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("integerVar", (Object)55555).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("integerVar", (Object)1).count());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("integerVar", (Object)44444).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("integerVar", (Object)55555).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("integerVar", (Object)1).count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThan("integerVar", (Object)55555).list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
        List<String> expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(((ProcessInstance)processInstances.get(0)).getId(), ((ProcessInstance)processInstances.get(1)).getId()));
        ids.removeAll(expecedIds);
        Assert.assertTrue((boolean)ids.isEmpty());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("integerVar", (Object)12345).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("integerVar", (Object)66666).count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("integerVar", (Object)55555).list();
        Assert.assertEquals((long)3L, (long)processInstances.size());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("integerVar", (Object)12344).count());
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance3.getId(), "test");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryShortVariable() {
        HashMap<String, Short> vars = new HashMap<String, Short>();
        short shortVar = 1234;
        vars.put("shortVar", shortVar);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        short shortVar2 = 6789;
        vars = new HashMap();
        vars.put("shortVar", shortVar);
        vars.put("shortVar2", shortVar2);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("shortVar", (short)5555);
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("shortVar", (Object)shortVar);
        List processInstances = query.list();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)2L, (long)processInstances.size());
        query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("shortVar", (Object)shortVar).variableValueEquals("shortVar2", (Object)shortVar2);
        ProcessInstance resultInstance = (ProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance2.getId(), (Object)resultInstance.getId());
        short unexistingValue = 9999;
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueEquals("shortVar", (Object)unexistingValue).singleResult();
        Assert.assertNull((Object)resultInstance);
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("shortVar", (Object)1234).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("shortVar", (Object)4444).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("shortVar", (Object)5555).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("shortVar", (Object)1).count());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("shortVar", (Object)4444).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("shortVar", (Object)5555).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("shortVar", (Object)1).count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThan("shortVar", (Object)5555).list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
        List<String> expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(((ProcessInstance)processInstances.get(0)).getId(), ((ProcessInstance)processInstances.get(1)).getId()));
        ids.removeAll(expecedIds);
        Assert.assertTrue((boolean)ids.isEmpty());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("shortVar", (Object)1234).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("shortVar", (Object)6666).count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("shortVar", (Object)5555).list();
        Assert.assertEquals((long)3L, (long)processInstances.size());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("shortVar", (Object)1233).count());
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance3.getId(), "test");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryDateVariable() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        Date date1 = Calendar.getInstance().getTime();
        vars.put("dateVar", date1);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        Date date2 = Calendar.getInstance().getTime();
        vars = new HashMap();
        vars.put("dateVar", date1);
        vars.put("dateVar2", date2);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        Calendar nextYear = Calendar.getInstance();
        nextYear.add(1, 1);
        vars = new HashMap();
        vars.put("dateVar", nextYear.getTime());
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        Calendar nextMonth = Calendar.getInstance();
        nextMonth.add(2, 1);
        Calendar twoYearsLater = Calendar.getInstance();
        twoYearsLater.add(1, 2);
        Calendar oneYearAgo = Calendar.getInstance();
        oneYearAgo.add(1, -1);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("dateVar", (Object)date1);
        List processInstances = query.list();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)2L, (long)processInstances.size());
        query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("dateVar", (Object)date1).variableValueEquals("dateVar2", (Object)date2);
        ProcessInstance resultInstance = (ProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance2.getId(), (Object)resultInstance.getId());
        Date unexistingDate = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("01/01/1989 12:00:00");
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueEquals("dateVar", (Object)unexistingDate).singleResult();
        Assert.assertNull((Object)resultInstance);
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("dateVar", (Object)date1).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("dateVar", (Object)nextMonth.getTime()).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("dateVar", (Object)nextYear.getTime()).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("dateVar", (Object)oneYearAgo.getTime()).count());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("dateVar", (Object)nextMonth.getTime()).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("dateVar", (Object)nextYear.getTime()).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("dateVar", (Object)oneYearAgo.getTime()).count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThan("dateVar", (Object)nextYear.getTime()).list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
        List<String> expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(((ProcessInstance)processInstances.get(0)).getId(), ((ProcessInstance)processInstances.get(1)).getId()));
        ids.removeAll(expecedIds);
        Assert.assertTrue((boolean)ids.isEmpty());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("dateVar", (Object)date1).count());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("dateVar", (Object)twoYearsLater.getTime()).count());
        processInstances = this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("dateVar", (Object)nextYear.getTime()).list();
        Assert.assertEquals((long)3L, (long)processInstances.size());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("dateVar", (Object)oneYearAgo.getTime()).count());
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance3.getId(), "test");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testBooleanVariable() throws Exception {
        HashMap<String, Boolean> vars = new HashMap<String, Boolean>();
        vars.put("booleanVar", true);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("booleanVar", false);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        List instances = this.runtimeService.createProcessInstanceQuery().variableValueEquals("booleanVar", (Object)true).list();
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((Object)processInstance1.getId(), (Object)((ProcessInstance)instances.get(0)).getId());
        instances = this.runtimeService.createProcessInstanceQuery().variableValueEquals("booleanVar", (Object)false).list();
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((Object)processInstance2.getId(), (Object)((ProcessInstance)instances.get(0)).getId());
        instances = this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("booleanVar", (Object)true).list();
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((Object)processInstance2.getId(), (Object)((ProcessInstance)instances.get(0)).getId());
        instances = this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("booleanVar", (Object)false).list();
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((Object)processInstance1.getId(), (Object)((ProcessInstance)instances.get(0)).getId());
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("booleanVar", (Object)true);
            Assert.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)CoreMatchers.containsString((String)"Booleans and null cannot be used in 'greater than' condition"));
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("booleanVar", (Object)true);
            Assert.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)CoreMatchers.containsString((String)"Booleans and null cannot be used in 'greater than or equal' condition"));
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueLessThan("booleanVar", (Object)true);
            Assert.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)CoreMatchers.containsString((String)"Booleans and null cannot be used in 'less than' condition"));
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("booleanVar", (Object)true);
            Assert.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)CoreMatchers.containsString((String)"Booleans and null cannot be used in 'less than or equal' condition"));
        }
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryVariablesUpdatedToNullValue() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("longVar", 928374L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "coca-cola");
        variables.put("dateVar", new Date());
        variables.put("booleanVar", true);
        variables.put("nullVar", null);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("longVar", null).variableValueEquals("shortVar", null).variableValueEquals("integerVar", null).variableValueEquals("stringVar", null).variableValueEquals("booleanVar", null).variableValueEquals("dateVar", null);
        ProcessInstanceQuery notQuery = this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("longVar", null).variableValueNotEquals("shortVar", null).variableValueNotEquals("integerVar", null).variableValueNotEquals("stringVar", null).variableValueNotEquals("booleanVar", null).variableValueNotEquals("dateVar", null);
        Assert.assertNull((Object)query.singleResult());
        Assert.assertNotNull((Object)notQuery.singleResult());
        this.runtimeService.setVariable(processInstance.getId(), "longVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "shortVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "integerVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "stringVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "dateVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "nullVar", null);
        this.runtimeService.setVariable(processInstance.getId(), "booleanVar", null);
        Execution queryResult = (Execution)query.singleResult();
        Assert.assertNotNull((Object)queryResult);
        Assert.assertEquals((Object)processInstance.getId(), (Object)queryResult.getId());
        Assert.assertNull((Object)notQuery.singleResult());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryNullVariable() throws Exception {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("nullVar", null);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("nullVar", "notnull");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("nullVarLong", "notnull");
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("nullVarDouble", "notnull");
        ProcessInstance processInstance4 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("nullVarByte", "testbytes".getBytes());
        ProcessInstance processInstance5 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("nullVar", null);
        List processInstances = query.list();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)1L, (long)processInstances.size());
        Assert.assertEquals((Object)processInstance1.getId(), (Object)((ProcessInstance)processInstances.get(0)).getId());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("nullVar", null).count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("nullVarLong", null).count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("nullVarDouble", null).count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("nullVarByte", null).count());
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("nullVar", null);
            Assert.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)CoreMatchers.containsString((String)"Booleans and null cannot be used in 'greater than' condition"));
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("nullVar", null);
            Assert.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)CoreMatchers.containsString((String)"Booleans and null cannot be used in 'greater than or equal' condition"));
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueLessThan("nullVar", null);
            Assert.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)CoreMatchers.containsString((String)"Booleans and null cannot be used in 'less than' condition"));
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("nullVar", null);
            Assert.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)CoreMatchers.containsString((String)"Booleans and null cannot be used in 'less than or equal' condition"));
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueLike("nullVar", null);
            Assert.fail((String)"Excetion expected");
        }
        catch (ProcessEngineException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)CoreMatchers.containsString((String)"Booleans and null cannot be used in 'like' condition"));
        }
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance3.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance4.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance5.getId(), "test");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryInvalidTypes() throws Exception {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("bytesVar", "test".getBytes());
        vars.put("serializableVar", new DummySerializable());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueEquals("bytesVar", (Object)"test".getBytes()).list();
            Assert.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)CoreMatchers.containsString((String)"Variables of type ByteArray cannot be used to query"));
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueEquals("serializableVar", (Object)new DummySerializable()).list();
            Assert.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)CoreMatchers.containsString((String)"Object values cannot be used to query"));
        }
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
    }

    @Test
    public void testQueryVariablesNullNameArgument() {
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueEquals(null, (Object)"value");
            Assert.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)CoreMatchers.containsString((String)"name is null"));
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueNotEquals(null, (Object)"value");
            Assert.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)CoreMatchers.containsString((String)"name is null"));
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan(null, (Object)"value");
            Assert.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)CoreMatchers.containsString((String)"name is null"));
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual(null, (Object)"value");
            Assert.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)CoreMatchers.containsString((String)"name is null"));
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueLessThan(null, (Object)"value");
            Assert.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)CoreMatchers.containsString((String)"name is null"));
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual(null, (Object)"value");
            Assert.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)CoreMatchers.containsString((String)"name is null"));
        }
        try {
            this.runtimeService.createProcessInstanceQuery().variableValueLike(null, "value");
            Assert.fail((String)"Expected exception");
        }
        catch (ProcessEngineException ae) {
            Assert.assertThat((Object)ae.getMessage(), (Matcher)CoreMatchers.containsString((String)"name is null"));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryAllVariableTypes() throws Exception {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("nullVar", null);
        vars.put("stringVar", "string");
        vars.put("longVar", 10L);
        vars.put("doubleVar", 1.2);
        vars.put("integerVar", 1234);
        vars.put("booleanVar", true);
        vars.put("shortVar", (short)123);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().variableValueEquals("nullVar", null).variableValueEquals("stringVar", (Object)"string").variableValueEquals("longVar", (Object)10L).variableValueEquals("doubleVar", (Object)1.2).variableValueEquals("integerVar", (Object)1234).variableValueEquals("booleanVar", (Object)true).variableValueEquals("shortVar", (Object)123);
        List processInstances = query.list();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)1L, (long)processInstances.size());
        Assert.assertEquals((Object)processInstance.getId(), (Object)((ProcessInstance)processInstances.get(0)).getId());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testClashingValues() throws Exception {
        HashMap<String, Long> vars = new HashMap<String, Long>();
        vars.put("var", 1234L);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        HashMap<String, Integer> vars2 = new HashMap<String, Integer>();
        vars2.put("var", 1234);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars2);
        List foundInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").variableValueEquals("var", (Object)1234L).list();
        Assert.assertEquals((long)1L, (long)foundInstances.size());
        Assert.assertEquals((Object)processInstance.getId(), (Object)((ProcessInstance)foundInstances.get(0)).getId());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
    }

    @Test
    public void testQueryByProcessInstanceIds() {
        HashSet<String> processInstanceIds = new HashSet<String>(this.processInstanceIds);
        this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY_2, "2");
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceIds(processInstanceIds);
        Assert.assertEquals((long)5L, (long)processInstanceQuery.count());
        List processInstances = processInstanceQuery.list();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)5L, (long)processInstances.size());
        for (ProcessInstance processInstance : processInstances) {
            Assert.assertTrue((boolean)processInstanceIds.contains(processInstance.getId()));
        }
    }

    @Test
    public void testQueryByProcessInstanceIdsEmpty() {
        try {
            this.runtimeService.createProcessInstanceQuery().processInstanceIds(new HashSet());
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            Assert.assertThat((Object)re.getMessage(), (Matcher)CoreMatchers.containsString((String)"Set of process instance ids is empty"));
        }
    }

    @Test
    public void testQueryByProcessInstanceIdsNull() {
        try {
            this.runtimeService.createProcessInstanceQuery().processInstanceIds(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            Assert.assertThat((Object)re.getMessage(), (Matcher)CoreMatchers.containsString((String)"Set of process instance ids is null"));
        }
    }

    @Test
    public void testQueryByActive() throws Exception {
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery();
        Assert.assertEquals((long)5L, (long)processInstanceQuery.active().count());
        this.repositoryService.suspendProcessDefinitionByKey(PROCESS_DEFINITION_KEY);
        Assert.assertEquals((long)5L, (long)processInstanceQuery.active().count());
        this.repositoryService.suspendProcessDefinitionByKey(PROCESS_DEFINITION_KEY, true, null);
        Assert.assertEquals((long)1L, (long)processInstanceQuery.active().count());
    }

    @Test
    public void testQueryBySuspended() throws Exception {
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery();
        Assert.assertEquals((long)0L, (long)processInstanceQuery.suspended().count());
        this.repositoryService.suspendProcessDefinitionByKey(PROCESS_DEFINITION_KEY);
        Assert.assertEquals((long)0L, (long)processInstanceQuery.suspended().count());
        this.repositoryService.suspendProcessDefinitionByKey(PROCESS_DEFINITION_KEY, true, null);
        Assert.assertEquals((long)4L, (long)processInstanceQuery.suspended().count());
    }

    @Test
    public void testNativeQuery() {
        String tablePrefix = this.engineRule.getProcessEngineConfiguration().getDatabaseTablePrefix();
        Assert.assertEquals((Object)(tablePrefix + "ACT_RU_EXECUTION"), (Object)this.managementService.getTableName(ProcessInstance.class));
        long piCount = this.runtimeService.createProcessInstanceQuery().count();
        Assert.assertEquals((long)piCount, (long)((NativeProcessInstanceQuery)this.runtimeService.createNativeProcessInstanceQuery().sql("SELECT * FROM " + this.managementService.getTableName(ProcessInstance.class))).list().size());
        Assert.assertEquals((long)piCount, (long)((NativeProcessInstanceQuery)this.runtimeService.createNativeProcessInstanceQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(ProcessInstance.class))).count());
    }

    @Test
    public void testNativeQueryPaging() {
        Assert.assertEquals((long)5L, (long)((NativeProcessInstanceQuery)this.runtimeService.createNativeProcessInstanceQuery().sql("SELECT * FROM " + this.managementService.getTableName(ProcessInstance.class))).listPage(0, 5).size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.testHelper.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        Assert.assertEquals((long)1L, (long)incidentList.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        List processInstanceList = this.runtimeService.createProcessInstanceQuery().incidentId(incident.getId()).list();
        Assert.assertEquals((long)1L, (long)processInstanceList.size());
    }

    @Test
    public void testQueryByInvalidIncidentId() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertEquals((long)0L, (long)query.incidentId("invalid").count());
        try {
            query.incidentId(null);
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentType() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.testHelper.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        Assert.assertEquals((long)1L, (long)incidentList.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        List processInstanceList = this.runtimeService.createProcessInstanceQuery().incidentType(incident.getIncidentType()).list();
        Assert.assertEquals((long)1L, (long)processInstanceList.size());
    }

    @Test
    public void testQueryByInvalidIncidentType() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertEquals((long)0L, (long)query.incidentType("invalid").count());
        try {
            query.incidentType(null);
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentMessage() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.testHelper.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        Assert.assertEquals((long)1L, (long)incidentList.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        List processInstanceList = this.runtimeService.createProcessInstanceQuery().incidentMessage(incident.getIncidentMessage()).list();
        Assert.assertEquals((long)1L, (long)processInstanceList.size());
    }

    @Test
    public void testQueryByInvalidIncidentMessage() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertEquals((long)0L, (long)query.incidentMessage("invalid").count());
        try {
            query.incidentMessage(null);
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentMessageLike() {
        this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.testHelper.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        Assert.assertEquals((long)1L, (long)incidentList.size());
        List processInstanceList = this.runtimeService.createProcessInstanceQuery().incidentMessageLike("%\\_exception%").list();
        Assert.assertEquals((long)1L, (long)processInstanceList.size());
    }

    @Test
    public void testQueryByInvalidIncidentMessageLike() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertEquals((long)0L, (long)query.incidentMessageLike("invalid").count());
        try {
            query.incidentMessageLike(null);
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingSubProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentIdInSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingSubProcess");
        this.testHelper.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        Assert.assertEquals((long)1L, (long)incidentList.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        List processInstanceList = this.runtimeService.createProcessInstanceQuery().incidentId(incident.getId()).list();
        Assert.assertEquals((long)1L, (long)processInstanceList.size());
        Assert.assertEquals((Object)processInstance.getId(), (Object)((ProcessInstance)processInstanceList.get(0)).getId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingSubProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentTypeInSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingSubProcess");
        this.testHelper.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        Assert.assertEquals((long)1L, (long)incidentList.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        List processInstanceList = this.runtimeService.createProcessInstanceQuery().incidentType(incident.getIncidentType()).list();
        Assert.assertEquals((long)1L, (long)processInstanceList.size());
        Assert.assertEquals((Object)processInstance.getId(), (Object)((ProcessInstance)processInstanceList.get(0)).getId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingSubProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentMessageInSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingSubProcess");
        this.testHelper.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        Assert.assertEquals((long)1L, (long)incidentList.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        List processInstanceList = this.runtimeService.createProcessInstanceQuery().incidentMessage(incident.getIncidentMessage()).list();
        Assert.assertEquals((long)1L, (long)processInstanceList.size());
        Assert.assertEquals((Object)processInstance.getId(), (Object)((ProcessInstance)processInstanceList.get(0)).getId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/failingSubProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentMessageLikeInSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingSubProcess");
        this.testHelper.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        Assert.assertEquals((long)1L, (long)incidentList.size());
        List processInstanceList = this.runtimeService.createProcessInstanceQuery().incidentMessageLike("%exception%").list();
        Assert.assertEquals((long)1L, (long)processInstanceList.size());
        Assert.assertEquals((Object)processInstance.getId(), (Object)((ProcessInstance)processInstanceList.get(0)).getId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByCaseInstanceId() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("oneProcessTaskCase").create().getId();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        query.caseInstanceId(caseInstanceId);
        Assert.assertEquals((long)1L, (long)query.count());
        List result = query.list();
        Assert.assertEquals((long)1L, (long)result.size());
        ProcessInstance processInstance = (ProcessInstance)result.get(0);
        Assert.assertEquals((Object)caseInstanceId, (Object)processInstance.getCaseInstanceId());
    }

    @Test
    public void testQueryByInvalidCaseInstanceId() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        query.caseInstanceId("invalid");
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            query.caseInstanceId(null);
            Assert.fail((String)"The passed case instance should not be null.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superCase.cmmn", "org/camunda/bpm/engine/test/api/runtime/superProcessWithCallActivityInsideSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testQueryByCaseInstanceIdHierarchy() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("oneProcessTaskCase").businessKey("aBusinessKey").create().getId();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        query.caseInstanceId(caseInstanceId);
        Assert.assertEquals((long)2L, (long)query.count());
        List result = query.list();
        Assert.assertEquals((long)2L, (long)result.size());
        ProcessInstance firstProcessInstance = (ProcessInstance)result.get(0);
        Assert.assertEquals((Object)caseInstanceId, (Object)firstProcessInstance.getCaseInstanceId());
        ProcessInstance secondProcessInstance = (ProcessInstance)result.get(1);
        Assert.assertEquals((Object)caseInstanceId, (Object)secondProcessInstance.getCaseInstanceId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessVariableValueEqualsNumber() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123L));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 12345L));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", (short)123));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123.0));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", null));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", Variables.longValue(null)));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "123"));
        Assert.assertEquals((long)4L, (long)this.runtimeService.createProcessInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)4L, (long)this.runtimeService.createProcessInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123L)).count());
        Assert.assertEquals((long)4L, (long)this.runtimeService.createProcessInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123.0)).count());
        Assert.assertEquals((long)4L, (long)this.runtimeService.createProcessInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue(null)).count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessVariableValueNumberComparison() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123L));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 12345L));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", (short)123));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123.0));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", null));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", Variables.longValue(null)));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "123"));
        Assert.assertEquals((long)4L, (long)this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThan("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)5L, (long)this.runtimeService.createProcessInstanceQuery().variableValueGreaterThanOrEqual("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThan("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)4L, (long)this.runtimeService.createProcessInstanceQuery().variableValueLessThanOrEqual("var", (Object)Variables.numberValue((Number)123)).count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn"})
    public void testQueryBySuperCaseInstanceId() {
        String superCaseInstanceId = this.caseService.createCaseInstanceByKey("oneProcessTaskCase").getId();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().superCaseInstanceId(superCaseInstanceId);
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
        ProcessInstance subProcessInstance = (ProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)subProcessInstance);
    }

    @Test
    public void testQueryByInvalidSuperCaseInstanceId() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertNull((Object)query.superProcessInstanceId("invalid").singleResult());
        Assert.assertEquals((long)0L, (long)query.superProcessInstanceId("invalid").list().size());
        try {
            query.superCaseInstanceId(null);
            Assert.fail();
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcessWithCaseCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryBySubCaseInstanceId() {
        String superProcessInstanceId = this.runtimeService.startProcessInstanceByKey("subProcessQueryTest").getId();
        String subCaseInstanceId = ((CaseInstance)this.caseService.createCaseInstanceQuery().superProcessInstanceId(superProcessInstanceId).singleResult()).getId();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().subCaseInstanceId(subCaseInstanceId);
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
        ProcessInstance superProcessInstance = (ProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)superProcessInstance);
        Assert.assertEquals((Object)superProcessInstanceId, (Object)superProcessInstance.getId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcessWithCaseCallActivityInsideSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryBySubCaseInstanceIdNested() {
        String superProcessInstanceId = this.runtimeService.startProcessInstanceByKey("subProcessQueryTest").getId();
        String subCaseInstanceId = ((CaseInstance)this.caseService.createCaseInstanceQuery().superProcessInstanceId(superProcessInstanceId).singleResult()).getId();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().subCaseInstanceId(subCaseInstanceId);
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
        ProcessInstance superProcessInstance = (ProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)superProcessInstance);
        Assert.assertEquals((Object)superProcessInstanceId, (Object)superProcessInstance.getId());
    }

    @Test
    public void testQueryByInvalidSubCaseInstanceId() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertNull((Object)query.subProcessInstanceId("invalid").singleResult());
        Assert.assertEquals((long)0L, (long)query.subProcessInstanceId("invalid").list().size());
        try {
            query.subCaseInstanceId(null);
            Assert.fail();
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryNullValue() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValueTyped("var", (TypedValue)Variables.stringValue(null)));
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValueTyped("var", null));
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"a String Value"));
        ProcessInstance processInstance4 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"another String Value"));
        List instances = this.runtimeService.createProcessInstanceQuery().variableValueEquals("var", null).list();
        this.verifyResultContainsExactly(instances, this.asSet(processInstance1.getId(), processInstance2.getId()));
        instances = this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("var", null).list();
        this.verifyResultContainsExactly(instances, this.asSet(processInstance3.getId(), processInstance4.getId()));
        instances = this.runtimeService.createProcessInstanceQuery().variableValueEquals("var", (Object)Variables.stringValue(null)).list();
        this.verifyResultContainsExactly(instances, this.asSet(processInstance1.getId()));
        instances = this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("var", (Object)Variables.stringValue(null)).list();
        this.verifyResultContainsExactly(instances, this.asSet(processInstance2.getId(), processInstance3.getId(), processInstance4.getId()));
        instances = this.runtimeService.createProcessInstanceQuery().variableValueEquals("var", (Object)"a String Value").list();
        this.verifyResultContainsExactly(instances, this.asSet(processInstance3.getId()));
        instances = this.runtimeService.createProcessInstanceQuery().variableValueNotEquals("var", (Object)"a String Value").list();
        this.verifyResultContainsExactly(instances, this.asSet(processInstance1.getId(), processInstance2.getId(), processInstance4.getId()));
    }

    @Test
    public void testQueryByDeploymentId() {
        String firstDeploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        org.camunda.bpm.engine.repository.Deployment secondDeployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml").deploy();
        ProcessInstance secondProcessInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().deploymentId(firstDeploymentId);
        Assert.assertEquals((long)5L, (long)query.count());
        List instances = query.list();
        Assert.assertEquals((long)5L, (long)instances.size());
        for (ProcessInstance returnedInstance : instances) {
            Assert.assertTrue((!returnedInstance.getId().equals(secondProcessInstance.getId()) ? 1 : 0) != 0);
        }
        this.repositoryService.deleteDeployment(secondDeployment.getId(), true);
    }

    @Test
    public void testQueryByInvalidDeploymentId() {
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().deploymentId("invalid").count());
        try {
            this.runtimeService.createProcessInstanceQuery().deploymentId(null).count();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByNullActivityId() {
        try {
            this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{null});
            Assert.fail((String)"exception expected");
        }
        catch (NullValueException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"activity ids contains null value"));
        }
    }

    @Test
    public void testQueryByNullActivityIds() {
        try {
            this.runtimeService.createProcessInstanceQuery().activityIdIn((String[])null);
            Assert.fail((String)"exception expected");
        }
        catch (NullValueException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"activity ids is null"));
        }
    }

    @Test
    public void testQueryByUnknownActivityId() {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"unknown"});
        this.assertNoProcessInstancesReturned(query);
    }

    @Test
    public void testQueryByLeafActivityId() {
        ProcessDefinition oneTaskDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition gatewaySubProcessDefinition = this.testHelper.deployAndGetDefinition(FORK_JOIN_SUB_PROCESS_MODEL);
        ProcessInstance oneTaskInstance1 = this.runtimeService.startProcessInstanceById(oneTaskDefinition.getId());
        ProcessInstance oneTaskInstance2 = this.runtimeService.startProcessInstanceById(oneTaskDefinition.getId());
        ProcessInstance gatewaySubProcessInstance1 = this.runtimeService.startProcessInstanceById(gatewaySubProcessDefinition.getId());
        ProcessInstance gatewaySubProcessInstance2 = this.runtimeService.startProcessInstanceById(gatewaySubProcessDefinition.getId());
        Task task = (Task)this.engineRule.getTaskService().createTaskQuery().processInstanceId(gatewaySubProcessInstance2.getId()).taskName("completeMe").singleResult();
        this.engineRule.getTaskService().complete(task.getId());
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"});
        this.assertReturnedProcessInstances(query, oneTaskInstance1, oneTaskInstance2);
        query = this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask1", "userTask2"});
        this.assertReturnedProcessInstances(query, gatewaySubProcessInstance1, gatewaySubProcessInstance2);
        query = this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask", "userTask1"});
        this.assertReturnedProcessInstances(query, oneTaskInstance1, oneTaskInstance2, gatewaySubProcessInstance1);
        query = this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask", "userTask1", "userTask2"});
        this.assertReturnedProcessInstances(query, oneTaskInstance1, oneTaskInstance2, gatewaySubProcessInstance1, gatewaySubProcessInstance2);
        query = this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"join"});
        this.assertReturnedProcessInstances(query, gatewaySubProcessInstance2);
    }

    @Test
    public void testQueryByNonLeafActivityId() {
        ProcessDefinition processDefinition = this.testHelper.deployAndGetDefinition(FORK_JOIN_SUB_PROCESS_MODEL);
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"subProcess", "fork"});
        this.assertNoProcessInstancesReturned(query);
    }

    @Test
    public void testQueryByAsyncBeforeActivityId() {
        ProcessDefinition testProcess = this.testHelper.deployAndGetDefinition(((EndEventBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((SubProcessBuilder)((StartEventBuilder)ProcessModels.newModel().startEvent("start").camundaAsyncBefore()).subProcess("subProcess").camundaAsyncBefore()).embeddedSubProcess().startEvent().serviceTask("task").camundaAsyncBefore()).camundaExpression("${true}")).endEvent().subProcessDone().endEvent("end").camundaAsyncBefore()).done());
        ProcessInstance instanceBeforeStart = this.runtimeService.startProcessInstanceById(testProcess.getId());
        ProcessInstance instanceBeforeSubProcess = this.runtimeService.startProcessInstanceById(testProcess.getId());
        this.executeJobForProcessInstance(instanceBeforeSubProcess);
        ProcessInstance instanceBeforeTask = this.runtimeService.startProcessInstanceById(testProcess.getId());
        this.executeJobForProcessInstance(instanceBeforeTask);
        this.executeJobForProcessInstance(instanceBeforeTask);
        ProcessInstance instanceBeforeEnd = this.runtimeService.startProcessInstanceById(testProcess.getId());
        this.executeJobForProcessInstance(instanceBeforeEnd);
        this.executeJobForProcessInstance(instanceBeforeEnd);
        this.executeJobForProcessInstance(instanceBeforeEnd);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"start"});
        this.assertReturnedProcessInstances(query, instanceBeforeStart);
        query = this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"subProcess"});
        this.assertReturnedProcessInstances(query, instanceBeforeSubProcess);
        query = this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"task"});
        this.assertReturnedProcessInstances(query, instanceBeforeTask);
        query = this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"end"});
        this.assertReturnedProcessInstances(query, instanceBeforeEnd);
    }

    @Test
    public void testQueryByAsyncAfterActivityId() {
        ProcessDefinition testProcess = this.testHelper.deployAndGetDefinition(((EndEventBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((SubProcessBuilder)((StartEventBuilder)ProcessModels.newModel().startEvent("start").camundaAsyncAfter()).subProcess("subProcess").camundaAsyncAfter()).embeddedSubProcess().startEvent().serviceTask("task").camundaAsyncAfter()).camundaExpression("${true}")).endEvent().subProcessDone().endEvent("end").camundaAsyncAfter()).done());
        ProcessInstance instanceAfterStart = this.runtimeService.startProcessInstanceById(testProcess.getId());
        ProcessInstance instanceAfterTask = this.runtimeService.startProcessInstanceById(testProcess.getId());
        this.executeJobForProcessInstance(instanceAfterTask);
        ProcessInstance instanceAfterSubProcess = this.runtimeService.startProcessInstanceById(testProcess.getId());
        this.executeJobForProcessInstance(instanceAfterSubProcess);
        this.executeJobForProcessInstance(instanceAfterSubProcess);
        ProcessInstance instanceAfterEnd = this.runtimeService.startProcessInstanceById(testProcess.getId());
        this.executeJobForProcessInstance(instanceAfterEnd);
        this.executeJobForProcessInstance(instanceAfterEnd);
        this.executeJobForProcessInstance(instanceAfterEnd);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"start"});
        this.assertReturnedProcessInstances(query, instanceAfterStart);
        query = this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"task"});
        this.assertReturnedProcessInstances(query, instanceAfterTask);
        query = this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"subProcess"});
        this.assertReturnedProcessInstances(query, instanceAfterSubProcess);
        query = this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"end"});
        this.assertReturnedProcessInstances(query, instanceAfterEnd);
    }

    @Test
    public void testQueryByActivityIdBeforeCompensation() {
        ProcessDefinition testProcess = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        this.runtimeService.startProcessInstanceById(testProcess.getId());
        this.testHelper.completeTask("userTask1");
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"subProcess"});
        this.assertNoProcessInstancesReturned(query);
    }

    @Test
    public void testQueryByActivityIdDuringCompensation() {
        ProcessDefinition testProcess = this.testHelper.deployAndGetDefinition(CompensationModels.COMPENSATION_ONE_TASK_SUBPROCESS_MODEL);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(testProcess.getId());
        this.testHelper.completeTask("userTask1");
        this.testHelper.completeTask("userTask2");
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"subProcess"});
        this.assertReturnedProcessInstances(query, processInstance);
        query = this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"compensationEvent"});
        this.assertReturnedProcessInstances(query, processInstance);
        query = this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"compensationHandler"});
        this.assertReturnedProcessInstances(query, processInstance);
    }

    @Test
    public void testQueryByRootProcessInstances() {
        String superProcess = "calling";
        String subProcess = "called";
        BpmnModelInstance callingInstance = ((CallActivityBuilder)ProcessModels.newModel(superProcess).startEvent().callActivity().calledElement(subProcess)).endEvent().done();
        BpmnModelInstance calledInstance = ProcessModels.newModel(subProcess).startEvent().userTask().endEvent().done();
        this.testHelper.deploy(callingInstance, calledInstance);
        String businessKey = "theOne";
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(superProcess, businessKey).getProcessInstanceId();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(businessKey).rootProcessInstances();
        Assert.assertEquals((long)1L, (long)query.count());
        List list = query.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)processInstanceId, (Object)((ProcessInstance)list.get(0)).getId());
    }

    @Test
    public void testQueryByRootProcessInstancesAndSuperProcess() {
        try {
            this.runtimeService.createProcessInstanceQuery().rootProcessInstances().superProcessInstanceId("processInstanceId");
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid query usage: cannot set both rootProcessInstances and superProcessInstanceId"));
        }
        try {
            this.runtimeService.createProcessInstanceQuery().superProcessInstanceId("processInstanceId").rootProcessInstances();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid query usage: cannot set both rootProcessInstances and superProcessInstanceId"));
        }
    }

    protected void executeJobForProcessInstance(ProcessInstance processInstance) {
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        this.managementService.executeJob(job.getId());
    }

    protected <T> Set<T> asSet(T ... elements) {
        return new HashSet<T>(Arrays.asList(elements));
    }

    protected void assertNoProcessInstancesReturned(ProcessInstanceQuery query) {
        Assert.assertEquals((long)0L, (long)query.count());
        Assert.assertEquals((long)0L, (long)query.list().size());
    }

    protected void assertReturnedProcessInstances(ProcessInstanceQuery query, ProcessInstance ... processInstances) {
        int expectedSize = processInstances.length;
        Assert.assertEquals((long)expectedSize, (long)query.count());
        Assert.assertEquals((long)expectedSize, (long)query.list().size());
        this.verifyResultContainsExactly(query.list(), this.collectProcessInstanceIds(Arrays.asList(processInstances)));
    }

    protected void verifyResultContainsExactly(List<ProcessInstance> instances, Set<String> processInstanceIds) {
        Set<String> retrievedInstanceIds = this.collectProcessInstanceIds(instances);
        Assert.assertEquals(processInstanceIds, retrievedInstanceIds);
    }

    protected Set<String> collectProcessInstanceIds(List<ProcessInstance> instances) {
        HashSet<String> retrievedInstanceIds = new HashSet<String>();
        for (ProcessInstance instance : instances) {
            retrievedInstanceIds.add(instance.getId());
        }
        return retrievedInstanceIds;
    }
}

