/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration.batch;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class BatchMigrationUserOperationLogTest {
    public static final String USER_ID = "userId";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected MigrationTestRule migrationRule = new MigrationTestRule(this.engineRule);
    protected BatchMigrationHelper batchHelper = new BatchMigrationHelper(this.engineRule, this.migrationRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.migrationRule);

    @After
    public void removeBatches() {
        this.batchHelper.removeAllRunningAndHistoricBatches();
    }

    @Test
    public void testLogCreation() {
        ProcessDefinition sourceProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.migrationRule.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).changeElementId("Process", "newProcess"));
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.engineRule.getIdentityService().setAuthenticatedUserId(USER_ID);
        this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).executeAsync();
        this.engineRule.getIdentityService().clearAuthentication();
        List opLogEntries = this.engineRule.getHistoryService().createUserOperationLogQuery().list();
        Assert.assertEquals((long)3L, (long)opLogEntries.size());
        Map<String, UserOperationLogEntry> entries = this.asMap(opLogEntries);
        UserOperationLogEntry procDefEntry = entries.get("processDefinitionId");
        Assert.assertNotNull((Object)procDefEntry);
        Assert.assertEquals((Object)"ProcessInstance", (Object)procDefEntry.getEntityType());
        Assert.assertEquals((Object)"Migrate", (Object)procDefEntry.getOperationType());
        Assert.assertEquals((Object)sourceProcessDefinition.getId(), (Object)procDefEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)sourceProcessDefinition.getKey(), (Object)procDefEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)procDefEntry.getProcessInstanceId());
        Assert.assertEquals((Object)sourceProcessDefinition.getId(), (Object)procDefEntry.getOrgValue());
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)procDefEntry.getNewValue());
        UserOperationLogEntry asyncEntry = entries.get("async");
        Assert.assertNotNull((Object)asyncEntry);
        Assert.assertEquals((Object)"ProcessInstance", (Object)asyncEntry.getEntityType());
        Assert.assertEquals((Object)"Migrate", (Object)asyncEntry.getOperationType());
        Assert.assertEquals((Object)sourceProcessDefinition.getId(), (Object)asyncEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)sourceProcessDefinition.getKey(), (Object)asyncEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)asyncEntry.getProcessInstanceId());
        Assert.assertNull((Object)asyncEntry.getOrgValue());
        Assert.assertEquals((Object)"true", (Object)asyncEntry.getNewValue());
        UserOperationLogEntry numInstancesEntry = entries.get("nrOfInstances");
        Assert.assertNotNull((Object)numInstancesEntry);
        Assert.assertEquals((Object)"ProcessInstance", (Object)numInstancesEntry.getEntityType());
        Assert.assertEquals((Object)"Migrate", (Object)numInstancesEntry.getOperationType());
        Assert.assertEquals((Object)sourceProcessDefinition.getId(), (Object)numInstancesEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)sourceProcessDefinition.getKey(), (Object)numInstancesEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)numInstancesEntry.getProcessInstanceId());
        Assert.assertNull((Object)numInstancesEntry.getOrgValue());
        Assert.assertEquals((Object)"1", (Object)numInstancesEntry.getNewValue());
        Assert.assertEquals((Object)procDefEntry.getOperationId(), (Object)asyncEntry.getOperationId());
        Assert.assertEquals((Object)asyncEntry.getOperationId(), (Object)numInstancesEntry.getOperationId());
    }

    @Test
    public void testNoCreationOnSyncBatchJobExecution() {
        ProcessDefinition sourceProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.migrationRule.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).changeElementId("Process", "newProcess"));
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        Batch batch = this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).executeAsync();
        this.batchHelper.executeSeedJob(batch);
        this.engineRule.getIdentityService().setAuthenticatedUserId(USER_ID);
        this.batchHelper.executeJobs(batch);
        this.engineRule.getIdentityService().clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.engineRule.getHistoryService().createUserOperationLogQuery().count());
    }

    @Test
    public void testNoCreationOnJobExecutorBatchJobExecution() {
        ProcessDefinition sourceProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.migrationRule.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).changeElementId("Process", "newProcess"));
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).executeAsync();
        this.migrationRule.waitForJobExecutorToProcessAllJobs(5000L);
        Assert.assertEquals((long)0L, (long)this.engineRule.getHistoryService().createUserOperationLogQuery().count());
    }

    protected Map<String, UserOperationLogEntry> asMap(List<UserOperationLogEntry> logEntries) {
        HashMap<String, UserOperationLogEntry> map = new HashMap<String, UserOperationLogEntry>();
        for (UserOperationLogEntry entry : logEntries) {
            UserOperationLogEntry previousValue = map.put(entry.getProperty(), entry);
            if (previousValue == null) continue;
            Assert.fail((String)"expected only entry for every property");
        }
        return map;
    }
}

