/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import java.util.ArrayList;
import java.util.HashMap;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.StringValue;

public class TaskVariablesTest
extends PluggableProcessEngineTestCase {
    public void testStandaloneTaskVariables() {
        Task task = this.taskService.newTask();
        task.setName("gonzoTask");
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.taskService.setVariable(taskId, "instrument", (Object)"trumpet");
        TaskVariablesTest.assertEquals((Object)"trumpet", (Object)this.taskService.getVariable(taskId, "instrument"));
        this.taskService.deleteTask(taskId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskVariablesTest.testTaskExecutionVariables.bpmn20.xml"})
    public void testTaskExecutionVariableLongValue() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        StringBuffer longString = new StringBuffer();
        for (int i = 0; i < 500; ++i) {
            longString.append("tensymbols");
        }
        try {
            this.runtimeService.setVariable(processInstanceId, "var", (Object)longString.toString());
        }
        catch (Exception ex) {
            if (!(ex instanceof BadUserRequestException)) {
                TaskVariablesTest.fail((String)("BadUserRequestException is expected, but another exception was received:  " + ex));
            }
            TaskVariablesTest.assertEquals((String)"Variable value is too long", (String)ex.getMessage());
        }
    }

    @Deployment
    public void testTaskExecutionVariables() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        HashMap<String, String> expectedVariables = new HashMap<String, String>();
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.runtimeService.getVariables(processInstanceId));
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.taskService.getVariables(taskId));
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.runtimeService.getVariablesLocal(processInstanceId));
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.taskService.getVariablesLocal(taskId));
        this.runtimeService.setVariable(processInstanceId, "instrument", (Object)"trumpet");
        expectedVariables = new HashMap();
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.taskService.getVariablesLocal(taskId));
        expectedVariables.put("instrument", "trumpet");
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.runtimeService.getVariables(processInstanceId));
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.taskService.getVariables(taskId));
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.runtimeService.getVariablesLocal(processInstanceId));
        this.taskService.setVariable(taskId, "player", (Object)"gonzo");
        expectedVariables = new HashMap();
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.taskService.getVariablesLocal(taskId));
        expectedVariables.put("player", "gonzo");
        expectedVariables.put("instrument", "trumpet");
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.runtimeService.getVariables(processInstanceId));
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.taskService.getVariables(taskId));
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.runtimeService.getVariablesLocal(processInstanceId));
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.runtimeService.getVariablesLocal(processInstanceId, null));
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.runtimeService.getVariablesLocalTyped(processInstanceId, null, true));
        this.taskService.setVariableLocal(taskId, "budget", (Object)"unlimited");
        expectedVariables = new HashMap();
        expectedVariables.put("budget", "unlimited");
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.taskService.getVariablesLocal(taskId));
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.taskService.getVariablesLocalTyped(taskId, true));
        expectedVariables.put("player", "gonzo");
        expectedVariables.put("instrument", "trumpet");
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.taskService.getVariables(taskId));
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.taskService.getVariablesTyped(taskId, true));
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.taskService.getVariables(taskId, null));
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.taskService.getVariablesTyped(taskId, null, true));
        expectedVariables = new HashMap();
        expectedVariables.put("player", "gonzo");
        expectedVariables.put("instrument", "trumpet");
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.runtimeService.getVariables(processInstanceId));
        TaskVariablesTest.assertEquals(expectedVariables, (Object)this.runtimeService.getVariablesLocal(processInstanceId));
        ArrayList<String> serializableValue = new ArrayList<String>();
        serializableValue.add("1");
        serializableValue.add("2");
        this.taskService.setVariable(taskId, "objectVariable", (Object)Variables.objectValue(serializableValue).create());
        ArrayList<String> serializableValueLocal = new ArrayList<String>();
        serializableValueLocal.add("3");
        serializableValueLocal.add("4");
        this.taskService.setVariableLocal(taskId, "objectVariableLocal", (Object)Variables.objectValue(serializableValueLocal).create());
        Object value = this.taskService.getVariable(taskId, "objectVariable");
        TaskVariablesTest.assertEquals(serializableValue, (Object)value);
        Object valueLocal = this.taskService.getVariableLocal(taskId, "objectVariableLocal");
        TaskVariablesTest.assertEquals(serializableValueLocal, (Object)valueLocal);
        ObjectValue typedValue = (ObjectValue)this.taskService.getVariableTyped(taskId, "objectVariable");
        TaskVariablesTest.assertEquals(serializableValue, (Object)typedValue.getValue());
        ObjectValue serializedValue = (ObjectValue)this.taskService.getVariableTyped(taskId, "objectVariable", false);
        TaskVariablesTest.assertFalse((boolean)serializedValue.isDeserialized());
        ObjectValue typedValueLocal = (ObjectValue)this.taskService.getVariableLocalTyped(taskId, "objectVariableLocal");
        TaskVariablesTest.assertEquals(serializableValueLocal, (Object)typedValueLocal.getValue());
        ObjectValue serializedValueLocal = (ObjectValue)this.taskService.getVariableLocalTyped(taskId, "objectVariableLocal", false);
        TaskVariablesTest.assertFalse((boolean)serializedValueLocal.isDeserialized());
        try {
            StringValue val = (StringValue)this.taskService.getVariableTyped(taskId, "objectVariable");
            TaskVariablesTest.fail((String)"expected exception");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

