/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ControllableThread;
import org.slf4j.Logger;

public class CompetingSignalsTest
extends PluggableProcessEngineTestCase {
    private static Logger LOG = ProcessEngineLogger.TEST_LOGGER.getLogger();
    Thread testThread = Thread.currentThread();
    static ControllableThread activeThread;

    @Deployment
    public void testCompetingSignals() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("CompetingSignalsProcess");
        String processInstanceId = processInstance.getId();
        LOG.debug("test thread starts thread one");
        SignalThread threadOne = new SignalThread(processInstanceId);
        threadOne.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread continues to start thread two");
        SignalThread threadTwo = new SignalThread(processInstanceId);
        threadTwo.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        CompetingSignalsTest.assertNull((Object)((Object)threadOne.exception));
        LOG.debug("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        CompetingSignalsTest.assertNotNull((Object)((Object)threadTwo.exception));
        this.assertTextPresent("was updated by another transaction concurrently", threadTwo.exception.getMessage());
    }

    public static class ControlledConcurrencyBehavior
    implements ActivityBehavior {
        public void execute(ActivityExecution execution) throws Exception {
            activeThread.returnControlToTestThreadAndWait();
        }
    }

    public class SignalThread
    extends ControllableThread {
        String executionId;
        OptimisticLockingException exception;

        public SignalThread(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                CompetingSignalsTest.this.runtimeService.signal(this.executionId);
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
            LOG.debug(this.getName() + " ends");
        }
    }
}

