/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.dmn.businessruletask;

import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.exception.dmn.DecisionDefinitionNotFoundException;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.dmn.businessruletask.TestPojo;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BusinessRuleTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.EndEventBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DmnBusinessRuleTaskTest {
    public static final String DECISION_PROCESS = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml";
    public static final String DECISION_PROCESS_EXPRESSION = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefExpression.bpmn20.xml";
    public static final String DECISION_PROCESS_COMPOSITEEXPRESSION = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefCompositeExpression.bpmn20.xml";
    public static final String DECISION_PROCESS_LATEST = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefLatestBinding.bpmn20.xml";
    public static final String DECISION_PROCESS_DEPLOYMENT = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefDeploymentBinding.bpmn20.xml";
    public static final String DECISION_PROCESS_VERSION = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefVersionBinding.bpmn20.xml";
    public static final String DECISION_OKAY_DMN = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionOkay.dmn11.xml";
    public static final String DECISION_NOT_OKAY_DMN = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionNotOkay.dmn11.xml";
    public static final String DECISION_VERSION_TAG_OKAY_DMN = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionVersionTagOkay.dmn11.xml";
    public static final String DECISION_POJO_DMN = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testPojo.dmn11.xml";
    public static final String DECISION_LITERAL_EXPRESSION_DMN = "org/camunda/bpm/engine/test/dmn/deployment/DecisionWithLiteralExpression.dmn";
    public static final String DRD_DISH_RESOURCE = "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    public static final BpmnModelInstance BPMN_VERSION_TAG_BINDING = ((EndEventBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("versionTag")).camundaDecisionRefVersionTag("0.0.2")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("result")).endEvent().camundaAsyncBefore()).done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected RuntimeService runtimeService;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefExpression.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionOkay.dmn11.xml"})
    @Test
    public void decisionRef() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Assert.assertEquals((Object)"okay", (Object)this.getDecisionResult(processInstance));
        processInstance = this.startExpressionProcess("testDecision", 1);
        Assert.assertEquals((Object)"okay", (Object)this.getDecisionResult(processInstance));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml"})
    @Test
    public void noDecisionFound() {
        this.thrown.expect(DecisionDefinitionNotFoundException.class);
        this.thrown.expectMessage("no decision definition deployed with key 'testDecision'");
        this.runtimeService.startProcessInstanceByKey("testProcess");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefExpression.bpmn20.xml"})
    @Test
    public void noDecisionFoundRefByExpression() {
        this.thrown.expect(DecisionDefinitionNotFoundException.class);
        this.thrown.expectMessage("no decision definition deployed with key = 'testDecision', version = '1' and tenant-id 'null");
        this.startExpressionProcess("testDecision", 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefLatestBinding.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionOkay.dmn11.xml"})
    @Test
    public void decisionRefLatestBinding() {
        this.testRule.deploy(DECISION_NOT_OKAY_DMN);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Assert.assertEquals((Object)"not okay", (Object)this.getDecisionResult(processInstance));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefDeploymentBinding.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionOkay.dmn11.xml"})
    @Test
    public void decisionRefDeploymentBinding() {
        this.testRule.deploy(DECISION_NOT_OKAY_DMN);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Assert.assertEquals((Object)"okay", (Object)this.getDecisionResult(processInstance));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefVersionBinding.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefExpression.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionOkay.dmn11.xml"})
    @Test
    public void decisionRefVersionBinding() {
        this.testRule.deploy(DECISION_NOT_OKAY_DMN);
        this.testRule.deploy(DECISION_OKAY_DMN);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Assert.assertEquals((Object)"not okay", (Object)this.getDecisionResult(processInstance));
        processInstance = this.startExpressionProcess("testDecision", 2);
        Assert.assertEquals((Object)"not okay", (Object)this.getDecisionResult(processInstance));
    }

    @Test
    public void decisionRefVersionTagBinding() {
        this.testRule.deploy(DECISION_VERSION_TAG_OKAY_DMN);
        this.testRule.deploy(BPMN_VERSION_TAG_BINDING);
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).execute();
        Assert.assertEquals((Object)"A", (Object)this.getDecisionResult(processInstance));
    }

    @Test
    public void decisionRefVersionTagBindingExpression() {
        this.testRule.deploy(DECISION_VERSION_TAG_OKAY_DMN);
        this.testRule.deploy(((EndEventBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("versionTag")).camundaDecisionRefVersionTag("${versionTagExpr}")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("result")).endEvent().camundaAsyncBefore()).done());
        VariableMap variables = Variables.createVariables().putValue("versionTagExpr", (Object)"0.0.2").putValue("status", (Object)"gold");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", (Map)variables);
        Assert.assertEquals((Object)"A", (Object)this.getDecisionResult(processInstance));
    }

    @Test
    public void decisionRefVersionTagBindingWithoutVersionTag() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Could not parse BPMN process.");
        this.testRule.deploy(((EndEventBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("testDecision")).camundaDecisionRefBinding("versionTag")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("result")).endEvent().camundaAsyncBefore()).done());
    }

    @Test
    public void decisionRefVersionTagBindingNoneDecisionDefinition() {
        this.thrown.expect(DecisionDefinitionNotFoundException.class);
        this.thrown.expectMessage("no decision definition deployed with key = 'decision', versionTag = '0.0.2' and tenant-id 'null'");
        this.testRule.deploy(BPMN_VERSION_TAG_BINDING);
        this.runtimeService.startProcessInstanceByKey("process");
    }

    @Test
    public void decisionRefVersionTagBindingTwoDecisionDefinitions() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Found more than one decision definition for key 'decision' and versionTag '0.0.2'");
        this.testRule.deploy(DECISION_VERSION_TAG_OKAY_DMN);
        this.testRule.deploy(DECISION_VERSION_TAG_OKAY_DMN);
        this.testRule.deploy(BPMN_VERSION_TAG_BINDING);
        this.runtimeService.startProcessInstanceByKey("process");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testPojo.dmn11.xml"})
    @Test
    public void testPojo() {
        VariableMap variables = Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37));
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
        Assert.assertEquals((Object)"okay", (Object)this.getDecisionResult(processInstance));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/DecisionWithLiteralExpression.dmn"})
    @Test
    public void evaluateDecisionWithLiteralExpression() {
        this.testRule.deploy(((EndEventBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decisionLiteralExpression")).camundaResultVariable("result")).camundaMapDecisionResult("singleEntry")).endEvent().camundaAsyncBefore()).done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("a", (Object)2).putValue("b", (Object)3));
        Assert.assertEquals((Object)5, (Object)this.getDecisionResult(processInstance));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    @Test
    public void evaluateDecisionWithRequiredDecisions() {
        this.testRule.deploy(((EndEventBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("dish-decision")).camundaResultVariable("result")).camundaMapDecisionResult("singleEntry")).endEvent().camundaAsyncBefore()).done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        Assert.assertEquals((Object)"Light salad", (Object)this.getDecisionResult(processInstance));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefCompositeExpression.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionOkay.dmn11.xml"})
    @Test
    public void decisionRefWithCompositeExpression() {
        VariableMap variables = Variables.createVariables().putValue("version", (Object)1);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcessCompositeExpression", (Map)variables);
        Assert.assertEquals((Object)"okay", (Object)this.getDecisionResult(processInstance));
    }

    protected ProcessInstance startExpressionProcess(Object decisionKey, Object version) {
        VariableMap variables = Variables.createVariables().putValue("decision", decisionKey).putValue("version", version);
        return this.runtimeService.startProcessInstanceByKey("testProcessExpression", (Map)variables);
    }

    protected Object getDecisionResult(ProcessInstance processInstance) {
        return this.runtimeService.getVariable(processInstance.getId(), "result");
    }
}

