/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch;

import camundajar.com.google.gson.JsonObject;
import java.util.List;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.BatchJobConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchJobContext;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.util.JsonUtil;

public abstract class AbstractBatchJobHandler<T extends BatchConfiguration>
implements BatchJobHandler<T> {
    @Override
    public abstract JobDeclaration<BatchJobContext, MessageEntity> getJobDeclaration();

    @Override
    public boolean createJobs(BatchEntity batch) {
        CommandContext commandContext = Context.getCommandContext();
        ByteArrayManager byteArrayManager = commandContext.getByteArrayManager();
        JobManager jobManager = commandContext.getJobManager();
        Object configuration = this.readConfiguration(batch.getConfigurationBytes());
        int batchJobsPerSeed = batch.getBatchJobsPerSeed();
        int invocationsPerBatchJob = batch.getInvocationsPerBatchJob();
        List<String> ids = ((BatchConfiguration)configuration).getIds();
        int numberOfItemsToProcess = Math.min(invocationsPerBatchJob * batchJobsPerSeed, ids.size());
        List<String> processIds = ids.subList(0, numberOfItemsToProcess);
        int createdJobs = 0;
        while (!processIds.isEmpty()) {
            int lastIdIndex = Math.min(invocationsPerBatchJob, processIds.size());
            List<String> idsForJob = processIds.subList(0, lastIdIndex);
            Object jobConfiguration = this.createJobConfiguration(configuration, idsForJob);
            ByteArrayEntity configurationEntity = this.saveConfiguration(byteArrayManager, jobConfiguration);
            JobEntity job = this.createBatchJob(batch, configurationEntity);
            this.postProcessJob(configuration, job);
            jobManager.insertAndHintJobExecutor(job);
            idsForJob.clear();
            ++createdJobs;
        }
        batch.setJobsCreated(batch.getJobsCreated() + createdJobs);
        batch.setConfigurationBytes(this.writeConfiguration((T)configuration));
        return ids.isEmpty();
    }

    protected abstract T createJobConfiguration(T var1, List<String> var2);

    protected void postProcessJob(T configuration, JobEntity job) {
    }

    protected JobEntity createBatchJob(BatchEntity batch, ByteArrayEntity configuration) {
        BatchJobContext creationContext = new BatchJobContext(batch, configuration);
        return this.getJobDeclaration().createJobInstance(creationContext);
    }

    @Override
    public void deleteJobs(BatchEntity batch) {
        List<JobEntity> jobs = Context.getCommandContext().getJobManager().findJobsByJobDefinitionId(batch.getBatchJobDefinitionId());
        for (JobEntity job : jobs) {
            job.delete();
        }
    }

    @Override
    public BatchJobConfiguration newConfiguration(String canonicalString) {
        return new BatchJobConfiguration(canonicalString);
    }

    @Override
    public void onDelete(BatchJobConfiguration configuration, JobEntity jobEntity) {
        String byteArrayId = configuration.getConfigurationByteArrayId();
        if (byteArrayId != null) {
            Context.getCommandContext().getByteArrayManager().deleteByteArrayById(byteArrayId);
        }
    }

    protected ByteArrayEntity saveConfiguration(ByteArrayManager byteArrayManager, T jobConfiguration) {
        ByteArrayEntity configurationEntity = new ByteArrayEntity();
        configurationEntity.setBytes(this.writeConfiguration(jobConfiguration));
        byteArrayManager.insert(configurationEntity);
        return configurationEntity;
    }

    @Override
    public byte[] writeConfiguration(T configuration) {
        JsonObject jsonObject = this.getJsonConverterInstance().toJsonObject(configuration);
        return JsonUtil.asBytes(jsonObject);
    }

    @Override
    public T readConfiguration(byte[] serializedConfiguration) {
        return (T)((BatchConfiguration)this.getJsonConverterInstance().toObject(JsonUtil.asObject(serializedConfiguration)));
    }

    protected abstract JsonObjectConverter<T> getJsonConverterInstance();
}

