/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.impl.bpmn.helper.BpmnProperties;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class RecalculateJobDuedateCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private boolean creationDateBased;

    public RecalculateJobDuedateCmd(String jobId, boolean creationDateBased) {
        EnsureUtil.ensureNotEmpty("The job id is mandatory", "jobId", jobId);
        this.jobId = jobId;
        this.creationDateBased = creationDateBased;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        JobEntity job = commandContext.getJobManager().findJobById(this.jobId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "No job found with id '" + this.jobId + "'", "job", (Object)job);
        this.checkJobType(job);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateJob(job);
        }
        final TimerDeclarationImpl timerDeclaration = this.findTimerDeclaration(commandContext, job);
        final TimerEntity timer = (TimerEntity)job;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                timerDeclaration.resolveAndSetDuedate(timer.getExecution(), timer, RecalculateJobDuedateCmd.this.creationDateBased);
            }
        };
        ProcessDefinitionEntity contextDefinition = commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(job.getProcessDefinitionId());
        ProcessApplicationContextUtil.doContextSwitch(runnable, contextDefinition);
        return null;
    }

    protected void checkJobType(JobEntity job) {
        String type = job.getJobHandlerType();
        if (!(("timer-transition".equals(type) || "timer-intermediate-transition".equals(type) || "timer-start-event".equals(type) || "timer-start-event-subprocess".equals(type)) && job instanceof TimerEntity)) {
            throw new ProcessEngineException("Only timer jobs can be recalculated, but the job with id '" + this.jobId + "' is of type '" + type + "'.");
        }
    }

    protected TimerDeclarationImpl findTimerDeclaration(CommandContext commandContext, JobEntity job) {
        TimerDeclarationImpl timerDeclaration = null;
        timerDeclaration = job.getExecutionId() != null ? this.findTimerDeclarationForActivity(commandContext, job) : this.findTimerDeclarationForProcessStartEvent(commandContext, job);
        if (timerDeclaration == null) {
            throw new ProcessEngineException("No timer declaration found for job id '" + this.jobId + "'.");
        }
        return timerDeclaration;
    }

    protected TimerDeclarationImpl findTimerDeclarationForActivity(CommandContext commandContext, JobEntity job) {
        ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(job.getExecutionId());
        if (execution == null) {
            throw new ProcessEngineException("No execution found with id '" + job.getExecutionId() + "' for job id '" + this.jobId + "'.");
        }
        ActivityImpl activity = execution.getProcessDefinition().findActivity(job.getActivityId());
        Map<String, TimerDeclarationImpl> timerDeclarations = activity.getEventScope().getProperties().get(BpmnProperties.TIMER_DECLARATIONS);
        return timerDeclarations.get(job.getActivityId());
    }

    protected TimerDeclarationImpl findTimerDeclarationForProcessStartEvent(CommandContext commandContext, JobEntity job) {
        ProcessDefinitionEntity processDefinition = commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(job.getProcessDefinitionId());
        List timerDeclarations = (List)processDefinition.getProperty("timerStart");
        for (TimerDeclarationImpl timerDeclarationCandidate : timerDeclarations) {
            if (!timerDeclarationCandidate.getJobDefinitionId().equals(job.getJobDefinitionId())) continue;
            return timerDeclarationCandidate;
        }
        return null;
    }
}

