/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.json;

import camundajar.com.google.gson.JsonObject;
import java.util.List;
import org.camunda.bpm.engine.impl.ModificationBatchConfiguration;
import org.camunda.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.json.ModificationCmdJsonConverter;
import org.camunda.bpm.engine.impl.util.JsonUtil;

public class ModificationBatchConfigurationJsonConverter
extends JsonObjectConverter<ModificationBatchConfiguration> {
    public static final ModificationBatchConfigurationJsonConverter INSTANCE = new ModificationBatchConfigurationJsonConverter();
    public static final String INSTRUCTIONS = "instructions";
    public static final String PROCESS_INSTANCE_IDS = "processInstanceIds";
    public static final String SKIP_LISTENERS = "skipListeners";
    public static final String SKIP_IO_MAPPINGS = "skipIoMappings";
    public static final String PROCESS_DEFINITION_ID = "processDefinitionId";

    @Override
    public JsonObject toJsonObject(ModificationBatchConfiguration configuration) {
        JsonObject json = JsonUtil.createObject();
        JsonUtil.addListField(json, INSTRUCTIONS, ModificationCmdJsonConverter.INSTANCE, configuration.getInstructions());
        JsonUtil.addListField(json, PROCESS_INSTANCE_IDS, configuration.getIds());
        JsonUtil.addField(json, PROCESS_DEFINITION_ID, configuration.getProcessDefinitionId());
        JsonUtil.addField(json, SKIP_LISTENERS, configuration.isSkipCustomListeners());
        JsonUtil.addField(json, SKIP_IO_MAPPINGS, configuration.isSkipIoMappings());
        return json;
    }

    @Override
    public ModificationBatchConfiguration toObject(JsonObject json) {
        List<String> processInstanceIds = this.readProcessInstanceIds(json);
        String processDefinitionId = JsonUtil.getString(json, PROCESS_DEFINITION_ID);
        List<AbstractProcessInstanceModificationCommand> instructions = JsonUtil.asList(JsonUtil.getArray(json, INSTRUCTIONS), ModificationCmdJsonConverter.INSTANCE);
        boolean skipCustomListeners = JsonUtil.getBoolean(json, SKIP_LISTENERS);
        boolean skipIoMappings = JsonUtil.getBoolean(json, SKIP_IO_MAPPINGS);
        return new ModificationBatchConfiguration(processInstanceIds, processDefinitionId, instructions, skipCustomListeners, skipIoMappings);
    }

    protected List<String> readProcessInstanceIds(JsonObject jsonObject) {
        return JsonUtil.asList(JsonUtil.getArray(jsonObject, PROCESS_INSTANCE_IDS));
    }
}

