/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.helper.BpmnProperties;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.instance.CoreExecution;
import org.camunda.bpm.engine.impl.core.variable.event.VariableEvent;
import org.camunda.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventProcessor;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.incident.DefaultIncidentHandler;
import org.camunda.bpm.engine.impl.incident.IncidentContext;
import org.camunda.bpm.engine.impl.incident.IncidentHandler;
import org.camunda.bpm.engine.impl.persistence.entity.DelayedVariableEvent;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmException;
import org.camunda.bpm.engine.impl.pvm.PvmExecution;
import org.camunda.bpm.engine.impl.pvm.PvmLogger;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.PvmProcessInstance;
import org.camunda.bpm.engine.impl.pvm.PvmScope;
import org.camunda.bpm.engine.impl.pvm.PvmTransition;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.delegate.CompositeActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.ModificationObserverBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.SignallableActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ActivityStartBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.ActivityInstanceState;
import org.camunda.bpm.engine.impl.pvm.runtime.Callback;
import org.camunda.bpm.engine.impl.pvm.runtime.CompensationBehavior;
import org.camunda.bpm.engine.impl.pvm.runtime.ExecutionStartContext;
import org.camunda.bpm.engine.impl.pvm.runtime.InstantiationStack;
import org.camunda.bpm.engine.impl.pvm.runtime.LegacyBehavior;
import org.camunda.bpm.engine.impl.pvm.runtime.ProcessInstanceStartContext;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.FoxAtomicOperationDeleteCascadeFireActivityEnd;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;
import org.camunda.bpm.engine.impl.tree.ExecutionWalker;
import org.camunda.bpm.engine.impl.tree.FlowScopeWalker;
import org.camunda.bpm.engine.impl.tree.LeafActivityInstanceExecutionCollector;
import org.camunda.bpm.engine.impl.tree.ReferenceWalker;
import org.camunda.bpm.engine.impl.tree.ScopeCollector;
import org.camunda.bpm.engine.impl.tree.ScopeExecutionCollector;
import org.camunda.bpm.engine.impl.tree.TreeVisitor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.Incident;

public abstract class PvmExecutionImpl
extends CoreExecution
implements ActivityExecution,
PvmProcessInstance {
    private static final long serialVersionUID = 1L;
    private static final PvmLogger LOG = ProcessEngineLogger.PVM_LOGGER;
    protected transient ProcessDefinitionImpl processDefinition;
    protected transient ExecutionStartContext startContext;
    protected transient ActivityImpl activity;
    protected transient PvmActivity nextActivity;
    protected transient TransitionImpl transition;
    protected transient List<PvmTransition> transitionsToTake = null;
    protected String activityInstanceId;
    protected String caseInstanceId;
    protected PvmExecutionImpl replacedBy;
    protected boolean deleteRoot;
    protected String deleteReason;
    protected boolean externallyTerminated;
    protected boolean isActive = true;
    protected boolean isScope = true;
    protected boolean isConcurrent = false;
    protected boolean isEnded = false;
    protected boolean isEventScope = false;
    protected boolean preserveScope = false;
    protected int activityInstanceState = ActivityInstanceState.DEFAULT.getStateCode();
    protected long sequenceCounter = 0L;
    protected transient List<DelayedVariableEvent> delayedEvents = new ArrayList<DelayedVariableEvent>();

    @Override
    public PvmExecutionImpl createExecution() {
        return this.createExecution(false);
    }

    @Override
    public abstract PvmExecutionImpl createExecution(boolean var1);

    @Override
    public PvmExecutionImpl createSubProcessInstance(PvmProcessDefinition processDefinition) {
        return this.createSubProcessInstance(processDefinition, null);
    }

    @Override
    public PvmExecutionImpl createSubProcessInstance(PvmProcessDefinition processDefinition, String businessKey) {
        PvmExecutionImpl processInstance = this.getProcessInstance();
        String caseInstanceId = null;
        if (processInstance != null) {
            caseInstanceId = processInstance.getCaseInstanceId();
        }
        return this.createSubProcessInstance(processDefinition, businessKey, caseInstanceId);
    }

    @Override
    public PvmExecutionImpl createSubProcessInstance(PvmProcessDefinition processDefinition, String businessKey, String caseInstanceId) {
        PvmExecutionImpl subProcessInstance = this.newExecution();
        subProcessInstance.setSuperExecution(this);
        this.setSubProcessInstance(subProcessInstance);
        subProcessInstance.setProcessDefinition((ProcessDefinitionImpl)processDefinition);
        subProcessInstance.setProcessInstance(subProcessInstance);
        subProcessInstance.setActivity(processDefinition.getInitial());
        if (businessKey != null) {
            subProcessInstance.setBusinessKey(businessKey);
        }
        if (caseInstanceId != null) {
            subProcessInstance.setCaseInstanceId(caseInstanceId);
        }
        return subProcessInstance;
    }

    protected abstract PvmExecutionImpl newExecution();

    @Override
    public abstract CmmnExecution createSubCaseInstance(CmmnCaseDefinition var1);

    @Override
    public abstract CmmnExecution createSubCaseInstance(CmmnCaseDefinition var1, String var2);

    public abstract void initialize();

    public abstract void initializeTimerDeclarations();

    public void executeIoMapping() {
        ActivityImpl currentActivity;
        ScopeImpl currentScope = this.getScopeActivity();
        if (currentScope != currentScope.getProcessDefinition() && (currentActivity = (ActivityImpl)currentScope) != null && currentActivity.getIoMapping() != null && !this.skipIoMapping) {
            currentActivity.getIoMapping().executeInputParameters(this);
        }
    }

    @Override
    public void start() {
        this.start(null);
    }

    @Override
    public void start(Map<String, Object> variables) {
        this.startContext = new ProcessInstanceStartContext(this.getActivity());
        this.initialize();
        if (variables != null) {
            this.setVariables(variables);
        }
        this.initializeTimerDeclarations();
        this.fireHistoricProcessStartEvent();
        this.performOperation(PvmAtomicOperation.PROCESS_START);
    }

    public void startWithoutExecuting(Map<String, Object> variables) {
        this.initialize();
        this.initializeTimerDeclarations();
        this.fireHistoricProcessStartEvent();
        this.performOperation(PvmAtomicOperation.FIRE_PROCESS_START);
        this.setActivity(null);
        this.setActivityInstanceId(this.getId());
        this.setVariables(variables);
    }

    public abstract void fireHistoricProcessStartEvent();

    @Override
    public void destroy() {
        LOG.destroying(this);
        this.setScope(false);
    }

    public void removeAllTasks() {
    }

    protected void removeEventScopes() {
        ArrayList<? extends PvmExecutionImpl> childExecutions = new ArrayList<PvmExecutionImpl>(this.getEventScopeExecutions());
        for (PvmExecutionImpl pvmExecutionImpl : childExecutions) {
            LOG.removingEventScope(pvmExecutionImpl);
            pvmExecutionImpl.destroy();
            pvmExecutionImpl.remove();
        }
    }

    public void clearScope(String reason, boolean skipCustomListeners, boolean skipIoMappings) {
        this.skipCustomListeners = skipCustomListeners;
        this.skipIoMapping = skipIoMappings;
        if (this.getSubProcessInstance() != null) {
            this.getSubProcessInstance().deleteCascade(reason, skipCustomListeners, skipIoMappings);
        }
        ArrayList<? extends PvmExecutionImpl> executions = new ArrayList<PvmExecutionImpl>(this.getNonEventScopeExecutions());
        for (PvmExecutionImpl pvmExecutionImpl : executions) {
            if (pvmExecutionImpl.getSubProcessInstance() != null) {
                pvmExecutionImpl.getSubProcessInstance().deleteCascade(reason, skipCustomListeners, skipIoMappings);
            }
            pvmExecutionImpl.deleteCascade(reason, skipCustomListeners, skipIoMappings);
        }
        ActivityImpl activity = this.getActivity();
        if (this.isActive && activity != null) {
            if (this.activityInstanceState != ActivityInstanceState.ENDING.getStateCode()) {
                this.setCanceled(true);
                this.performOperation(PvmAtomicOperation.FIRE_ACTIVITY_END);
            }
            this.activityInstanceState = ActivityInstanceState.DEFAULT.getStateCode();
        }
    }

    @Override
    public void interrupt(String reason) {
        this.interrupt(reason, false, false);
    }

    public void interrupt(String reason, boolean skipCustomListeners, boolean skipIoMappings) {
        LOG.interruptingExecution(reason, skipCustomListeners);
        this.clearScope(reason, skipCustomListeners, skipIoMappings);
    }

    @Override
    public void end(boolean completeScope) {
        this.setCompleteScope(completeScope);
        this.isActive = false;
        this.isEnded = true;
        if (this.hasReplacedParent()) {
            this.getParent().replacedBy = null;
        }
        this.performOperation(PvmAtomicOperation.ACTIVITY_NOTIFY_LISTENER_END);
    }

    @Override
    public void endCompensation() {
        this.performOperation(PvmAtomicOperation.FIRE_ACTIVITY_END);
        this.remove();
        PvmExecutionImpl parent = this.getParent();
        if (parent.getActivity() == null) {
            parent.setActivity((PvmActivity)((Object)this.getActivity().getFlowScope()));
        }
        parent.signal("compensationDone", null);
    }

    public void propagateEnd() {
        if (!this.isEnded()) {
            throw new ProcessEngineException(this.toString() + " must have ended before ending can be propagated");
        }
        if (this.isProcessInstanceExecution()) {
            this.performOperation(PvmAtomicOperation.PROCESS_END);
        }
    }

    @Override
    public void remove() {
        PvmExecutionImpl parent = this.getParent();
        if (parent != null) {
            parent.getExecutions().remove(this);
            long parentSequenceCounter = parent.getSequenceCounter();
            long mySequenceCounter = this.getSequenceCounter();
            if (mySequenceCounter > parentSequenceCounter) {
                parent.setSequenceCounter(mySequenceCounter);
            }
            parent.skipCustomListeners |= this.skipCustomListeners;
            parent.skipIoMapping |= this.skipIoMapping;
        }
        this.isActive = false;
        this.isEnded = true;
        if (this.hasReplacedParent()) {
            this.getParent().replacedBy = null;
        }
        this.removeEventScopes();
    }

    public PvmExecutionImpl createConcurrentExecution() {
        if (!this.isScope()) {
            throw new ProcessEngineException("Cannot create concurrent execution for " + this);
        }
        List<? extends PvmExecutionImpl> children = this.getNonEventScopeExecutions();
        this.forceUpdate();
        if (children.isEmpty()) {
            PvmExecutionImpl replacingExecution = this.createExecution();
            replacingExecution.setConcurrent(true);
            replacingExecution.setScope(false);
            replacingExecution.replace(this);
            this.inactivate();
            this.setActivity(null);
        } else if (children.size() == 1) {
            PvmExecutionImpl child = children.get(0);
            PvmExecutionImpl concurrentReplacingExecution = this.createExecution();
            concurrentReplacingExecution.setConcurrent(true);
            concurrentReplacingExecution.setScope(false);
            concurrentReplacingExecution.setActive(false);
            concurrentReplacingExecution.onConcurrentExpand(this);
            child.setParent(concurrentReplacingExecution);
            this.leaveActivityInstance();
            this.setActivity(null);
        }
        PvmExecutionImpl concurrentExecution = this.createExecution();
        concurrentExecution.setConcurrent(true);
        concurrentExecution.setScope(false);
        return concurrentExecution;
    }

    @Override
    public boolean tryPruneLastConcurrentChild() {
        PvmExecutionImpl lastConcurrent;
        if (this.getNonEventScopeExecutions().size() == 1 && (lastConcurrent = this.getNonEventScopeExecutions().get(0)).isConcurrent()) {
            if (!lastConcurrent.isScope()) {
                this.setActivity(lastConcurrent.getActivity());
                this.setTransition(lastConcurrent.getTransition());
                this.replace(lastConcurrent);
                if (lastConcurrent.hasChildren()) {
                    for (PvmExecutionImpl pvmExecutionImpl : lastConcurrent.getExecutionsAsCopy()) {
                        pvmExecutionImpl.setParent(this);
                    }
                }
                if (!this.isActive() && lastConcurrent.isActive()) {
                    this.setActive(true);
                }
                lastConcurrent.remove();
            } else {
                LegacyBehavior.pruneConcurrentScope(lastConcurrent);
            }
            return true;
        }
        return false;
    }

    @Override
    public void deleteCascade(String deleteReason) {
        this.deleteCascade(deleteReason, false);
    }

    public void deleteCascade(String deleteReason, boolean skipCustomListeners) {
        this.deleteCascade(deleteReason, skipCustomListeners, false);
    }

    public void deleteCascade(String deleteReason, boolean skipCustomListeners, boolean skipIoMappings) {
        this.deleteCascade(deleteReason, skipCustomListeners, skipIoMappings, false, false);
    }

    public void deleteCascade(String deleteReason, boolean skipCustomListeners, boolean skipIoMappings, boolean externallyTerminated, boolean skipSubprocesses) {
        this.deleteReason = deleteReason;
        this.setDeleteRoot(true);
        this.isEnded = true;
        this.skipCustomListeners = skipCustomListeners;
        this.skipIoMapping = skipIoMappings;
        this.externallyTerminated = externallyTerminated;
        this.skipSubprocesses = skipSubprocesses;
        this.performOperation(PvmAtomicOperation.DELETE_CASCADE);
    }

    public void deleteCascade2(String deleteReason) {
        this.deleteReason = deleteReason;
        this.setDeleteRoot(true);
        this.performOperation(new FoxAtomicOperationDeleteCascadeFireActivityEnd());
    }

    public void executeEventHandlerActivity(ActivityImpl eventHandlerActivity) {
        ScopeImpl flowScope = eventHandlerActivity.getFlowScope();
        ScopeImpl eventScope = eventHandlerActivity.getEventScope();
        if (eventHandlerActivity.getActivityStartBehavior() == ActivityStartBehavior.CONCURRENT_IN_FLOW_SCOPE && flowScope != eventScope) {
            this.findExecutionForScope(eventScope, flowScope).executeActivity(eventHandlerActivity);
        } else {
            this.executeActivity(eventHandlerActivity);
        }
    }

    public abstract PvmExecutionImpl getReplacedBy();

    public PvmExecutionImpl resolveReplacedBy() {
        PvmExecutionImpl secondHopReplacingExecution;
        PvmExecutionImpl replacingExecution = this.getReplacedBy();
        if (replacingExecution != null && (secondHopReplacingExecution = replacingExecution.getReplacedBy()) != null) {
            replacingExecution = secondHopReplacingExecution;
        }
        return replacingExecution;
    }

    public boolean hasReplacedParent() {
        return this.getParent() != null && this.getParent().getReplacedBy() == this;
    }

    public boolean isReplacedByParent() {
        return this.getReplacedBy() != null && this.getReplacedBy() == this.getParent();
    }

    public void replace(PvmExecutionImpl execution) {
        this.activityInstanceId = execution.getActivityInstanceId();
        this.isActive = execution.isActive;
        this.replacedBy = null;
        execution.replacedBy = this;
        this.transitionsToTake = execution.transitionsToTake;
        execution.leaveActivityInstance();
    }

    public void onConcurrentExpand(PvmExecutionImpl scopeExecution) {
    }

    @Override
    public void signal(String signalName, Object signalData) {
        if (this.getActivity() == null) {
            throw new PvmException("cannot signal execution " + this.id + ": it has no current activity");
        }
        SignallableActivityBehavior activityBehavior = (SignallableActivityBehavior)this.activity.getActivityBehavior();
        try {
            activityBehavior.signal(this, signalName, signalData);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PvmException("couldn't process signal '" + signalName + "' on activity '" + this.activity.getId() + "': " + e.getMessage(), e);
        }
    }

    public void take() {
        if (this.transition == null) {
            throw new PvmException(this.toString() + ": no transition to take specified");
        }
        TransitionImpl transitionImpl = this.transition;
        this.setActivity(transitionImpl.getSource());
        this.setActivityInstanceId(null);
        this.setActive(true);
        this.performOperation(PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_TAKE);
    }

    @Override
    public void executeActivity(PvmActivity activity) {
        if (!activity.getIncomingTransitions().isEmpty()) {
            throw new ProcessEngineException("Activity is contained in normal flow and cannot be executed using executeActivity().");
        }
        ActivityStartBehavior activityStartBehavior = activity.getActivityStartBehavior();
        if (!this.isScope() && ActivityStartBehavior.DEFAULT != activityStartBehavior) {
            throw new ProcessEngineException("Activity '" + activity + "' with start behavior '" + (Object)((Object)activityStartBehavior) + "'cannot be executed by non-scope execution.");
        }
        PvmActivity activityImpl = activity;
        switch (activityStartBehavior) {
            case CONCURRENT_IN_FLOW_SCOPE: {
                this.nextActivity = activityImpl;
                this.performOperation(PvmAtomicOperation.ACTIVITY_START_CONCURRENT);
                break;
            }
            case CANCEL_EVENT_SCOPE: {
                this.nextActivity = activityImpl;
                this.performOperation(PvmAtomicOperation.ACTIVITY_START_CANCEL_SCOPE);
                break;
            }
            case INTERRUPT_EVENT_SCOPE: {
                this.nextActivity = activityImpl;
                this.performOperation(PvmAtomicOperation.ACTIVITY_START_INTERRUPT_SCOPE);
                break;
            }
            default: {
                this.setActivity(activityImpl);
                this.setActivityInstanceId(null);
                this.performOperation(PvmAtomicOperation.ACTIVITY_START_CREATE_SCOPE);
            }
        }
    }

    public void executeActivitiesConcurrent(List<PvmActivity> activityStack, PvmActivity targetActivity, PvmTransition targetTransition, Map<String, Object> variables, Map<String, Object> localVariables, boolean skipCustomListeners, boolean skipIoMappings) {
        ScopeImpl flowScope = null;
        if (!activityStack.isEmpty()) {
            flowScope = activityStack.get(0).getFlowScope();
        } else if (targetActivity != null) {
            flowScope = targetActivity.getFlowScope();
        } else if (targetTransition != null) {
            flowScope = targetTransition.getSource().getFlowScope();
        }
        PvmExecutionImpl propagatingExecution = null;
        if (flowScope.getActivityBehavior() instanceof ModificationObserverBehavior) {
            ModificationObserverBehavior flowScopeBehavior = (ModificationObserverBehavior)flowScope.getActivityBehavior();
            propagatingExecution = (PvmExecutionImpl)flowScopeBehavior.createInnerInstance(this);
        } else {
            propagatingExecution = this.createConcurrentExecution();
        }
        propagatingExecution.executeActivities(activityStack, targetActivity, targetTransition, variables, localVariables, skipCustomListeners, skipIoMappings);
    }

    public Map<PvmActivity, PvmExecutionImpl> instantiateScopes(List<PvmActivity> activityStack, boolean skipCustomListeners, boolean skipIoMappings) {
        if (activityStack.isEmpty()) {
            return Collections.emptyMap();
        }
        this.skipCustomListeners = skipCustomListeners;
        this.skipIoMapping = skipIoMappings;
        ExecutionStartContext executionStartContext = new ExecutionStartContext(false);
        InstantiationStack instantiationStack = new InstantiationStack(new LinkedList<PvmActivity>(activityStack));
        executionStartContext.setInstantiationStack(instantiationStack);
        this.setStartContext(executionStartContext);
        this.performOperation(PvmAtomicOperation.ACTIVITY_INIT_STACK_AND_RETURN);
        HashMap<PvmActivity, PvmExecutionImpl> createdExecutions = new HashMap<PvmActivity, PvmExecutionImpl>();
        PvmExecutionImpl currentExecution = this;
        for (PvmActivity instantiatedActivity : activityStack) {
            if ((currentExecution = currentExecution.getNonEventScopeExecutions().get(0)).isConcurrent()) {
                currentExecution = currentExecution.getNonEventScopeExecutions().get(0);
            }
            createdExecutions.put(instantiatedActivity, currentExecution);
        }
        return createdExecutions;
    }

    public void executeActivities(List<PvmActivity> activityStack, PvmActivity targetActivity, PvmTransition targetTransition, Map<String, Object> variables, Map<String, Object> localVariables, boolean skipCustomListeners, boolean skipIoMappings) {
        this.skipCustomListeners = skipCustomListeners;
        this.skipIoMapping = skipIoMappings;
        this.activityInstanceId = null;
        this.isEnded = false;
        if (!activityStack.isEmpty()) {
            ExecutionStartContext executionStartContext = new ExecutionStartContext(false);
            InstantiationStack instantiationStack = new InstantiationStack(activityStack, targetActivity, targetTransition);
            executionStartContext.setInstantiationStack(instantiationStack);
            executionStartContext.setVariables(variables);
            executionStartContext.setVariablesLocal(localVariables);
            this.setStartContext(executionStartContext);
            this.performOperation(PvmAtomicOperation.ACTIVITY_INIT_STACK);
        } else if (targetActivity != null) {
            this.setVariables(variables);
            this.setVariablesLocal(localVariables);
            this.setActivity(targetActivity);
            this.performOperation(PvmAtomicOperation.ACTIVITY_START_CREATE_SCOPE);
        } else if (targetTransition != null) {
            this.setVariables(variables);
            this.setVariablesLocal(localVariables);
            this.setActivity(targetTransition.getSource());
            this.setTransition(targetTransition);
            this.performOperation(PvmAtomicOperation.TRANSITION_START_NOTIFY_LISTENER_TAKE);
        }
    }

    @Override
    public List<ActivityExecution> findInactiveConcurrentExecutions(PvmActivity activity) {
        ArrayList<ActivityExecution> inactiveConcurrentExecutionsInActivity = new ArrayList<ActivityExecution>();
        if (this.isConcurrent()) {
            return this.getParent().findInactiveChildExecutions(activity);
        }
        if (!this.isActive()) {
            inactiveConcurrentExecutionsInActivity.add(this);
        }
        return inactiveConcurrentExecutionsInActivity;
    }

    @Override
    public List<ActivityExecution> findInactiveChildExecutions(PvmActivity activity) {
        ArrayList<ActivityExecution> inactiveConcurrentExecutionsInActivity = new ArrayList<ActivityExecution>();
        List<PvmExecutionImpl> concurrentExecutions = this.getAllChildExecutions();
        for (PvmExecutionImpl concurrentExecution : concurrentExecutions) {
            if (concurrentExecution.getActivity() != activity || concurrentExecution.isActive()) continue;
            inactiveConcurrentExecutionsInActivity.add(concurrentExecution);
        }
        return inactiveConcurrentExecutionsInActivity;
    }

    protected List<PvmExecutionImpl> getAllChildExecutions() {
        ArrayList<PvmExecutionImpl> childExecutions = new ArrayList<PvmExecutionImpl>();
        for (PvmExecutionImpl pvmExecutionImpl : this.getExecutions()) {
            childExecutions.add(pvmExecutionImpl);
            childExecutions.addAll(pvmExecutionImpl.getAllChildExecutions());
        }
        return childExecutions;
    }

    @Override
    public void leaveActivityViaTransition(PvmTransition outgoingTransition) {
        this.leaveActivityViaTransitions(Arrays.asList(outgoingTransition), Collections.emptyList());
    }

    @Override
    public void leaveActivityViaTransitions(List<PvmTransition> _transitions, List<? extends ActivityExecution> _recyclableExecutions) {
        List<ActivityExecution> recyclableExecutions = Collections.emptyList();
        if (_recyclableExecutions != null) {
            recyclableExecutions = new ArrayList<ActivityExecution>(_recyclableExecutions);
        }
        if (recyclableExecutions.size() > 1) {
            this.removeVariablesLocalInternal();
        }
        for (ActivityExecution execution : recyclableExecutions) {
            execution.setEnded(true);
        }
        recyclableExecutions.remove(this);
        for (ActivityExecution execution : recyclableExecutions) {
            execution.end(_transitions.isEmpty());
        }
        PvmExecutionImpl propagatingExecution = this;
        if (this.getReplacedBy() != null) {
            propagatingExecution = this.getReplacedBy();
        }
        propagatingExecution.isActive = true;
        propagatingExecution.isEnded = false;
        if (_transitions.isEmpty()) {
            propagatingExecution.end(!propagatingExecution.isConcurrent());
        } else {
            propagatingExecution.setTransitionsToTake(_transitions);
            propagatingExecution.performOperation(PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_END);
        }
    }

    protected abstract void removeVariablesLocalInternal();

    public boolean isActive(String activityId) {
        return this.findExecution(activityId) != null;
    }

    @Override
    public void inactivate() {
        this.isActive = false;
    }

    public abstract List<? extends PvmExecutionImpl> getExecutions();

    public abstract List<? extends PvmExecutionImpl> getExecutionsAsCopy();

    public List<? extends PvmExecutionImpl> getNonEventScopeExecutions() {
        List<? extends PvmExecutionImpl> children = this.getExecutions();
        ArrayList<PvmExecutionImpl> result = new ArrayList<PvmExecutionImpl>();
        for (PvmExecutionImpl pvmExecutionImpl : children) {
            if (pvmExecutionImpl.isEventScope()) continue;
            result.add(pvmExecutionImpl);
        }
        return result;
    }

    public List<? extends PvmExecutionImpl> getEventScopeExecutions() {
        List<? extends PvmExecutionImpl> children = this.getExecutions();
        ArrayList<PvmExecutionImpl> result = new ArrayList<PvmExecutionImpl>();
        for (PvmExecutionImpl pvmExecutionImpl : children) {
            if (!pvmExecutionImpl.isEventScope()) continue;
            result.add(pvmExecutionImpl);
        }
        return result;
    }

    @Override
    public PvmExecutionImpl findExecution(String activityId) {
        if (this.getActivity() != null && this.getActivity().getId().equals(activityId)) {
            return this;
        }
        for (PvmExecutionImpl pvmExecutionImpl : this.getExecutions()) {
            PvmExecutionImpl result = pvmExecutionImpl.findExecution(activityId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public List<PvmExecution> findExecutions(String activityId) {
        ArrayList<PvmExecution> matchingExecutions = new ArrayList<PvmExecution>();
        this.collectExecutions(activityId, matchingExecutions);
        return matchingExecutions;
    }

    protected void collectExecutions(String activityId, List<PvmExecution> executions) {
        if (this.getActivity() != null && this.getActivity().getId().equals(activityId)) {
            executions.add(this);
        }
        for (PvmExecutionImpl pvmExecutionImpl : this.getExecutions()) {
            pvmExecutionImpl.collectExecutions(activityId, executions);
        }
    }

    @Override
    public List<String> findActiveActivityIds() {
        ArrayList<String> activeActivityIds = new ArrayList<String>();
        this.collectActiveActivityIds(activeActivityIds);
        return activeActivityIds;
    }

    protected void collectActiveActivityIds(List<String> activeActivityIds) {
        ActivityImpl activity = this.getActivity();
        if (this.isActive && activity != null) {
            activeActivityIds.add(activity.getId());
        }
        for (PvmExecutionImpl pvmExecutionImpl : this.getExecutions()) {
            pvmExecutionImpl.collectActiveActivityIds(activeActivityIds);
        }
    }

    @Override
    public String getProcessBusinessKey() {
        return this.getProcessInstance().getBusinessKey();
    }

    @Override
    public void setProcessBusinessKey(String businessKey) {
        final PvmExecutionImpl processInstance = this.getProcessInstance();
        processInstance.setBusinessKey(businessKey);
        HistoryLevel historyLevel = Context.getCommandContext().getProcessEngineConfiguration().getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.PROCESS_INSTANCE_UPDATE, processInstance)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createProcessInstanceUpdateEvt(processInstance);
                }
            });
        }
    }

    @Override
    public String getBusinessKey() {
        if (this.isProcessInstanceExecution()) {
            return this.businessKey;
        }
        return this.getProcessBusinessKey();
    }

    public void setProcessDefinition(ProcessDefinitionImpl processDefinition) {
        this.processDefinition = processDefinition;
    }

    public ProcessDefinitionImpl getProcessDefinition() {
        return this.processDefinition;
    }

    @Override
    public abstract PvmExecutionImpl getProcessInstance();

    public abstract void setProcessInstance(PvmExecutionImpl var1);

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @Override
    public ActivityImpl getActivity() {
        return this.activity;
    }

    public String getActivityId() {
        ActivityImpl activity = this.getActivity();
        if (activity != null) {
            return activity.getId();
        }
        return null;
    }

    @Override
    public String getCurrentActivityName() {
        ActivityImpl activity = this.getActivity();
        if (activity != null) {
            return activity.getName();
        }
        return null;
    }

    @Override
    public String getCurrentActivityId() {
        return this.getActivityId();
    }

    @Override
    public void setActivity(PvmActivity activity) {
        this.activity = (ActivityImpl)activity;
    }

    @Override
    public void enterActivityInstance() {
        ActivityImpl activity = this.getActivity();
        this.activityInstanceId = this.generateActivityInstanceId(activity.getId());
        LOG.debugEnterActivityInstance(this, this.getParentActivityInstanceId());
        this.executeIoMapping();
        if (activity.isScope()) {
            this.initializeTimerDeclarations();
        }
    }

    public void activityInstanceStarting() {
        this.activityInstanceState = ActivityInstanceState.STARTING.getStateCode();
    }

    public void activityInstanceStarted() {
        this.activityInstanceState = ActivityInstanceState.DEFAULT.getStateCode();
    }

    public void activityInstanceDone() {
        this.activityInstanceState = ActivityInstanceState.ENDING.getStateCode();
    }

    protected abstract String generateActivityInstanceId(String var1);

    @Override
    public void leaveActivityInstance() {
        if (this.activityInstanceId != null) {
            LOG.debugLeavesActivityInstance(this, this.activityInstanceId);
        }
        this.activityInstanceId = this.getParentActivityInstanceId();
        this.activityInstanceState = ActivityInstanceState.DEFAULT.getStateCode();
    }

    @Override
    public String getParentActivityInstanceId() {
        if (this.isProcessInstanceExecution()) {
            return this.getId();
        }
        return this.getParent().getActivityInstanceId();
    }

    @Override
    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    @Override
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    @Override
    public abstract PvmExecutionImpl getParent();

    @Override
    public String getParentId() {
        PvmExecutionImpl parent = this.getParent();
        if (parent != null) {
            return parent.getId();
        }
        return null;
    }

    @Override
    public boolean hasChildren() {
        return !this.getExecutions().isEmpty();
    }

    public void setParent(PvmExecutionImpl parent) {
        PvmExecutionImpl currentParent = this.getParent();
        this.setParentExecution(parent);
        if (currentParent != null) {
            currentParent.getExecutions().remove(this);
        }
        if (parent != null) {
            parent.getExecutions().add(this);
        }
    }

    public abstract void setParentExecution(PvmExecutionImpl var1);

    @Override
    public abstract PvmExecutionImpl getSuperExecution();

    public abstract void setSuperExecution(PvmExecutionImpl var1);

    public abstract PvmExecutionImpl getSubProcessInstance();

    public abstract void setSubProcessInstance(PvmExecutionImpl var1);

    public abstract CmmnExecution getSuperCaseExecution();

    public abstract void setSuperCaseExecution(CmmnExecution var1);

    public abstract CmmnExecution getSubCaseInstance();

    public abstract void setSubCaseInstance(CmmnExecution var1);

    protected ScopeImpl getScopeActivity() {
        ScopeImpl scope = null;
        scope = this.isProcessInstanceExecution() ? this.getProcessDefinition() : this.getActivity();
        return scope;
    }

    @Override
    public boolean isScope() {
        return this.isScope;
    }

    @Override
    public void setScope(boolean isScope) {
        this.isScope = isScope;
    }

    @Override
    public PvmExecutionImpl findExecutionForFlowScope(PvmScope targetFlowScope) {
        PvmExecutionImpl scopeExecution = this.isScope() ? this : this.getParent();
        ActivityImpl currentActivity = this.getActivity();
        EnsureUtil.ensureNotNull("activity of current execution", (Object)currentActivity);
        currentActivity = currentActivity.isScope() ? currentActivity : currentActivity.getFlowScope();
        return scopeExecution.findExecutionForScope(currentActivity, (ScopeImpl)targetFlowScope);
    }

    public PvmExecutionImpl findExecutionForScope(ScopeImpl currentScope, ScopeImpl targetScope) {
        if (!targetScope.isScope()) {
            throw new ProcessEngineException("Target scope must be a scope.");
        }
        Map<ScopeImpl, PvmExecutionImpl> activityExecutionMapping = this.createActivityExecutionMapping(currentScope);
        PvmExecutionImpl scopeExecution = activityExecutionMapping.get(targetScope);
        if (scopeExecution == null) {
            scopeExecution = LegacyBehavior.getScopeExecution(targetScope, activityExecutionMapping);
        }
        return scopeExecution;
    }

    public Map<ScopeImpl, PvmExecutionImpl> createActivityExecutionMapping(ScopeImpl currentScope) {
        if (!this.isScope()) {
            throw new ProcessEngineException("Execution must be a scope execution");
        }
        if (!currentScope.isScope()) {
            throw new ProcessEngineException("Current scope must be a scope.");
        }
        LeafActivityInstanceExecutionCollector leafCollector = new LeafActivityInstanceExecutionCollector();
        new ExecutionWalker(this).addPreVisitor(leafCollector).walkUntil();
        List<PvmExecutionImpl> leaves = leafCollector.getLeaves();
        leaves.remove(this);
        Collections.reverse(leaves);
        Map<ScopeImpl, PvmExecutionImpl> mapping = new HashMap<ScopeImpl, PvmExecutionImpl>();
        for (PvmExecutionImpl leaf : leaves) {
            ScopeImpl leafFlowScope = leaf.getFlowScope();
            PvmExecutionImpl leafFlowScopeExecution = leaf.getFlowScopeExecution();
            mapping = leafFlowScopeExecution.createActivityExecutionMapping(leafFlowScope, mapping);
        }
        mapping = this.createActivityExecutionMapping(currentScope, mapping);
        return mapping;
    }

    @Override
    public Map<ScopeImpl, PvmExecutionImpl> createActivityExecutionMapping() {
        ActivityImpl currentActivity = this.getActivity();
        EnsureUtil.ensureNotNull("activity of current execution", (Object)currentActivity);
        ScopeImpl flowScope = this.getFlowScope();
        PvmExecutionImpl flowScopeExecution = this.getFlowScopeExecution();
        return flowScopeExecution.createActivityExecutionMapping(flowScope);
    }

    protected PvmExecutionImpl getFlowScopeExecution() {
        if (!this.isScope || CompensationBehavior.executesNonScopeCompensationHandler(this)) {
            return this.getParent().getFlowScopeExecution();
        }
        return this;
    }

    protected ScopeImpl getFlowScope() {
        ActivityImpl activity = this.getActivity();
        if (!activity.isScope() || this.activityInstanceId == null || activity.isScope() && !this.isScope() && activity.getActivityBehavior() instanceof CompositeActivityBehavior) {
            return activity.getFlowScope();
        }
        return activity;
    }

    protected Map<ScopeImpl, PvmExecutionImpl> createActivityExecutionMapping(ScopeImpl currentScope, final Map<ScopeImpl, PvmExecutionImpl> mapping) {
        if (!this.isScope()) {
            throw new ProcessEngineException("Execution must be a scope execution");
        }
        if (!currentScope.isScope()) {
            throw new ProcessEngineException("Current scope must be a scope.");
        }
        ScopeExecutionCollector scopeExecutionCollector = new ScopeExecutionCollector();
        new ExecutionWalker(this).addPreVisitor(scopeExecutionCollector).walkWhile(new ReferenceWalker.WalkCondition<PvmExecutionImpl>(){

            @Override
            public boolean isFulfilled(PvmExecutionImpl element) {
                return element == null || mapping.containsValue(element);
            }
        });
        final List<PvmExecutionImpl> scopeExecutions = scopeExecutionCollector.getScopeExecutions();
        ScopeCollector scopeCollector = new ScopeCollector();
        new FlowScopeWalker(currentScope).addPreVisitor(scopeCollector).walkWhile(new ReferenceWalker.WalkCondition<ScopeImpl>(){

            @Override
            public boolean isFulfilled(ScopeImpl element) {
                return element == null || mapping.containsKey(element);
            }
        });
        final List<ScopeImpl> scopes = scopeCollector.getScopes();
        ScopeImpl topMostScope = scopes.get(scopes.size() - 1);
        new FlowScopeWalker(topMostScope.getFlowScope()).addPreVisitor(new TreeVisitor<ScopeImpl>(){

            @Override
            public void visit(ScopeImpl obj) {
                scopes.add(obj);
                PvmExecutionImpl priorMappingExecution = (PvmExecutionImpl)mapping.get(obj);
                if (priorMappingExecution != null && !scopeExecutions.contains(priorMappingExecution)) {
                    scopeExecutions.add(priorMappingExecution);
                }
            }
        }).walkWhile();
        if (scopes.size() == scopeExecutions.size()) {
            HashMap<ScopeImpl, PvmExecutionImpl> result = new HashMap<ScopeImpl, PvmExecutionImpl>();
            for (int i = 0; i < scopes.size(); ++i) {
                result.put(scopes.get(i), scopeExecutions.get(i));
            }
            return result;
        }
        return LegacyBehavior.createActivityExecutionMapping(scopeExecutions, scopes);
    }

    public String toString() {
        if (this.isProcessInstanceExecution()) {
            return "ProcessInstance[" + this.getToStringIdentity() + "]";
        }
        return (this.isConcurrent ? "Concurrent" : "") + (this.isScope ? "Scope" : "") + "Execution[" + this.getToStringIdentity() + "]";
    }

    protected String getToStringIdentity() {
        return this.id;
    }

    @Override
    public String getVariableScopeKey() {
        return "execution";
    }

    @Override
    public AbstractVariableScope getParentVariableScope() {
        return this.getParent();
    }

    @Override
    public void setVariable(String variableName, Object value, String targetActivityId) {
        String activityId = this.getActivityId();
        if (activityId != null && activityId.equals(targetActivityId)) {
            this.setVariableLocal(variableName, value);
        } else {
            PvmExecutionImpl executionForFlowScope = this.findExecutionForFlowScope(targetActivityId);
            if (executionForFlowScope != null) {
                executionForFlowScope.setVariableLocal(variableName, value);
            }
        }
    }

    protected PvmExecutionImpl findExecutionForFlowScope(final String targetScopeId) {
        EnsureUtil.ensureNotNull("target scope id", (Object)targetScopeId);
        ActivityImpl currentActivity = this.getActivity();
        EnsureUtil.ensureNotNull("activity of current execution", (Object)currentActivity);
        FlowScopeWalker walker = new FlowScopeWalker(currentActivity);
        ScopeImpl targetFlowScope = walker.walkUntil(new ReferenceWalker.WalkCondition<ScopeImpl>(){

            @Override
            public boolean isFulfilled(ScopeImpl scope) {
                return scope == null || scope.getId().equals(targetScopeId);
            }
        });
        if (targetFlowScope == null) {
            throw LOG.scopeNotFoundException(targetScopeId, this.getId());
        }
        return this.findExecutionForFlowScope(targetFlowScope);
    }

    public long getSequenceCounter() {
        return this.sequenceCounter;
    }

    public void setSequenceCounter(long sequenceCounter) {
        this.sequenceCounter = sequenceCounter;
    }

    public void incrementSequenceCounter() {
        ++this.sequenceCounter;
    }

    public boolean isExternallyTerminated() {
        return this.externallyTerminated;
    }

    public void setExternallyTerminated(boolean externallyTerminated) {
        this.externallyTerminated = externallyTerminated;
    }

    public String getDeleteReason() {
        return this.deleteReason;
    }

    public void setDeleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
    }

    public boolean isDeleteRoot() {
        return this.deleteRoot;
    }

    public void setDeleteRoot(boolean deleteRoot) {
        this.deleteRoot = deleteRoot;
    }

    @Override
    public TransitionImpl getTransition() {
        return this.transition;
    }

    public List<PvmTransition> getTransitionsToTake() {
        return this.transitionsToTake;
    }

    public void setTransitionsToTake(List<PvmTransition> transitionsToTake) {
        this.transitionsToTake = transitionsToTake;
    }

    @Override
    public String getCurrentTransitionId() {
        TransitionImpl transition = this.getTransition();
        if (transition != null) {
            return transition.getId();
        }
        return null;
    }

    public void setTransition(PvmTransition transition) {
        this.transition = (TransitionImpl)transition;
    }

    @Override
    public boolean isConcurrent() {
        return this.isConcurrent;
    }

    @Override
    public void setConcurrent(boolean isConcurrent) {
        this.isConcurrent = isConcurrent;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public void setEnded(boolean isEnded) {
        this.isEnded = isEnded;
    }

    @Override
    public boolean isEnded() {
        return this.isEnded;
    }

    @Override
    public boolean isCanceled() {
        return ActivityInstanceState.CANCELED.getStateCode() == this.activityInstanceState;
    }

    public void setCanceled(boolean canceled) {
        if (canceled) {
            this.activityInstanceState = ActivityInstanceState.CANCELED.getStateCode();
        }
    }

    @Override
    public boolean isCompleteScope() {
        return ActivityInstanceState.SCOPE_COMPLETE.getStateCode() == this.activityInstanceState;
    }

    public void setCompleteScope(boolean completeScope) {
        if (completeScope && !this.isCanceled()) {
            this.activityInstanceState = ActivityInstanceState.SCOPE_COMPLETE.getStateCode();
        }
    }

    public void setPreserveScope(boolean preserveScope) {
        this.preserveScope = preserveScope;
    }

    public boolean isPreserveScope() {
        return this.preserveScope;
    }

    public int getActivityInstanceState() {
        return this.activityInstanceState;
    }

    public boolean isInState(ActivityInstanceState state) {
        return this.activityInstanceState == state.getStateCode();
    }

    public boolean isEventScope() {
        return this.isEventScope;
    }

    public void setEventScope(boolean isEventScope) {
        this.isEventScope = isEventScope;
    }

    public ExecutionStartContext getExecutionStartContext() {
        return this.startContext;
    }

    public void disposeProcessInstanceStartContext() {
        this.startContext = null;
    }

    public void disposeExecutionStartContext() {
        this.startContext = null;
    }

    @Override
    public PvmActivity getNextActivity() {
        return this.nextActivity;
    }

    @Override
    public boolean isProcessInstanceExecution() {
        return this.getParent() == null;
    }

    public ProcessInstanceStartContext getProcessInstanceStartContext() {
        if (this.startContext != null && this.startContext instanceof ProcessInstanceStartContext) {
            return (ProcessInstanceStartContext)this.startContext;
        }
        return null;
    }

    public boolean hasProcessInstanceStartContext() {
        return this.startContext != null && this.startContext instanceof ProcessInstanceStartContext;
    }

    public void setStartContext(ExecutionStartContext startContext) {
        this.startContext = startContext;
    }

    public void setNextActivity(PvmActivity nextActivity) {
        this.nextActivity = nextActivity;
    }

    public PvmExecutionImpl getParentScopeExecution(boolean considerSuperExecution) {
        if (this.isProcessInstanceExecution()) {
            if (considerSuperExecution && this.getSuperExecution() != null) {
                PvmExecutionImpl superExecution = this.getSuperExecution();
                if (superExecution.isScope()) {
                    return superExecution;
                }
                return superExecution.getParent();
            }
            return null;
        }
        PvmExecutionImpl parent = this.getParent();
        if (parent.isScope()) {
            return parent;
        }
        return parent.getParent();
    }

    public void delayEvent(PvmExecutionImpl targetScope, VariableEvent variableEvent) {
        DelayedVariableEvent delayedVariableEvent = new DelayedVariableEvent(targetScope, variableEvent);
        this.delayEvent(delayedVariableEvent);
    }

    public void delayEvent(DelayedVariableEvent delayedVariableEvent) {
        Boolean hasConditionalEvents = this.getProcessDefinition().getProperties().get(BpmnProperties.HAS_CONDITIONAL_EVENTS);
        if (hasConditionalEvents == null || !hasConditionalEvents.equals(Boolean.TRUE)) {
            return;
        }
        if (this.isProcessInstanceExecution()) {
            this.delayedEvents.add(delayedVariableEvent);
        } else {
            this.getProcessInstance().delayEvent(delayedVariableEvent);
        }
    }

    public List<DelayedVariableEvent> getDelayedEvents() {
        if (this.isProcessInstanceExecution()) {
            return this.delayedEvents;
        }
        return this.getProcessInstance().getDelayedEvents();
    }

    public void clearDelayedEvents() {
        if (this.isProcessInstanceExecution()) {
            this.delayedEvents.clear();
        } else {
            this.getProcessInstance().clearDelayedEvents();
        }
    }

    public void dispatchDelayedEventsAndPerformOperation(final PvmAtomicOperation atomicOperation) {
        this.dispatchDelayedEventsAndPerformOperation(new Callback<PvmExecutionImpl, Void>(){

            @Override
            public Void callback(PvmExecutionImpl param) {
                param.performOperation(atomicOperation);
                return null;
            }
        });
    }

    public void dispatchDelayedEventsAndPerformOperation(final Callback<PvmExecutionImpl, Void> continuation) {
        PvmExecutionImpl execution = this;
        if (execution.getDelayedEvents().isEmpty()) {
            this.continueExecutionIfNotCanceled(continuation, execution);
            return;
        }
        this.continueIfExecutionDoesNotAffectNextOperation(new Callback<PvmExecutionImpl, Void>(){

            @Override
            public Void callback(PvmExecutionImpl execution) {
                PvmExecutionImpl.this.dispatchScopeEvents(execution);
                return null;
            }
        }, new Callback<PvmExecutionImpl, Void>(){

            @Override
            public Void callback(PvmExecutionImpl execution) {
                PvmExecutionImpl.this.continueExecutionIfNotCanceled(continuation, execution);
                return null;
            }
        }, execution);
    }

    public void continueIfExecutionDoesNotAffectNextOperation(Callback<PvmExecutionImpl, Void> dispatching, Callback<PvmExecutionImpl, Void> continuation, PvmExecutionImpl execution) {
        String lastActivityId = execution.getActivityId();
        String lastActivityInstanceId = this.getActivityInstanceId(execution);
        dispatching.callback(execution);
        execution = execution.getReplacedBy() != null ? execution.getReplacedBy() : execution;
        String currentActivityInstanceId = this.getActivityInstanceId(execution);
        String currentActivityId = execution.getActivityId();
        if (!execution.isCanceled() && this.isOnSameActivity(lastActivityInstanceId, lastActivityId, currentActivityInstanceId, currentActivityId)) {
            continuation.callback(execution);
        }
    }

    protected void continueExecutionIfNotCanceled(Callback<PvmExecutionImpl, Void> continuation, PvmExecutionImpl execution) {
        if (continuation != null && !execution.isCanceled()) {
            continuation.callback(execution);
        }
    }

    protected void dispatchScopeEvents(PvmExecutionImpl execution) {
        PvmExecutionImpl scopeExecution = execution.isScope() ? execution : execution.getParent();
        ArrayList<DelayedVariableEvent> delayedEvents = new ArrayList<DelayedVariableEvent>(scopeExecution.getDelayedEvents());
        scopeExecution.clearDelayedEvents();
        HashMap<PvmExecutionImpl, String> activityInstanceIds = new HashMap<PvmExecutionImpl, String>();
        HashMap<PvmExecutionImpl, String> activityIds = new HashMap<PvmExecutionImpl, String>();
        this.initActivityIds(delayedEvents, activityInstanceIds, activityIds);
        for (DelayedVariableEvent event : delayedEvents) {
            PvmExecutionImpl targetScope = event.getTargetScope();
            PvmExecutionImpl replaced = targetScope.getReplacedBy() != null ? targetScope.getReplacedBy() : targetScope;
            this.dispatchOnSameActivity(targetScope, replaced, activityIds, activityInstanceIds, event);
        }
    }

    protected void initActivityIds(List<DelayedVariableEvent> delayedEvents, Map<PvmExecutionImpl, String> activityInstanceIds, Map<PvmExecutionImpl, String> activityIds) {
        for (DelayedVariableEvent event : delayedEvents) {
            PvmExecutionImpl targetScope = event.getTargetScope();
            String targetScopeActivityInstanceId = this.getActivityInstanceId(targetScope);
            activityInstanceIds.put(targetScope, targetScopeActivityInstanceId);
            activityIds.put(targetScope, targetScope.getActivityId());
        }
    }

    private void dispatchOnSameActivity(PvmExecutionImpl targetScope, PvmExecutionImpl replacedBy, Map<PvmExecutionImpl, String> activityIds, Map<PvmExecutionImpl, String> activityInstanceIds, DelayedVariableEvent delayedVariableEvent) {
        String currentActivityInstanceId = this.getActivityInstanceId(targetScope);
        String currentActivityId = targetScope.getActivityId();
        String lastActivityInstanceId = activityInstanceIds.get(targetScope);
        String lastActivityId = activityIds.get(targetScope);
        boolean onSameAct = this.isOnSameActivity(lastActivityInstanceId, lastActivityId, currentActivityInstanceId, currentActivityId);
        if (targetScope != replacedBy && !onSameAct) {
            currentActivityInstanceId = this.getActivityInstanceId(replacedBy);
            currentActivityId = replacedBy.getActivityId();
            onSameAct = this.isOnSameActivity(lastActivityInstanceId, lastActivityId, currentActivityInstanceId, currentActivityId);
        }
        if (onSameAct && this.isOnDispatchableState(targetScope)) {
            targetScope.dispatchEvent(delayedVariableEvent.getEvent());
        }
    }

    private boolean isOnDispatchableState(PvmExecutionImpl targetScope) {
        ActivityImpl targetActivity = targetScope.getActivity();
        return targetScope.getActivityId() == null || !targetActivity.isScope() || targetScope.isInState(ActivityInstanceState.DEFAULT);
    }

    private boolean isOnSameActivity(String lastActivityInstanceId, String lastActivityId, String currentActivityInstanceId, String currentActivityId) {
        return lastActivityInstanceId == null && lastActivityInstanceId == currentActivityInstanceId && lastActivityId.equals(currentActivityId) || lastActivityInstanceId != null && lastActivityInstanceId.equals(currentActivityInstanceId) && (lastActivityId == null || lastActivityId.equals(currentActivityId));
    }

    private String getActivityInstanceId(PvmExecutionImpl targetScope) {
        if (targetScope.isConcurrent()) {
            return targetScope.getActivityInstanceId();
        }
        ActivityImpl targetActivity = targetScope.getActivity();
        if (targetActivity != null && targetActivity.getActivities().isEmpty()) {
            return targetScope.getActivityInstanceId();
        }
        return targetScope.getParentActivityInstanceId();
    }

    @Override
    public Incident createIncident(String incidentType, String configuration) {
        return this.createIncident(incidentType, configuration, null);
    }

    @Override
    public Incident createIncident(String incidentType, String configuration, String message) {
        IncidentContext incidentContext = new IncidentContext();
        incidentContext.setTenantId(this.getTenantId());
        incidentContext.setProcessDefinitionId(this.getProcessDefinitionId());
        incidentContext.setExecutionId(this.getId());
        incidentContext.setActivityId(this.getActivityId());
        incidentContext.setConfiguration(configuration);
        IncidentHandler incidentHandler = this.findIncidentHandler(incidentType);
        if (incidentHandler == null) {
            incidentHandler = new DefaultIncidentHandler(incidentType);
        }
        return incidentHandler.handleIncident(incidentContext, message);
    }

    @Override
    public void resolveIncident(String incidentId) {
        IncidentEntity incident = (IncidentEntity)Context.getCommandContext().getIncidentManager().findIncidentById(incidentId);
        IncidentHandler incidentHandler = this.findIncidentHandler(incident.getIncidentType());
        if (incidentHandler == null) {
            incidentHandler = new DefaultIncidentHandler(incident.getIncidentType());
        }
        IncidentContext incidentContext = new IncidentContext(incident);
        incidentHandler.resolveIncident(incidentContext);
    }

    public IncidentHandler findIncidentHandler(String incidentType) {
        Map<String, IncidentHandler> incidentHandlers = Context.getProcessEngineConfiguration().getIncidentHandlers();
        return incidentHandlers.get(incidentType);
    }
}

