/*
 * Copyright © 2013-2018 camunda services GmbH and various authors (info@camunda.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.camunda.bpm.engine.test.bpmn.event.error;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;

import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;

public class ThrowErrorDelegate extends AbstractBpmnActivityBehavior implements Serializable {

  public static final long serialVersionUID = 1L;

  @Override
  public void execute(ActivityExecution execution) throws Exception {
    handle(execution, "executed");
  }

  @Override
  public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
    handle(execution, "signaled");
  }

  protected void handle(ActivityExecution execution, String action) throws Exception {
    execution.setVariable(action, true);
    String type = (String) execution.getVariable("type");
    if ("error".equalsIgnoreCase(type)) {
      throw new BpmnError("MyError");
    }
    else if ("exception".equalsIgnoreCase(type)) {
      throw new MyBusinessException("MyException");
    }
    else if ("leave".equalsIgnoreCase(type)) {
      execution.setVariable("type", null);
      leave(execution);
    }
  }

  public static Map<String, Object> throwError() {
    return Collections.singletonMap("type", (Object) "error");
  }

  public static Map<String, Object> throwException() {
    return Collections.singletonMap("type", (Object) "exception");
  }

  public static Map<String, Object> leaveExecution() {
    return Collections.singletonMap("type", (Object) "leave");
  }

}
