/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.authorization.TaskPermissions;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.TaskServiceImpl;
import org.camunda.bpm.engine.impl.cfg.auth.DefaultAuthorizationProvider;
import org.camunda.bpm.engine.impl.cfg.auth.ResourceAuthorizationProvider;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.task.IdentityLink;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.camunda.bpm.engine.test.api.authorization.MyExtendedPermissionDefaultAuthorizationProvider;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class TaskAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    protected static final String CASE_KEY = "oneTaskCase";
    protected static final String DEMO_ASSIGNEE_PROCESS_KEY = "demoAssigneeProcess";
    protected static final String CANDIDATE_USERS_PROCESS_KEY = "candidateUsersProcess";
    protected static final String CANDIDATE_GROUPS_PROCESS_KEY = "candidateGroupsProcess";
    protected static final String INVALID_PERMISSION = "invalidPermission";
    protected String deploymentId;

    @Override
    public void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn", "org/camunda/bpm/engine/test/api/authorization/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/candidateUsersProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/candidateGroupsProcess.bpmn20.xml").getId();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.deleteDeployment(this.deploymentId);
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List variables = TaskAuthorizationTest.this.historyService.createHistoricVariableInstanceQuery().includeDeleted().list();
                for (HistoricVariableInstance variable : variables) {
                    commandContext.getDbEntityManager().delete((DbEntity)((HistoricVariableInstanceEntity)variable));
                }
                return null;
            }
        });
    }

    public void testSimpleQueryWithTaskInsideProcessWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testSimpleQueryWithTaskInsideProcessWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testSimpleQueryWithTaskInsideProcessWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testSimpleQueryWithTaskInsideProcessWithReadPermissionOnOneTaskProcess() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testSimpleQueryWithTaskInsideProcessWithReadPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_TASK});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testSimpleQueryWithMultiple() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_TASK});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testQueryWithTaskInsideProcessWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryWithTaskInsideProcessWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.disableAuthorization();
        String taskId = ((Task)this.taskService.createTaskQuery().processDefinitionKey(PROCESS_KEY).listPage(0, 1).get(0)).getId();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testQueryWithTaskInsideProcessWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 7);
    }

    public void testQueryWithTaskInsideProcessWithReadPermissionOnOneTaskProcess() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 3);
    }

    public void testQueryWithTaskInsideProcessWithReadPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_TASK});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 7);
    }

    public void testQueryWithTaskInsideCaseWithoutAuthorization() {
        this.createCaseInstanceByKey(CASE_KEY);
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testQueryWithStandaloneTaskWithoutAuthorization() {
        String taskId = "newTask";
        this.createTask(taskId);
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 0);
        this.deleteTask(taskId, true);
    }

    public void testQueryWithStandaloneTaskWithReadPermissionOnTask() {
        String taskId = "newTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 1);
        this.deleteTask(taskId, true);
    }

    public void testNewTaskWithoutAuthorization() {
        try {
            this.taskService.newTask();
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to create a new task.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'Task'", e.getMessage());
        }
    }

    public void testNewTask() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE});
        Task task = this.taskService.newTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
    }

    public void testSaveTaskInsertWithoutAuthorization() {
        TaskEntity task = TaskEntity.create();
        try {
            this.taskService.saveTask((Task)task);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to save a task.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'Task'", e.getMessage());
        }
    }

    public void testSaveTaskInsert() {
        TaskEntity task = TaskEntity.create();
        task.setAssignee("demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.taskService.saveTask((Task)task);
        task = (TaskEntity)this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
        String taskId = task.getId();
        this.deleteTask(taskId, true);
    }

    public void testSaveAndUpdateTaskWithTaskAssignPermission() {
        TaskEntity task = TaskEntity.create();
        task.setAssignee("demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE, Permissions.TASK_ASSIGN});
        this.taskService.saveTask((Task)task);
        task.delegate("demoNew");
        this.taskService.saveTask((Task)task);
        task = (TaskEntity)this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demoNew", (String)task.getAssignee());
        String taskId = task.getId();
        this.deleteTask(taskId, true);
    }

    public void testSaveStandaloneTaskUpdateWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        Task task = this.selectSingleTask();
        try {
            this.taskService.saveTask(task);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to save a task.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN'", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testSaveStandaloneTaskUpdate() {
        String taskId = "myTask";
        this.createTask(taskId);
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.saveTask(task);
        task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
        this.deleteTask(taskId, true);
    }

    public void testSaveProcessTaskUpdateWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        try {
            this.taskService.saveTask(task);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to save a task.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(task.getId(), message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSaveProcessTaskUpdateWithUpdatePermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.createGrantAuthorization((Resource)Resources.TASK, task.getId(), this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.saveTask(task);
        task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testSaveProcessTaskUpdateWithTaskAssignPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.createGrantAuthorization((Resource)Resources.TASK, task.getId(), this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.saveTask(task);
        task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testSaveProcessTaskUpdateWithUpdatePermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.saveTask(task);
        task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testSaveProcessTaskUpdateWithTaskAssignPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.saveTask(task);
        task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testSaveProcessTaskUpdateWithUpdateTasksPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.saveTask(task);
        task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testSaveProcessTaskUpdateWithTaskAssignPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.saveTask(task);
        task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testSaveCaseTaskUpdate() {
        this.createCaseInstanceByKey(CASE_KEY);
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.taskService.saveTask(task);
        task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testDeleteTaskWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.deleteTask(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete a task.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'DELETE' permission on resource 'myTask' of type 'Task'", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testDeleteTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.DELETE});
        this.taskService.deleteTask(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNull((Object)task);
        this.deleteTask(taskId, true);
    }

    public void testDeleteTasksWithoutAuthorization() {
        String firstTaskId = "myTask1";
        this.createTask(firstTaskId);
        String secondTaskId = "myTask2";
        this.createTask(secondTaskId);
        try {
            this.taskService.deleteTasks(Arrays.asList(firstTaskId, secondTaskId));
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete tasks.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'DELETE' permission on resource 'myTask1' of type 'Task'", e.getMessage());
        }
        this.deleteTask(firstTaskId, true);
        this.deleteTask(secondTaskId, true);
    }

    public void testDeleteTasksWithDeletePermissionOnFirstTask() {
        String firstTaskId = "myTask1";
        this.createTask(firstTaskId);
        this.createGrantAuthorization((Resource)Resources.TASK, firstTaskId, this.userId, new Permission[]{Permissions.DELETE});
        String secondTaskId = "myTask2";
        this.createTask(secondTaskId);
        try {
            this.taskService.deleteTasks(Arrays.asList(firstTaskId, secondTaskId));
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete tasks.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'DELETE' permission on resource 'myTask2' of type 'Task'", e.getMessage());
        }
        this.deleteTask(firstTaskId, true);
        this.deleteTask(secondTaskId, true);
    }

    public void testDeleteTasks() {
        String firstTaskId = "myTask1";
        this.createTask(firstTaskId);
        String secondTaskId = "myTask2";
        this.createTask(secondTaskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.DELETE});
        this.taskService.deleteTasks(Arrays.asList(firstTaskId, secondTaskId));
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNull((Object)task);
        this.deleteTask(firstTaskId, true);
        this.deleteTask(secondTaskId, true);
    }

    public void testStandaloneTaskSetAssigneeWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.setAssignee(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to set an assignee");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetAssignee() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetAssigneeWithTaskAssignPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskSetAssigneeWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.setAssignee(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to set an assignee");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskSetAssigneeWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskSetAssigneeWithTaskAssignPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskSetAssigneeWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskSetAssigneeWithTaskAssignPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskSetAssigneeWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskSetAssigneeWithTaskAssignPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskSetAssignee() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testCaseTaskSetAssignee() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testStandaloneTaskSetOwnerWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.setOwner(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to set an owner");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetOwner() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getOwner());
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetOwnerWithTaskAssignPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getOwner());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskSetOwnerWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.setOwner(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to set an owner");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskSetOwnerWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getOwner());
    }

    public void testProcessTaskSetOwnerWithTaskAssignPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getOwner());
    }

    public void testProcessTaskSetOwnerWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getOwner());
    }

    public void testProcessTaskSetOwnerWithTaskAssignPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getOwner());
    }

    public void testProcessTaskSetOwnerWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getOwner());
    }

    public void testProcessTaskSetOwnerWithTaskAssignPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getOwner());
    }

    public void testProcessTaskSetOwner() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getOwner());
    }

    public void testProcessTaskSetOwnerWithTaskAssignPermission() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getOwner());
    }

    public void testCaseTaskSetOwner() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getOwner());
    }

    public void testStandaloneTaskAddCandidateUserWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.addCandidateUser(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to add a candidate user");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskAddCandidateUser() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskAddCandidateUserWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.addCandidateUser(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to add a candidate user");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskAddCandidateUserWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddCandidateUserWithTaskAssignPermissionRevokeOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createRevokeAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.taskService.addCandidateUser(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to add an user identity link");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
    }

    public void testProcessTaskAddCandidateUserWithTaskAssignPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddCandidateUserWithGrantTaskAssignAndRevokeUpdatePermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.createRevokeAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddCandidateUserWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddCandidateUserWithTaskAssignPersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddCandidateUserWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddCandidateUserWithTaskAssignPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddCandidateUser() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testCaseTaskAddCandidateUser() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testStandaloneTaskAddCandidateGroupWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.addCandidateGroup(taskId, "accounting");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to add a candidate group");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskAddCandidateGroup() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskAddCandidateGroupWithTaskAssignPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskAddCandidateGroupWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.addCandidateGroup(taskId, "accounting");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to add a candidate group");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskAddCandidateGroupWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddCandidateGroupWithTaskAssignPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddCandidateGroupWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddCandidateGroupWithTaskAssignPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddCandidateGroupWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddCandidateGroupWithTaskAssignPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddCandidateGroup() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddCandidateGroupWithTaskAssignPermission() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddCandidateGroupWithTaskAssignPermissionRevoked() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createRevokeAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testCaseTaskAddCandidateGroup() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testStandaloneTaskAddUserIdentityLinkWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to add an user identity link");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskAddUserIdentityLink() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskAddUserIdentityLinkWithTaskAssignPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskAddUserIdentityLinkWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to add an user identity link");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskAddUserIdentityLinkWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddUserIdentityLinkWithTaskAssignPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddUserIdentityLinkWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddUserIdentityLinkWithTaskAssignPersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddUserIdentityLinkWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddUserIdentityLinkWithTaskAssignPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddUserIdentityLink() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testCaseTaskAddUserIdentityLink() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)identityLink.getUserId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testStandaloneTaskAddGroupIdentityLinkWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to add a group identity link");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskAddGroupIdentityLink() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskAddGroupIdentityLinkWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to add a group identity link");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskAddGroupIdentityLinkWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddGroupIdentityLinkWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddGroupIdentityLinkWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testProcessTaskAddGroupIdentityLink() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testCaseTaskAddGroupIdentityLink() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertEquals((int)1, (int)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        TaskAuthorizationTest.assertNotNull((Object)identityLink);
        TaskAuthorizationTest.assertEquals((String)"accounting", (String)identityLink.getGroupId());
        TaskAuthorizationTest.assertEquals((String)"candidate", (String)identityLink.getType());
    }

    public void testStandaloneTaskDeleteCandidateUserWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateUser(taskId, "demo");
        try {
            this.taskService.deleteCandidateUser(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete a candidate user");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskDeleteCandidateUser() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskDeleteCandidateUserWithTaskAssignPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskDeleteCandidateUserWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        try {
            this.taskService.deleteCandidateUser(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete a candidate user");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskDeleteCandidateUserWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteCandidateUserWithTaskAssignPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteCandidateUserWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteCandidateUserWithTaskAssignPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteCandidateUserWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteCandidateUserWithTaskAssignPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteCandidateUser() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testCaseTaskDeleteCandidateUser() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testStandaloneTaskDeleteCandidateGroupWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateGroup(taskId, "accounting");
        try {
            this.taskService.deleteCandidateGroup(taskId, "accounting");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete a candidate group");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskDeleteCandidateGroup() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskDeleteCandidateGroupWithTaskAssignPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskDeleteCandidateGroupWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        try {
            this.taskService.deleteCandidateGroup(taskId, "accounting");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete a candidate group");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskDeleteCandidateGroupWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteCandidateGroupWithTaskAssignPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteCandidateGroupWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteCandidateGroupWithTaskAssignPersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteCandidateGroupWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteCandidateGroupWithTaskAssignPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteCandidateGroup() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testCaseTaskDeleteCandidateGroup() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testStandaloneTaskDeleteUserIdentityLinkWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateUser(taskId, "demo");
        try {
            this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete an user identity link");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskDeleteUserIdentityLink() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskDeleteUserIdentityLinkWithTaskAssignPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskDeleteUserIdentityLinkWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        try {
            this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete an user identity link");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskDeleteUserIdentityLinkWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteUserIdentityLinkWithTaskAssignPersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteUserIdentityLinkWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteUserIdentityLinkWithTaskAssignPersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteUserIdentityLinkWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteUserIdentityLinkWithTaskAssignPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteUserIdentityLink() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteUserIdentityLinkWithTaskAssignPermission() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testCaseTaskDeleteUserIdentityLink() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testStandaloneTaskDeleteGroupIdentityLinkWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateGroup(taskId, "accounting");
        try {
            this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete a group identity link");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskDeleteGroupIdentityLink() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskDeleteGroupIdentityLinkWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        try {
            this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete a group identity link");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskDeleteGroupIdentityLinkWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteGroupIdentityLinkWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteGroupIdentityLinkWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testProcessTaskDeleteGroupIdentityLink() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testCaseTaskDeleteGroupIdentityLink() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)linksForTask);
        TaskAuthorizationTest.assertTrue((boolean)linksForTask.isEmpty());
    }

    public void testStandaloneTaskGetIdentityLinksWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateUser(taskId, "demo");
        try {
            this.taskService.getIdentityLinksForTask(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to get identity links");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'READ' permission on resource 'myTask' of type 'Task'", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskGetIdentityLinks() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        List identityLinksForTask = this.taskService.getIdentityLinksForTask(taskId);
        TaskAuthorizationTest.assertNotNull((Object)identityLinksForTask);
        TaskAuthorizationTest.assertFalse((boolean)identityLinksForTask.isEmpty());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskGetIdentityLinksWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        try {
            this.taskService.getIdentityLinksForTask(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to get the identity links");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.READ_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskGetIdentityLinksWithReadPersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        List identityLinksForTask = this.taskService.getIdentityLinksForTask(taskId);
        TaskAuthorizationTest.assertNotNull((Object)identityLinksForTask);
        TaskAuthorizationTest.assertFalse((boolean)identityLinksForTask.isEmpty());
    }

    public void testProcessTaskGetIdentityLinksWithReadPersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        List identityLinksForTask = this.taskService.getIdentityLinksForTask(taskId);
        TaskAuthorizationTest.assertNotNull((Object)identityLinksForTask);
        TaskAuthorizationTest.assertFalse((boolean)identityLinksForTask.isEmpty());
    }

    public void testProcessTaskGetIdentityLinksWithReadTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        List identityLinksForTask = this.taskService.getIdentityLinksForTask(taskId);
        TaskAuthorizationTest.assertNotNull((Object)identityLinksForTask);
        TaskAuthorizationTest.assertFalse((boolean)identityLinksForTask.isEmpty());
    }

    public void testProcessTaskGetIdentityLinks() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        List identityLinksForTask = this.taskService.getIdentityLinksForTask(taskId);
        TaskAuthorizationTest.assertNotNull((Object)identityLinksForTask);
        TaskAuthorizationTest.assertFalse((boolean)identityLinksForTask.isEmpty());
    }

    public void testCaseTaskGetIdentityLinks() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        List identityLinksForTask = this.taskService.getIdentityLinksForTask(taskId);
        TaskAuthorizationTest.assertNotNull((Object)identityLinksForTask);
        TaskAuthorizationTest.assertFalse((boolean)identityLinksForTask.isEmpty());
    }

    public void testStandaloneTaskClaimTaskWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.claim(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to claim the task.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have one of the following permissions:", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskClaimTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskClaimTaskWithTaskWorkPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_WORK});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskClaimTaskWithRevokeTaskWorkPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createRevokeAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_WORK});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.taskService.claim(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to complete a task");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_WORK", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskClaimTaskWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.claim(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to claim the task");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskClaimTaskWithUpdatePermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskClaimTaskWithTaskWorkPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_WORK});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskClaimTaskWithGrantTaskWorkAndRevokeUpdatePermissionsOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_WORK});
        this.createRevokeAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskClaimTaskWithRevokeTaskWorkPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createRevokeAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_WORK});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.taskService.complete(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to complete a task");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_WORK", e.getMessage());
        }
    }

    public void testProcessTaskClaimTaskWithUpdatePermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskClaimTaskWithTaskWorkPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_WORK});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskClaimTaskWithUpdateTasksPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskClaimTaskWithTaskWorkPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_WORK});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskClaimTaskWithRevokeTaskWorkPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createRevokeAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_WORK});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        try {
            this.taskService.complete(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to complete a task");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_WORK", e.getMessage());
        }
    }

    public void testProcessTaskClaimTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testCaseTaskClaimTask() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testStandaloneTaskCompleteTaskWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.complete(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to complete a task");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_WORK", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskCompleteTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNull((Object)task);
        if (!this.processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_NONE)) {
            this.historyService.deleteHistoricTaskInstance(taskId);
        }
    }

    public void testStandaloneTaskCompleteWithTaskWorkPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_WORK});
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNull((Object)task);
        if (!this.processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_NONE)) {
            this.historyService.deleteHistoricTaskInstance(taskId);
        }
    }

    public void testProcessTaskCompleteTaskWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.complete(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to complete a task");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskCompleteTaskWithUpdatePermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNull((Object)task);
    }

    public void testProcessTaskCompleteTaskWithTaskWorkPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_WORK});
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNull((Object)task);
    }

    public void testProcessTaskCompleteTaskWithUpdatePermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNull((Object)task);
    }

    public void testProcessTaskCompleteTaskWithUpdateTasksPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNull((Object)task);
    }

    public void testProcessTaskCompleteTaskWithTaskWorkPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_WORK});
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNull((Object)task);
    }

    public void testProcessTaskCompleteTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNull((Object)task);
    }

    public void testCaseTaskCompleteTask() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNull((Object)task);
    }

    public void testStandaloneTaskDelegateTaskWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.delegateTask(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delegate a task");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskDelegateTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskDelegateTaskWithTaskAssignPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskDelegateTaskWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.delegateTask(taskId, "demo");
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to delegate a task");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskDelegateTaskWithUpdatePermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskDelegateTaskWithTaskAssignPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskDelegateTaskWithUpdatePermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskDelegateTaskWithTaskAssignPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskDelegateTaskWithUpdateTasksPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskDelegateTaskWithTaskAssignPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskDelegateTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testProcessTaskDelegateTaskWithTaskAssignPermission() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testCaseTaskDelegateTask() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)"demo", (String)task.getAssignee());
    }

    public void testStandaloneTaskResolveTaskWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.resolveTask(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to resolve a task");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_WORK", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskResolveTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.setAssignee(taskId, this.userId);
        this.delegateTask(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.resolveTask(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)this.userId, (String)task.getAssignee());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskResolveTaskWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.resolveTask(taskId);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to resolve a task");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskResolveTaskWithUpdatePermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, this.userId);
        this.delegateTask(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.resolveTask(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)this.userId, (String)task.getAssignee());
    }

    public void testProcessTaskResolveTaskWithUpdatePermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, this.userId);
        this.delegateTask(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.resolveTask(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)this.userId, (String)task.getAssignee());
    }

    public void testProcessTaskResolveTaskWithUpdateTasksPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, this.userId);
        this.delegateTask(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.resolveTask(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)this.userId, (String)task.getAssignee());
    }

    public void testProcessTaskResolveTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, this.userId);
        this.delegateTask(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.resolveTask(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)this.userId, (String)task.getAssignee());
    }

    public void testCaseTaskResolveTask() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, this.userId);
        this.delegateTask(taskId, "demo");
        this.taskService.resolveTask(taskId);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)this.userId, (String)task.getAssignee());
    }

    public void testStandaloneTaskSetPriorityWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.setPriority(taskId, 80);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to set a priority");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN'", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetPriority() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((int)80, (int)task.getPriority());
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetPriorityWithTaskAssignPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((int)80, (int)task.getPriority());
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskSetPriorityWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.setPriority(taskId, 80);
            TaskAuthorizationTest.fail((String)"Exception expected: It should not be possible to set a priority");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(taskId, message);
            this.assertTextPresent(Resources.TASK.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testProcessTaskSetPriorityWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((int)80, (int)task.getPriority());
    }

    public void testProcessTaskSetPriorityWithTaskAssignPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((int)80, (int)task.getPriority());
    }

    public void testProcessTaskSetPriorityWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((int)80, (int)task.getPriority());
    }

    public void testProcessTaskSetPriorityWithTaskAssignPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((int)80, (int)task.getPriority());
    }

    public void testProcessTaskSetPriorityWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((int)80, (int)task.getPriority());
    }

    public void testProcessTaskSetPriorityWithTaskAssignPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((int)80, (int)task.getPriority());
    }

    public void testProcessTaskSetPriority() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((int)80, (int)task.getPriority());
    }

    public void testProcessTaskSetPriorityWithTaskAssignPermission() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((int)80, (int)task.getPriority());
    }

    public void testCaseTaskSetPriority() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((int)80, (int)task.getPriority());
    }

    public void testStandaloneTaskGetSubTasksWithoutAuthorization() {
        String parentTaskId = "parentTaskId";
        this.createTask(parentTaskId);
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        TaskAuthorizationTest.assertTrue((boolean)subTasks.isEmpty());
        this.deleteTask(parentTaskId, true);
    }

    public void testStandaloneTaskGetSubTasksWithReadPermissionOnSub1() {
        String parentTaskId = "parentTaskId";
        this.createTask(parentTaskId);
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, "sub1", this.userId, new Permission[]{Permissions.READ});
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        TaskAuthorizationTest.assertFalse((boolean)subTasks.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)subTasks.size());
        TaskAuthorizationTest.assertEquals((String)"sub1", (String)((Task)subTasks.get(0)).getId());
        this.deleteTask(parentTaskId, true);
    }

    public void testStandaloneTaskGetSubTasks() {
        String parentTaskId = "parentTaskId";
        this.createTask(parentTaskId);
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        TaskAuthorizationTest.assertFalse((boolean)subTasks.isEmpty());
        TaskAuthorizationTest.assertEquals((int)2, (int)subTasks.size());
        this.deleteTask(parentTaskId, true);
    }

    public void testProcessTaskGetSubTasksWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String parentTaskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        TaskAuthorizationTest.assertTrue((boolean)subTasks.isEmpty());
    }

    public void testProcessTaskGetSubTasksWithReadPermissionOnSub1() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String parentTaskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, "sub1", this.userId, new Permission[]{Permissions.READ});
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        TaskAuthorizationTest.assertFalse((boolean)subTasks.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)subTasks.size());
        TaskAuthorizationTest.assertEquals((String)"sub1", (String)((Task)subTasks.get(0)).getId());
    }

    public void testProcessTaskGetSubTasks() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String parentTaskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        TaskAuthorizationTest.assertFalse((boolean)subTasks.isEmpty());
        TaskAuthorizationTest.assertEquals((int)2, (int)subTasks.size());
    }

    public void testCaseTaskGetSubTasksWithoutAuthorization() {
        this.createCaseInstanceByKey(CASE_KEY);
        String parentTaskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        TaskAuthorizationTest.assertTrue((boolean)subTasks.isEmpty());
    }

    public void testCaseTaskGetSubTasksWithReadPermissionOnSub1() {
        this.createCaseInstanceByKey(CASE_KEY);
        String parentTaskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, "sub1", this.userId, new Permission[]{Permissions.READ});
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        TaskAuthorizationTest.assertFalse((boolean)subTasks.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)subTasks.size());
        TaskAuthorizationTest.assertEquals((String)"sub1", (String)((Task)subTasks.get(0)).getId());
    }

    public void testCaseTaskGetSubTasks() {
        this.createCaseInstanceByKey(CASE_KEY);
        String parentTaskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        TaskAuthorizationTest.assertFalse((boolean)subTasks.isEmpty());
        TaskAuthorizationTest.assertEquals((int)2, (int)subTasks.size());
    }

    public void testStandaloneTaskClearAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(taskId).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        this.taskService.complete(taskId);
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(taskId).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNull((Object)authorization);
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskClearAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(taskId).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        this.taskService.complete(taskId);
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(taskId).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNull((Object)authorization);
    }

    public void testStandaloneTaskSetAssigneeCreateNewAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetAssigneeUpdateAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.setAssignee(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetAssigneeToNullAuthorizationStillAvailable() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        this.taskService.setAssignee(taskId, null);
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    public void testQueryStandaloneTaskSetAssignee() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetAssigneeOutsideCommandContextInsert() {
        String taskId = "myTask";
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        Task task = this.taskService.newTask(taskId);
        task.setAssignee("demo");
        this.taskService.saveTask(task);
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetAssigneeOutsideCommandContextSave() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.taskService.saveTask(task);
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskSetAssigneeCreateNewAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
    }

    public void testProcessTaskSetAssigneeUpdateAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.setAssignee(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
    }

    public void testProcessTaskSetAssigneeToNullAuthorizationStillAvailable() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        this.taskService.setAssignee(taskId, null);
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
    }

    public void testQueryProcessTaskSetAssignee() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
    }

    public void testProcessTaskAssignee() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, DEMO_ASSIGNEE_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.runtimeService.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
    }

    public void testCaseTaskSetAssigneeNoAuthorization() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNull((Object)authorization);
    }

    public void testStandaloneTaskSetOwnerCreateNewAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetOwnerUpdateAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.setOwner(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    public void testQueryStandaloneTaskSetOwner() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetOwnerOutsideCommandContextInsert() {
        String taskId = "myTask";
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        Task task = this.taskService.newTask(taskId);
        task.setOwner("demo");
        this.taskService.saveTask(task);
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskSetOwnerOutsideCommandContextSave() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        Task task = this.selectSingleTask();
        task.setOwner("demo");
        this.taskService.saveTask(task);
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskSetOwnerCreateNewAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
    }

    public void testProcessTaskSetOwnerUpdateAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.setOwner(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
    }

    public void testQueryProcessTaskSetOwner() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
    }

    public void testCaseTaskSetOwnerNoAuthorization() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNull((Object)authorization);
    }

    public void testStandaloneTaskAddCandidateUserCreateNewAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskAddCandidateUserUpdateAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    public void testQueryStandaloneTaskAddCandidateUser() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        this.deleteTask(taskId, true);
    }

    public void testQueryStandaloneTaskAddCandidateUserWithTaskAssignPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addCandidateUser(taskId, "demo");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskAddCandidateUserCreateNewAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
    }

    public void testProcessTaskAddCandidateUserUpdateAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
    }

    public void testQueryProcessTaskAddCandidateUser() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
    }

    public void testProcessTaskCandidateUsers() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, CANDIDATE_USERS_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.runtimeService.startProcessInstanceByKey(CANDIDATE_USERS_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"test"}).resourceId(taskId).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
    }

    public void testCaseTaskAddCandidateUserNoAuthorization() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNull((Object)authorization);
    }

    public void testStandaloneTaskAddCandidateGroupCreateNewAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "management");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"management"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    public void testStandaloneTaskAddCandidateGroupUpdateAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.addCandidateGroup(taskId, "management");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"management"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    public void testQueryStandaloneTaskAddCandidateGroup() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "management");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", Arrays.asList("management"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        this.deleteTask(taskId, true);
    }

    public void testProcessTaskAddCandidateGroupCreateNewAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "management");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"management"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
    }

    public void testProcessTaskAddCandidateGroupUpdateAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.addCandidateGroup(taskId, "management");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"management"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
    }

    public void testQueryProcessTaskAddCandidateGroup() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "management");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", Arrays.asList("management"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
    }

    public void testProcessTaskCandidateGroups() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, CANDIDATE_GROUPS_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.runtimeService.startProcessInstanceByKey(CANDIDATE_GROUPS_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"management"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"accounting"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNotNull((Object)authorization);
        TaskAuthorizationTest.assertEquals((int)Resources.TASK.resourceType(), (int)authorization.getResourceType());
        TaskAuthorizationTest.assertEquals((String)taskId, (String)authorization.getResourceId());
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        TaskAuthorizationTest.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", Arrays.asList("management"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskAuthorizationTest.assertNotNull((Object)task);
        TaskAuthorizationTest.assertEquals((String)taskId, (String)task.getId());
    }

    public void testCaseTaskAddCandidateGroupNoAuthorization() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "management");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"management"}).singleResult();
        this.enableAuthorization();
        TaskAuthorizationTest.assertNull((Object)authorization);
    }

    public void testCaseTaskGetVariable() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        Object variable = this.taskService.getVariable(taskId, "aVariableName");
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testCaseTaskGetVariableLocal() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Object variable = this.taskService.getVariableLocal(taskId, "aVariableName");
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testCaseTaskGetVariableTyped() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        TypedValue typedValue = this.taskService.getVariableTyped(taskId, "aVariableName");
        TaskAuthorizationTest.assertNotNull((Object)typedValue);
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testCaseTaskGetVariableLocalTyped() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        TypedValue typedValue = this.taskService.getVariableLocalTyped(taskId, "aVariableName");
        TaskAuthorizationTest.assertNotNull((Object)typedValue);
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testCaseTaskGetVariables() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        Map variables = this.taskService.getVariables(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testCaseTaskGetVariablesLocal() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Map variables = this.taskService.getVariablesLocal(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testCaseTaskGetVariablesTyped() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        VariableMap variables = this.taskService.getVariablesTyped(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testCaseTaskGetVariablesLocalTyped() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        VariableMap variables = this.taskService.getVariablesLocalTyped(taskId);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testCaseTaskGetVariablesByName() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        Map variables = this.taskService.getVariables(taskId, Arrays.asList("aVariableName"));
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testCaseTaskGetVariablesLocalByName() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Map variables = this.taskService.getVariablesLocal(taskId, Arrays.asList("aVariableName"));
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testCaseTaskGetVariablesTypedByName() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        VariableMap variables = this.taskService.getVariablesTyped(taskId, Arrays.asList("aVariableName"), false);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testCaseTaskGetVariablesLocalTypedByName() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        VariableMap variables = this.taskService.getVariablesLocalTyped(taskId, Arrays.asList("aVariableName"), false);
        TaskAuthorizationTest.assertNotNull((Object)variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testCaseTaskSetVariable() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.verifySetVariable(taskId);
    }

    public void testCaseTaskSetVariableLocal() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.verifySetVariableLocal(taskId);
    }

    public void testCaseTaskSetVariables() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.verifySetVariables(taskId);
    }

    public void testCaseTaskSetVariablesLocal() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.verifySetVariablesLocal(taskId);
    }

    public void testCaseTaskRemoveVariable() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.verifyRemoveVariable(taskId);
    }

    public void testCaseTaskRemoveVariableLocal() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
        this.enableAuthorization();
        this.verifyRemoveVariableLocal(taskId);
    }

    public void testCaseTaskRemoveVariables() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.verifyRemoveVariables(taskId);
    }

    public void testCaseTaskRemoveVariablesLocal() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
        this.enableAuthorization();
        this.verifyRemoveVariablesLocal(taskId);
    }

    public void testCaseTaskUpdateVariablesLocal() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.verifyUpdateVariablesLocal(taskId);
    }

    public void testCaseTaskUpdateVariables() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.verifyUpdateVariables(taskId);
    }

    public void testStandaloneTaskSaveWithGenericResourceIdOwner() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE});
        Task task = this.taskService.newTask();
        task.setOwner("*");
        try {
            this.taskService.saveTask(task);
            TaskAuthorizationTest.fail((String)"it should not be possible to save a task with the generic resource id *");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot create default authorization for owner *: id cannot be *. * is a reserved identifier", e.getMessage());
        }
    }

    public void testStandaloneTaskSaveWithGenericResourceIdOwnerTaskServiceApi() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE, Permissions.UPDATE});
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        try {
            this.taskService.setOwner(task.getId(), "*");
            TaskAuthorizationTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot create default authorization for owner *: id cannot be *. * is a reserved identifier", e.getMessage());
        }
        this.deleteTask(task.getId(), true);
    }

    public void testStandaloneTaskSaveWithGenericResourceIdAssignee() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE});
        Task task = this.taskService.newTask();
        task.setAssignee("*");
        try {
            this.taskService.saveTask(task);
            TaskAuthorizationTest.fail((String)"it should not be possible to save a task with the generic resource id *");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot create default authorization for assignee *: id cannot be *. * is a reserved identifier", e.getMessage());
        }
    }

    public void testStandaloneTaskSaveWithGenericResourceIdAssigneeTaskServiceApi() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE, Permissions.UPDATE});
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        try {
            this.taskService.setAssignee(task.getId(), "*");
            TaskAuthorizationTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot create default authorization for assignee *: id cannot be *. * is a reserved identifier", e.getMessage());
        }
        this.deleteTask(task.getId(), true);
    }

    public void testStandaloneTaskSaveIdentityLinkWithGenericUserId() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE, Permissions.UPDATE});
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        try {
            this.taskService.addUserIdentityLink(task.getId(), "*", "someLink");
            TaskAuthorizationTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot grant default authorization for identity link to user *: id cannot be *. * is a reserved identifier.", e.getMessage());
        }
        this.deleteTask(task.getId(), true);
    }

    public void testStandaloneTaskSaveIdentityLinkWithGenericGroupId() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE, Permissions.UPDATE});
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        try {
            this.taskService.addGroupIdentityLink(task.getId(), "*", "someLink");
            TaskAuthorizationTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot grant default authorization for identity link to group *: id cannot be *. * is a reserved identifier.", e.getMessage());
        }
        this.deleteTask(task.getId(), true);
    }

    public void testStandaloneTaskSaveIdentityLinkWithGenericGroupIdAndTaskAssignPermission() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE, Permissions.TASK_ASSIGN});
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        try {
            this.taskService.addGroupIdentityLink(task.getId(), "*", "someLink");
            TaskAuthorizationTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot grant default authorization for identity link to group *: id cannot be *. * is a reserved identifier.", e.getMessage());
        }
        this.deleteTask(task.getId(), true);
    }

    public void testStandaloneTaskSaveIdentityLinkWithGenericTaskId() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE, Permissions.UPDATE});
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        try {
            this.taskService.addUserIdentityLink("*", "aUserId", "someLink");
            TaskAuthorizationTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot find task with id *", e.getMessage());
        }
        try {
            this.taskService.addGroupIdentityLink("*", "aGroupId", "someLink");
            TaskAuthorizationTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot find task with id *", e.getMessage());
        }
        this.deleteTask(task.getId(), true);
    }

    public void testStandaloneTaskSaveIdentityLinkWithGenericTaskIdAndTaskAssignPermission() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE, Permissions.TASK_ASSIGN});
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        try {
            this.taskService.addUserIdentityLink("*", "aUserId", "someLink");
            TaskAuthorizationTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot find task with id *", e.getMessage());
        }
        try {
            this.taskService.addGroupIdentityLink("*", "aGroupId", "someLink");
            TaskAuthorizationTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot find task with id *", e.getMessage());
        }
        this.deleteTask(task.getId(), true);
    }

    @Deployment
    public void testSetGenericResourceIdAssignee() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.startProcessInstanceByKey("genericResourceIdAssignmentProcess");
            TaskAuthorizationTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot create default authorization for assignee *: id cannot be *. * is a reserved identifier.", e.getMessage());
        }
    }

    public void testAssignSameAssigneeAndOwnerToTask() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.ALL});
        Task newTask = this.taskService.newTask();
        newTask.setAssignee("Horst");
        newTask.setOwner("Horst");
        try {
            this.taskService.saveTask(newTask);
        }
        catch (Exception e) {
            TaskAuthorizationTest.fail((String)"Setting same assignee and owner to user should not fail!");
        }
        this.taskService.deleteTask(newTask.getId(), true);
    }

    public void testPermissionsOnAssignSameAssigneeAndOwnerToTask() {
        try {
            this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE, Permissions.DELETE, Permissions.READ});
            this.processEngineConfiguration.setResourceAuthorizationProvider((ResourceAuthorizationProvider)new MyExtendedPermissionDefaultAuthorizationProvider());
            Task newTask = this.taskService.newTask();
            newTask.setAssignee("Horst");
            newTask.setOwner("Horst");
            this.taskService.saveTask(newTask);
            Authorization auth = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"Horst"}).singleResult();
            TaskAuthorizationTest.assertTrue((boolean)auth.isPermissionGranted((Permission)Permissions.DELETE));
            this.taskService.deleteTask(newTask.getId(), true);
        }
        finally {
            this.processEngineConfiguration.setResourceAuthorizationProvider((ResourceAuthorizationProvider)new DefaultAuthorizationProvider());
        }
    }

    @Deployment
    public void testAssignSameAssigneeAndOwnerToProcess() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.ALL});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.ALL});
        this.runtimeService.startProcessInstanceByKey("process");
        List auths = this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"horst"}).list();
        TaskAuthorizationTest.assertTrue((auths.size() == 1 ? 1 : 0) != 0);
    }

    @Deployment
    public void testAssignSameUserToProcessTwice() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.ALL});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.ALL});
        this.runtimeService.startProcessInstanceByKey("process");
        List auths = this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"hans"}).list();
        TaskAuthorizationTest.assertTrue((auths.size() == 1 ? 1 : 0) != 0);
    }

    @Deployment
    public void testAssignSameGroupToProcessTwice() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.ALL});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.ALL});
        this.runtimeService.startProcessInstanceByKey("process");
        List auths = this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"abc"}).list();
        TaskAuthorizationTest.assertTrue((auths.size() == 1 ? 1 : 0) != 0);
    }

    protected void verifyQueryResults(TaskQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }

    protected void verifyQueryResults(VariableInstanceQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }

    protected void verifyMessageIsValid(String taskId, String message) {
        this.assertTextPresent(this.userId, message);
        this.assertTextPresent(Permissions.UPDATE.getName(), message);
        this.assertTextPresent(TaskPermissions.UPDATE_VARIABLE.getName(), message);
        this.assertTextPresent(taskId, message);
        this.assertTextPresent(Resources.TASK.resourceName(), message);
        this.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
        this.assertTextPresent(ProcessDefinitionPermissions.UPDATE_TASK_VARIABLE.getName(), message);
        this.assertTextPresent(PROCESS_KEY, message);
        this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
    }

    protected void verifyVariableInstanceCountDisabledAuthorization(int count) {
        this.disableAuthorization();
        this.verifyQueryResults(this.runtimeService.createVariableInstanceQuery(), count);
        this.enableAuthorization();
    }

    protected void verifySetVariable(String taskId) {
        this.taskService.setVariable(taskId, "aVariableName", (Object)"aVariableValue");
        this.verifyVariableInstanceCountDisabledAuthorization(1);
    }

    protected void verifySetVariableLocal(String taskId) {
        this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
        this.verifyVariableInstanceCountDisabledAuthorization(1);
    }

    protected void verifySetVariables(String taskId) {
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.verifyVariableInstanceCountDisabledAuthorization(1);
    }

    protected void verifySetVariablesLocal(String taskId) {
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.verifyVariableInstanceCountDisabledAuthorization(1);
    }

    protected void verifyRemoveVariable(String taskId) {
        this.taskService.removeVariable(taskId, "aVariableName");
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void verifyRemoveVariableLocal(String taskId) {
        this.taskService.removeVariableLocal(taskId, "aVariableName");
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void verifyRemoveVariables(String taskId) {
        this.taskService.removeVariables(taskId, Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void verifyRemoveVariablesLocal(String taskId) {
        this.taskService.removeVariablesLocal(taskId, Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void verifyUpdateVariables(String taskId) {
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, (Map)this.getVariables(), null);
        this.verifyVariableInstanceCountDisabledAuthorization(1);
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, null, Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void verifyUpdateVariablesLocal(String taskId) {
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), null);
        this.verifyVariableInstanceCountDisabledAuthorization(1);
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, null, Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void verifyGetVariables(Map<String, Object> variables) {
        TaskAuthorizationTest.assertNotNull(variables);
        TaskAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        TaskAuthorizationTest.assertEquals((int)1, (int)variables.size());
        TaskAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get("aVariableName"));
    }
}

