/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.passwordpolicy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.pwpolicy.PasswordPolicy;
import org.camunda.bpm.engine.pwpolicy.PasswordPolicyRule;

public class CustomPasswordPolicyImpl
implements PasswordPolicy {
    public static List<String> passwordBlacklist = Arrays.asList("password", "hello", "qwerty");
    private List<PasswordPolicyRule> rules = new ArrayList<PasswordPolicyRule>();

    public CustomPasswordPolicyImpl() {
        this.rules.add(this.getBlackListStringRule());
        this.rules.add(this.getNoConsecutiveDigitRule());
    }

    public List<PasswordPolicyRule> getRules() {
        return this.rules;
    }

    private PasswordPolicyRule getBlackListStringRule() {
        return new PasswordPolicyRule(){

            public String getPlaceholder() {
                return "BLACKLIST";
            }

            public Map<String, String> getParameter() {
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("blacklist", passwordBlacklist.toString());
                return param;
            }

            public boolean execute(String password) {
                for (String string : passwordBlacklist) {
                    if (!password.contains(string)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private PasswordPolicyRule getNoConsecutiveDigitRule() {
        return new PasswordPolicyRule(){

            public String getPlaceholder() {
                return "NO_CONSECUTIVE_DIGITS";
            }

            public Map<String, String> getParameter() {
                return null;
            }

            public boolean execute(String password) {
                for (int i = 0; i < password.length() - 1; ++i) {
                    char first = password.charAt(i);
                    char second = password.charAt(i + 1);
                    if (!Character.isDigit(first) || !Character.isDigit(second)) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

