/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.passwordpolicy;

import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.pwpolicy.DefaultPasswordPolicyImpl;
import org.camunda.bpm.engine.impl.pwpolicy.PasswordPolicyException;
import org.camunda.bpm.engine.pwpolicy.PasswordPolicy;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.passwordpolicy.CustomPasswordPolicyImpl;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CustomPasswordPolicyTest {
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    private ProcessEngineConfigurationImpl processEngineConfiguration;
    private IdentityService identityService;

    @Before
    public void init() {
        this.identityService = this.engineRule.getIdentityService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.processEngineConfiguration.setPasswordPolicy((PasswordPolicy)new CustomPasswordPolicyImpl());
        this.processEngineConfiguration.setDisablePasswordPolicy(false);
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.setPasswordPolicy((PasswordPolicy)new DefaultPasswordPolicyImpl());
        this.processEngineConfiguration.setDisablePasswordPolicy(true);
        this.identityService.deleteUser("user");
    }

    @Test
    public void testCustomPasswordPolicy() {
        PasswordPolicy policy = this.processEngineConfiguration.getPasswordPolicy();
        Assert.assertTrue((boolean)policy.getClass().isAssignableFrom(CustomPasswordPolicyImpl.class));
        Assert.assertEquals((long)2L, (long)policy.getRules().size());
        User user = this.identityService.newUser("user");
        for (String password : CustomPasswordPolicyImpl.passwordBlacklist) {
            try {
                user.setPassword(password);
                this.identityService.saveUser(user);
                Assert.fail();
            }
            catch (PasswordPolicyException e) {
                Assert.assertEquals((Object)policy.getRules(), (Object)e.getPolicyRules());
            }
        }
        try {
            user.setPassword("password42");
            this.identityService.saveUser(user);
            Assert.fail();
        }
        catch (PasswordPolicyException e) {
            Assert.assertEquals((Object)policy.getRules(), (Object)e.getPolicyRules());
        }
        user.setPassword("this should work");
        this.identityService.saveUser(user);
    }
}

