/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.conditional;

import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.bpmn.event.conditional.AbstractConditionalEventTestCase;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.ConditionalEventDefinitionBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class MixedConditionalEventTest
extends AbstractConditionalEventTestCase {
    protected static final String TASK_AFTER_CONDITIONAL_BOUNDARY_EVENT = "Task after conditional boundary event";
    protected static final String TASK_AFTER_CONDITIONAL_START_EVENT = "Task after conditional start event";
    protected static final String TASK_AFTER_COND_START_EVENT_IN_SUB_PROCESS = "Task after cond start event in sub process";
    protected static final String TASK_AFTER_COND_BOUN_EVENT_IN_SUB_PROCESS = "Task after cond bound event in sub process";

    protected BpmnModelInstance addBoundaryEvent(BpmnModelInstance modelInstance, String activityId, String userTaskName, boolean isInterrupting) {
        return ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(modelInstance).activityBuilder(activityId).boundaryEvent().cancelActivity(Boolean.valueOf(isInterrupting))).conditionalEventDefinition().condition("${variable == 1}")).conditionalEventDefinitionDone().userTask().name(userTaskName)).endEvent().done();
    }

    protected BpmnModelInstance addEventSubProcess(BpmnModelInstance model, String parentId, String userTaskName, boolean isInterrupting) {
        return ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(model).addSubProcessTo(parentId).triggerByEvent()).embeddedSubProcess().startEvent().interrupting(isInterrupting)).conditionalEventDefinition().condition("${variable == 1}")).conditionalEventDefinitionDone().userTask().name(userTaskName)).endEvent().done();
    }

    protected void deployMixedProcess(BpmnModelInstance model, String parentId, boolean isInterrupting) {
        this.deployMixedProcess(model, parentId, "taskWithCondition", isInterrupting);
    }

    protected void deployMixedProcess(BpmnModelInstance model, String parentId, String activityId, boolean isInterrupting) {
        BpmnModelInstance modelInstance = this.addEventSubProcess(model, parentId, TASK_AFTER_CONDITIONAL_START_EVENT, isInterrupting);
        modelInstance = this.addBoundaryEvent(modelInstance, activityId, TASK_AFTER_CONDITIONAL_BOUNDARY_EVENT, isInterrupting);
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
    }

    @Test
    public void testSetVariableOnInputMapping() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).userTask("taskWithCondition").camundaInputParameter("variable", "1")).name("Task with condition")).endEvent().done();
        this.deployMixedProcess(modelInstance, "conditionalEventProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)TASK_AFTER_CONDITIONAL_BOUNDARY_EVENT, (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testSetVariableOnOutputMapping() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("taskWithCondition").camundaOutputParameter("variable", "1")).name("Task with condition")).endEvent().done();
        this.deployMixedProcess(modelInstance, "conditionalEventProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)TASK_AFTER_CONDITIONAL_START_EVENT, (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableOnInputMapping() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).userTask("taskWithCondition").camundaInputParameter("variable", "1")).name("Task with condition")).endEvent().done();
        this.deployMixedProcess(modelInstance, "conditionalEventProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.taskService.complete(((Task)taskQuery.singleResult()).getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"Task with condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableOnOutputMapping() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("taskWithCondition").camundaOutputParameter("variable", "1")).name("Task with condition")).userTask().name("afterOutputMapping")).endEvent().done();
        this.deployMixedProcess(modelInstance, "conditionalEventProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.taskService.complete(((Task)taskQuery.singleResult()).getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)2L, (long)this.tasksAfterVariableIsSet.size());
        MixedConditionalEventTest.assertTaskNames(this.tasksAfterVariableIsSet, TASK_AFTER_CONDITIONAL_START_EVENT, "afterOutputMapping");
    }

    @Test
    public void testSetVariableOnStartExecutionListenerInSubProcess() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().subProcess("subProcess").embeddedSubProcess().startEvent().userTask("beforeConditionId").name("Before Condition")).userTask("taskWithCondition").camundaExecutionListenerExpression("start", "${execution.setVariable(\"variable\", 1)}")).name("Task with condition")).endEvent().subProcessDone().endEvent().done();
        this.deployMixedProcess(modelInstance, "subProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)TASK_AFTER_CONDITIONAL_START_EVENT, (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testSetVariableOnEndExecutionListenerInSubProcess() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().subProcess("subProcess").embeddedSubProcess().startEvent().userTask("taskWithCondition").camundaExecutionListenerExpression("end", "${execution.setVariable(\"variable\", 1)}")).name("Task with condition")).endEvent().subProcessDone().endEvent().done();
        this.deployMixedProcess(modelInstance, "subProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)TASK_AFTER_CONDITIONAL_START_EVENT, (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableOnStartExecutionListenerInSubProcess() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().subProcess("subProcess").embeddedSubProcess().startEvent().userTask("beforeConditionId").name("Before Condition")).userTask("taskWithCondition").camundaExecutionListenerExpression("start", "${execution.setVariable(\"variable\", 1)}")).name("Task with condition")).endEvent().subProcessDone().endEvent().done();
        this.deployMixedProcess(modelInstance, "subProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.taskService.complete(((Task)taskQuery.singleResult()).getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)3L, (long)this.tasksAfterVariableIsSet.size());
        MixedConditionalEventTest.assertTaskNames(this.tasksAfterVariableIsSet, TASK_AFTER_CONDITIONAL_START_EVENT, TASK_AFTER_CONDITIONAL_BOUNDARY_EVENT, "Task with condition");
    }

    @Test
    public void testNonInterruptingSetVariableOnEndExecutionListenerInSubProcess() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().subProcess("subProcess").embeddedSubProcess().startEvent().userTask("taskWithCondition").camundaExecutionListenerExpression("end", "${execution.setVariable(\"variable\", 1)}")).name("Task with condition")).userTask().name("afterOutputMapping")).endEvent().subProcessDone().endEvent().done();
        this.deployMixedProcess(modelInstance, "subProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.taskService.complete(((Task)taskQuery.singleResult()).getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)2L, (long)this.tasksAfterVariableIsSet.size());
        MixedConditionalEventTest.assertTaskNames(this.tasksAfterVariableIsSet, TASK_AFTER_CONDITIONAL_START_EVENT, "afterOutputMapping");
    }

    @Test
    public void testSetVariableOnInputMappingInSubProcess() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().subProcess("subProcess").embeddedSubProcess().startEvent().userTask("beforeConditionId").name("Before Condition")).userTask("taskWithCondition").camundaInputParameter("variable", "1")).name("Task with condition")).endEvent().subProcessDone().endEvent().done();
        this.deployMixedProcess(modelInstance, "subProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)TASK_AFTER_CONDITIONAL_BOUNDARY_EVENT, (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testSetVariableOnOutputMappingInSubProcess() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().subProcess("subProcess").embeddedSubProcess().startEvent().userTask("taskWithCondition").camundaOutputParameter("variable", "1")).name("Task with condition")).endEvent().subProcessDone().endEvent().done();
        this.deployMixedProcess(modelInstance, "subProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)TASK_AFTER_CONDITIONAL_START_EVENT, (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableOnInputMappingInSubProcess() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().subProcess("subProcess").embeddedSubProcess().startEvent().userTask("beforeConditionId").name("Before Condition")).userTask("taskWithCondition").camundaInputParameter("variable", "1")).name("Task with condition")).endEvent().subProcessDone().endEvent().done();
        this.deployMixedProcess(modelInstance, "subProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.taskService.complete(((Task)taskQuery.singleResult()).getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"Task with condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableOnOutputMappingInSubProcess() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().subProcess("subProcess").embeddedSubProcess().startEvent().userTask("taskWithCondition").camundaOutputParameter("variable", "1")).name("Task with condition")).userTask().name("afterOutputMapping")).endEvent().subProcessDone().endEvent().done();
        this.deployMixedProcess(modelInstance, "subProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.taskService.complete(((Task)taskQuery.singleResult()).getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)2L, (long)this.tasksAfterVariableIsSet.size());
        MixedConditionalEventTest.assertTaskNames(this.tasksAfterVariableIsSet, TASK_AFTER_CONDITIONAL_START_EVENT, "afterOutputMapping");
    }

    @Test
    public void testSetVariableOnStartExecutionListenerInSubProcessWithBoundary() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((SubProcessBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().subProcess("subProcess").camundaExecutionListenerExpression("start", "${execution.setVariable(\"variable\", 1)}")).embeddedSubProcess().startEvent().userTask("taskWithCondition").name("Task with condition")).endEvent().subProcessDone().endEvent().done();
        modelInstance = this.addEventSubProcess(modelInstance, "subProcess", TASK_AFTER_COND_START_EVENT_IN_SUB_PROCESS, true);
        this.deployMixedProcess(modelInstance, "conditionalEventProcess", "subProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)TASK_AFTER_CONDITIONAL_START_EVENT, (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testSetVariableOnEndExecutionListenerInSubProcessWithBoundary() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().subProcess("subProcess").embeddedSubProcess().startEvent().userTask("taskWithCondition").camundaExecutionListenerExpression("end", "${execution.setVariable(\"variable\", 1)}")).name("Task with condition")).endEvent().subProcessDone().endEvent().done();
        modelInstance = this.addEventSubProcess(modelInstance, "subProcess", TASK_AFTER_COND_START_EVENT_IN_SUB_PROCESS, true);
        this.deployMixedProcess(modelInstance, "conditionalEventProcess", "subProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)TASK_AFTER_CONDITIONAL_START_EVENT, (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableOnStartExecutionListenerInSubProcessWithBoundary() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((SubProcessBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().subProcess("subProcess").camundaExecutionListenerExpression("start", "${execution.setVariable(\"variable\", 1)}")).embeddedSubProcess().startEvent().userTask("taskWithCondition").name("Task with condition")).endEvent().subProcessDone().endEvent().done();
        modelInstance = this.addEventSubProcess(modelInstance, "subProcess", TASK_AFTER_COND_START_EVENT_IN_SUB_PROCESS, false);
        this.deployMixedProcess(modelInstance, "conditionalEventProcess", "subProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)4L, (long)this.tasksAfterVariableIsSet.size());
        MixedConditionalEventTest.assertTaskNames(this.tasksAfterVariableIsSet, TASK_AFTER_CONDITIONAL_START_EVENT, TASK_AFTER_COND_START_EVENT_IN_SUB_PROCESS, TASK_AFTER_CONDITIONAL_BOUNDARY_EVENT, "Task with condition");
    }

    @Test
    public void testNonInterruptingSetVariableOnEndExecutionListenerInSubProcessWithBoundary() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().subProcess("subProcess").embeddedSubProcess().startEvent().userTask("taskWithCondition").camundaExecutionListenerExpression("end", "${execution.setVariable(\"variable\", 1)}")).name("Task with condition")).userTask().name("afterOutputMapping")).endEvent().subProcessDone().endEvent().done();
        modelInstance = this.addEventSubProcess(modelInstance, "subProcess", TASK_AFTER_COND_START_EVENT_IN_SUB_PROCESS, false);
        this.deployMixedProcess(modelInstance, "conditionalEventProcess", "subProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.taskService.complete(((Task)taskQuery.singleResult()).getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)4L, (long)this.tasksAfterVariableIsSet.size());
    }

    @Test
    public void testSetVariableOnInputMappingInSubProcessWithBoundary() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((SubProcessBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().subProcess("subProcess").camundaInputParameter("variable", "1")).embeddedSubProcess().startEvent().userTask("taskWithCondition").name("Task with condition")).endEvent().subProcessDone().endEvent().done();
        modelInstance = this.addEventSubProcess(modelInstance, "subProcess", TASK_AFTER_COND_START_EVENT_IN_SUB_PROCESS, true);
        this.deployMixedProcess(modelInstance, "conditionalEventProcess", "subProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)1L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((Object)TASK_AFTER_CONDITIONAL_BOUNDARY_EVENT, (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testSetVariableOnOutputMappingInSubProcessWithBoundary() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().subProcess("subProcess").embeddedSubProcess().startEvent().userTask("taskWithCondition").camundaOutputParameter("variable", "1")).name("Task with condition")).endEvent().subProcessDone().endEvent().done();
        modelInstance = this.addEventSubProcess(modelInstance, "subProcess", TASK_AFTER_COND_START_EVENT_IN_SUB_PROCESS, true);
        this.deployMixedProcess(modelInstance, "conditionalEventProcess", "subProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)TASK_AFTER_CONDITIONAL_START_EVENT, (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableOnInputMappingInSubProcessWithBoundary() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((SubProcessBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().subProcess("subProcess").camundaInputParameter("variable", "1")).embeddedSubProcess().startEvent().userTask("taskWithCondition").name("Task with condition")).endEvent().subProcessDone().endEvent().done();
        modelInstance = this.addEventSubProcess(modelInstance, "subProcess", TASK_AFTER_COND_START_EVENT_IN_SUB_PROCESS, false);
        this.deployMixedProcess(modelInstance, "conditionalEventProcess", "subProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)3L, (long)this.tasksAfterVariableIsSet.size());
        MixedConditionalEventTest.assertTaskNames(this.tasksAfterVariableIsSet, TASK_AFTER_COND_START_EVENT_IN_SUB_PROCESS, TASK_AFTER_CONDITIONAL_BOUNDARY_EVENT, "Task with condition");
    }

    @Test
    public void testNonInterruptingSetVariableOnOutputMappingInSubProcessWithBoundary() {
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().subProcess("subProcess").embeddedSubProcess().startEvent().userTask("taskWithCondition").camundaOutputParameter("variable", "1")).name("Task with condition")).userTask().name("afterOutputMapping")).endEvent().subProcessDone().endEvent().done();
        modelInstance = this.addEventSubProcess(modelInstance, "subProcess", TASK_AFTER_COND_START_EVENT_IN_SUB_PROCESS, false);
        this.deployMixedProcess(modelInstance, "conditionalEventProcess", "subProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        this.taskService.complete(((Task)taskQuery.singleResult()).getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)4L, (long)this.tasksAfterVariableIsSet.size());
    }

    @Test
    public void testSetVariableInOutMappingOfCallActivity() {
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", DELEGATED_PROCESS).deploy());
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((CallActivityBuilder)((CallActivityBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).subProcess("subProcess").embeddedSubProcess().startEvent().callActivity("taskWithCondition").calledElement("delegatedProcess")).camundaOut("variable", "variable")).userTask().name("afterOutputMapping")).endEvent().subProcessDone().endEvent().done();
        modelInstance = this.addEventSubProcess(modelInstance, "subProcess", TASK_AFTER_COND_START_EVENT_IN_SUB_PROCESS, true);
        modelInstance = this.addBoundaryEvent(modelInstance, "taskWithCondition", TASK_AFTER_COND_BOUN_EVENT_IN_SUB_PROCESS, true);
        this.deployMixedProcess(modelInstance, "conditionalEventProcess", "subProcess", true);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)TASK_AFTER_CONDITIONAL_START_EVENT, (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }

    @Test
    public void testNonInterruptingSetVariableInOutMappingOfCallActivity() {
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", DELEGATED_PROCESS).deploy());
        BpmnModelInstance modelInstance = ((UserTaskBuilder)((CallActivityBuilder)((CallActivityBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"conditionalEventProcess").startEvent().userTask("beforeConditionId").name("Before Condition")).subProcess("subProcess").embeddedSubProcess().startEvent().callActivity("taskWithCondition").calledElement("delegatedProcess")).camundaOut("variable", "variable")).userTask().name("afterOutputMapping")).endEvent().subProcessDone().endEvent().done();
        modelInstance = this.addEventSubProcess(modelInstance, "subProcess", TASK_AFTER_COND_START_EVENT_IN_SUB_PROCESS, false);
        modelInstance = this.addBoundaryEvent(modelInstance, "taskWithCondition", TASK_AFTER_COND_BOUN_EVENT_IN_SUB_PROCESS, false);
        this.deployMixedProcess(modelInstance, "conditionalEventProcess", "subProcess", false);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)5L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)3L, (long)this.conditionEventSubscriptionQuery.count());
    }

    @Ignore
    @Deployment
    public void testCompensationWithConditionalEvents() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Cancel", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.tasksAfterVariableIsSet = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)4L, (long)this.tasksAfterVariableIsSet.size());
    }

    @Test
    @Deployment
    public void testCompactedExecutionTree() {
        this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskName("Before Condition").singleResult()).getId());
        this.tasksAfterVariableIsSet = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)1L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((Object)TASK_AFTER_CONDITIONAL_START_EVENT, (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
    }
}

