/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.passwordPolicy;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.impl.pwpolicy.DefaultPasswordPolicyImpl;
import org.camunda.bpm.engine.impl.pwpolicy.PasswordPolicyChecker;
import org.camunda.bpm.engine.impl.pwpolicy.PasswordPolicyDigitRuleImpl;
import org.camunda.bpm.engine.impl.pwpolicy.PasswordPolicyException;
import org.camunda.bpm.engine.impl.pwpolicy.PasswordPolicyLengthRuleImpl;
import org.camunda.bpm.engine.impl.pwpolicy.PasswordPolicyLowerCaseRuleImpl;
import org.camunda.bpm.engine.impl.pwpolicy.PasswordPolicySpecialCharacterRuleImpl;
import org.camunda.bpm.engine.impl.pwpolicy.PasswordPolicyUpperCaseRuleImpl;
import org.camunda.bpm.engine.pwpolicy.PasswordPolicy;
import org.camunda.bpm.engine.pwpolicy.PasswordPolicyRule;
import org.junit.Assert;
import org.junit.Test;

public class DefaultPasswordPolicyTest {
    @Test
    public void testDefaultPasswordPolicy() {
        DefaultPasswordPolicyImpl policy = new DefaultPasswordPolicyImpl();
        List<String> nonCompliantPasswords = Arrays.asList("password", "Password", "LongPassword", "LongPassw0rd");
        for (String pw : nonCompliantPasswords) {
            try {
                PasswordPolicyChecker.checkPassword((PasswordPolicy)policy, (String)pw);
                Assert.assertTrue((boolean)false);
            }
            catch (PasswordPolicyException e) {
                this.checkPolicyRules(e.getPolicyRules());
            }
        }
        Assert.assertTrue((boolean)PasswordPolicyChecker.checkPassword((PasswordPolicy)policy, (String)"LongPas$w0rd"));
    }

    private void checkPolicyRules(List<PasswordPolicyRule> rules) {
        Assert.assertEquals((long)5L, (long)rules.size());
        for (PasswordPolicyRule rule : rules) {
            if (PasswordPolicyLengthRuleImpl.class.isAssignableFrom(rule.getClass())) {
                Assert.assertEquals((Object)"LENGTH", (Object)rule.getPlaceholder());
                Assert.assertEquals((Object)"10", ((PasswordPolicyLengthRuleImpl)rule).getParameter().get("minLength"));
                continue;
            }
            if (PasswordPolicyLowerCaseRuleImpl.class.isAssignableFrom(rule.getClass())) {
                Assert.assertEquals((Object)"LOWERCASE", (Object)rule.getPlaceholder());
                Assert.assertEquals((Object)"1", ((PasswordPolicyLowerCaseRuleImpl)rule).getParameter().get("minLowerCase"));
                continue;
            }
            if (PasswordPolicyUpperCaseRuleImpl.class.isAssignableFrom(rule.getClass())) {
                Assert.assertEquals((Object)"UPPERCASE", (Object)rule.getPlaceholder());
                Assert.assertEquals((Object)"1", ((PasswordPolicyUpperCaseRuleImpl)rule).getParameter().get("minUpperCase"));
                continue;
            }
            if (PasswordPolicyDigitRuleImpl.class.isAssignableFrom(rule.getClass())) {
                Assert.assertEquals((Object)"DIGIT", (Object)rule.getPlaceholder());
                Assert.assertEquals((Object)"1", ((PasswordPolicyDigitRuleImpl)rule).getParameter().get("minDigit"));
                continue;
            }
            if (!PasswordPolicySpecialCharacterRuleImpl.class.isAssignableFrom(rule.getClass())) continue;
            Assert.assertEquals((Object)"SPECIAL", (Object)rule.getPlaceholder());
            Assert.assertEquals((Object)"1", ((PasswordPolicySpecialCharacterRuleImpl)rule).getParameter().get("minSpecial"));
        }
    }
}

