/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.util;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngines;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.runtime.Job;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class ProcessEngineBootstrapRule
extends TestWatcher {
    private ProcessEngine processEngine;

    public ProcessEngineBootstrapRule() {
        this("camunda.cfg.xml");
    }

    public ProcessEngineBootstrapRule(String configurationResource) {
        this.processEngine = this.bootstrapEngine(configurationResource);
    }

    public ProcessEngine bootstrapEngine(String configurationResource) {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)configurationResource);
        processEngineConfiguration.setDisablePasswordPolicy(true);
        this.configureEngine(processEngineConfiguration);
        return processEngineConfiguration.buildProcessEngine();
    }

    public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
        return configuration;
    }

    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    protected void finished(Description description) {
        this.deleteHistoryCleanupJob();
        this.processEngine.close();
        ProcessEngines.unregister((ProcessEngine)this.processEngine);
        this.processEngine = null;
    }

    private void deleteHistoryCleanupJob() {
        List jobs = this.processEngine.getHistoryService().findHistoryCleanupJobs();
        for (final Job job : jobs) {
            ((ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration()).getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

                public Void execute(CommandContext commandContext) {
                    commandContext.getJobManager().deleteJob((JobEntity)job);
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(job.getId());
                    return null;
                }
            });
        }
    }
}

