/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineBootstrapCommand;
import org.camunda.bpm.engine.SchemaOperationsCommand;
import org.camunda.bpm.engine.impl.BootstrapEngineCommand;
import org.camunda.bpm.engine.impl.HistoryLevelSetupCommand;
import org.camunda.bpm.engine.impl.SchemaOperationsProcessEngineBuild;
import org.camunda.bpm.engine.impl.cfg.BeansConfigurationHelper;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.camunda.bpm.engine.variable.type.ValueTypeResolver;

public abstract class ProcessEngineConfiguration {
    public static final String DB_SCHEMA_UPDATE_FALSE = "false";
    public static final String DB_SCHEMA_UPDATE_CREATE_DROP = "create-drop";
    public static final String DB_SCHEMA_UPDATE_TRUE = "true";
    public static final String HISTORY_NONE = "none";
    public static final String HISTORY_ACTIVITY = "activity";
    @Deprecated
    public static final String HISTORY_VARIABLE = "variable";
    public static final String HISTORY_AUDIT = "audit";
    public static final String HISTORY_FULL = "full";
    public static final String HISTORY_AUTO = "auto";
    public static final String HISTORY_DEFAULT = "audit";
    public static final String HISTORY_CLEANUP_STRATEGY_END_TIME_BASED = "endTimeBased";
    public static final String HISTORY_CLEANUP_STRATEGY_REMOVAL_TIME_BASED = "removalTimeBased";
    public static final String HISTORY_REMOVAL_TIME_STRATEGY_START = "start";
    public static final String HISTORY_REMOVAL_TIME_STRATEGY_END = "end";
    public static final String HISTORY_REMOVAL_TIME_STRATEGY_NONE = "none";
    public static final String AUTHORIZATION_CHECK_REVOKE_ALWAYS = "always";
    public static final String AUTHORIZATION_CHECK_REVOKE_NEVER = "never";
    public static final String AUTHORIZATION_CHECK_REVOKE_AUTO = "auto";
    protected String processEngineName = "default";
    protected int idBlockSize = 100;
    protected String history = "audit";
    protected boolean jobExecutorActivate;
    protected boolean jobExecutorDeploymentAware = false;
    protected boolean jobExecutorPreferTimerJobs = false;
    protected boolean jobExecutorAcquireByDueDate = false;
    protected boolean jobExecutorAcquireByPriority = false;
    protected boolean ensureJobDueDateNotNull = false;
    protected boolean producePrioritizedJobs = true;
    protected boolean producePrioritizedExternalTasks = true;
    protected boolean hintJobExecutor = true;
    protected String mailServerHost = "localhost";
    protected String mailServerUsername;
    protected String mailServerPassword;
    protected int mailServerPort = 25;
    protected boolean useTLS = false;
    protected String mailServerDefaultFrom = "camunda@localhost";
    protected String databaseType;
    protected String databaseSchemaUpdate = "false";
    protected String jdbcDriver = "org.h2.Driver";
    protected String jdbcUrl = "jdbc:h2:tcp://localhost/activiti";
    protected String jdbcUsername = "sa";
    protected String jdbcPassword = "";
    protected String dataSourceJndiName = null;
    protected int jdbcMaxActiveConnections;
    protected int jdbcMaxIdleConnections;
    protected int jdbcMaxCheckoutTime;
    protected int jdbcMaxWaitTime;
    protected boolean jdbcPingEnabled = false;
    protected String jdbcPingQuery = null;
    protected int jdbcPingConnectionNotUsedFor;
    protected DataSource dataSource;
    protected SchemaOperationsCommand schemaOperationsCommand = new SchemaOperationsProcessEngineBuild();
    protected ProcessEngineBootstrapCommand bootstrapCommand = new BootstrapEngineCommand();
    protected HistoryLevelSetupCommand historyLevelCommand = new HistoryLevelSetupCommand();
    protected boolean transactionsExternallyManaged = false;
    protected Integer jdbcStatementTimeout;
    protected boolean jdbcBatchProcessing = true;
    protected String jpaPersistenceUnitName;
    protected Object jpaEntityManagerFactory;
    protected boolean jpaHandleTransaction;
    protected boolean jpaCloseEntityManager;
    protected int defaultNumberOfRetries = 3;
    protected ClassLoader classLoader;
    protected boolean createIncidentOnFailedJobEnabled = true;
    protected boolean authorizationEnabled = false;
    protected String defaultUserPermissionNameForTask = "UPDATE";
    protected boolean authorizationEnabledForCustomCode = false;
    protected boolean tenantCheckEnabled = true;
    protected ValueTypeResolver valueTypeResolver;
    protected String authorizationCheckRevokes = "auto";
    protected String generalResourceWhitelistPattern = "[a-zA-Z0-9]+|camunda-admin";
    protected String userResourceWhitelistPattern;
    protected String groupResourceWhitelistPattern;
    protected String tenantResourceWhitelistPattern;
    protected boolean enableExceptionsAfterUnhandledBpmnError = false;
    protected boolean skipHistoryOptimisticLockingExceptions = true;
    protected boolean enforceSpecificVariablePermission = false;
    protected List<String> disabledPermissions = Collections.emptyList();

    protected ProcessEngineConfiguration() {
    }

    public abstract ProcessEngine buildProcessEngine();

    public static ProcessEngineConfiguration createProcessEngineConfigurationFromResourceDefault() {
        ProcessEngineConfiguration processEngineConfiguration = null;
        try {
            processEngineConfiguration = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource("camunda.cfg.xml", "processEngineConfiguration");
        }
        catch (RuntimeException ex) {
            processEngineConfiguration = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource("activiti.cfg.xml", "processEngineConfiguration");
        }
        return processEngineConfiguration;
    }

    public static ProcessEngineConfiguration createProcessEngineConfigurationFromResource(String resource) {
        return ProcessEngineConfiguration.createProcessEngineConfigurationFromResource(resource, "processEngineConfiguration");
    }

    public static ProcessEngineConfiguration createProcessEngineConfigurationFromResource(String resource, String beanName) {
        return BeansConfigurationHelper.parseProcessEngineConfigurationFromResource(resource, beanName);
    }

    public static ProcessEngineConfiguration createProcessEngineConfigurationFromInputStream(InputStream inputStream) {
        return ProcessEngineConfiguration.createProcessEngineConfigurationFromInputStream(inputStream, "processEngineConfiguration");
    }

    public static ProcessEngineConfiguration createProcessEngineConfigurationFromInputStream(InputStream inputStream, String beanName) {
        return BeansConfigurationHelper.parseProcessEngineConfigurationFromInputStream(inputStream, beanName);
    }

    public static ProcessEngineConfiguration createStandaloneProcessEngineConfiguration() {
        return new StandaloneProcessEngineConfiguration();
    }

    public static ProcessEngineConfiguration createStandaloneInMemProcessEngineConfiguration() {
        return new StandaloneInMemProcessEngineConfiguration();
    }

    public String getProcessEngineName() {
        return this.processEngineName;
    }

    public ProcessEngineConfiguration setProcessEngineName(String processEngineName) {
        this.processEngineName = processEngineName;
        return this;
    }

    public int getIdBlockSize() {
        return this.idBlockSize;
    }

    public ProcessEngineConfiguration setIdBlockSize(int idBlockSize) {
        this.idBlockSize = idBlockSize;
        return this;
    }

    public String getHistory() {
        return this.history;
    }

    public ProcessEngineConfiguration setHistory(String history) {
        this.history = history;
        return this;
    }

    public String getMailServerHost() {
        return this.mailServerHost;
    }

    public ProcessEngineConfiguration setMailServerHost(String mailServerHost) {
        this.mailServerHost = mailServerHost;
        return this;
    }

    public String getMailServerUsername() {
        return this.mailServerUsername;
    }

    public ProcessEngineConfiguration setMailServerUsername(String mailServerUsername) {
        this.mailServerUsername = mailServerUsername;
        return this;
    }

    public String getMailServerPassword() {
        return this.mailServerPassword;
    }

    public ProcessEngineConfiguration setMailServerPassword(String mailServerPassword) {
        this.mailServerPassword = mailServerPassword;
        return this;
    }

    public int getMailServerPort() {
        return this.mailServerPort;
    }

    public ProcessEngineConfiguration setMailServerPort(int mailServerPort) {
        this.mailServerPort = mailServerPort;
        return this;
    }

    public boolean getMailServerUseTLS() {
        return this.useTLS;
    }

    public ProcessEngineConfiguration setMailServerUseTLS(boolean useTLS) {
        this.useTLS = useTLS;
        return this;
    }

    public String getMailServerDefaultFrom() {
        return this.mailServerDefaultFrom;
    }

    public ProcessEngineConfiguration setMailServerDefaultFrom(String mailServerDefaultFrom) {
        this.mailServerDefaultFrom = mailServerDefaultFrom;
        return this;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public ProcessEngineConfiguration setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
        return this;
    }

    public String getDatabaseSchemaUpdate() {
        return this.databaseSchemaUpdate;
    }

    public ProcessEngineConfiguration setDatabaseSchemaUpdate(String databaseSchemaUpdate) {
        this.databaseSchemaUpdate = databaseSchemaUpdate;
        return this;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public ProcessEngineConfiguration setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public SchemaOperationsCommand getSchemaOperationsCommand() {
        return this.schemaOperationsCommand;
    }

    public void setSchemaOperationsCommand(SchemaOperationsCommand schemaOperationsCommand) {
        this.schemaOperationsCommand = schemaOperationsCommand;
    }

    public ProcessEngineBootstrapCommand getProcessEngineBootstrapCommand() {
        return this.bootstrapCommand;
    }

    public void setProcessEngineBootstrapCommand(ProcessEngineBootstrapCommand bootstrapCommand) {
        this.bootstrapCommand = bootstrapCommand;
    }

    public HistoryLevelSetupCommand getHistoryLevelCommand() {
        return this.historyLevelCommand;
    }

    public void setHistoryLevelCommand(HistoryLevelSetupCommand historyLevelCommand) {
        this.historyLevelCommand = historyLevelCommand;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public ProcessEngineConfiguration setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
        return this;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public ProcessEngineConfiguration setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
        return this;
    }

    public String getJdbcUsername() {
        return this.jdbcUsername;
    }

    public ProcessEngineConfiguration setJdbcUsername(String jdbcUsername) {
        this.jdbcUsername = jdbcUsername;
        return this;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public ProcessEngineConfiguration setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
        return this;
    }

    public boolean isTransactionsExternallyManaged() {
        return this.transactionsExternallyManaged;
    }

    public ProcessEngineConfiguration setTransactionsExternallyManaged(boolean transactionsExternallyManaged) {
        this.transactionsExternallyManaged = transactionsExternallyManaged;
        return this;
    }

    public int getJdbcMaxActiveConnections() {
        return this.jdbcMaxActiveConnections;
    }

    public ProcessEngineConfiguration setJdbcMaxActiveConnections(int jdbcMaxActiveConnections) {
        this.jdbcMaxActiveConnections = jdbcMaxActiveConnections;
        return this;
    }

    public int getJdbcMaxIdleConnections() {
        return this.jdbcMaxIdleConnections;
    }

    public ProcessEngineConfiguration setJdbcMaxIdleConnections(int jdbcMaxIdleConnections) {
        this.jdbcMaxIdleConnections = jdbcMaxIdleConnections;
        return this;
    }

    public int getJdbcMaxCheckoutTime() {
        return this.jdbcMaxCheckoutTime;
    }

    public ProcessEngineConfiguration setJdbcMaxCheckoutTime(int jdbcMaxCheckoutTime) {
        this.jdbcMaxCheckoutTime = jdbcMaxCheckoutTime;
        return this;
    }

    public int getJdbcMaxWaitTime() {
        return this.jdbcMaxWaitTime;
    }

    public ProcessEngineConfiguration setJdbcMaxWaitTime(int jdbcMaxWaitTime) {
        this.jdbcMaxWaitTime = jdbcMaxWaitTime;
        return this;
    }

    public boolean isJdbcPingEnabled() {
        return this.jdbcPingEnabled;
    }

    public ProcessEngineConfiguration setJdbcPingEnabled(boolean jdbcPingEnabled) {
        this.jdbcPingEnabled = jdbcPingEnabled;
        return this;
    }

    public String getJdbcPingQuery() {
        return this.jdbcPingQuery;
    }

    public ProcessEngineConfiguration setJdbcPingQuery(String jdbcPingQuery) {
        this.jdbcPingQuery = jdbcPingQuery;
        return this;
    }

    public int getJdbcPingConnectionNotUsedFor() {
        return this.jdbcPingConnectionNotUsedFor;
    }

    public ProcessEngineConfiguration setJdbcPingConnectionNotUsedFor(int jdbcPingNotUsedFor) {
        this.jdbcPingConnectionNotUsedFor = jdbcPingNotUsedFor;
        return this;
    }

    public Integer getJdbcStatementTimeout() {
        return this.jdbcStatementTimeout;
    }

    public ProcessEngineConfiguration setJdbcStatementTimeout(Integer jdbcStatementTimeout) {
        this.jdbcStatementTimeout = jdbcStatementTimeout;
        return this;
    }

    public boolean isJdbcBatchProcessing() {
        return this.jdbcBatchProcessing;
    }

    public ProcessEngineConfiguration setJdbcBatchProcessing(boolean jdbcBatchProcessing) {
        this.jdbcBatchProcessing = jdbcBatchProcessing;
        return this;
    }

    public boolean isJobExecutorActivate() {
        return this.jobExecutorActivate;
    }

    public ProcessEngineConfiguration setJobExecutorActivate(boolean jobExecutorActivate) {
        this.jobExecutorActivate = jobExecutorActivate;
        return this;
    }

    public boolean isJobExecutorDeploymentAware() {
        return this.jobExecutorDeploymentAware;
    }

    public ProcessEngineConfiguration setJobExecutorDeploymentAware(boolean jobExecutorDeploymentAware) {
        this.jobExecutorDeploymentAware = jobExecutorDeploymentAware;
        return this;
    }

    public boolean isJobExecutorAcquireByDueDate() {
        return this.jobExecutorAcquireByDueDate;
    }

    public ProcessEngineConfiguration setJobExecutorAcquireByDueDate(boolean jobExecutorAcquireByDueDate) {
        this.jobExecutorAcquireByDueDate = jobExecutorAcquireByDueDate;
        return this;
    }

    public boolean isJobExecutorPreferTimerJobs() {
        return this.jobExecutorPreferTimerJobs;
    }

    public ProcessEngineConfiguration setJobExecutorPreferTimerJobs(boolean jobExecutorPreferTimerJobs) {
        this.jobExecutorPreferTimerJobs = jobExecutorPreferTimerJobs;
        return this;
    }

    public boolean isHintJobExecutor() {
        return this.hintJobExecutor;
    }

    public ProcessEngineConfiguration setHintJobExecutor(boolean hintJobExecutor) {
        this.hintJobExecutor = hintJobExecutor;
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ProcessEngineConfiguration setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public Object getJpaEntityManagerFactory() {
        return this.jpaEntityManagerFactory;
    }

    public ProcessEngineConfiguration setJpaEntityManagerFactory(Object jpaEntityManagerFactory) {
        this.jpaEntityManagerFactory = jpaEntityManagerFactory;
        return this;
    }

    public boolean isJpaHandleTransaction() {
        return this.jpaHandleTransaction;
    }

    public ProcessEngineConfiguration setJpaHandleTransaction(boolean jpaHandleTransaction) {
        this.jpaHandleTransaction = jpaHandleTransaction;
        return this;
    }

    public boolean isJpaCloseEntityManager() {
        return this.jpaCloseEntityManager;
    }

    public ProcessEngineConfiguration setJpaCloseEntityManager(boolean jpaCloseEntityManager) {
        this.jpaCloseEntityManager = jpaCloseEntityManager;
        return this;
    }

    public String getJpaPersistenceUnitName() {
        return this.jpaPersistenceUnitName;
    }

    public void setJpaPersistenceUnitName(String jpaPersistenceUnitName) {
        this.jpaPersistenceUnitName = jpaPersistenceUnitName;
    }

    public String getDataSourceJndiName() {
        return this.dataSourceJndiName;
    }

    public void setDataSourceJndiName(String dataSourceJndiName) {
        this.dataSourceJndiName = dataSourceJndiName;
    }

    public boolean isCreateIncidentOnFailedJobEnabled() {
        return this.createIncidentOnFailedJobEnabled;
    }

    public ProcessEngineConfiguration setCreateIncidentOnFailedJobEnabled(boolean createIncidentOnFailedJobEnabled) {
        this.createIncidentOnFailedJobEnabled = createIncidentOnFailedJobEnabled;
        return this;
    }

    public boolean isAuthorizationEnabled() {
        return this.authorizationEnabled;
    }

    public ProcessEngineConfiguration setAuthorizationEnabled(boolean isAuthorizationChecksEnabled) {
        this.authorizationEnabled = isAuthorizationChecksEnabled;
        return this;
    }

    public String getDefaultUserPermissionNameForTask() {
        return this.defaultUserPermissionNameForTask;
    }

    public ProcessEngineConfiguration setDefaultUserPermissionNameForTask(String defaultUserPermissionNameForTask) {
        this.defaultUserPermissionNameForTask = defaultUserPermissionNameForTask;
        return this;
    }

    public boolean isAuthorizationEnabledForCustomCode() {
        return this.authorizationEnabledForCustomCode;
    }

    public ProcessEngineConfiguration setAuthorizationEnabledForCustomCode(boolean authorizationEnabledForCustomCode) {
        this.authorizationEnabledForCustomCode = authorizationEnabledForCustomCode;
        return this;
    }

    public boolean isTenantCheckEnabled() {
        return this.tenantCheckEnabled;
    }

    public ProcessEngineConfiguration setTenantCheckEnabled(boolean isTenantCheckEnabled) {
        this.tenantCheckEnabled = isTenantCheckEnabled;
        return this;
    }

    public String getGeneralResourceWhitelistPattern() {
        return this.generalResourceWhitelistPattern;
    }

    public void setGeneralResourceWhitelistPattern(String generalResourceWhitelistPattern) {
        this.generalResourceWhitelistPattern = generalResourceWhitelistPattern;
    }

    public String getUserResourceWhitelistPattern() {
        return this.userResourceWhitelistPattern;
    }

    public void setUserResourceWhitelistPattern(String userResourceWhitelistPattern) {
        this.userResourceWhitelistPattern = userResourceWhitelistPattern;
    }

    public String getGroupResourceWhitelistPattern() {
        return this.groupResourceWhitelistPattern;
    }

    public void setGroupResourceWhitelistPattern(String groupResourceWhitelistPattern) {
        this.groupResourceWhitelistPattern = groupResourceWhitelistPattern;
    }

    public String getTenantResourceWhitelistPattern() {
        return this.tenantResourceWhitelistPattern;
    }

    public void setTenantResourceWhitelistPattern(String tenantResourceWhitelistPattern) {
        this.tenantResourceWhitelistPattern = tenantResourceWhitelistPattern;
    }

    public int getDefaultNumberOfRetries() {
        return this.defaultNumberOfRetries;
    }

    public void setDefaultNumberOfRetries(int defaultNumberOfRetries) {
        this.defaultNumberOfRetries = defaultNumberOfRetries;
    }

    public ValueTypeResolver getValueTypeResolver() {
        return this.valueTypeResolver;
    }

    public ProcessEngineConfiguration setValueTypeResolver(ValueTypeResolver valueTypeResolver) {
        this.valueTypeResolver = valueTypeResolver;
        return this;
    }

    public boolean isEnsureJobDueDateNotNull() {
        return this.ensureJobDueDateNotNull;
    }

    public void setEnsureJobDueDateNotNull(boolean ensureJobDueDateNotNull) {
        this.ensureJobDueDateNotNull = ensureJobDueDateNotNull;
    }

    public boolean isProducePrioritizedJobs() {
        return this.producePrioritizedJobs;
    }

    public void setProducePrioritizedJobs(boolean producePrioritizedJobs) {
        this.producePrioritizedJobs = producePrioritizedJobs;
    }

    public boolean isJobExecutorAcquireByPriority() {
        return this.jobExecutorAcquireByPriority;
    }

    public void setJobExecutorAcquireByPriority(boolean jobExecutorAcquireByPriority) {
        this.jobExecutorAcquireByPriority = jobExecutorAcquireByPriority;
    }

    public boolean isProducePrioritizedExternalTasks() {
        return this.producePrioritizedExternalTasks;
    }

    public void setProducePrioritizedExternalTasks(boolean producePrioritizedExternalTasks) {
        this.producePrioritizedExternalTasks = producePrioritizedExternalTasks;
    }

    public void setAuthorizationCheckRevokes(String authorizationCheckRevokes) {
        this.authorizationCheckRevokes = authorizationCheckRevokes;
    }

    public String getAuthorizationCheckRevokes() {
        return this.authorizationCheckRevokes;
    }

    public boolean isEnableExceptionsAfterUnhandledBpmnError() {
        return this.enableExceptionsAfterUnhandledBpmnError;
    }

    public void setEnableExceptionsAfterUnhandledBpmnError(boolean enableExceptionsAfterUnhandledBpmnError) {
        this.enableExceptionsAfterUnhandledBpmnError = enableExceptionsAfterUnhandledBpmnError;
    }

    public boolean isSkipHistoryOptimisticLockingExceptions() {
        return this.skipHistoryOptimisticLockingExceptions;
    }

    public ProcessEngineConfiguration setSkipHistoryOptimisticLockingExceptions(boolean skipHistoryOptimisticLockingExceptions) {
        this.skipHistoryOptimisticLockingExceptions = skipHistoryOptimisticLockingExceptions;
        return this;
    }

    public boolean isEnforceSpecificVariablePermission() {
        return this.enforceSpecificVariablePermission;
    }

    public void setEnforceSpecificVariablePermission(boolean ensureSpecificVariablePermission) {
        this.enforceSpecificVariablePermission = ensureSpecificVariablePermission;
    }

    public List<String> getDisabledPermissions() {
        return this.disabledPermissions;
    }

    public void setDisabledPermissions(List<String> disabledPermissions) {
        this.disabledPermissions = disabledPermissions;
    }
}

