/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.impl.HistoricCaseInstanceQueryImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DeleteHistoricCaseInstancesBulkCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final List<String> caseInstanceIds;

    public DeleteHistoricCaseInstancesBulkCmd(List<String> caseInstanceIds) {
        this.caseInstanceIds = caseInstanceIds;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "caseInstanceIds", this.caseInstanceIds);
        commandContext.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                EnsureUtil.ensureEquals(BadUserRequestException.class, "ClosedCaseInstanceIds", new HistoricCaseInstanceQueryImpl().closed().caseInstanceIds(new HashSet<String>(DeleteHistoricCaseInstancesBulkCmd.this.caseInstanceIds)).count(), DeleteHistoricCaseInstancesBulkCmd.this.caseInstanceIds.size());
                return null;
            }
        });
        commandContext.getHistoricCaseInstanceManager().deleteHistoricCaseInstancesByIds(this.caseInstanceIds);
        return null;
    }
}

