/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionObserver;
import org.camunda.bpm.engine.variable.VariableMap;

public class ExecutionVariableSnapshotObserver
implements ExecutionObserver {
    protected VariableMap variableSnapshot;
    protected ExecutionEntity execution;
    protected boolean localVariables = true;

    public ExecutionVariableSnapshotObserver(ExecutionEntity executionEntity) {
        this(executionEntity, true);
    }

    public ExecutionVariableSnapshotObserver(ExecutionEntity executionEntity, boolean localVariables) {
        this.execution = executionEntity;
        this.execution.addExecutionObserver(this);
        this.localVariables = localVariables;
    }

    @Override
    public void onClear(ExecutionEntity execution) {
        if (this.variableSnapshot == null) {
            this.variableSnapshot = this.getVariables(this.localVariables);
        }
    }

    public VariableMap getVariables() {
        if (this.variableSnapshot == null) {
            return this.getVariables(this.localVariables);
        }
        return this.variableSnapshot;
    }

    private VariableMap getVariables(boolean localVariables) {
        return this.localVariables ? this.execution.getVariablesLocalTyped(false) : this.execution.getVariablesTyped(false);
    }
}

