/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pwpolicy;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.pwpolicy.PasswordPolicyRule;

public class PasswordPolicyDigitRuleImpl
implements PasswordPolicyRule {
    public static final String placeholder = "DIGIT";
    private int minDigit;

    public PasswordPolicyDigitRuleImpl(int minDigit) {
        this.minDigit = minDigit;
    }

    @Override
    public String getPlaceholder() {
        return placeholder;
    }

    @Override
    public Map<String, String> getParameter() {
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("minDigit", "" + this.minDigit);
        return parameter;
    }

    @Override
    public boolean execute(String password) {
        int digitCount = 0;
        char[] cArray = password.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (Character.isDigit(c.charValue())) {
                ++digitCount;
            }
            if (digitCount < this.minDigit) continue;
            return true;
        }
        return false;
    }
}

