/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pwpolicy;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.pwpolicy.PasswordPolicyRule;

public class PasswordPolicyLowerCaseRuleImpl
implements PasswordPolicyRule {
    public static final String placeholder = "LOWERCASE";
    private int minLowerCase;

    public PasswordPolicyLowerCaseRuleImpl(int minLowerCase) {
        this.minLowerCase = minLowerCase;
    }

    @Override
    public String getPlaceholder() {
        return placeholder;
    }

    @Override
    public Map<String, String> getParameter() {
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("minLowerCase", "" + this.minLowerCase);
        return parameter;
    }

    @Override
    public boolean execute(String password) {
        int lowerCaseCount = 0;
        char[] cArray = password.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (Character.isLowerCase(c.charValue())) {
                ++lowerCaseCount;
            }
            if (lowerCaseCount < this.minLowerCase) continue;
            return true;
        }
        return false;
    }
}

